/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.m4.core;

import edu.udo.cs.miningmart.db.DB;
import edu.udo.cs.miningmart.exception.DbConnectionClosed;
import edu.udo.cs.miningmart.exception.M4CompilerError;
import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.exception.MiningMartException;
import edu.udo.cs.miningmart.m4.BaseAttribute;
import edu.udo.cs.miningmart.m4.Columnset;
import edu.udo.cs.miningmart.m4.core.ColumnStatistics1;
import edu.udo.cs.miningmart.m4.core.ColumnStatistics2;
import edu.udo.cs.miningmart.m4.core.KeyMember;
import edu.udo.cs.miningmart.m4.core.M4Data;
import edu.udo.cs.miningmart.m4.core.RelationalDatatypes;
import edu.udo.cs.miningmart.m4.utils.InterM4ColumnColumnStatist1;
import edu.udo.cs.miningmart.m4.utils.InterM4ColumnColumnStatist2;
import edu.udo.cs.miningmart.m4.utils.InterM4ColumnForeignKeyMember;
import edu.udo.cs.miningmart.m4.utils.InterM4ColumnPrimaryKeyMember;
import edu.udo.cs.miningmart.m4.utils.InterM4Communicator;
import edu.udo.cs.miningmart.m4.utils.M4Info;
import edu.udo.cs.miningmart.m4.utils.M4InfoEntry;
import edu.udo.cs.miningmart.m4.utils.Print;
import edu.udo.cs.miningmart.m4.utils.XmlInfo;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Vector;

public class Column
extends M4Data
implements XmlInfo,
edu.udo.cs.miningmart.m4.Column {
    static final InterM4Communicator colCstat1 = new InterM4ColumnColumnStatist1();
    static final InterM4Communicator colCstat2 = new InterM4ColumnColumnStatist2();
    static final InterM4Communicator colPkMem = new InterM4ColumnPrimaryKeyMember();
    static final InterM4Communicator colFkMem = new InterM4ColumnForeignKeyMember();
    public static final String M4_TABLE_NAME = "column_t";
    public static final String ATTRIB_COLUMN_ID = "col_id";
    public static final String ATTRIB_COLUMN_NAME = "col_name";
    public static final String ATTRIB_COLUMNSET_ID = "col_csid";
    public static final String ATTRIB_COLUMN_DATATYPE = "col_coldtid";
    public static final String ATTRIB_COLUMN_SQL = "col_sql";
    public static final String M4_TABLE_COL_BA = "ba_column_t";
    public static final String ATTRIB_COL_BA_TUPLE_ID = "bac_id";
    public static final String ATTRIB_COL_BA_COLID = "bac_colid";
    public static final String ATTRIB_COL_BA_BAID = "bac_baid";
    private static RelationalDatatypes dataTypeMapping = null;
    public static M4Info m4Info = null;
    private static M4Info xmlInfo = null;
    private edu.udo.cs.miningmart.m4.core.BaseAttribute myBaseAttribute;
    private edu.udo.cs.miningmart.m4.core.Columnset myColumnSet;
    private long dataType;
    private String sql;
    private boolean allBasicStatisticsLoaded = false;
    private final Vector myBasicStatistics = new Vector();
    private boolean allDistribStatisticsLoaded = false;
    private final Vector myDistribStatistics = new Vector();
    private final Vector myPrimaryKeyMembers = new Vector();
    private boolean allPrimaryKeyMembersLoaded = false;
    private final Vector myForeignKeyMembers = new Vector();
    private boolean allForeignKeyMembersLoaded = false;

    private RelationalDatatypes getRelationalDatatypeMapping(DB db) throws M4Exception, DbConnectionClosed {
        if (dataTypeMapping == null) {
            dataTypeMapping = new RelationalDatatypes(db);
        }
        return dataTypeMapping;
    }

    public String getM4TableName() {
        return M4_TABLE_NAME;
    }

    public String getIdAttributeName() {
        return ATTRIB_COLUMN_ID;
    }

    public M4Info getM4Info() {
        if (m4Info == null) {
            M4InfoEntry[] m4i = new M4InfoEntry[]{new M4InfoEntry(ATTRIB_COLUMN_ID, "getId", "setId", Long.TYPE, "NN"), new M4InfoEntry(ATTRIB_COLUMN_NAME, "getName", "setName", String.class, "NN"), new M4InfoEntry(ATTRIB_COLUMNSET_ID, "getColumnset", "primitiveSetColumnset", Columnset.class, "NN"), new M4InfoEntry(ATTRIB_COLUMN_DATATYPE, "getColumnDataType", "setColumnDataType", Long.TYPE, "NN"), new M4InfoEntry(ATTRIB_COLUMN_SQL, "getSQLDefinition", "setSQLDefinition", String.class)};
            m4Info = new M4Info(m4i);
        }
        return m4Info;
    }

    public M4Info getXmlInfo() {
        if (xmlInfo == null) {
            M4InfoEntry[] m4i = new M4InfoEntry[]{new M4InfoEntry("Name", "getName", "setName", String.class), new M4InfoEntry("Columnset", "getColumnset", "setColumnset", Columnset.class), new M4InfoEntry("BaseAttribute", "getTheBaseAttribute", "setBaseAttribute", BaseAttribute.class), new M4InfoEntry("ColDatatype", "getColumnDataTypeName", "setColumnDataTypeName", String.class), new M4InfoEntry("SqlDefinition", "getSQLDefinition", "setSQLDefinition", String.class), new M4InfoEntry("Docu", "getDocumentation", "setDocumentation", String.class)};
            xmlInfo = new M4Info(m4i);
        }
        return xmlInfo;
    }

    public Column(DB m4Db) {
        super(m4Db);
    }

    public void print() {
        Columnset cs = this.getColumnset();
        String cdt = "[ID: " + this.getColumnDataType() + "]";
        try {
            cdt = this.getColumnDataTypeName();
        }
        catch (MiningMartException e) {
            // empty catch block
        }
        String colSetName = cs == null ? "<Columnset not set>" : cs.getSchema() + "." + cs.getName();
        try {
            this.doPrint(Print.M4_OBJECT, "Column " + this.getName() + "(Id = " + this.getId() + ";" + " Type = " + cdt + ") of Columnset " + colSetName + "  defined in SQL as " + this.getSQLDefinition() + "  (Unique: " + this.getNumberOfUniqueValues() + " Missing: " + this.getNumberOfMissingValues() + " Min: " + this.getMinValue() + " Max: " + this.getMaxValue() + " Median: " + this.getMedianValue() + " Modal: " + this.getModalValue() + " Average: " + this.getAverageValue() + " Std. Dev.: " + this.getStandardDeviation() + ")");
        }
        catch (M4Exception e) {
            // empty catch block
        }
    }

    public void setName(String name) {
        name = this.replaceSpacesInName(name);
        super.setName(name);
    }

    protected Collection getObjectsInNamespace(Class typeOfObjects) throws M4Exception {
        return null;
    }

    public edu.udo.cs.miningmart.m4.Column copyColToCS(Columnset cs) throws M4Exception {
        Column ret = (Column)this.getM4Db().createNewInstance(Column.class);
        ret.myId = 0L;
        String nameOfCopy = cs.getValidName(this.getName(), Column.class);
        ret.setName(nameOfCopy);
        ret.setColumnset(cs);
        ret.setBaseAttribute(this.getTheBaseAttribute());
        ret.setColumnDataType(this.getColumnDataType());
        ret.setSQLDefinition(this.getSQLDefinition());
        cs.addColumn(ret);
        return ret;
    }

    public void setBaseAttribute(BaseAttribute ba) throws M4Exception {
        edu.udo.cs.miningmart.m4.core.BaseAttribute.ba2col.updateReferenceTo(this, ba);
    }

    public BaseAttribute getTheBaseAttribute() throws M4Exception {
        return this.myBaseAttribute;
    }

    public void setSQLDefinition(String sqlDefinition) {
        this.setDirty();
        this.sql = sqlDefinition == null || sqlDefinition.length() == 0 ? this.getName() : sqlDefinition;
    }

    public String getSQLDefinition() {
        if (this.sql == null) {
            return this.getName();
        }
        return this.sql;
    }

    public String getSQLPlusLocation() {
        String location = this.getColumnset().getSchemaPlusName();
        location = location != null && !location.equals("") ? location + "." : "";
        return location + this.getSQLDefinition();
    }

    public void setColumnDataType(long type) {
        this.setDirty();
        this.dataType = type;
    }

    public long getColumnDataType() {
        return this.dataType;
    }

    public void setColumnDataTypeName(String dtname) throws M4Exception {
        long type;
        try {
            type = this.getRelationalDatatypeMapping(this.getM4Db()).getIdForName(dtname);
        }
        catch (DbConnectionClosed d) {
            throw new M4Exception("Connection to DB lost: " + d.getMessage());
        }
        this.setColumnDataType(type);
    }

    public String getColumnDataTypeName() throws M4Exception {
        long type = this.getColumnDataType();
        try {
            return this.getRelationalDatatypeMapping(this.getM4Db()).getNameForId(type);
        }
        catch (DbConnectionClosed d) {
            throw new M4Exception("Db Connection closed when asking for relational data type of column '" + this.getName() + "'!");
        }
    }

    public Collection getPrimaryKeyMembers() throws M4Exception {
        if (!this.allPrimaryKeyMembersLoaded && !this.isNew()) {
            this.allPrimaryKeyMembersLoaded = true;
            Collection pkms = this.getObjectsReferencingMe(KeyMember.class, "km_pkcolid");
            colPkMem.setCollectionTo(this, pkms);
        }
        return this.myPrimaryKeyMembers;
    }

    public Collection getForeignKeyMembers() throws M4Exception {
        if (!this.allForeignKeyMembersLoaded && !this.isNew()) {
            this.allForeignKeyMembersLoaded = true;
            Collection fkms = this.getObjectsReferencingMe(KeyMember.class, "km_fkcolid");
            colFkMem.setCollectionTo(this, fkms);
        }
        return this.myForeignKeyMembers;
    }

    public Collection getBasicColStats() throws M4Exception {
        if (!this.allBasicStatisticsLoaded && !this.isNew()) {
            this.allBasicStatisticsLoaded = true;
            Collection references = this.getObjectsReferencingMe(ColumnStatistics1.class);
            colCstat1.setCollectionTo(this, references);
        }
        return this.myBasicStatistics;
    }

    private ColumnStatistics1 getBasicStat() throws M4Exception {
        Collection col = this.getBasicColStats();
        ColumnStatistics1 ret = null;
        if (col != null && col.size() >= 1) {
            ret = col instanceof Vector ? (ColumnStatistics1)((Vector)col).get(0) : (ColumnStatistics1)col.iterator().next();
        } else {
            ret = (ColumnStatistics1)this.getM4Db().createNewInstance(ColumnStatistics1.class);
            colCstat1.add(this, ret);
        }
        return ret;
    }

    public Collection getDistributionStatistics() throws M4Exception {
        if (!this.allDistribStatisticsLoaded && !this.isNew()) {
            this.allDistribStatisticsLoaded = true;
            Collection references = this.getObjectsReferencingMe(ColumnStatistics2.class);
            colCstat2.setCollectionTo(this, references);
        }
        return this.myDistribStatistics;
    }

    public void setDistributionStatistics(Collection dStats) throws M4Exception {
        if (dStats == null) {
            dStats = new Vector();
        }
        colCstat2.setCollectionTo(this, dStats);
    }

    public int getNumberOfUniqueValues() throws M4Exception {
        Integer i = this.getBasicStat().getNrOfUniqueValuesI();
        return i == null ? 0 : i;
    }

    private boolean isMissingNumberOfUniqueValues() throws M4Exception {
        return this.getBasicStat().getNrOfUniqueValuesI() == null;
    }

    public int getNumberOfMissingValues() throws M4Exception {
        Integer i = this.getBasicStat().getNrOfMissingValuesI();
        return i == null ? 0 : i;
    }

    private boolean isMissingNumberOfMissingValues() throws M4Exception {
        return this.getBasicStat().getNrOfMissingValuesI() == null;
    }

    public String getMinValue() throws M4Exception {
        return this.getBasicStat().getMinimum();
    }

    public String getMaxValue() throws M4Exception {
        return this.getBasicStat().getMaximum();
    }

    public String getMedianValue() throws M4Exception {
        return this.getBasicStat().getMedian();
    }

    public String getModalValue() throws M4Exception {
        return this.getBasicStat().getModal();
    }

    public String getAverageValue() throws M4Exception {
        Double doub = this.getBasicStat().getAverageD();
        if (doub == null) {
            return null;
        }
        return doub.toString();
    }

    public String getStandardDeviation() throws M4Exception {
        Double doub = this.getBasicStat().getStandardDeviationD();
        if (doub == null) {
            return null;
        }
        return doub.toString();
    }

    public String getVariance() throws M4Exception {
        Double doub = this.getBasicStat().getVarianceD();
        if (doub == null) {
            return null;
        }
        return doub.toString();
    }

    protected void setNumberOfUniqueValues(int nuv) throws M4Exception {
        this.getBasicStat().setNrOfUniqueValues(new Integer(nuv));
    }

    public void setNumberOfMissingValues(int nmv) throws M4Exception {
        this.getBasicStat().setNrOfMissingValues(new Integer(nmv));
    }

    protected void setMinValue(String min) throws M4Exception {
        this.getBasicStat().setMinimum(min);
    }

    public void setMaxValue(double newMax) throws M4Exception {
        if (Double.compare(newMax, Double.NaN) != 0) {
            this.setMaxValue("" + newMax);
        }
    }

    public void setMinValue(double newMin) throws M4Exception {
        if (Double.compare(newMin, Double.NaN) != 0) {
            this.setMinValue("" + newMin);
        }
    }

    protected void setMaxValue(String max) throws M4Exception {
        this.getBasicStat().setMaximum(max);
    }

    protected void setMedianValue(String med) throws M4Exception {
        this.getBasicStat().setMedian(med);
    }

    protected void setModalValue(String mod) throws M4Exception {
        this.getBasicStat().setModal(mod);
    }

    protected void setAverageValue(String avg) throws M4Exception {
        Double v = null;
        if (avg != null && avg.trim().length() > 0) {
            v = new Double(avg);
        }
        this.getBasicStat().setAverage(v);
    }

    protected void setStandardDeviation(String stddev) throws M4Exception {
        Double v = null;
        if (stddev != null && stddev.trim().length() > 0) {
            v = new Double(stddev);
        }
        this.getBasicStat().setStandardDeviation(v);
    }

    protected void setVariance(String var) throws M4Exception {
        Double v = null;
        if (var != null && var.trim().length() > 0) {
            v = new Double(var);
        }
        this.getBasicStat().setVariance(v);
    }

    public Columnset getColumnset() {
        return this.myColumnSet;
    }

    public void setColumnset(Columnset cs) throws M4Exception {
        edu.udo.cs.miningmart.m4.core.Columnset.cs2col.checkNameExists(this, cs);
        edu.udo.cs.miningmart.m4.core.Columnset.cs2col.updateReferenceTo(this, cs);
    }

    public String readOrComputeMinimum() throws M4Exception {
        String min = this.getMinValue();
        if (min == null) {
            Columnset cs = this.getColumnset();
            String query = "SELECT MIN(" + this.getSQLDefinition() + ") FROM " + cs.getSchemaPlusName();
            min = this.executeBusinessSingleValueSqlRead(query);
            if (min == null) {
                String addInfo = cs.getStatisticsAll() > 0L ? "!" : " because this columnset has no rows!";
                throw new M4Exception("Could not compute minimum for column '" + this.getName() + "', M4 id " + this.getId() + " in columnset '" + cs.getName() + "'" + addInfo);
            }
            this.setMinValue(min);
        }
        return min;
    }

    public String readOrComputeAverage() throws M4Exception {
        String avg = this.getAverageValue();
        if (avg == null) {
            edu.udo.cs.miningmart.m4.core.Columnset cs = (edu.udo.cs.miningmart.m4.core.Columnset)this.getColumnset();
            String query = "SELECT AVG(" + this.getSQLDefinition() + ") FROM " + cs.getSchemaPlusName();
            avg = this.executeBusinessSingleValueSqlRead(query);
            if (avg == null) {
                throw new M4Exception("Could not compute average value for column '" + this.getName() + "', M4 id " + this.getId() + " in columnset '" + cs.getName() + "'!");
            }
            this.setAverageValue(avg);
        }
        return avg;
    }

    public String readOrComputeStdDev() throws M4Exception {
        String stddev = this.getStandardDeviation();
        if (stddev == null) {
            edu.udo.cs.miningmart.m4.core.Columnset cs = (edu.udo.cs.miningmart.m4.core.Columnset)this.getColumnset();
            String query = "SELECT STDDEV(" + this.getSQLDefinition() + ") FROM " + cs.getSchemaPlusName();
            stddev = this.executeBusinessSingleValueSqlRead(query);
            if (stddev == null) {
                throw new M4Exception("Could not compute standard deviation for column '" + this.getName() + "', M4 id " + this.getId() + " in columnset '" + cs.getName() + "'!");
            }
            this.setAverageValue(stddev);
        }
        return stddev;
    }

    public String readOrComputeMaximum() throws M4Exception {
        String max = this.getMaxValue();
        if (max == null) {
            Columnset cs = this.getColumnset();
            String query = "SELECT MAX(" + this.getSQLDefinition() + ") FROM " + cs.getSchemaPlusName();
            max = this.executeBusinessSingleValueSqlRead(query);
            if (max == null) {
                throw new M4Exception("Could not compute minimum for column '" + this.getName() + "', M4 id " + this.getId() + " in columnset '" + cs.getName() + "'!");
            }
            this.setMaxValue(max);
        }
        return max;
    }

    public int readOrComputeNumMissingValues() throws M4Exception {
        if (this.isMissingNumberOfMissingValues()) {
            edu.udo.cs.miningmart.m4.core.Columnset cs = (edu.udo.cs.miningmart.m4.core.Columnset)this.getColumnset();
            String query = "SELECT COUNT(*) FROM " + cs.getSchemaPlusName() + " WHERE " + this.getSQLDefinition() + " IS NULL";
            Long missingL = this.executeBusinessSingleValueSqlReadL(query);
            if (missingL == null) {
                throw new M4Exception("Could not compute number of missing values for column '" + this.getName() + "', M4 id " + this.getId() + " in columnset '" + cs.getName() + "'!");
            }
            this.setNumberOfMissingValues(missingL.intValue());
        }
        return this.getNumberOfMissingValues();
    }

    public int readOrComputeUniqueValues() throws M4Exception {
        if (this.isMissingNumberOfUniqueValues()) {
            edu.udo.cs.miningmart.m4.core.Columnset cs = (edu.udo.cs.miningmart.m4.core.Columnset)this.getColumnset();
            String query = "SELECT COUNT(*) FROM (SELECT DISTINCT " + this.getSQLDefinition() + " FROM " + cs.getSchemaPlusName() + " WHERE " + this.getSQLDefinition() + " IS NOT NULL) foo";
            Long uniqueL = this.executeBusinessSingleValueSqlReadL(query);
            if (uniqueL == null) {
                throw new M4Exception("Could not compute number of missing values for column '" + this.getName() + "', M4 id " + this.getId() + " in columnset '" + cs.getName() + "'!");
            }
            this.setNumberOfUniqueValues(uniqueL.intValue());
        }
        return this.getNumberOfUniqueValues();
    }

    public void clearStatistics() throws M4Exception {
        colCstat1.setCollectionTo(this, new Vector(0));
        colCstat2.setCollectionTo(this, new Vector(0));
    }

    public void updateStatistics() throws M4Exception {
        try {
            int numMissing;
            Long numDistinct;
            String csName = this.getColumnset().getSchemaPlusName();
            String colSql = this.getSQLDefinition().trim();
            long colDt = this.getColumnDataType();
            if (this.isMissingNumberOfUniqueValues() && (numDistinct = this.executeBusinessSingleValueSqlReadL("SELECT COUNT(DISTINCT " + colSql + ")" + " FROM " + csName)) != null) {
                this.setNumberOfUniqueValues(numDistinct.intValue());
            }
            if (this.isMissingNumberOfMissingValues()) {
                Long numMissingL = this.executeBusinessSingleValueSqlReadL("SELECT COUNT(*) FROM " + csName + " WHERE (" + colSql + ") IS NULL");
                if (numMissingL != null) {
                    numMissing = numMissingL.intValue();
                    this.setNumberOfMissingValues(numMissing);
                } else {
                    numMissing = 0;
                }
            } else {
                numMissing = this.getNumberOfMissingValues();
            }
            long rowCount = this.getColumnset().getStatisticsAll() - (long)numMissing;
            if (rowCount == 0L) {
                return;
            }
            switch ((short)colDt) {
                case 12: {
                    this.updateOrdinalValueStatistics(rowCount);
                    break;
                }
                case 13: {
                    this.updateNominalValueStatistics();
                    break;
                }
                case 14: {
                    this.updateTimeValueStatistics(rowCount);
                    break;
                }
                case 15: {
                    this.updateKeyValueStatistics();
                    break;
                }
                default: {
                    throw new M4CompilerError("Invalid Column Datatype '" + colDt + "' in CompilerDatabaseService.updateStatistics!");
                }
            }
        }
        catch (M4CompilerError m4e) {
            throw new M4Exception("M4 error when updating statistics: " + m4e.getMessage());
        }
    }

    private void updateOrdinalValueStatistics(long rowCount) throws M4Exception {
        try {
            String maxVal;
            String minVal;
            String csName = this.getColumnset().getSchemaPlusName();
            String colSql = this.getSQLDefinition().trim();
            try {
                minVal = this.readOrComputeMinimum();
                maxVal = this.readOrComputeMaximum();
            }
            catch (M4Exception e) {
                this.updateNominalValueStatistics();
                return;
            }
            this.readOrComputeAverage();
            ResultSet rs = null;
            try {
                Collection oldDistStat;
                if (this.getStandardDeviation() == null || this.getVariance() == null) {
                    String que = "SELECT ROUND(STDDEV(" + colSql + "),5), " + " ROUND(MOD(VARIANCE(" + colSql + "),100000000000000000000000000000000000000),5) " + " FROM " + csName;
                    if (this.getM4Db().getBusinessDbms() == 2) {
                        que = "SELECT STDDEV(" + colSql + "), VARIANCE(" + colSql + ") FROM " + csName;
                    }
                    if ((rs = this.executeBusinessSqlRead(que)).next()) {
                        double stddevVal = rs.getDouble(1);
                        if (!rs.wasNull()) {
                            this.setStandardDeviation(Double.toString(stddevVal));
                        }
                        double varVal = rs.getDouble(2);
                        if (!rs.wasNull()) {
                            this.setVariance(Double.toString(varVal));
                        }
                    }
                    rs.close();
                    rs = null;
                }
                if ((oldDistStat = this.getDistributionStatistics()) == null || oldDistStat.isEmpty() || this.getMedianValue() == null || this.getModalValue() == null) {
                    colCstat2.setCollectionTo(this, new Vector(0));
                    if (minVal != null && maxVal != null && !minVal.equals(maxVal)) {
                        String que = "SELECT AVG(" + colSql + ")," + " COUNT(*), " + " MIN(" + colSql + ")," + " MAX(" + colSql + ") " + " FROM " + csName + " WHERE NOT (" + colSql + ") IS NULL " + " GROUP BY ROUND((" + colSql + " - " + minVal + ")" + " / (" + maxVal + " - " + minVal + ") * 10)" + " ORDER BY AVG(" + colSql + ")";
                        double modalCount = 0.0;
                        double medianSum = 0.0;
                        String modalVal = "NULL";
                        String medianVal = "NULL";
                        rs = this.executeBusinessSqlRead(que);
                        while (rs.next()) {
                            ColumnStatistics2 csstat2 = (ColumnStatistics2)this.getM4Db().createNewInstance(ColumnStatistics2.class);
                            csstat2.setTheColumn(this);
                            csstat2.setDistributionValue(rs.getString(1));
                            csstat2.setDistributionCount((int)rs.getLong(2));
                            double d = rs.getDouble(3);
                            if (!rs.wasNull()) {
                                csstat2.setDistributionMinimum(d);
                            }
                            d = rs.getDouble(4);
                            if (!rs.wasNull()) {
                                csstat2.setDistributionMaximum(d);
                            }
                            if ((double)csstat2.getDistributionCount() > modalCount) {
                                modalCount = csstat2.getDistributionCount();
                                modalVal = csstat2.getDistributionValue();
                            }
                            if (medianSum <= (double)(rowCount / 2L) && (double)(rowCount / 2L) <= medianSum + (double)csstat2.getDistributionCount()) {
                                medianVal = csstat2.getDistributionValue();
                            }
                            medianSum += (double)csstat2.getDistributionCount();
                        }
                        this.setModalValue(modalVal);
                        this.setMedianValue(medianVal);
                    }
                }
            }
            catch (SQLException e) {
                throw new M4CompilerError("Column.updateOrdinalValueStatistics(Column ID: " + this.getId() + ") :" + e.getMessage());
            }
            finally {
                DB.closeResultSet(rs);
            }
        }
        catch (M4CompilerError m4e) {
            throw new M4Exception("M4 error when updating statistics: " + m4e.getMessage());
        }
    }

    private void updateNominalValueStatistics() throws M4Exception {
        String csName = this.getColumnset().getSchemaPlusName();
        String colSql = this.getSQLDefinition().trim();
        long colId = this.getId();
        ResultSet rs = null;
        try {
            Collection oldDistStat = this.getDistributionStatistics();
            if (oldDistStat == null || oldDistStat.isEmpty() || this.getModalValue() == null) {
                colCstat2.setCollectionTo(this, new Vector(0));
                String que = "SELECT (" + colSql + "), " + " COUNT(*) FROM " + csName + " WHERE (" + colSql + ") IS NOT NULL" + " GROUP BY (" + colSql + ")";
                double modalCount = 0.0;
                String modalVal = "NULL";
                rs = this.executeBusinessSqlRead(que);
                while (rs.next()) {
                    String attrName = rs.getString(1);
                    if (rs.wasNull()) {
                        attrName = "NULL";
                    }
                    long attrCount = rs.getLong(2);
                    ColumnStatistics2 cstat2 = (ColumnStatistics2)this.getM4Db().createNewInstance(ColumnStatistics2.class);
                    cstat2.setTheColumn(this);
                    cstat2.setDistributionValue(attrName);
                    cstat2.setDistributionCount((int)attrCount);
                    if (!((double)attrCount > modalCount)) continue;
                    modalCount = attrCount;
                    modalVal = attrName;
                }
                this.setModalValue(modalVal);
            }
        }
        catch (SQLException e) {
            throw new M4Exception("CompilerDatabaseService.updateOrdinalValueStatistics(Column ID: " + colId + ") :" + e.getMessage());
        }
        finally {
            DB.closeResultSet(rs);
        }
    }

    private void updateTimeValueStatistics(long rowCount) throws M4Exception {
        String csName = this.getColumnset().getSchemaPlusName();
        String colSql = this.getSQLDefinition().trim();
        long colId = this.getId();
        try {
            this.readOrComputeMinimum();
            this.readOrComputeMaximum();
        }
        catch (M4Exception e) {
            // empty catch block
        }
        Collection oldDistStat = this.getDistributionStatistics();
        if (oldDistStat != null && !oldDistStat.isEmpty() && this.getModalValue() != null && this.getMedianValue() != null) {
            return;
        }
        ResultSet rs = null;
        try {
            colCstat2.setCollectionTo(this, new Vector(0));
            long monthBetween = this.getM4Db().getNumberOfMonthsBetween(csName, "MAX(" + colSql + ")", "MIN(" + colSql + ")");
            String distBase = monthBetween > 600L ? "YYYY" : (monthBetween > 60L ? "YYYYQ" : (monthBetween > 3L ? "YYYYMM" : (monthBetween > 0L ? "YYYYMMDD" : "YYYYMMDD")));
            String query = this.getM4Db().getSelectStringDistribValuesTimeColumn(colSql, csName, distBase);
            double modalCount = 0.0;
            double medianSum = 0.0;
            String modalVal = "NULL";
            String medianVal = "NULL";
            rs = this.executeBusinessSqlRead(query);
            while (rs.next()) {
                String attrVal = rs.getString(1);
                if (rs.wasNull()) {
                    attrVal = "NULL";
                }
                attrVal = this.removeSeparators(attrVal);
                long attrCount = rs.getLong(2);
                String attrMin = rs.getString(3);
                if (rs.wasNull()) {
                    attrMin = "NULL";
                }
                attrMin = this.removeSeparators(attrMin);
                String attrMax = rs.getString(4);
                if (rs.wasNull()) {
                    attrMax = "NULL";
                }
                attrMax = this.removeSeparators(attrMax);
                ColumnStatistics2 cstat2 = (ColumnStatistics2)this.getM4Db().createNewInstance(ColumnStatistics2.class);
                cstat2.setTheColumn(this);
                cstat2.setDistributionValue(attrVal);
                cstat2.setDistributionCount((int)attrCount);
                cstat2.setDistributionMinimum(Double.parseDouble(attrMin));
                cstat2.setDistributionMaximum(Double.parseDouble(attrMax));
                if ((double)attrCount > modalCount) {
                    modalCount = attrCount;
                    modalVal = attrVal;
                }
                if (medianSum <= (double)(rowCount / 2L) && (double)(rowCount / 2L) <= medianSum + (double)attrCount) {
                    medianVal = attrVal;
                }
                medianSum += (double)attrCount;
            }
            this.setModalValue(modalVal);
            this.setMedianValue(medianVal);
        }
        catch (SQLException e) {
            try {
                throw new M4Exception("CompilerDatabaseService.updateOrdinalValueStatistics(Column ID: " + colId + ") :" + e.getMessage());
            }
            catch (Throwable throwable) {
                DB.closeResultSet(rs);
                throw throwable;
            }
        }
        DB.closeResultSet(rs);
    }

    private String removeSeparators(String dateWithSeparationCharacters) {
        return dateWithSeparationCharacters.replaceAll("-", "");
    }

    private void updateKeyValueStatistics() {
        try {
            this.readOrComputeMinimum();
            this.readOrComputeMaximum();
        }
        catch (M4Exception m4Exception) {
            // empty catch block
        }
    }

    private void readBaseAttributeForColumnFromDB() throws M4Exception {
        String query = "SELECT bac_baid FROM ba_column_t WHERE bac_colid = " + this.getId();
        Long baId = this.executeM4SingleValueSqlReadL(query);
        edu.udo.cs.miningmart.m4.core.BaseAttribute ba = null;
        if (baId != null) {
            ba = (edu.udo.cs.miningmart.m4.core.BaseAttribute)this.getM4Db().getM4Object(baId, edu.udo.cs.miningmart.m4.core.BaseAttribute.class);
        }
        this.primitiveSetBaseAttribute(ba);
    }

    public void primitiveSetBaseAttribute(BaseAttribute ba) {
        this.setDirty();
        this.myBaseAttribute = (edu.udo.cs.miningmart.m4.core.BaseAttribute)ba;
    }

    public void primitiveSetColumnset(Columnset cs) {
        this.setDirty();
        this.myColumnSet = (edu.udo.cs.miningmart.m4.core.Columnset)cs;
    }

    protected void readFromDbLocal() throws M4Exception {
        this.readBaseAttributeForColumnFromDB();
    }

    public void storeLocal() throws M4Exception {
        super.storeLocal();
        String sql = "DELETE FROM ba_column_t WHERE bac_colid = " + this.getId();
        this.executeM4SqlWrite(sql);
        if (this.getTheBaseAttribute() != null) {
            String baId = Long.toString(this.getTheBaseAttribute().getId());
            String sql2 = "INSERT INTO ba_column_t ( bac_id, bac_colid, bac_baid ) VALUES ( " + this.getNextM4SequenceValue() + ", " + this.getId() + ", " + baId + " )";
            this.executeM4SqlWrite(sql2);
        }
    }

    protected void deleteLocal() throws M4Exception {
        super.deleteLocal();
        String sql = "DELETE FROM ba_column_t WHERE bac_colid = " + this.getId();
        this.executeM4SqlWrite(sql);
    }

    public void deleteSoon() throws M4Exception {
        Collection stats;
        Collection fks;
        Collection pks = this.getPrimaryKeyMembers();
        if (pks != null && !pks.isEmpty()) {
            for (KeyMember km : new Vector(pks)) {
                km.deleteSoon();
            }
        }
        if ((fks = this.getForeignKeyMembers()) != null && !fks.isEmpty()) {
            for (KeyMember km : new Vector(fks)) {
                km.deleteSoon();
            }
        }
        if ((stats = this.getDistributionStatistics()) != null && !stats.isEmpty()) {
            for (ColumnStatistics2 mystats2 : new Vector(stats)) {
                mystats2.deleteSoon();
            }
        }
        if ((stats = this.getBasicColStats()) != null && !stats.isEmpty()) {
            for (ColumnStatistics1 mystats1 : new Vector(stats)) {
                mystats1.deleteSoon();
            }
        }
        super.deleteSoon();
    }

    protected void removeAllM4References() throws M4Exception {
        Vector empty = new Vector(0);
        colCstat1.setCollectionTo(this, empty);
        colPkMem.setCollectionTo(this, empty);
        colFkMem.setCollectionTo(this, empty);
        this.setDistributionStatistics(null);
        this.setBaseAttribute(null);
        this.setColumnset(null);
        this.removeDocObject();
    }

    public Collection getDependentObjects() throws M4Exception {
        Collection ret = super.getDependentObjects();
        ret.addAll(this.getBasicColStats());
        ret.addAll(this.getDistributionStatistics());
        ret.addAll(this.getPrimaryKeyMembers());
        ret.addAll(this.getForeignKeyMembers());
        return ret;
    }

    public void removeBaseAttribute() throws M4Exception {
        this.setBaseAttribute(null);
    }
}

