/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.m4.core;

import edu.udo.cs.miningmart.db.DB;
import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.m4.Step;
import edu.udo.cs.miningmart.m4.core.Case;
import edu.udo.cs.miningmart.m4.core.Concept;
import edu.udo.cs.miningmart.m4.core.GraphicalM4Object;
import edu.udo.cs.miningmart.m4.core.M4Object;
import edu.udo.cs.miningmart.m4.utils.HasCrossReferences;
import edu.udo.cs.miningmart.m4.utils.InterM4ChainStep;
import edu.udo.cs.miningmart.m4.utils.InterM4ChainToParentChain;
import edu.udo.cs.miningmart.m4.utils.InterM4Communicator;
import edu.udo.cs.miningmart.m4.utils.M4Info;
import edu.udo.cs.miningmart.m4.utils.M4InfoEntry;
import edu.udo.cs.miningmart.m4.utils.Print;
import edu.udo.cs.miningmart.m4.utils.XmlInfo;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

public class Chain
extends GraphicalM4Object
implements XmlInfo,
edu.udo.cs.miningmart.m4.Chain,
HasCrossReferences {
    public static final String M4_TABLE = "chain_t";
    public static final String ATTRIB_CHAIN_ID = "ch_id";
    public static final String ATTRIB_CASE_ID = "ch_caseid";
    public static final String ATTRIB_PARENTCHAIN_ID = "ch_parent";
    public static final String ATTRIB_CHAIN_NAME = "ch_name";
    public static final String ATTRIB_CHAIN_DESCR = "ch_descript";
    static final InterM4Communicator chain2step = new InterM4ChainStep();
    static final InterM4Communicator chain2parentChain = new InterM4ChainToParentChain();
    public static M4Info m4Info = null;
    private static M4Info xmlInfo = null;
    private String myDescription;
    private Case myCase;
    private Chain myParentChain = null;
    private final Vector mySteps = new Vector();
    private final Vector mySubchains = new Vector();
    private boolean allSubchainsLoaded = false;
    private boolean allStepsLoaded = false;

    public String getM4TableName() {
        return M4_TABLE;
    }

    public String getIdAttributeName() {
        return ATTRIB_CHAIN_ID;
    }

    public M4Info getM4Info() {
        if (m4Info == null) {
            M4InfoEntry[] m4i = new M4InfoEntry[]{new M4InfoEntry(ATTRIB_CHAIN_ID, "getId", "setId", Long.TYPE, "NN"), new M4InfoEntry(ATTRIB_CHAIN_NAME, "getName", "setName", String.class, "NN"), new M4InfoEntry(ATTRIB_PARENTCHAIN_ID, "getParentChain", "primitiveSetParentChain", edu.udo.cs.miningmart.m4.Chain.class), new M4InfoEntry(ATTRIB_CASE_ID, "getTheCase", "primitiveSetCase", edu.udo.cs.miningmart.m4.Case.class, "NN"), new M4InfoEntry(ATTRIB_CHAIN_DESCR, "getDescription", "setDescription", String.class)};
            m4Info = new M4Info(m4i);
        }
        return m4Info;
    }

    public M4Info getXmlInfo() {
        if (xmlInfo == null) {
            M4InfoEntry[] m4i = new M4InfoEntry[]{new M4InfoEntry("Name", "getName", "setName", String.class), new M4InfoEntry("Case", "getTheCase", "setTheCase", edu.udo.cs.miningmart.m4.Case.class), new M4InfoEntry("ParentChain", "getParentChain", "setParentChain", edu.udo.cs.miningmart.m4.Chain.class), new M4InfoEntry("Description", "getDescription", "setDescription", String.class), new M4InfoEntry("Docu", "getDocumentation", "setDocumentation", String.class)};
            xmlInfo = new M4Info(m4i);
        }
        return xmlInfo;
    }

    public Chain(DB db) {
        super(db);
    }

    public void print() {
        this.doPrint(Print.M4_OBJECT, "Chain (Id = " + this.getId() + ";" + "      Name = " + this.getName() + ";" + "      Steps: ");
        try {
            for (Long l : this.getTopLevelSteps()) {
                if (l == null) continue;
                this.doPrint(Print.M4_OBJECT, "Step " + l);
            }
        }
        catch (M4Exception e) {
            this.doPrint(Print.M4_OBJECT, "Warning: Error loading steps in Chain.print(): " + e.getMessage());
        }
        this.doPrint(Print.M4_OBJECT, ")");
        super.print();
    }

    public Collection getCrossReferences() {
        Vector<Chain> allParents = new Vector<Chain>();
        for (Chain parent = (Chain)this.getParentChain(); parent != null; parent = (Chain)parent.getParentChain()) {
            allParents.add(parent);
        }
        return allParents;
    }

    protected Collection getObjectsInNamespace(Class typeOfObjects) throws M4Exception {
        if (typeOfObjects.isAssignableFrom(Chain.class)) {
            return this.getDirectSubChains();
        }
        if (typeOfObjects.isAssignableFrom(edu.udo.cs.miningmart.m4.core.Step.class)) {
            return this.getTopLevelSteps();
        }
        throw new M4Exception("Chain.getObjectsInNamespace: unknown type of objects given: " + typeOfObjects.getName());
    }

    public Collection getTopLevelSteps() throws M4Exception {
        if (!this.allStepsLoaded && !this.isNew()) {
            this.allStepsLoaded = true;
            this.readStepsForChainFromDb();
        }
        return this.mySteps;
    }

    public Iterator getTopLevelStepsSequentialised() throws M4Exception {
        Collection c = this.getTopLevelSteps();
        if (!c.isEmpty()) {
            Iterator allStepsIterator = this.getTheCase().getStepIterator();
            Vector<edu.udo.cs.miningmart.m4.core.Step> sortedStepsOfThisChain = new Vector<edu.udo.cs.miningmart.m4.core.Step>();
            while (allStepsIterator.hasNext()) {
                edu.udo.cs.miningmart.m4.core.Step globalStep = (edu.udo.cs.miningmart.m4.core.Step)allStepsIterator.next();
                for (edu.udo.cs.miningmart.m4.core.Step nextStep : c) {
                    if (!globalStep.equals(nextStep)) continue;
                    sortedStepsOfThisChain.add(nextStep);
                }
            }
            return sortedStepsOfThisChain.iterator();
        }
        return null;
    }

    public edu.udo.cs.miningmart.m4.Chain createSubChain(String name, Collection stepsAndChains) throws M4Exception {
        if (stepsAndChains == null) {
            this.doPrint(Print.M4_OBJECT, "Warning: Chain.createSubChain/2: got <null> instead of a collection of steps and chains!");
        }
        Chain newChain = (Chain)this.getTheCase().createChain(name);
        for (M4Object anM4Object : stepsAndChains) {
            if (anM4Object instanceof edu.udo.cs.miningmart.m4.core.Step) {
                newChain.addStep((edu.udo.cs.miningmart.m4.core.Step)anM4Object);
                continue;
            }
            if (anM4Object instanceof Chain) {
                newChain.addSubChain((Chain)anM4Object);
                continue;
            }
            throw new M4Exception("Case.createChain/2: found something in the given collection that is neither Step nor Chain!");
        }
        newChain.setParentChain(this);
        return newChain;
    }

    public edu.udo.cs.miningmart.m4.Case getTheCase() {
        return this.myCase;
    }

    public void deleteSoon() throws M4Exception {
        Collection subchains;
        Collection steps = this.getTopLevelSteps();
        if (steps == null) {
            throw new M4Exception("Chain.deleteSoon: got NULL when looking for my top level steps (in Chain '" + this.getName() + "')!");
        }
        Iterator stIt = steps.iterator();
        Chain parent = (Chain)this.getParentChain();
        if (parent != null) {
            Vector<edu.udo.cs.miningmart.m4.core.Step> theSteps = new Vector<edu.udo.cs.miningmart.m4.core.Step>();
            while (stIt.hasNext()) {
                edu.udo.cs.miningmart.m4.core.Step aStep = (edu.udo.cs.miningmart.m4.core.Step)stIt.next();
                theSteps.add(aStep);
            }
            for (edu.udo.cs.miningmart.m4.core.Step aStep : theSteps) {
                parent.addStep(aStep);
            }
        }
        if ((subchains = this.getDirectSubChains()) == null) {
            throw new M4Exception("Chain.deleteSoon: got NULL when looking for my direct subchains (in Chain '" + this.getName() + "')!");
        }
        for (Chain subChain : new Vector(subchains)) {
            subChain.setParentChain(parent);
        }
        super.deleteSoon();
    }

    public Collection getAllSteps() throws M4Exception {
        Vector allTheSteps = new Vector();
        this.getAllSteps(allTheSteps);
        return allTheSteps;
    }

    private void getAllSteps(Collection allTheSteps) throws M4Exception {
        Collection thisLevelsSteps = this.getTopLevelSteps();
        allTheSteps.addAll(thisLevelsSteps);
        Collection thisLevelsSubchains = this.getDirectSubChains();
        if (thisLevelsSubchains == null) {
            throw new M4Exception("Chain '" + this.getName() + "': got NULL when asking for subchains!");
        }
        for (Chain aChain : thisLevelsSubchains) {
            aChain.getAllSteps(allTheSteps);
        }
    }

    public Collection getAllChains() throws M4Exception {
        Vector allTheChains = new Vector();
        this.getAllChains(allTheChains);
        return allTheChains;
    }

    private void getAllChains(Collection allTheChains) throws M4Exception {
        Collection thisLevelsSubchains = this.getDirectSubChains();
        if (thisLevelsSubchains == null) {
            throw new M4Exception("Chain '" + this.getName() + "': got NULL when asking for direct subchains!");
        }
        allTheChains.addAll(thisLevelsSubchains);
        for (Chain aChain : thisLevelsSubchains) {
            aChain.getAllChains(allTheChains);
        }
    }

    public boolean dependencyExists(Step toStep) throws M4Exception {
        Collection allStepsOfThisChain = this.getAllSteps();
        if (allStepsOfThisChain == null) {
            throw new M4Exception("Chain '" + this.getName() + "': got NULL when asking for all steps!");
        }
        for (edu.udo.cs.miningmart.m4.core.Step aStep : allStepsOfThisChain) {
            if (!this.getTheCase().containsDependency(aStep, toStep)) continue;
            return true;
        }
        return false;
    }

    public boolean dependencyExists(edu.udo.cs.miningmart.m4.Chain toChain) throws M4Exception {
        Collection allStepsOfThisChain = this.getAllSteps();
        Collection allStepsOfToChain = toChain.getAllSteps();
        if (allStepsOfThisChain == null) {
            throw new M4Exception("Chain '" + this.getName() + "': got NULL when asking for all steps!");
        }
        if (allStepsOfToChain == null) {
            throw new M4Exception("ToChain '" + toChain.getName() + "': got NULL when asking for all steps!");
        }
        for (edu.udo.cs.miningmart.m4.core.Step aStep : allStepsOfThisChain) {
            for (edu.udo.cs.miningmart.m4.core.Step toStep : allStepsOfToChain) {
                if (!this.getTheCase().containsDependency(aStep, toStep)) continue;
                return true;
            }
        }
        return false;
    }

    public Collection getPredecessors(Step toStep) throws M4Exception {
        Vector<edu.udo.cs.miningmart.m4.core.Step> thePredecessors = new Vector<edu.udo.cs.miningmart.m4.core.Step>();
        Collection allSteps = this.getAllSteps();
        Iterator it = allSteps.iterator();
        Case myCase = (Case)this.getTheCase();
        while (myCase != null && it.hasNext()) {
            edu.udo.cs.miningmart.m4.core.Step myStep = (edu.udo.cs.miningmart.m4.core.Step)it.next();
            if (!myCase.containsDependency(myStep, toStep)) continue;
            thePredecessors.add(myStep);
        }
        return thePredecessors;
    }

    public Collection getSuccessors(Step fromStep) throws M4Exception {
        Vector<edu.udo.cs.miningmart.m4.core.Step> theSuccessors = new Vector<edu.udo.cs.miningmart.m4.core.Step>();
        Collection allSteps = this.getAllSteps();
        Iterator it = allSteps.iterator();
        Case myCase = (Case)this.getTheCase();
        while (myCase != null && it.hasNext()) {
            edu.udo.cs.miningmart.m4.core.Step myStep = (edu.udo.cs.miningmart.m4.core.Step)it.next();
            if (!myCase.containsDependency(fromStep, myStep)) continue;
            theSuccessors.add(myStep);
        }
        return theSuccessors;
    }

    public boolean hasPredecessorOutside() throws M4Exception {
        for (edu.udo.cs.miningmart.m4.core.Step myStep : this.getAllSteps()) {
            for (edu.udo.cs.miningmart.m4.core.Step predStep : myStep.getAllPredecessors()) {
                if (predStep.getTheChain() != null && predStep.belongsToChainOrSubChain(this.getParentChain())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasSuccessorOutside() throws M4Exception {
        for (edu.udo.cs.miningmart.m4.core.Step myStep : this.getAllSteps()) {
            for (edu.udo.cs.miningmart.m4.core.Step succStep : myStep.getSuccessors()) {
                if (succStep.getTheChain() != null && succStep.belongsToChainOrSubChain(this.getParentChain())) continue;
                return true;
            }
        }
        return false;
    }

    public Collection getAllTransitionsToChain(edu.udo.cs.miningmart.m4.Chain toChain) throws M4Exception {
        Collection allToSteps = toChain.getAllSteps();
        Vector<edu.udo.cs.miningmart.m4.core.Step[]> resultingPairs = new Vector<edu.udo.cs.miningmart.m4.core.Step[]>();
        if (allToSteps != null) {
            for (edu.udo.cs.miningmart.m4.core.Step toStep : allToSteps) {
                Collection allFromSteps = this.getPredecessors(toStep);
                if (allFromSteps == null) continue;
                Iterator it2 = allFromSteps.iterator();
                while (it2.hasNext()) {
                    edu.udo.cs.miningmart.m4.core.Step[] onePair = new edu.udo.cs.miningmart.m4.core.Step[]{(edu.udo.cs.miningmart.m4.core.Step)it2.next(), toStep};
                    resultingPairs.add(onePair);
                }
            }
        }
        resultingPairs.trimToSize();
        return resultingPairs;
    }

    public Collection getInvolvedConcepts() throws M4Exception {
        Collection myTopLevelSteps = this.getTopLevelSteps();
        Vector<Concept> involvedConcepts = new Vector<Concept>();
        if (myTopLevelSteps != null && !myTopLevelSteps.isEmpty()) {
            for (edu.udo.cs.miningmart.m4.core.Step aStep : myTopLevelSteps) {
                Collection stepInvolvedConcepts = aStep.getAllInputConcepts();
                Concept out = (Concept)aStep.getOutputConcept();
                if (out != null) {
                    stepInvolvedConcepts.add(out);
                }
                if (stepInvolvedConcepts == null || stepInvolvedConcepts.isEmpty()) continue;
                for (Concept oneInputConcept : stepInvolvedConcepts) {
                    if (involvedConcepts.contains(oneInputConcept)) continue;
                    involvedConcepts.add(oneInputConcept);
                }
            }
        }
        return involvedConcepts;
    }

    public edu.udo.cs.miningmart.m4.Chain getParentChain() {
        return this.myParentChain;
    }

    public String getDescription() {
        return this.myDescription;
    }

    public void setTheCase(edu.udo.cs.miningmart.m4.Case m4Case) throws M4Exception {
        Case.case2chain.checkNameExists(this, m4Case);
        Case.case2chain.updateReferenceTo(this, m4Case);
    }

    public void primitiveSetCase(edu.udo.cs.miningmart.m4.Case m4case) {
        this.setDirty();
        this.myCase = (Case)m4case;
    }

    public void setParentChain(edu.udo.cs.miningmart.m4.Chain theParentChain) throws M4Exception {
        chain2parentChain.checkNameExists(this, theParentChain);
        chain2parentChain.updateReferenceTo(this, theParentChain);
    }

    public void primitiveSetParentChain(edu.udo.cs.miningmart.m4.Chain theParentChain) {
        this.setDirty();
        this.myParentChain = (Chain)theParentChain;
    }

    public void setDescription(String description) {
        this.setDirty();
        this.myDescription = description;
    }

    public void addStep(Step step) throws M4Exception {
        chain2step.checkNameExists((edu.udo.cs.miningmart.m4.core.Step)step, this);
        chain2step.add(this, (edu.udo.cs.miningmart.m4.core.Step)step);
    }

    public boolean removeStep(Step step) throws M4Exception {
        return chain2step.remove(this, (edu.udo.cs.miningmart.m4.core.Step)step);
    }

    private void readStepsForChainFromDb() throws M4Exception {
        Iterator it = this.getObjectsReferencingMe(edu.udo.cs.miningmart.m4.core.Step.class).iterator();
        while (it.hasNext()) {
            this.addStep((Step)it.next());
        }
    }

    private void readSubchainsForChainFromDb() throws M4Exception {
        Iterator it = this.getObjectsReferencingMe(Chain.class).iterator();
        while (it.hasNext()) {
            this.addSubChain((edu.udo.cs.miningmart.m4.Chain)it.next());
        }
    }

    protected void removeAllM4References() throws M4Exception {
        this.setTheCase(null);
        this.setParentChain(null);
        chain2step.setCollectionTo(this, new Vector());
        chain2parentChain.setCollectionTo(this, new Vector());
        this.setDescription(null);
        this.removeDocObject();
    }

    protected boolean hasCoordinates() {
        return true;
    }

    protected Collection getGraphicallyEmbeddedObjects() throws M4Exception {
        Collection ret = this.getTopLevelSteps();
        ret.addAll(this.getDirectSubChains());
        return ret;
    }

    public Collection getDependentObjects() throws M4Exception {
        Collection ret = super.getDependentObjects();
        ret.addAll(this.getTopLevelSteps());
        ret.addAll(this.getDirectSubChains());
        return ret;
    }

    public edu.udo.cs.miningmart.m4.Chain copy(edu.udo.cs.miningmart.m4.Case newCase) throws M4Exception {
        Chain theCopy = new Chain(this.getM4Db());
        theCopy.setTheCase(newCase);
        theCopy.setDescription(this.getDescription());
        String nameOfCopy = newCase.getValidName(this.getName(), Chain.class);
        theCopy.setName(nameOfCopy);
        return theCopy;
    }

    public void addSubChain(edu.udo.cs.miningmart.m4.Chain subchain) throws M4Exception {
        chain2parentChain.checkNameExists((Chain)subchain, this);
        chain2parentChain.add(this, (Chain)subchain);
    }

    public void resolveSubChain(edu.udo.cs.miningmart.m4.Chain chain) throws M4Exception {
        Iterator it = this.getDirectSubChains().iterator();
        Collection stepsOfResolvedChain = null;
        Collection chainsOfResolvedChain = null;
        Chain chainToBeResolved = null;
        while (it.hasNext()) {
            Chain myChain = (Chain)it.next();
            if (!myChain.equals(chain)) continue;
            chainToBeResolved = myChain;
            stepsOfResolvedChain = chainToBeResolved.getTopLevelSteps();
            chainsOfResolvedChain = chainToBeResolved.getDirectSubChains();
        }
        if (stepsOfResolvedChain != null && chainsOfResolvedChain != null) {
            for (edu.udo.cs.miningmart.m4.core.Step myStep : stepsOfResolvedChain) {
                myStep.setTheChain(this);
            }
            for (Chain subChain : chainsOfResolvedChain) {
                subChain.setParentChain(this);
            }
            chainToBeResolved.deleteSoon();
        }
    }

    public Collection getDirectSubChains() throws M4Exception {
        if (!this.allSubchainsLoaded && !this.isNew()) {
            this.allSubchainsLoaded = true;
            this.readSubchainsForChainFromDb();
        }
        return this.mySubchains;
    }
}

