/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.m4.core;

import edu.udo.cs.miningmart.db.DB;
import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.m4.Chain;
import edu.udo.cs.miningmart.m4.Columnset;
import edu.udo.cs.miningmart.m4.Relation;
import edu.udo.cs.miningmart.m4.Step;
import edu.udo.cs.miningmart.m4.core.BaseAttribute;
import edu.udo.cs.miningmart.m4.core.Column;
import edu.udo.cs.miningmart.m4.core.Concept;
import edu.udo.cs.miningmart.m4.core.ConceptualDatatypes;
import edu.udo.cs.miningmart.m4.core.Feature;
import edu.udo.cs.miningmart.m4.core.ForeignKey;
import edu.udo.cs.miningmart.m4.core.M4Data;
import edu.udo.cs.miningmart.m4.core.M4Object;
import edu.udo.cs.miningmart.m4.core.OpParam;
import edu.udo.cs.miningmart.m4.core.Operator;
import edu.udo.cs.miningmart.m4.core.Projection;
import edu.udo.cs.miningmart.m4.core.Value;
import edu.udo.cs.miningmart.m4.utils.InterM4CaseChain;
import edu.udo.cs.miningmart.m4.utils.InterM4CaseConcept;
import edu.udo.cs.miningmart.m4.utils.InterM4CaseStep;
import edu.udo.cs.miningmart.m4.utils.InterM4Communicator;
import edu.udo.cs.miningmart.m4.utils.M4Info;
import edu.udo.cs.miningmart.m4.utils.M4InfoEntry;
import edu.udo.cs.miningmart.m4.utils.Print;
import edu.udo.cs.miningmart.m4.utils.XmlInfo;
import edu.udo.cs.miningmart.schemamatching.DataModelConnection;
import edu.udo.cs.miningmart.schemamatching.DataModelMatcher;
import edu.udo.cs.miningmart.schemamatching.MatchingResult;
import edu.udo.cs.miningmart.schemamatching.MmSchemaMatcher;
import edu.udo.cs.miningmart.schemamatching.SchemaMatchException;
import java.awt.Point;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Case
extends M4Data
implements XmlInfo,
edu.udo.cs.miningmart.m4.Case {
    public static final String M4_TABLE_NAME = "case_t";
    public static final String ATTRIB_CASE_ID = "ca_id";
    public static final String ATTRIB_CASE_NAME = "ca_name";
    public static final String ATTRIB_CASE_MODE = "ca_mode";
    public static final String TESTMODE = "TEST";
    public static final String FINALMODE = "FINAL";
    static final InterM4Communicator case2con = new InterM4CaseConcept();
    static final InterM4Communicator case2step = new InterM4CaseStep();
    static final InterM4Communicator case2chain = new InterM4CaseChain();
    public static M4Info m4Info = null;
    private static M4Info xmlInfo = null;
    public static final int MATERIALISATION_DISTANCE = 4;
    public static final int THRESHOLD_INPUTSIZE_RECOMMEND_MATERIALISATION = 1000000;
    private final Vector myChains = new Vector();
    private Vector mySteps = new Vector();
    private final Vector myConcepts = new Vector();
    private Collection stepsAlreadyRecommended = new Vector();
    private boolean allConceptsLoaded = false;
    private boolean allStepsLoaded = false;
    private boolean allChainsLoaded = false;
    private Map stepToRequiredSteps = null;
    private Map changedFeatureNames = null;
    private Map newToOldNames = null;
    private String myMode = "TEST";

    @Override
    public String getM4TableName() {
        return M4_TABLE_NAME;
    }

    @Override
    public String getIdAttributeName() {
        return ATTRIB_CASE_ID;
    }

    @Override
    public M4Info getM4Info() {
        if (m4Info == null) {
            M4InfoEntry[] m4i = new M4InfoEntry[]{new M4InfoEntry(ATTRIB_CASE_ID, "getId", "setId", Long.TYPE, "NN"), new M4InfoEntry(ATTRIB_CASE_NAME, "getName", "setName", String.class, "NN"), new M4InfoEntry(ATTRIB_CASE_MODE, "getTheMode", "setTheMode", String.class, "NN")};
            m4Info = new M4Info(m4i);
        }
        return m4Info;
    }

    @Override
    public M4Info getXmlInfo() {
        if (xmlInfo == null) {
            M4InfoEntry[] m4i = new M4InfoEntry[]{new M4InfoEntry("Name", "getName", "setName", String.class), new M4InfoEntry("Docu", "getDocumentation", "setDocumentation", String.class), new M4InfoEntry("Mode", "getTheMode", "setTheMode", String.class)};
            xmlInfo = new M4Info(m4i);
        }
        return xmlInfo;
    }

    public Case(DB m4Db) {
        super(m4Db);
    }

    @Override
    public void addStepDependency(Step before, Step after) throws M4Exception {
        if (before == null || after == null) {
            throw new M4Exception("Trying to enter null-values in step dependency graph! Case: " + this.getId());
        }
        Vector steps = this.getTheSteps();
        int beforeIndex = steps.indexOf(before);
        int afterIndex = steps.indexOf(after);
        if (beforeIndex == -1 || afterIndex == -1) {
            throw new M4Exception("Trying to enter dependency for unknown step! Step ID:" + (beforeIndex == -1 ? "<" + before.getId() + ">" : "") + (afterIndex == -1 ? "<" + after.getId() + ">" : "") + ", Case ID: " + this.getId());
        }
        Collection successorsOfSuccessor = this.getDependentStepsFor(after);
        if (successorsOfSuccessor.contains(before)) {
            throw new M4Exception("Adding this dependency would result in a circle!");
        }
        Collection reversingSteps = after.getDependentReversingSteps();
        Collection pres = this.getStepsToCompileBefore(before, true);
        pres.add(before);
        for (edu.udo.cs.miningmart.m4.core.Step revStep : reversingSteps) {
            if (!pres.contains(revStep)) continue;
            throw new M4Exception("Adding this dependency would let the step '" + revStep.getName() + "',\nwhich reverses the feature construction of step '" + after.getName() + "',\ncome before '" + after.getName() + "'!");
        }
        before.addSuccessor(after);
        this.sortMyStepsAccordingToStepsequence();
        this.clearRequiredStepsMap();
        this.clearListOfRecommendations();
    }

    private void sortMyStepsAccordingToStepsequence() throws M4Exception {
        this.allStepsLoaded = false;
        this.getTheSteps();
    }

    @Override
    public boolean containsDependency(Step before, Step after) throws M4Exception {
        if (this.getTheSteps().contains(before)) {
            return before.getSuccessors().contains(after);
        }
        return false;
    }

    @Override
    public boolean removeStepDependency(Step before, Step after) throws M4Exception {
        if (before == null || after == null) {
            throw new M4Exception("Trying to remove null-entries in step dependency graph! Case: " + this.getId());
        }
        boolean done = before.removeSuccessor(after);
        if (done) {
            this.clearRequiredStepsMap();
            this.clearListOfRecommendations();
            this.sortMyStepsAccordingToStepsequence();
        }
        return done;
    }

    @Override
    protected Collection getObjectsInNamespace(Class typeOfObjects) throws M4Exception {
        if (typeOfObjects.isAssignableFrom(Concept.class)) {
            return this.getConcepts();
        }
        if (typeOfObjects.isAssignableFrom(edu.udo.cs.miningmart.m4.core.Chain.class)) {
            return this.getAllChains();
        }
        if (typeOfObjects.isAssignableFrom(edu.udo.cs.miningmart.m4.core.Step.class)) {
            return this.getTheSteps();
        }
        if (typeOfObjects.isAssignableFrom(edu.udo.cs.miningmart.m4.core.Relation.class)) {
            return this.getAllRelations();
        }
        if (typeOfObjects.isAssignableFrom(Projection.class)) {
            return this.getAllProjections();
        }
        if (typeOfObjects.isAssignableFrom(ForeignKey.class)) {
            Collection rels = this.getAllRelations();
            Vector<ForeignKey> theFKs = new Vector<ForeignKey>();
            for (edu.udo.cs.miningmart.m4.core.Relation aRel : rels) {
                ForeignKey fk = (ForeignKey)aRel.getFromKey();
                if (fk != null && !theFKs.contains(fk)) {
                    theFKs.add(fk);
                }
                if ((fk = (ForeignKey)aRel.getToKey()) == null || theFKs.contains(fk)) continue;
                theFKs.add(fk);
            }
            theFKs.trimToSize();
            return theFKs;
        }
        throw new M4Exception("Case.getObjectsInNamespace: unknown type of objects given: " + typeOfObjects.getName());
    }

    @Override
    public DataModelConnection findMatchingForInputDataModel(Collection<edu.udo.cs.miningmart.m4.Concept> targetDataModel, MmSchemaMatcher theMatcher) throws SchemaMatchException, M4Exception {
        Collection inputDataModel = this.getInputDataModel();
        DataModelConnection dmc = this.getMatching(inputDataModel, targetDataModel, theMatcher);
        if (dmc != null) {
            dmc.setDataModelProducingStep(null);
            dmc.setInitialDataModel(true);
        }
        return dmc;
    }

    @Override
    public DataModelConnection findMatchingForResultingDataModel(Step theStep, Collection<edu.udo.cs.miningmart.m4.Concept> targetDataModel, MmSchemaMatcher theMatcher) throws SchemaMatchException, M4Exception {
        if (!theStep.getTheCase().equals(this)) {
            return null;
        }
        Collection dataModel = theStep.getResultingDataModel();
        DataModelConnection dmc = this.getMatching(dataModel, targetDataModel, theMatcher);
        if (dmc != null) {
            dmc.setDataModelProducingStep(theStep);
            dmc.setInitialDataModel(false);
        }
        return dmc;
    }

    @Override
    public DataModelConnection findEntryPoint(Collection<edu.udo.cs.miningmart.m4.Concept> targetDataModel, MmSchemaMatcher theMatcher) throws SchemaMatchException, M4Exception {
        DataModelConnection currentDmc = this.findMatchingForInputDataModel(targetDataModel, theMatcher);
        double bestSimilarity = currentDmc != null ? currentDmc.getSimilarity() : -1.0;
        DataModelConnection bestConnection = currentDmc;
        Iterator allStepsIterator = this.getStepIterator();
        while (allStepsIterator.hasNext()) {
            edu.udo.cs.miningmart.m4.core.Step myStep = (edu.udo.cs.miningmart.m4.core.Step)allStepsIterator.next();
            currentDmc = this.findMatchingForResultingDataModel(myStep, targetDataModel, theMatcher);
            if (currentDmc == null || !(currentDmc.getSimilarity() > bestSimilarity)) continue;
            bestConnection = currentDmc;
            bestSimilarity = currentDmc.getSimilarity();
        }
        return bestConnection;
    }

    private DataModelConnection getMatching(Collection<edu.udo.cs.miningmart.m4.Concept> conceptualModel, Collection<edu.udo.cs.miningmart.m4.Concept> targetModel, MmSchemaMatcher theMatcher) throws SchemaMatchException {
        DataModelMatcher dmm = new DataModelMatcher(theMatcher);
        Collection<MatchingResult<edu.udo.cs.miningmart.m4.Concept>> matchResult = dmm.getDataModelMatching(conceptualModel, targetModel);
        if (matchResult == null || matchResult.isEmpty()) {
            return null;
        }
        DataModelConnection ret = new DataModelConnection();
        ret.setSimilarity(theMatcher.getGlobalSimilarity(conceptualModel, targetModel, matchResult));
        ret.setTheConceptMappings(matchResult);
        return ret;
    }

    @Override
    public Collection getAllRelations() throws M4Exception {
        Collection theConcepts = this.getConcepts();
        Iterator it = theConcepts.iterator();
        Vector<edu.udo.cs.miningmart.m4.core.Relation> theRels = new Vector<edu.udo.cs.miningmart.m4.core.Relation>();
        while (it.hasNext()) {
            Concept con = (Concept)it.next();
            Vector someRels = new Vector(con.getTheToRelationships());
            someRels.addAll(con.getTheFromRelationships());
            for (edu.udo.cs.miningmart.m4.core.Relation rel : someRels) {
                if (theRels.contains(rel)) continue;
                theRels.add(rel);
            }
        }
        theRels.trimToSize();
        return theRels;
    }

    @Override
    public Relation getRelation(String relationName) throws M4Exception {
        if (relationName == null) {
            return null;
        }
        for (edu.udo.cs.miningmart.m4.core.Relation myRel : this.getAllRelations()) {
            if (!myRel.getName().equalsIgnoreCase(relationName)) continue;
            return myRel;
        }
        return null;
    }

    public Collection getAllProjections() throws M4Exception {
        Collection theConcepts = this.getConcepts();
        Iterator it = theConcepts.iterator();
        Vector<Projection> theProjs = new Vector<Projection>();
        while (it.hasNext()) {
            Concept con = (Concept)it.next();
            Vector someProjs = new Vector(con.getProjectionsAsFromConcept());
            someProjs.addAll(con.getProjectionsAsToConcept());
            for (Projection proj : someProjs) {
                if (theProjs.contains(proj)) continue;
                theProjs.add(proj);
            }
        }
        theProjs.trimToSize();
        return theProjs;
    }

    @Override
    public Map getOperatorToStepMap() throws M4Exception {
        Iterator stepIt = this.getStepIterator();
        HashMap<Operator, Vector<edu.udo.cs.miningmart.m4.core.Step>> myMap = new HashMap<Operator, Vector<edu.udo.cs.miningmart.m4.core.Step>>();
        while (stepIt.hasNext()) {
            edu.udo.cs.miningmart.m4.core.Step myStep = (edu.udo.cs.miningmart.m4.core.Step)stepIt.next();
            Operator myOp = (Operator)myStep.getTheOperator();
            Vector<edu.udo.cs.miningmart.m4.core.Step> stepsWithThisOperator = (Vector<edu.udo.cs.miningmart.m4.core.Step>)myMap.get(myOp);
            if (stepsWithThisOperator == null) {
                stepsWithThisOperator = new Vector<edu.udo.cs.miningmart.m4.core.Step>();
                stepsWithThisOperator.add(myStep);
                myMap.put(myOp, stepsWithThisOperator);
                continue;
            }
            stepsWithThisOperator.add(myStep);
        }
        return myMap;
    }

    @Override
    public void setTheMode(String newMode) throws M4Exception {
        this.setDirty();
        if (!newMode.equals(TESTMODE) && !newMode.equals(FINALMODE)) {
            throw new M4Exception("Case.setTheMode: constant TEST or FINAL expected; found '" + newMode + "'!");
        }
        this.myMode = newMode;
    }

    @Override
    public String getTheMode() {
        return this.myMode;
    }

    @Override
    public void print() {
        this.doPrint(Print.M4_OBJECT, "Step (Id = " + this.getId() + ";" + "      Name = " + this.getName() + ";" + "      Steps: ");
        try {
            Iterator it = this.getStepIterator();
            while (it.hasNext()) {
                edu.udo.cs.miningmart.m4.core.Step s = (edu.udo.cs.miningmart.m4.core.Step)it.next();
                if (s == null) continue;
                this.doPrint(Print.M4_OBJECT, "Step " + s.getId());
            }
        }
        catch (M4Exception e) {
            this.doPrint(Print.M4_OBJECT, "Warning: Error loading steps in Case.print(): " + e.getMessage());
        }
        this.doPrint(Print.M4_OBJECT, ")");
    }

    @Override
    public Step getStepIdNo(int i) throws M4Exception {
        Vector steps = this.getTheSteps();
        if (i < 0 || i >= steps.size()) {
            return null;
        }
        return (edu.udo.cs.miningmart.m4.core.Step)steps.get(i);
    }

    @Override
    public int getNumberOfSteps() throws M4Exception {
        return this.getTheSteps().size();
    }

    @Override
    public Step getPredecessorIdOf(Step step) throws M4Exception {
        Iterator it = this.getStepIterator();
        edu.udo.cs.miningmart.m4.core.Step predecessor = null;
        while (it.hasNext()) {
            edu.udo.cs.miningmart.m4.core.Step next = (edu.udo.cs.miningmart.m4.core.Step)it.next();
            if (next.equals(step)) {
                return predecessor;
            }
            predecessor = next;
        }
        return null;
    }

    @Override
    public Step getSuccessorOf(Step step) throws M4Exception {
        Iterator it = this.getStepIterator();
        while (it.hasNext() && !((edu.udo.cs.miningmart.m4.core.Step)it.next()).equals(step)) {
        }
        if (it.hasNext()) {
            return (edu.udo.cs.miningmart.m4.core.Step)it.next();
        }
        return null;
    }

    @Override
    public Collection sortSteps(Collection someSteps) throws M4Exception {
        Iterator globalStepOrderIterator = this.getStepIterator();
        Vector<edu.udo.cs.miningmart.m4.core.Step> sorted = new Vector<edu.udo.cs.miningmart.m4.core.Step>();
        while (globalStepOrderIterator.hasNext()) {
            edu.udo.cs.miningmart.m4.core.Step globalStep = (edu.udo.cs.miningmart.m4.core.Step)globalStepOrderIterator.next();
            if (!someSteps.contains(globalStep)) continue;
            sorted.add(globalStep);
        }
        return sorted;
    }

    @Override
    public int indexOfStep(Step step) throws M4Exception {
        Vector col = this.getTheSteps();
        return col.indexOf(step);
    }

    @Override
    public Iterator getStepIterator() throws M4Exception {
        return this.getTheSteps().iterator();
    }

    @Override
    public Iterator getReverseIterator() throws M4Exception {
        LinkedList rev = new LinkedList();
        Iterator it = this.getStepIterator();
        while (it.hasNext()) {
            rev.addFirst(it.next());
        }
        return rev.iterator();
    }

    @Override
    public Collection getDependentStepsFor(Step step) throws M4Exception {
        if (step == null) {
            throw new M4Exception("Case.getDependentStepsFor(Step): got <null> Step!");
        }
        if (!this.getTheSteps().contains(step)) {
            throw new M4Exception("Case.getDependentStepsFor(Step):\nStep with ID: " + step.getId() + " not part of this Case " + this.getId() + "!");
        }
        HashMap openDict = new HashMap();
        LinkedList<Step> path = new LinkedList<Step>();
        LinkedList<edu.udo.cs.miningmart.m4.core.Step> closed = new LinkedList<edu.udo.cs.miningmart.m4.core.Step>();
        HashSet<edu.udo.cs.miningmart.m4.core.Step> closedDict = new HashSet<edu.udo.cs.miningmart.m4.core.Step>();
        path.addLast(step);
        openDict.put(step, new LinkedList(step.getSuccessors()));
        while (!path.isEmpty()) {
            edu.udo.cs.miningmart.m4.core.Step last = (edu.udo.cs.miningmart.m4.core.Step)path.getLast();
            LinkedList successors = (LinkedList)openDict.get(last);
            edu.udo.cs.miningmart.m4.core.Step next = null;
            while (next == null && !successors.isEmpty()) {
                next = (edu.udo.cs.miningmart.m4.core.Step)successors.removeFirst();
                if (openDict.containsKey(next)) {
                    throw new M4Exception("Case.getDependentStepsFor(long):\nCase " + this.getId() + " has cyclic dependencies between Steps!");
                }
                if (!closedDict.contains(next)) continue;
                next = null;
            }
            if (next == null && successors.isEmpty()) {
                path.remove(last);
                openDict.remove(last);
                closedDict.add(last);
                closed.addFirst(last);
                continue;
            }
            path.addLast(next);
            openDict.put(next, new LinkedList(next.getSuccessors()));
        }
        return closed;
    }

    @Override
    public Collection getStepsToCompileBefore(Step step, boolean ignoreCompiledStatusOfSteps) throws M4Exception {
        Collection requiredSteps;
        if (step == null) {
            throw new M4Exception("Case.getStepsToCompileBefore(Step): got <null> Step!");
        }
        if (!this.getTheSteps().contains(step)) {
            throw new M4Exception("Case.getStepsToCompileBefore(Step):\nStep with ID: " + step.getId() + " not part of this Case " + this.getId() + "!");
        }
        if (this.stepToRequiredSteps == null) {
            this.stepToRequiredSteps = new HashMap();
        }
        if ((requiredSteps = (Collection)this.stepToRequiredSteps.get(step)) != null) {
            return requiredSteps;
        }
        HashSet open = new HashSet();
        LinkedList closed = new LinkedList();
        this.getPreSteps(step, open, closed, ignoreCompiledStatusOfSteps);
        closed.remove(step);
        this.stepToRequiredSteps.put(step, closed);
        return closed;
    }

    private void clearRequiredStepsMap() {
        this.stepToRequiredSteps = null;
    }

    private void clearListOfRecommendations() {
        this.stepsAlreadyRecommended = new Vector();
    }

    private void getPreSteps(Step step, HashSet open, LinkedList closed, boolean ignoreCompiledStatus) throws M4Exception {
        if (closed.contains(step)) {
            return;
        }
        Collection predecessors = step.getAllPredecessors();
        if (predecessors == null) {
            throw new M4Exception("Case.getPreSteps(), Step " + step.getId() + ": got NULL when asking for predecessors!");
        }
        if (!ignoreCompiledStatus && step.isCompiled()) {
            return;
        }
        open.add(step);
        for (edu.udo.cs.miningmart.m4.core.Step onePredecessor : predecessors) {
            if (open.contains(onePredecessor)) {
                throw new M4Exception("Case.getPreSteps(): Found a cycle involving Step '" + onePredecessor.getName() + "' (" + onePredecessor.getId() + ")!");
            }
            this.getPreSteps(onePredecessor, open, closed, ignoreCompiledStatus);
        }
        open.remove(step);
        if (!closed.contains(step)) {
            closed.addLast(step);
        }
    }

    @Override
    public Collection getDirectlyDependentSteps(Step step) throws M4Exception {
        if (step != null && this.getTheSteps().contains(step)) {
            return step.getSuccessors();
        }
        return null;
    }

    @Override
    public void storeChangedNameOfFeature(String oldName, String newName) {
        if (this.changedFeatureNames == null) {
            this.changedFeatureNames = new HashMap();
            this.newToOldNames = new HashMap();
        }
        this.changedFeatureNames.put(oldName, newName);
        this.newToOldNames.put(newName, oldName);
    }

    @Override
    public String getNewNameOfChangedFeature(String oldName) {
        if (this.changedFeatureNames == null) {
            return null;
        }
        return (String)this.changedFeatureNames.get(oldName);
    }

    @Override
    public String getOldNameOfChangedFeature(String newName) {
        if (this.newToOldNames == null) {
            return null;
        }
        return (String)this.newToOldNames.get(newName);
    }

    @Override
    public Step findCandidateStepForMaterialisation() throws M4Exception {
        Iterator stepIt = this.getStepIterator();
        while (stepIt.hasNext()) {
            edu.udo.cs.miningmart.m4.core.Step oneStep = (edu.udo.cs.miningmart.m4.core.Step)stepIt.next();
            if (this.stepsAlreadyRecommended.contains(oneStep) || oneStep.materialisesOutput()) continue;
            if (oneStep.isLastStepProducingConceptualOutput()) {
                this.stepsAlreadyRecommended.add(oneStep);
                return oneStep;
            }
            if (oneStep.getMaximumNumberOfStepsSinceLastMaterialisation() < 4 || oneStep.getSuccessors().size() <= 1) continue;
            this.stepsAlreadyRecommended.add(oneStep);
            return oneStep;
        }
        return null;
    }

    @Override
    public Collection getFinalSteps() throws M4Exception {
        Iterator stepIt = this.getStepIterator();
        Vector<edu.udo.cs.miningmart.m4.core.Step> ret = new Vector<edu.udo.cs.miningmart.m4.core.Step>();
        while (stepIt.hasNext()) {
            edu.udo.cs.miningmart.m4.core.Step oneStep = (edu.udo.cs.miningmart.m4.core.Step)stepIt.next();
            if (!oneStep.getSuccessors().isEmpty()) continue;
            ret.add(oneStep);
        }
        return ret;
    }

    @Override
    public void insertMaterialisationAfterStep(Step precedingStep, Step materialisingStep) throws M4Exception {
        OpParam inputConceptOpPar;
        if (precedingStep == null || materialisingStep == null) {
            return;
        }
        Concept inputConceptForNewStep = (Concept)precedingStep.getOutputConcept();
        if (inputConceptForNewStep == null) {
            Collection oldInputs = precedingStep.getAllInputConcepts();
            if (oldInputs.size() != 1) {
                throw new M4Exception("Could not determine input concept for new step '" + materialisingStep.getName() + "'!");
            }
            inputConceptForNewStep = (Concept)oldInputs.iterator().next();
        }
        if ((inputConceptOpPar = (OpParam)materialisingStep.getTheOperator().getOpParam("TheInputConcept")) == null) {
            throw new M4Exception("Missing parameter in step '" + materialisingStep.getName() + "'!");
        }
        Vector<Object> theObjects = new Vector<Object>();
        theObjects.add(inputConceptForNewStep);
        materialisingStep.setParameter(inputConceptOpPar, theObjects, 0);
        String tablename = materialisingStep.getName() + "_Table";
        theObjects = new Vector();
        Value v = (Value)this.getM4Db().createNewInstance(Value.class);
        v.setType("NOMINAL");
        v.setValue(tablename);
        theObjects.add(v);
        OpParam tableNameOpPar = (OpParam)materialisingStep.getTheOperator().getOpParam("TableName");
        if (tableNameOpPar == null) {
            throw new M4Exception("Missing parameter in step '" + materialisingStep.getName() + "'!");
        }
        materialisingStep.setParameter(tableNameOpPar, theObjects, 0);
        OpParam outputConceptOpPar = (OpParam)materialisingStep.getTheOperator().getOpParam("TheOutputConcept");
        if (outputConceptOpPar == null) {
            throw new M4Exception("Missing parameter in step '" + materialisingStep.getName() + "'!");
        }
        theObjects = new Vector();
        String nameForOutputConcept = inputConceptForNewStep.getName() + "_Mat";
        nameForOutputConcept = this.getValidName(nameForOutputConcept, Concept.class);
        theObjects.add(nameForOutputConcept);
        materialisingStep.createOutput(outputConceptOpPar, theObjects);
        for (edu.udo.cs.miningmart.m4.core.Step oneSuccessor : materialisingStep.getSuccessors()) {
            oneSuccessor.changeInputConcept(inputConceptForNewStep, materialisingStep.getOutputConcept());
            Collection stepsUsingUnmaterialisedConcept = oneSuccessor.getSuccessorsUntilOutputConceptIsCreated();
            if (stepsUsingUnmaterialisedConcept != null && !stepsUsingUnmaterialisedConcept.isEmpty()) {
                for (edu.udo.cs.miningmart.m4.core.Step followerOfSuccessor : stepsUsingUnmaterialisedConcept) {
                    followerOfSuccessor.changeInputConcept(inputConceptForNewStep, materialisingStep.getOutputConcept());
                }
            }
            if (!oneSuccessor.adaptOutputToChangedInput()) continue;
            oneSuccessor.propagateOutputChanges();
        }
    }

    @Override
    public void arrangeStepsOnGrid(int gridLength) throws M4Exception {
        if (gridLength <= 0) {
            return;
        }
        Iterator allStepsIt = this.getStepIterator();
        while (allStepsIt.hasNext()) {
            edu.udo.cs.miningmart.m4.core.Step oneStep = (edu.udo.cs.miningmart.m4.core.Step)allStepsIt.next();
            Point p = oneStep.getPoint();
            int x = p.x / gridLength * gridLength;
            int y = p.y / gridLength * gridLength;
            p.x = x;
            p.y = y;
            oneStep.setPoint(p);
        }
    }

    @Override
    public void arrangeConceptsOnGrid(int gridLength) throws M4Exception {
        if (gridLength <= 0) {
            return;
        }
        for (Concept oneConcept : this.getConcepts()) {
            Point p = oneConcept.getPoint();
            int x = p.x / gridLength * gridLength;
            int y = p.y / gridLength * gridLength;
            p.x = x;
            p.y = y;
            oneConcept.setPoint(p);
        }
    }

    @Override
    public void putConceptsOnGrid() throws M4Exception {
        Collection allConcepts = this.getConcepts();
        if (allConcepts == null || allConcepts.isEmpty()) {
            return;
        }
        int noOfConcepts = allConcepts.size();
        int length = (int)Math.floor(Math.sqrt(noOfConcepts));
        int xCounter = 0;
        int yCounter = 0;
        for (Concept oneConcept : this.getConcepts()) {
            Point p = oneConcept.getPoint();
            int x = xCounter * 250 + 50;
            int y = yCounter * 100 + 50;
            p.x = x;
            p.y = y;
            oneConcept.setPoint(p);
            if (++xCounter != length) continue;
            xCounter = 0;
            ++yCounter;
        }
    }

    @Override
    public Collection getConcepts() throws M4Exception {
        if (!this.allConceptsLoaded && !this.isNew()) {
            this.allConceptsLoaded = true;
            this.readConceptsForCaseFromDb();
        }
        return this.myConcepts;
    }

    @Override
    public Collection getInputDataModel() throws M4Exception {
        Iterator it = this.getConcepts().iterator();
        Vector<Concept> ret = new Vector<Concept>();
        while (it.hasNext()) {
            Collection consumingSteps;
            Concept myCon = (Concept)it.next();
            edu.udo.cs.miningmart.m4.core.Step creatingStep = (edu.udo.cs.miningmart.m4.core.Step)myCon.getStepWhereThisIsOutputConcept();
            if (creatingStep == null && (consumingSteps = myCon.getStepsWhereThisIsInputConcept()) != null && !consumingSteps.isEmpty() && !ret.contains(myCon)) {
                ret.add(myCon);
            }
            if (!myCon.getType().equals("DB") || ret.contains(myCon)) continue;
            ret.add(myCon);
        }
        for (edu.udo.cs.miningmart.m4.core.Relation rel : this.getAllRelations()) {
            Collection consumingSteps = rel.getStepsWhereThisIsInputRelation();
            Iterator stepIt = consumingSteps.iterator();
            if (!stepIt.hasNext()) continue;
            Concept from = (Concept)rel.getTheFromConcept();
            Concept to = (Concept)rel.getTheToConcept();
            if (from.getStepWhereThisIsOutputConcept() == null && !ret.contains(from)) {
                ret.add(from);
            }
            if (to == null || to.getStepWhereThisIsOutputConcept() != null || ret.contains(to)) continue;
            ret.add(to);
        }
        return ret;
    }

    @Override
    public void addConcept(edu.udo.cs.miningmart.m4.Concept con) throws M4Exception {
        case2con.checkNameExists((Concept)con, this);
        case2con.add(this, (Concept)con);
    }

    @Override
    public boolean removeConcept(edu.udo.cs.miningmart.m4.Concept con) throws M4Exception {
        return case2con.remove(this, (Concept)con);
    }

    @Override
    public Collection getAllChains() throws M4Exception {
        if (!this.allChainsLoaded && !this.isNew()) {
            this.allChainsLoaded = true;
            this.readChainsForCaseFromDb();
        }
        return this.myChains;
    }

    @Override
    public Collection getTopLevelChains() throws M4Exception {
        Collection allChains = this.getAllChains();
        Iterator it = allChains.iterator();
        Vector<edu.udo.cs.miningmart.m4.core.Chain> theTopLevelChains = new Vector<edu.udo.cs.miningmart.m4.core.Chain>();
        while (it.hasNext()) {
            edu.udo.cs.miningmart.m4.core.Chain aChain = (edu.udo.cs.miningmart.m4.core.Chain)it.next();
            if (aChain.getParentChain() != null) continue;
            theTopLevelChains.add(aChain);
        }
        return theTopLevelChains;
    }

    @Override
    public Chain getChainByName(String name) throws M4Exception {
        if (name == null) {
            return null;
        }
        Collection theChains = this.getAllChains();
        for (edu.udo.cs.miningmart.m4.core.Chain c : theChains) {
            if (!c.getName().equals(name)) continue;
            return c;
        }
        return null;
    }

    @Override
    public void addChain(Chain chain) throws M4Exception {
        edu.udo.cs.miningmart.m4.core.Chain ch = (edu.udo.cs.miningmart.m4.core.Chain)chain;
        case2chain.checkNameExists(ch, this);
        case2chain.add(this, ch);
    }

    @Override
    public boolean removeChain(Chain chain) throws M4Exception {
        return case2chain.remove(this, (edu.udo.cs.miningmart.m4.core.Chain)chain);
    }

    @Override
    public void removeChain(String name) throws M4Exception {
        if (name == null) {
            throw new M4Exception("Case.removeChain: got <null> for chain name!");
        }
        Collection theChains = this.getAllChains();
        Iterator it = theChains.iterator();
        try {
            while (it.hasNext()) {
                edu.udo.cs.miningmart.m4.core.Chain c = (edu.udo.cs.miningmart.m4.core.Chain)it.next();
                if (!c.getName().equals(name)) continue;
                this.removeChain(c);
            }
        }
        catch (M4Exception m4e) {
            throw new M4Exception("Could not remove Chain '" + name + " from Case " + this.getId() + ": " + m4e.getMessage());
        }
    }

    @Override
    public Step getStepByName(String name) throws M4Exception {
        if (name == null) {
            return null;
        }
        for (edu.udo.cs.miningmart.m4.core.Step step : this.getTheSteps()) {
            if (step == null || !name.equals(step.getName())) continue;
            return step;
        }
        return null;
    }

    @Override
    public Vector getTheSteps() throws M4Exception {
        if (!this.allStepsLoaded && !this.isNew()) {
            this.allStepsLoaded = true;
            this.readStepsFromDb();
        }
        return this.mySteps;
    }

    @Override
    public void addStep(Step step) throws M4Exception {
        case2step.checkNameExists((edu.udo.cs.miningmart.m4.core.Step)step, this);
        case2step.add(this, (edu.udo.cs.miningmart.m4.core.Step)step);
        this.clearRequiredStepsMap();
        this.clearListOfRecommendations();
    }

    @Override
    public boolean removeStep(Step step) throws M4Exception {
        this.clearRequiredStepsMap();
        this.clearListOfRecommendations();
        boolean ok = case2step.remove(this, (edu.udo.cs.miningmart.m4.core.Step)step);
        return ok;
    }

    private void readConceptsForCaseFromDb() throws M4Exception {
        this.getM4Db().commitM4Transactions();
        Iterator it = this.getObjectsReferencingMe(Concept.class).iterator();
        while (it.hasNext()) {
            this.addConcept((Concept)it.next());
        }
    }

    private void readChainsForCaseFromDb() throws M4Exception {
        this.getM4Db().commitM4Transactions();
        Iterator it = this.getObjectsReferencingMe(edu.udo.cs.miningmart.m4.core.Chain.class).iterator();
        while (it.hasNext()) {
            this.addChain((edu.udo.cs.miningmart.m4.core.Chain)it.next());
        }
    }

    private void readStepsFromDb() throws M4Exception {
        this.getM4Db().commitM4Transactions();
        edu.udo.cs.miningmart.m4.core.Step artificialStep = (edu.udo.cs.miningmart.m4.core.Step)this.getM4Db().createNewInstance(edu.udo.cs.miningmart.m4.core.Step.class);
        Collection theSteps = this.getObjectsReferencingMe(edu.udo.cs.miningmart.m4.core.Step.class);
        for (edu.udo.cs.miningmart.m4.core.Step currentStep : theSteps) {
            this.addStep(currentStep);
            artificialStep.addSuccessor(currentStep);
        }
        Vector stepsOfCase = this.getTheSteps();
        stepsOfCase.add(artificialStep);
        Iterator sequentialIterator = this.getDependentStepsFor(artificialStep).iterator();
        stepsOfCase.clear();
        artificialStep.getSuccessors().clear();
        artificialStep.deleteSoon();
        if (sequentialIterator.next() != artificialStep) {
            throw new M4Exception("Sequentializer error in Case.readStepsFromDb():\nMethod getDependentStepsFor(Step) returns invalid Collection!");
        }
        while (sequentialIterator.hasNext()) {
            stepsOfCase.add(sequentialIterator.next());
        }
    }

    @Override
    protected void removeAllM4References() throws M4Exception {
        Vector empty = new Vector();
        case2chain.setCollectionTo(this, empty);
        case2con.setCollectionTo(this, empty);
        case2step.setCollectionTo(this, empty);
        this.removeDocObject();
    }

    @Override
    public Collection getDependentObjects() throws M4Exception {
        Collection ret = super.getDependentObjects();
        ret.addAll(this.getAllChains());
        ret.addAll(this.getConcepts());
        ret.addAll(this.getTheSteps());
        return ret;
    }

    @Override
    public void store() throws M4Exception {
        this.getM4Db().updateDatabase();
        this.setNotNew();
        this.sortMyStepsAccordingToStepsequence();
    }

    @Override
    public edu.udo.cs.miningmart.m4.Case copy() throws M4Exception {
        Case theCopy = new Case(this.getM4Db());
        theCopy.setTheMode(this.getTheMode());
        String nameOfCopy = this.getValidName(this.getName(), null);
        theCopy.setName(nameOfCopy);
        return theCopy;
    }

    @Override
    public Step createStep(String name) throws M4Exception {
        if (name == null) {
            throw new M4Exception("Case.createStep: got <null> for step name!");
        }
        edu.udo.cs.miningmart.m4.core.Step newStep = (edu.udo.cs.miningmart.m4.core.Step)this.getM4Db().createNewInstance(edu.udo.cs.miningmart.m4.core.Step.class);
        String errormessage = "Could not connect new Step '" + name + "' to Case " + this.getId() + ": ";
        try {
            newStep.setName(name);
            newStep.setTheCase(this);
            this.addStep(newStep);
        }
        catch (M4Exception m4e) {
            throw new M4Exception(errormessage + m4e.getMessage());
        }
        return newStep;
    }

    @Override
    public Collection getAllStepNames() throws M4Exception {
        Iterator it = this.getStepIterator();
        Vector<String> stepNames = new Vector<String>();
        if (it != null) {
            while (it.hasNext()) {
                edu.udo.cs.miningmart.m4.core.Step step = (edu.udo.cs.miningmart.m4.core.Step)it.next();
                if (step == null) continue;
                stepNames.add(step.getName());
            }
        }
        return stepNames;
    }

    @Override
    public void removeStep(String name) throws M4Exception {
        if (name == null) {
            throw new M4Exception("Case.removeStep: got <null> for step name!");
        }
        edu.udo.cs.miningmart.m4.core.Step step = (edu.udo.cs.miningmart.m4.core.Step)this.getStepByName(name);
        if (step != null) {
            this.removeStep(step);
        }
    }

    @Override
    public void removeAllSteps() throws M4Exception {
        Iterator it = this.getStepIterator();
        if (it == null) {
            return;
        }
        while (it.hasNext()) {
            edu.udo.cs.miningmart.m4.core.Step step = (edu.udo.cs.miningmart.m4.core.Step)it.next();
            this.removeStep(step);
        }
        this.clearRequiredStepsMap();
        this.clearListOfRecommendations();
    }

    @Override
    public Chain createChain(String name) throws M4Exception {
        if (name == null) {
            throw new M4Exception("Case.createChain: got <null> for chain name!");
        }
        edu.udo.cs.miningmart.m4.core.Chain newChain = new edu.udo.cs.miningmart.m4.core.Chain(this.getM4Db());
        newChain.setName(name);
        this.addChain(newChain);
        return newChain;
    }

    @Override
    public Chain createChain(String name, Collection stepsAndChains) throws M4Exception {
        if (stepsAndChains == null) {
            this.doPrint(Print.M4_OBJECT, "Warning: Case.createChain/2: got <null> instead of a collection of steps and chains!");
        }
        edu.udo.cs.miningmart.m4.core.Chain newChain = (edu.udo.cs.miningmart.m4.core.Chain)this.createChain(name);
        for (M4Object anM4Object : stepsAndChains) {
            if (anM4Object instanceof edu.udo.cs.miningmart.m4.core.Step) {
                newChain.addStep((edu.udo.cs.miningmart.m4.core.Step)anM4Object);
                continue;
            }
            if (anM4Object instanceof edu.udo.cs.miningmart.m4.core.Chain) {
                newChain.addSubChain((edu.udo.cs.miningmart.m4.core.Chain)anM4Object);
                continue;
            }
            throw new M4Exception("Case.createChain/2: found something in the given collection that is neither Step nor Chain!");
        }
        return newChain;
    }

    @Override
    public void resolveChain(Chain toBeResolved) throws M4Exception {
        if (toBeResolved == null || toBeResolved.getParentChain() != null) {
            throw new M4Exception("Case.resolveChain: can only resolve top-level chains!");
        }
        if (this.getChainByName(toBeResolved.getName()) == null) {
            throw new M4Exception("Case.resolveChain: unknown Chain '" + toBeResolved.getName() + "'!");
        }
        Collection stepsOfResolvedChain = toBeResolved.getTopLevelSteps();
        Collection chainsOfResolvedChain = toBeResolved.getDirectSubChains();
        Iterator stepsIt = stepsOfResolvedChain.iterator();
        if (stepsIt.hasNext()) {
            throw new M4Exception("Case.resolveChain: chain '" + toBeResolved.getName() + "' is top-level chain and has Steps, so it cannot be resolved!");
        }
        for (edu.udo.cs.miningmart.m4.core.Chain subChain : chainsOfResolvedChain) {
            subChain.setParentChain(null);
        }
        toBeResolved.deleteSoon();
    }

    @Override
    public edu.udo.cs.miningmart.m4.Concept createConcept(String name, String type) throws M4Exception {
        if (name == null || type == null) {
            throw new M4Exception("Case.createConcept: Name or type for new concept were <null>!");
        }
        Concept newConcept = new Concept(this.getM4Db());
        name = this.getValidName(name, Concept.class);
        newConcept.setName(name);
        newConcept.setType(type);
        this.addConcept(newConcept);
        return newConcept;
    }

    @Override
    public edu.udo.cs.miningmart.m4.Concept createConceptFromTable(String tableName) throws M4Exception {
        Concept newConcept = null;
        edu.udo.cs.miningmart.m4.core.Columnset newCs = null;
        newCs = (edu.udo.cs.miningmart.m4.core.Columnset)this.getM4Db().createColumnsetFromTable(tableName);
        newConcept = (Concept)this.createConceptFromColumnset(newCs);
        return newConcept;
    }

    @Override
    public edu.udo.cs.miningmart.m4.Concept createConceptFromColumnset(Columnset cs) throws M4Exception {
        if (cs == null) {
            return null;
        }
        Concept newConcept = null;
        try {
            newConcept = (Concept)this.createConcept(cs.getName(), "DB");
            newConcept.addColumnSet(cs);
            for (Column myCol : cs.getColumns()) {
                String m4RelationalDataType = myCol.getColumnDataTypeName();
                String m4ConceptualDataType = ConceptualDatatypes.guessConceptualTypeGivenRelationalType(m4RelationalDataType);
                String role = m4RelationalDataType.equals("KEY") ? "KEY" : "NO_ROLE";
                BaseAttribute newBa = (BaseAttribute)newConcept.createBaseAttribute(myCol.getName(), m4ConceptualDataType, "DB", role);
                newBa.addColumn(myCol);
            }
        }
        catch (M4Exception m4e) {
            if (newConcept != null) {
                newConcept.deleteSoon();
            }
            throw m4e;
        }
        return newConcept;
    }

    @Override
    public edu.udo.cs.miningmart.m4.Concept createConceptAndRelationsFromTables(String tableName) throws M4Exception {
        edu.udo.cs.miningmart.m4.core.Columnset newCs;
        Concept fromConcept = (Concept)this.createConceptFromTable(tableName);
        if (fromConcept != null && (newCs = (edu.udo.cs.miningmart.m4.core.Columnset)fromConcept.getCurrentColumnSet()) != null) {
            Map myMap = this.getM4Db().getMapOfForeignKeyReferences(newCs, this);
            Map columnsForCs = this.transformMapping(myMap);
            for (Map.Entry myEntry : columnsForCs.entrySet()) {
                edu.udo.cs.miningmart.m4.core.Columnset referencedCs = (edu.udo.cs.miningmart.m4.core.Columnset)myEntry.getKey();
                Collection referringCols = (Collection)myEntry.getValue();
                Concept toConcept = (Concept)referencedCs.getTheConcept();
                if (toConcept == null) {
                    toConcept = (Concept)this.createConceptFromColumnset(referencedCs);
                }
                Collection primaryKeyColsInReferencedCs = this.getM4Db().getPrimaryKeysFromDbSchema(referencedCs);
                Collection fromConceptKeyAttribs = this.findBAs(referringCols, fromConcept);
                Collection toConceptKeyAttribs = this.findBAs(primaryKeyColsInReferencedCs, toConcept);
                String nameForNewRelation = "Rel" + fromConcept.getName() + "To" + toConcept.getName();
                this.createOneToManyRelation(nameForNewRelation, fromConceptKeyAttribs, toConceptKeyAttribs);
            }
        }
        return fromConcept;
    }

    @Override
    public Collection createManyToManyRelationsFromCrossTable(String crossTableName, Collection<String> allowedDbObjects) throws M4Exception {
        edu.udo.cs.miningmart.m4.core.Columnset crossCs = (edu.udo.cs.miningmart.m4.core.Columnset)this.getM4Db().getColumnsetFromCase(crossTableName, this);
        if (crossCs == null) {
            crossCs = (edu.udo.cs.miningmart.m4.core.Columnset)this.getM4Db().createColumnsetFromTable(crossTableName);
        }
        Map myMap = this.getM4Db().getMapOfForeignKeyReferences(crossCs, this);
        Map columnsForCs = this.transformMapping(myMap);
        Vector<edu.udo.cs.miningmart.m4.core.Relation> ret = new Vector<edu.udo.cs.miningmart.m4.core.Relation>();
        for (Map.Entry myEntry : columnsForCs.entrySet()) {
            edu.udo.cs.miningmart.m4.core.Columnset referencedCs = (edu.udo.cs.miningmart.m4.core.Columnset)myEntry.getKey();
            Collection referringCols = (Collection)myEntry.getValue();
            Concept fromConcept = (Concept)referencedCs.getTheConcept();
            if (fromConcept == null) {
                if (allowedDbObjects != null && !allowedDbObjects.contains(referencedCs.getName().toLowerCase()) && !allowedDbObjects.contains(referencedCs.getName().toUpperCase())) continue;
                fromConcept = (Concept)this.createConceptFromColumnset(referencedCs);
            }
            Collection primaryKeyColsInReferencedCs = this.getM4Db().getPrimaryKeysFromDbSchema(referencedCs);
            Collection fromConceptKeyAttribs = this.findBAs(primaryKeyColsInReferencedCs, fromConcept);
            for (Map.Entry secondEntry : columnsForCs.entrySet()) {
                edu.udo.cs.miningmart.m4.core.Columnset secondReferencedCs = (edu.udo.cs.miningmart.m4.core.Columnset)secondEntry.getKey();
                if (secondReferencedCs.equals(referencedCs)) continue;
                Collection secondReferringCols = (Collection)myEntry.getValue();
                Concept toConcept = (Concept)secondReferencedCs.getTheConcept();
                if (toConcept == null) {
                    if (allowedDbObjects != null && !allowedDbObjects.contains(secondReferencedCs.getName().toLowerCase()) && !allowedDbObjects.contains(secondReferencedCs.getName().toUpperCase())) continue;
                    toConcept = (Concept)this.createConceptFromColumnset(secondReferencedCs);
                }
                if (!this.checkNoRelationExists(fromConcept, toConcept)) continue;
                Collection secondPrimaryKeyColsInReferencedCs = this.getM4Db().getPrimaryKeysFromDbSchema(secondReferencedCs);
                Collection toConceptKeyAttribs = this.findBAs(secondPrimaryKeyColsInReferencedCs, toConcept);
                Collection referringColumnsNames = this.getNames(referringCols);
                Collection secondReferringColumnsNames = this.getNames(secondReferringCols);
                String nameForNewRelation = "Rel" + fromConcept.getName() + "To" + toConcept.getName();
                edu.udo.cs.miningmart.m4.core.Relation r = (edu.udo.cs.miningmart.m4.core.Relation)this.createManyToManyRelation(nameForNewRelation, fromConceptKeyAttribs, toConceptKeyAttribs, crossTableName, referringColumnsNames, secondReferringColumnsNames);
                ret.add(r);
            }
        }
        return ret;
    }

    private boolean checkNoRelationExists(Concept from, Concept to) throws M4Exception {
        Collection candidateRelations = from.getTheFromRelationships();
        for (edu.udo.cs.miningmart.m4.core.Relation myRel : candidateRelations) {
            if (!myRel.getTheToConcept().equals(to)) continue;
            return false;
        }
        candidateRelations = to.getTheFromRelationships();
        for (edu.udo.cs.miningmart.m4.core.Relation myRel : candidateRelations) {
            if (!myRel.getTheToConcept().equals(from)) continue;
            return false;
        }
        return true;
    }

    private Map transformMapping(Map givenMap) {
        HashMap<edu.udo.cs.miningmart.m4.core.Columnset, Vector<Column>> columnsForCs = new HashMap<edu.udo.cs.miningmart.m4.core.Columnset, Vector<Column>>();
        if (givenMap != null && !givenMap.isEmpty()) {
            for (Map.Entry myEntry : givenMap.entrySet()) {
                Column foreignKeyCol = (Column)myEntry.getKey();
                edu.udo.cs.miningmart.m4.core.Columnset referencedCs = (edu.udo.cs.miningmart.m4.core.Columnset)myEntry.getValue();
                if (referencedCs == null) continue;
                Vector<Column> allForeignKeyColsForReferencedCs = (Vector<Column>)columnsForCs.get(referencedCs);
                if (allForeignKeyColsForReferencedCs == null) {
                    allForeignKeyColsForReferencedCs = new Vector<Column>();
                    columnsForCs.put(referencedCs, allForeignKeyColsForReferencedCs);
                }
                allForeignKeyColsForReferencedCs.add(foreignKeyCol);
            }
        }
        return columnsForCs;
    }

    private Collection getNames(Collection objects) {
        Vector<String> names = new Vector<String>();
        if (objects != null) {
            for (M4Object anM4Obj : objects) {
                names.add(anM4Obj.getName());
            }
        }
        return names;
    }

    private Collection findBAs(Collection columns, Concept aConcept) throws M4Exception {
        Vector<BaseAttribute> ret = new Vector<BaseAttribute>();
        for (BaseAttribute myBa : aConcept.getAllBaseAttributes()) {
            for (Column myCol : columns) {
                if (!myCol.getTheBaseAttribute().equals(myBa)) continue;
                ret.add(myBa);
            }
        }
        return ret;
    }

    @Override
    public Relation createOneToManyRelation(String relName, Collection fromConceptKeyAttribs, Collection toConceptKeyAttribs) throws M4Exception {
        Concept fromConcept = this.getConceptFromKeys(fromConceptKeyAttribs);
        Concept toConcept = this.getConceptFromKeys(toConceptKeyAttribs);
        if (fromConcept == null || toConcept == null) {
            throw new M4Exception("Case.createManyToManyRelation: either FromConcept or ToConcept or both are NULL!");
        }
        if (fromConceptKeyAttribs.size() != toConceptKeyAttribs.size()) {
            throw new M4Exception("Case.createOneToManyRelation: number of key attributes in FromConcept and ToConcept must be equal!");
        }
        ForeignKey theForeignKey = (ForeignKey)this.getM4Db().createNewInstance(ForeignKey.class);
        theForeignKey.setForeignKeyColumnset(fromConcept.getCurrentColumnSet());
        theForeignKey.setPrimaryKeyColumnset(toConcept.getCurrentColumnSet());
        theForeignKey.createColumnLinksFromAttribs(fromConceptKeyAttribs, toConceptKeyAttribs);
        theForeignKey.setName(relName + "_FK");
        edu.udo.cs.miningmart.m4.core.Relation newRelation = (edu.udo.cs.miningmart.m4.core.Relation)this.getM4Db().createNewInstance(edu.udo.cs.miningmart.m4.core.Relation.class);
        newRelation.setFromKey(theForeignKey);
        newRelation.setToKey(null);
        newRelation.setCrossLinkColumnSet(null);
        newRelation.setTheFromConcept(fromConcept);
        newRelation.setTheToConcept(toConcept);
        newRelation.setName(relName);
        return newRelation;
    }

    @Override
    public Relation createManyToManyRelation(String relName, Collection fromConceptKeyAttribs, Collection toConceptKeyAttribs, String crossTableName, Collection crossLinkToFromConceptNames, Collection crossLinkToToConceptNames) throws M4Exception {
        Concept fromConcept = this.getConceptFromKeys(fromConceptKeyAttribs);
        Concept toConcept = this.getConceptFromKeys(toConceptKeyAttribs);
        if (fromConcept == null || toConcept == null) {
            throw new M4Exception("Case.createManyToManyRelation: either FromConcept or ToConcept or both are NULL!");
        }
        if (fromConceptKeyAttribs.size() != crossLinkToFromConceptNames.size()) {
            throw new M4Exception("Case.createManyToManyRelation: number of key attribs in FromConcept and cross table must be equal!");
        }
        if (toConceptKeyAttribs.size() != crossLinkToToConceptNames.size()) {
            throw new M4Exception("Case.createManyToManyRelation: number of key attribs in ToConcept and cross table must be equal!");
        }
        ForeignKey linkCrossToFromConcept = (ForeignKey)this.getM4Db().createNewInstance(ForeignKey.class);
        ForeignKey linkCrossToToConcept = (ForeignKey)this.getM4Db().createNewInstance(ForeignKey.class);
        edu.udo.cs.miningmart.m4.core.Relation newRelation = (edu.udo.cs.miningmart.m4.core.Relation)this.getM4Db().createNewInstance(edu.udo.cs.miningmart.m4.core.Relation.class);
        edu.udo.cs.miningmart.m4.core.Columnset crossColumnset = (edu.udo.cs.miningmart.m4.core.Columnset)this.getM4Db().getColumnsetFromCase(crossTableName, this);
        if (crossColumnset == null) {
            crossColumnset = (edu.udo.cs.miningmart.m4.core.Columnset)newRelation.createCrossLinkColumnset(crossTableName, this.getM4Db().getBusinessSchemaName(), "T");
        } else {
            newRelation.setCrossLinkColumnSet(crossColumnset);
        }
        linkCrossToFromConcept.setPrimaryKeyColumnset(fromConcept.getCurrentColumnSet());
        linkCrossToFromConcept.setForeignKeyColumnset(crossColumnset);
        linkCrossToToConcept.setPrimaryKeyColumnset(toConcept.getCurrentColumnSet());
        linkCrossToToConcept.setForeignKeyColumnset(crossColumnset);
        Iterator fromKeyIt = fromConceptKeyAttribs.iterator();
        Iterator crossKeyIt = crossLinkToFromConceptNames.iterator();
        while (fromKeyIt.hasNext()) {
            Feature fromFeature = (Feature)fromKeyIt.next();
            String crossKeyName = (String)crossKeyIt.next();
            if (fromFeature instanceof BaseAttribute) {
                Column fromCol = (Column)crossColumnset.getColumn(crossKeyName);
                Column toCol = (Column)((BaseAttribute)fromFeature).getCurrentColumn();
                linkCrossToFromConcept.addColumnLink(fromCol, toCol);
                continue;
            }
            throw new M4Exception("Case.createManyToManyRelation: MultiColumnFeatures are not allowed as Key attributes yet!");
        }
        Iterator toKeyIt = toConceptKeyAttribs.iterator();
        crossKeyIt = crossLinkToToConceptNames.iterator();
        while (toKeyIt.hasNext()) {
            Feature toFeature = (Feature)toKeyIt.next();
            String crossKeyName = (String)crossKeyIt.next();
            if (toFeature instanceof BaseAttribute) {
                Column fromCol = (Column)crossColumnset.getColumn(crossKeyName);
                Column toCol = (Column)((BaseAttribute)toFeature).getCurrentColumn();
                linkCrossToToConcept.addColumnLink(fromCol, toCol);
                continue;
            }
            throw new M4Exception("Case.createManyToManyRelation: MultiColumnFeatures are not allowed as Key attributes yet!");
        }
        linkCrossToFromConcept.setName(crossTableName + "_" + fromConcept.getName() + "_FK");
        linkCrossToToConcept.setName(crossTableName + "_" + toConcept.getName() + "_FK");
        newRelation.setFromKey(linkCrossToFromConcept);
        newRelation.setToKey(linkCrossToToConcept);
        newRelation.setTheFromConcept(fromConcept);
        newRelation.setTheToConcept(toConcept);
        newRelation.setName(relName);
        return newRelation;
    }

    private Concept getConceptFromKeys(Collection conceptKeyAttribs) throws M4Exception {
        if (conceptKeyAttribs == null || conceptKeyAttribs.isEmpty()) {
            throw new M4Exception("Cannot create a Relation without Key attributes!");
        }
        Iterator keyIt = conceptKeyAttribs.iterator();
        Concept theConcept = null;
        while (keyIt.hasNext()) {
            Feature feature = (Feature)keyIt.next();
            if (theConcept == null) {
                theConcept = (Concept)feature.getConcept();
                continue;
            }
            if (theConcept.equals(feature.getConcept())) continue;
            throw new M4Exception("Case.createManyToManyRelation: all key attributes must belong to the same Concept!");
        }
        return theConcept;
    }

    @Override
    public edu.udo.cs.miningmart.m4.Concept getConcept(String conceptName) throws M4Exception {
        Iterator it;
        Collection c = this.getConcepts();
        if (conceptName == null || c == null || (it = c.iterator()) == null) {
            return null;
        }
        while (it.hasNext()) {
            Concept concept = (Concept)it.next();
            if (concept == null || !conceptName.equals(concept.getName())) continue;
            return concept;
        }
        return null;
    }

    @Override
    public Collection getAllConceptNames() throws M4Exception {
        Iterator it;
        Collection c = this.getConcepts();
        if (c == null || (it = c.iterator()) == null) {
            return null;
        }
        Vector<String> names = new Vector<String>();
        while (it.hasNext()) {
            Concept concept = (Concept)it.next();
            if (concept == null) continue;
            names.add(concept.getName());
        }
        return names;
    }

    @Override
    public int compareTo(Object o) {
        return super.compareTo(o);
    }
}

