/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.m4.core;

import edu.udo.cs.miningmart.db.DB;
import edu.udo.cs.miningmart.exception.DbConnectionClosed;
import edu.udo.cs.miningmart.exception.M4CompilerError;
import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.m4.Columnset;
import edu.udo.cs.miningmart.m4.Feature;
import edu.udo.cs.miningmart.m4.MultiColumnFeature;
import edu.udo.cs.miningmart.m4.Step;
import edu.udo.cs.miningmart.m4.core.Column;
import edu.udo.cs.miningmart.m4.core.Concept;
import edu.udo.cs.miningmart.m4.core.ConceptualDatatypes;
import edu.udo.cs.miningmart.m4.core.GraphicalM4Object;
import edu.udo.cs.miningmart.m4.core.Parameter;
import edu.udo.cs.miningmart.m4.core.Roles;
import edu.udo.cs.miningmart.m4.utils.InterM4BaseattributeColumn;
import edu.udo.cs.miningmart.m4.utils.M4Info;
import edu.udo.cs.miningmart.m4.utils.M4InfoEntry;
import edu.udo.cs.miningmart.m4.utils.Print;
import edu.udo.cs.miningmart.m4.utils.XmlInfo;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

public class BaseAttribute
extends edu.udo.cs.miningmart.m4.core.Feature
implements XmlInfo,
edu.udo.cs.miningmart.m4.BaseAttribute {
    public static final String M4_TABLE_NAME = "baseattrib_t";
    public static final String ATTRIB_BASEATTRIBUTE_ID = "ba_id";
    public static final String ATTRIB_BASEATTRIBUTE_NAME = "ba_name";
    public static final String ATTRIB_BASEATTRIBUTE_CONCEPTUAL_DT = "ba_condtid";
    public static final String ATTRIB_BASEATTRIBUTE_ROLE = "ba_role";
    public static final String ATTRIB_BASEATTRIBUTE_RELEVANCE = "ba_relevance";
    public static final String ATTRIB_BASEATTRIBUTE_TYPE = "ba_attribtype";
    public static final String ATTRIB_BASEATTRIBUTE_MCF_ID = "ba_mcfid";
    public static final String M4_TABLE_BA_CON = "ba_concept_t";
    public static final String ATTRIB_BA_CON_TUPLE_ID = "bc_id";
    public static final String ATTRIB_BA_CON_CONID = "bc_conid";
    public static final String ATTRIB_BA_CON_BAID = "bc_baid";
    static final InterM4BaseattributeColumn ba2col = new InterM4BaseattributeColumn();
    private static ConceptualDatatypes dataTypeMapping = null;
    private static Roles roleMapping = null;
    public static M4Info m4Info = null;
    private static M4Info xmlInfo = null;
    private long dataType;
    private long myRole;
    private final Vector myColumns = new Vector();
    private boolean allColumnsLoaded = false;
    private boolean relevant;
    private boolean dbAttrib;
    private edu.udo.cs.miningmart.m4.core.MultiColumnFeature myMCFeature;

    private ConceptualDatatypes getConceptualDatatypeMapping(DB db) throws DbConnectionClosed, M4Exception {
        if (dataTypeMapping == null) {
            dataTypeMapping = new ConceptualDatatypes(db);
        }
        return dataTypeMapping;
    }

    private Roles getRoleMapping(DB db) throws DbConnectionClosed, M4Exception {
        if (roleMapping == null) {
            roleMapping = new Roles(db);
        }
        return roleMapping;
    }

    public String getM4TableName() {
        return M4_TABLE_NAME;
    }

    public String getIdAttributeName() {
        return ATTRIB_BASEATTRIBUTE_ID;
    }

    public M4Info getM4Info() {
        if (m4Info == null) {
            M4InfoEntry[] m4i = new M4InfoEntry[]{new M4InfoEntry(ATTRIB_BASEATTRIBUTE_ID, "getId", "setId", Long.TYPE, "NN"), new M4InfoEntry(ATTRIB_BASEATTRIBUTE_NAME, "getName", "setName", String.class, "NN"), new M4InfoEntry(ATTRIB_BASEATTRIBUTE_CONCEPTUAL_DT, "getConceptualDataType", "setConceptualDataType", Long.TYPE, "NN"), new M4InfoEntry(ATTRIB_BASEATTRIBUTE_ROLE, "getRole", "setRole", Long.TYPE, "NN"), new M4InfoEntry(ATTRIB_BASEATTRIBUTE_RELEVANCE, "getRelevantS", "setRelevantS", String.class), new M4InfoEntry(ATTRIB_BASEATTRIBUTE_TYPE, "getDBAttribS", "setDBAttribS", String.class, "NN"), new M4InfoEntry(ATTRIB_BASEATTRIBUTE_MCF_ID, "getMCFeature", "primitiveSetMCFeature", MultiColumnFeature.class)};
            m4Info = new M4Info(m4i);
        }
        return m4Info;
    }

    public M4Info getXmlInfo() {
        if (xmlInfo == null) {
            M4InfoEntry[] m4i = new M4InfoEntry[]{new M4InfoEntry("Name", "getName", "setName", String.class), new M4InfoEntry("ConDatatype", "getConceptualDataTypeName", "setConceptualDataTypeName", String.class), new M4InfoEntry("Role", "getRoleName", "setRoleName", String.class), new M4InfoEntry("Relevant", "getRelevantS", "setRelevantS", String.class), new M4InfoEntry("Type", "getDBAttribS", "setDBAttribS", String.class), new M4InfoEntry("MultiColumnFeature", "getMCFeature", "setMCFeature", MultiColumnFeature.class), new M4InfoEntry("Concept", "getConcept", "setConcept", edu.udo.cs.miningmart.m4.Concept.class), new M4InfoEntry("Docu", "getDocumentation", "setDocumentation", String.class)};
            xmlInfo = new M4Info(m4i);
        }
        return xmlInfo;
    }

    public BaseAttribute(DB m4Db) {
        super(m4Db);
    }

    public void print() {
        String roleName;
        String dtName;
        try {
            dtName = this.getConceptualDataTypeName();
        }
        catch (Exception e) {
            dtName = " <Conceptual datatype Id: " + this.getConceptualDataType() + "> ";
        }
        try {
            roleName = this.getRoleName();
        }
        catch (Exception e) {
            try {
                roleName = " <Role Id: " + this.getRole() + "> ";
            }
            catch (Exception e2) {
                roleName = " <Unknown Role>";
            }
        }
        String toPrint = "Base Attribute " + this.getName() + " (Id: " + this.myId + "): " + dtName + " (Role: " + roleName + ") of concepts: ";
        try {
            Concept c = (Concept)this.getConcept();
            toPrint = c != null ? toPrint + c.getName() + ", " : toPrint + "(not loaded)";
        }
        catch (M4Exception m4e) {
            this.doPrint(m4e);
        }
        this.doPrint(Print.M4_OBJECT, toPrint);
        if (this.myColumns != null) {
            for (Column col : this.myColumns) {
                if (col == null) continue;
                col.print();
            }
        }
    }

    public void setName(String name) {
        name = this.replaceSpacesInName(name);
        super.setName(name);
    }

    public edu.udo.cs.miningmart.m4.BaseAttribute copy() throws M4Exception {
        BaseAttribute ret = (BaseAttribute)this.getM4Db().createNewInstance(BaseAttribute.class);
        ret.setId(0L);
        ret.setConceptualDataType(this.getConceptualDataType());
        ret.setRole(this.getRole());
        ret.setDBAttrib(this.isDBAttrib());
        ret.setName(this.getName());
        ret.setRelevant(this.isRelevant());
        return ret;
    }

    public Feature copy(edu.udo.cs.miningmart.m4.Concept newConcept) throws M4Exception {
        BaseAttribute theCopy = (BaseAttribute)this.copy();
        String nameOfCopy = newConcept.getValidName(this.getName(), BaseAttribute.class);
        ((GraphicalM4Object)theCopy).setName(nameOfCopy);
        theCopy.setConcept(newConcept);
        return theCopy;
    }

    public void addColumn(edu.udo.cs.miningmart.m4.Column column) throws M4Exception {
        ba2col.add(this, (Column)column);
    }

    public edu.udo.cs.miningmart.m4.Column createColumn(String name) throws M4Exception {
        Column newCol = (Column)this.getM4Db().createNewInstance(Column.class);
        newCol.setName(name);
        this.addColumn(newCol);
        return newCol;
    }

    public boolean hasColumn(edu.udo.cs.miningmart.m4.Column col) throws M4Exception {
        Collection columns = this.getColumns();
        if (col == null || columns == null) {
            return false;
        }
        return columns.contains(col);
    }

    public boolean hasColumns() throws M4Exception {
        Collection columns = this.getColumns();
        return columns != null && !columns.isEmpty();
    }

    public boolean removeColumn(edu.udo.cs.miningmart.m4.Column column) throws M4Exception {
        return ba2col.remove(this, (Column)column);
    }

    public void removeLinkToColumns() throws M4Exception {
        ba2col.setCollectionTo(this, null);
    }

    public void setConceptualDataType(long type) {
        this.setDirty();
        this.dataType = type;
    }

    public long getConceptualDataType() {
        return this.dataType;
    }

    public void setConceptualDataTypeName(String dtname) throws M4Exception {
        try {
            long type = this.getConceptualDatatypeMapping(this.getM4Db()).getIdForName(dtname);
            this.setConceptualDataType(type);
        }
        catch (DbConnectionClosed c) {
            throw new M4Exception("BaseAttribute.setConceptualDataTypeName: DbConnectionClosed Exception caught: " + c.getMessage());
        }
    }

    public String getConceptualDataTypeName() throws M4Exception {
        try {
            long type = this.getConceptualDataType();
            return this.getConceptualDatatypeMapping(this.getM4Db()).getNameForId(type);
        }
        catch (DbConnectionClosed c) {
            throw new M4Exception("BaseAttribute.getConceptualDataTypeName: DbConnectionClosed Exception caught: " + c.getMessage());
        }
    }

    public void setRole(long role) {
        this.setDirty();
        this.myRole = role;
    }

    public long getRole() throws M4Exception {
        try {
            String currentRole = this.getRoleMapping(this.getM4Db()).getNameForId(this.myRole);
            if (currentRole == null) {
                currentRole = "NO_ROLE";
            }
            return this.getRoleMapping(this.getM4Db()).getIdForName(currentRole);
        }
        catch (DbConnectionClosed c) {
            throw new M4Exception("BaseAttribute.getRole: DbConnectionClosed Exception caught: " + c.getMessage());
        }
    }

    public void setRoleName(String rolename) throws M4Exception {
        try {
            long role = this.getRoleMapping(this.getM4Db()).getIdForName(rolename);
            this.setRole(role);
        }
        catch (DbConnectionClosed c) {
            throw new M4Exception("BaseAttribute.setRoleName: DbConnectionClosed Exception caught: " + c.getMessage());
        }
    }

    public String getRoleName() throws M4Exception {
        try {
            long role = this.getRole();
            return this.getRoleMapping(this.getM4Db()).getNameForId(role);
        }
        catch (DbConnectionClosed c) {
            throw new M4Exception("BaseAttribute.getRoleName: DbConnectionClosed Exception caught: " + c.getMessage());
        }
    }

    public void setColumns(Collection theColumns) throws M4Exception {
        ba2col.setCollectionTo(this, theColumns);
    }

    public Collection getColumns() throws M4Exception {
        if (!this.allColumnsLoaded && !this.isNew()) {
            this.allColumnsLoaded = true;
            this.readColumnsForBA();
        }
        return this.myColumns;
    }

    public edu.udo.cs.miningmart.m4.Column getColumn(int index) throws M4Exception {
        this.getColumns();
        if (this.myColumns != null && index > -1 && index < this.myColumns.size()) {
            return (edu.udo.cs.miningmart.m4.Column)this.myColumns.get(index);
        }
        throw new M4Exception("BaseAttribute.getColumn(): No Columnarray exists, or wrong index!");
    }

    private edu.udo.cs.miningmart.m4.Column getColumnForColumnSet(edu.udo.cs.miningmart.m4.core.Columnset cs) throws M4Exception {
        Collection columns = this.getColumns();
        if (columns != null) {
            for (Column col : columns) {
                Columnset myCs;
                if (col == null || (myCs = col.getColumnset()) == null || myCs.getId() != cs.getId()) continue;
                return col;
            }
        }
        return null;
    }

    public edu.udo.cs.miningmart.m4.Column getCurrentColumn() throws M4Exception {
        edu.udo.cs.miningmart.m4.Concept c = this.getConcept();
        if (c != null) {
            edu.udo.cs.miningmart.m4.core.Columnset cs = (edu.udo.cs.miningmart.m4.core.Columnset)c.getCurrentColumnSet();
            return this.getColumnForColumnSet(cs);
        }
        return null;
    }

    public Step getStepWhereThisIsOutputBa() throws M4Exception {
        Collection params = this.getParameterReferences();
        if (params != null) {
            for (Parameter p : params) {
                if (p == null || !p.getParameterType().equals("OUT")) continue;
                return (edu.udo.cs.miningmart.m4.core.Step)p.getTheStep();
            }
        }
        return null;
    }

    public void setMCFeature(MultiColumnFeature mcf) throws M4Exception {
        edu.udo.cs.miningmart.m4.core.MultiColumnFeature.mcf2ba.checkNameExists(this, mcf);
        edu.udo.cs.miningmart.m4.core.MultiColumnFeature.mcf2ba.updateReferenceTo(this, mcf);
    }

    public MultiColumnFeature getMCFeature() {
        return this.myMCFeature;
    }

    public boolean isRelevant() {
        return this.relevant;
    }

    public String getRelevantS() {
        return this.isRelevant() ? "YES" : "NO";
    }

    public void setRelevant(boolean r) {
        this.setDirty();
        this.relevant = r;
    }

    public void setRelevantS(String r) {
        this.setRelevant("YES".equals(r));
    }

    public boolean isDBAttrib() {
        return this.dbAttrib;
    }

    public String getDBAttribS() {
        return this.isDBAttrib() ? "DB" : "MINING";
    }

    public String getType() {
        return this.getDBAttribS();
    }

    public void setDBAttrib(boolean a) {
        this.setDirty();
        this.dbAttrib = a;
    }

    public void setDBAttribS(String attrib) {
        this.setDBAttrib("DB".equals(attrib));
    }

    public void setType(String type) throws M4Exception {
        if (type.equals("BASE")) {
            throw new M4Exception("M4 error when trying to set type for BaseAttribute '" + this.getName() + "': the type '" + "BASE" + "' is no longer supported!");
        }
        if (!type.equals("DB") && !type.equals("MINING")) {
            throw new M4Exception("M4 error when trying to set type for BaseAttribute '" + this.getName() + "': unknown type '" + type + "'!");
        }
        this.setDBAttribS(type);
    }

    public boolean isDeselected() throws M4CompilerError {
        try {
            return this.getCurrentColumn() == null;
        }
        catch (M4Exception e) {
            throw new M4CompilerError("Error getting current column for BA with Id " + this.getId() + ": " + e.getMessage());
        }
    }

    private void readColumnsForBA() throws M4Exception {
        Collection theColumns = this.getObjectsReferencingMe(Column.class);
        this.setColumns(theColumns);
    }

    private void readConceptForBA() throws M4Exception {
        String query = "SELECT bc_conid FROM ba_concept_t WHERE bc_baid = " + this.getId();
        Long conId = this.executeM4SingleValueSqlReadL(query);
        Concept c = null;
        if (conId != null) {
            c = (Concept)this.getM4Db().getM4Object(conId, Concept.class);
        }
        this.primitiveSetConcept(c);
    }

    public void primitiveSetMCFeature(MultiColumnFeature mcf) {
        this.setDirty();
        this.myMCFeature = (edu.udo.cs.miningmart.m4.core.MultiColumnFeature)mcf;
    }

    public boolean isRelationallyValid() throws M4Exception {
        if (this.getConcept() == null) {
            return false;
        }
        if (this.isDBAttrib()) {
            Collection columns = this.getColumns();
            return columns != null && !columns.isEmpty();
        }
        boolean valid = false;
        Iterator it = null;
        it = this.getConcept().getParameterReferences().iterator();
        while (it.hasNext()) {
            if (((Parameter)it.next()).getParameterType() != "OUT") continue;
            valid = true;
        }
        if (!valid && this.getMCFeature() != null) {
            it = this.getMCFeature().getParameterReferences().iterator();
            while (it.hasNext()) {
                if (((Parameter)it.next()).getParameterType() != "OUT") continue;
                valid = true;
            }
        }
        if (!valid) {
            it = this.getParameterReferences().iterator();
            while (it.hasNext()) {
                if (((Parameter)it.next()).getParameterType() != "OUT") continue;
                valid = true;
            }
        }
        return valid;
    }

    protected void readFromDbLocal() throws M4Exception {
        this.readConceptForBA();
    }

    protected void storeLocal() throws M4Exception {
        super.storeLocal();
        String sql = "DELETE FROM ba_concept_t WHERE bc_baid = " + this.getId();
        this.executeM4SqlWrite(sql);
        if (this.getConcept() != null) {
            String conceptId = Long.toString(this.getConcept().getId());
            String sql2 = "INSERT INTO ba_concept_t ( bc_id, bc_baid, bc_conid ) VALUES ( " + this.getNextM4SequenceValue() + ", " + this.getId() + ", " + conceptId + " )";
            this.executeM4SqlWrite(sql2);
        }
    }

    protected void deleteLocal() throws M4Exception {
        super.deleteLocal();
        String sql = "DELETE FROM ba_concept_t WHERE bc_baid = " + this.getId();
        this.executeM4SqlWrite(sql);
        sql = "DELETE FROM ba_column_t WHERE bac_baid = " + this.getId();
        this.executeM4SqlWrite(sql);
    }

    protected void removeAllM4References() throws M4Exception {
        super.removeAllM4References();
        this.setColumns(new Vector());
        this.setConcept(null);
        this.setMCFeature(null);
        this.removeDocObject();
    }

    public Collection getDependentObjects() throws M4Exception {
        Collection ret = super.getDependentObjects();
        ret.addAll(this.getColumns());
        return ret;
    }
}

