/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.m4.core;

import edu.udo.cs.miningmart.db.DB;
import edu.udo.cs.miningmart.exception.M4CompilerError;
import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.m4.Step;
import edu.udo.cs.miningmart.m4.core.BaseAttribute;
import edu.udo.cs.miningmart.m4.core.Column;
import edu.udo.cs.miningmart.m4.core.Columnset;
import edu.udo.cs.miningmart.m4.core.Concept;
import edu.udo.cs.miningmart.m4.core.Condition;
import edu.udo.cs.miningmart.m4.core.Constraint;
import edu.udo.cs.miningmart.m4.core.EstimatedStatistics;
import edu.udo.cs.miningmart.m4.core.Feature;
import edu.udo.cs.miningmart.m4.core.M4Data;
import edu.udo.cs.miningmart.m4.core.OpParam;
import edu.udo.cs.miningmart.m4.core.Operator;
import edu.udo.cs.miningmart.m4.core.Parameter;
import edu.udo.cs.miningmart.m4.core.ParameterObject;
import edu.udo.cs.miningmart.m4.core.Relation;
import edu.udo.cs.miningmart.m4.core.Value;
import edu.udo.cs.miningmart.m4.utils.M4Info;
import edu.udo.cs.miningmart.m4.utils.M4InfoEntry;
import edu.udo.cs.miningmart.m4.utils.Print;
import edu.udo.cs.miningmart.m4.utils.XmlInfo;
import edu.udo.cs.miningmart.operator.ExecutableOperator;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;

public class Assertion
extends M4Data
implements XmlInfo,
edu.udo.cs.miningmart.m4.Assertion {
    public static final String M4_TABLE_NAME = "op_assert_t";
    public static final String ATTRIB_ASSERT_ID = "assert_id";
    public static final String ATTRIB_OPERATOR_ID = "assert_opid";
    public static final String ATTRIB_ASSERT_TYPE = "assert_type";
    public static final String ATTRIB_ASSERT_OBJ1 = "assert_obj1";
    public static final String ATTRIB_ASSERT_OBJ2 = "assert_obj2";
    public static final String ASSERTION_NOT_NULL = "NOT_NULL";
    public static final String ASSERTION_UNIQUE = "UNIQUE";
    public static final String ESTIMATE_SIZE_BY_RELATIONS = "SZ_BY_REL";
    public static final String ESTIMATE_SIZE_BY_VALUE = "SZ_BY_VAL";
    public static final String ESTIMATE_SIZE_REDUCE_MV = "SZ_MIN_MV";
    public static final String ESTIMATE_SIZE_BY_DIVISION = "SZ_DIV_BY";
    public static final String ESTIMATE_SIZE_BY_VALLIST = "SZ_BY_VL";
    public static final String ESTIMATE_SIZE_ADD_INPUTS = "SZ_ADD";
    public static final String ESTIMATE_SIZE_MULTIPLY_BY = "SZ_MULT_NO";
    public static final String ESTIMATE_VALLIST_TAKE_FROM = "VL_FROM";
    public static final String ESTIMATE_VALLIST_UNCHANGED = "VL_UNCH";
    public static final String ESTIMATE_VALLIST_ADD_VALUE = "VL_ADD";
    public static final String ESTIMATE_VALLIST_FROM_PARAM = "VL_BY_PAR";
    public static final String ESTIMATE_VALLIST_BY_SYMBOL = "VL_BY_SYM";
    public static final String ESTIMATE_VALLIST_COMBINE = "VL_COMB";
    public static final String ESTIMATE_VALLIST_FROM_LIST = "VL_BY_LIST";
    public static final String ESTIMATE_MINMAX_TAKE_FROM = "MM_FROM";
    public static final String ESTIMATE_MINMAX_UNCHANGED = "MM_UNCH";
    public static final String ESTIMATE_MINIMUM_FROM_PARAM = "MIN_FROM";
    public static final String ESTIMATE_MAXIMUM_FROM_PARAM = "MAX_FROM";
    public static final String ESTIMATE_MINMAX_COMBINE = "MM_COMB";
    public static final String ESTIMATE_VALFREQ_REPL_MV = "VF_REPL_MV";
    public static final String ESTIMATE_VALFREQ_BY_SELECTIVITY = "VF_BY_SEL";
    public static final String ESTIMATE_VALFREQ_AGGREGATE = "VF_BY_AGG";
    public static final String ESTIMATE_VALFREQ_ADD_INPUTS = "VF_ADD";
    public static final String ESTIMATE_VALFREQ_TAKE_FROM = "VF_FROM";
    public static final String ESTIMATE_VALFREQ_MULT_BY = "VF_MULT_NO";
    public static final String ESTIMATE_MV_BY_SELECTIVITY = "MV_BY_SEL";
    public static final String ESTIMATE_MV_TAKE_FROM = "MV_FROM";
    public static final String ESTIMATE_MV_ADD_INPUTS = "MV_ADD";
    public static final String ESTIMATE_NO_CHANGE = "NO_CHANGE";
    public static final String ESTIMATE_ROW_SELECTION = "ES_SELECT";
    private static final String OUTVAL_SYMBOL = "L";
    private static M4Info m4Info = null;
    private static M4Info xmlInfo = null;
    private Operator myOperator;
    private String myType;
    private String myObj1;
    private String myObj2;

    public String getM4TableName() {
        return M4_TABLE_NAME;
    }

    public String getIdAttributeName() {
        return ATTRIB_ASSERT_ID;
    }

    public M4Info getM4Info() {
        if (m4Info == null) {
            M4InfoEntry[] m4i = new M4InfoEntry[]{new M4InfoEntry(ATTRIB_ASSERT_ID, "getId", "setId", Long.TYPE, "NN"), new M4InfoEntry(ATTRIB_OPERATOR_ID, "getTheOperator", "primitiveSetOperator", edu.udo.cs.miningmart.m4.Operator.class, "NN"), new M4InfoEntry(ATTRIB_ASSERT_TYPE, "getAssertionType", "setAssertionType", String.class, "NN"), new M4InfoEntry(ATTRIB_ASSERT_OBJ1, "getObj1", "setObj1", String.class, "NN"), new M4InfoEntry(ATTRIB_ASSERT_OBJ2, "getObj2", "setObj2", String.class)};
            m4Info = new M4Info(m4i);
        }
        return m4Info;
    }

    public M4Info getXmlInfo() {
        if (xmlInfo == null) {
            M4InfoEntry[] m4i = new M4InfoEntry[]{new M4InfoEntry("Operator", "getTheOperator", "setTheOperator", edu.udo.cs.miningmart.m4.Operator.class), new M4InfoEntry("Type", "getAssertionType", "setAssertionType", String.class), new M4InfoEntry("Obj1", "getObj1", "setObj1", String.class), new M4InfoEntry("Obj2", "getObj2", "setObj2", String.class), new M4InfoEntry("Docu", "getDocumentation", "setDocumentation", String.class)};
            xmlInfo = new M4Info(m4i);
        }
        return xmlInfo;
    }

    public Assertion(DB db) {
        super(db);
    }

    public void print() {
        edu.udo.cs.miningmart.m4.Operator op = this.getTheOperator();
        String opName = op == null ? null : op.getName();
        this.doPrint(Print.M4_OBJECT, "Assertion (Id = " + this.getId() + ";" + " Name = " + this.getName() + "; TYPE = " + this.getAssertionType() + " OBJ1 = " + this.getObj1() + "; OBJ2 = " + this.getObj2() + " Operator = " + opName + ")");
    }

    protected Collection getObjectsInNamespace(Class typeOfObjects) throws M4Exception {
        return null;
    }

    public String getObj1() {
        return this.myObj1;
    }

    public String getObj2() {
        return this.myObj2;
    }

    public edu.udo.cs.miningmart.m4.Operator getTheOperator() {
        return this.myOperator;
    }

    public String getAssertionType() {
        return this.myType;
    }

    public void setObj1(String myObj1) {
        this.setDirty();
        this.myObj1 = myObj1;
    }

    public void setObj2(String myObj2) {
        this.setDirty();
        this.myObj2 = myObj2;
    }

    public void setTheOperator(edu.udo.cs.miningmart.m4.Operator operator) throws M4Exception {
        Operator.op2assert.updateReferenceTo(this, operator);
    }

    public void primitiveSetOperator(edu.udo.cs.miningmart.m4.Operator operator) {
        this.setDirty();
        this.myOperator = (Operator)operator;
    }

    public void setAssertionType(String myType) {
        this.setDirty();
        this.myType = myType;
    }

    protected void removeAllM4References() throws M4Exception {
        this.setTheOperator(null);
        this.removeDocObject();
    }

    public void writeAssertion(ExecutableOperator op) throws M4CompilerError {
        String assertionType = this.getAssertionType();
        for (int loop = 0; loop < op.getNumberOfLoops(); ++loop) {
            if (assertionType.equals(ASSERTION_NOT_NULL)) {
                this.assertNotNull(op, loop);
                continue;
            }
            if (!assertionType.equals(ASSERTION_UNIQUE)) continue;
            this.assertUniqueness(op, loop);
        }
    }

    public void applyEstimationOneInput(Step whichStep, edu.udo.cs.miningmart.m4.EstimatedStatistics inputEstimation, edu.udo.cs.miningmart.m4.EstimatedStatistics outputEstimation) throws M4Exception {
        if (this.doRowSelectionEstimation(whichStep, inputEstimation, outputEstimation)) {
            return;
        }
        this.doSizeEstimationSingleInput(whichStep, inputEstimation, outputEstimation);
        this.doOtherEstimations(whichStep, inputEstimation, outputEstimation);
    }

    public void applyEstimationSeveralInputs(Step whichStep, edu.udo.cs.miningmart.m4.EstimatedStatistics[] inputEstimations, edu.udo.cs.miningmart.m4.EstimatedStatistics outputEstimation) throws M4Exception {
        this.doSizeEstimationSeveralInputs(whichStep, inputEstimations, outputEstimation);
        for (int i = 0; i < inputEstimations.length; ++i) {
            this.doOtherEstimations(whichStep, inputEstimations[i], outputEstimation);
        }
    }

    public boolean isValueListAssertion() {
        return this.getAssertionType().startsWith("VL");
    }

    public boolean isValueFrequencyAssertion() {
        return this.getAssertionType().startsWith("VF");
    }

    private void doOtherEstimations(Step whichStep, edu.udo.cs.miningmart.m4.EstimatedStatistics inputEstimation, edu.udo.cs.miningmart.m4.EstimatedStatistics outputEstimation) throws M4Exception {
        this.doValueListEstimation(whichStep, inputEstimation, outputEstimation);
        this.doBoundsEstimation(whichStep, inputEstimation, outputEstimation);
        this.doMissingValuesEstimation(whichStep, inputEstimation, outputEstimation);
        this.doValueFrequenciesEstimation(whichStep, inputEstimation, outputEstimation);
    }

    private void doValueFrequenciesEstimation(Step whichStep, edu.udo.cs.miningmart.m4.EstimatedStatistics inputEstimation, edu.udo.cs.miningmart.m4.EstimatedStatistics outputEstimation) throws M4Exception {
        Concept outputConcept;
        if (this.getAssertionType().equals(ESTIMATE_NO_CHANGE)) {
            outputConcept = (Concept)whichStep.getOutputConcept();
            Collection outBAs = outputConcept.getAllBaseAttributes();
            for (BaseAttribute outBA : outBAs) {
                Vector inValList;
                if (!whichStep.isVisible(outBA) || (inValList = inputEstimation.getValueList(outBA.getName())) == null) continue;
                for (String value : inValList) {
                    int freq = inputEstimation.getNumberOfOccurrences(outBA.getName(), value);
                    outputEstimation.setNumberOfOccurrences(outBA.getName(), value, freq);
                }
            }
        }
        if (this.getAssertionType().equals(ESTIMATE_VALFREQ_REPL_MV)) {
            String[] outputBaNames = this.getNamesOfAttribParameterForAllLoops(this.getObj1(), (edu.udo.cs.miningmart.m4.core.Step)whichStep);
            String value = this.getValueParameter(this.getObj2(), (edu.udo.cs.miningmart.m4.core.Step)whichStep);
            String[] inputBaNames = this.getInputAttribsForOutputAttribs(outputBaNames, this.getObj1(), (edu.udo.cs.miningmart.m4.core.Step)whichStep);
            if (inputBaNames != null) {
                if (inputBaNames.length != outputBaNames.length) {
                    throw new M4Exception("Assertion '" + this.getAssertionType() + "' in step '" + whichStep.getName() + "': unmatched numbers of input and output attributes!");
                }
                for (int i = 0; i < inputBaNames.length; ++i) {
                    if (inputBaNames[i] == null) continue;
                    int freq = inputEstimation.getNumberOfOccurrences(inputBaNames[i], value);
                    if (freq == Integer.MIN_VALUE) {
                        outputEstimation.setNumberOfOccurrences(outputBaNames[i], value, Integer.MIN_VALUE);
                        continue;
                    }
                    int noOfMissVals = inputEstimation.getNumberOfMissingValues(inputBaNames[i]);
                    if (noOfMissVals == Integer.MIN_VALUE) {
                        if (freq == 0) {
                            outputEstimation.addValueInformation(outputBaNames[i], value, Integer.MIN_VALUE);
                            continue;
                        }
                        outputEstimation.setNumberOfOccurrences(outputBaNames[i], value, Integer.MIN_VALUE);
                        continue;
                    }
                    if (freq == 0) {
                        if (noOfMissVals <= 0) continue;
                        outputEstimation.addValueInformation(outputBaNames[i], value, noOfMissVals);
                        continue;
                    }
                    outputEstimation.setNumberOfOccurrences(outputBaNames[i], value, freq + noOfMissVals);
                }
            }
        }
        if (this.getAssertionType().equals(ESTIMATE_VALFREQ_BY_SELECTIVITY) && inputEstimation.getNumberOfRows() != Integer.MIN_VALUE && outputEstimation.getNumberOfRows() != Integer.MIN_VALUE) {
            outputConcept = (Concept)whichStep.getOutputConcept();
            Concept inputConcept = (Concept)inputEstimation.getConcept();
            for (BaseAttribute outputBa : outputConcept.getAllBaseAttributes()) {
                String outBaName = outputBa.getName();
                BaseAttribute inputBa = (BaseAttribute)inputConcept.getBaseAttribute(outBaName);
                if (inputBa == null) {
                    inputBa = this.getMappedInput(outputBa, inputConcept, (edu.udo.cs.miningmart.m4.core.Step)whichStep);
                }
                if (inputBa == null) continue;
                String inBaName = inputBa.getName();
                this.applyVfSelectivity((EstimatedStatistics)inputEstimation, (EstimatedStatistics)outputEstimation, inBaName, outBaName);
            }
        }
        if (this.getAssertionType().equals(ESTIMATE_VALFREQ_AGGREGATE)) {
            String[] namesOfAttribs = this.getNamesOfAttribParameterForAllLoops(this.getObj1(), (edu.udo.cs.miningmart.m4.core.Step)whichStep);
            if (namesOfAttribs == null) {
                return;
            }
            for (int i = 0; i < namesOfAttribs.length; ++i) {
                int freq = this.getProductOfOtherFrequencies(namesOfAttribs, i, (EstimatedStatistics)inputEstimation);
                Vector vl = inputEstimation.getValueList(namesOfAttribs[i]);
                if (vl == null) continue;
                for (String value : vl) {
                    outputEstimation.setNumberOfOccurrences(namesOfAttribs[i], value, freq);
                }
            }
        }
        if (this.getAssertionType().equals(ESTIMATE_VALFREQ_ADD_INPUTS)) {
            String outBaName = this.getNameOfAttribParameter(this.getObj2(), (edu.udo.cs.miningmart.m4.core.Step)whichStep);
            StringTokenizer st = new StringTokenizer(this.getObj1(), ", ");
            String[] inNames = new String[st.countTokens()];
            int i = 0;
            while (st.hasMoreTokens()) {
                inNames[i] = st.nextToken();
                ++i;
            }
            if (outBaName != null) {
                HashMap valuesToFrequencies = new HashMap();
                for (int j = 0; j < inNames.length; ++j) {
                    String[] moreAttribNames = this.getNamesOfAttribParameterForAllLoops(inNames[j], (edu.udo.cs.miningmart.m4.core.Step)whichStep);
                    if (moreAttribNames == null) continue;
                    for (int k = 0; k < moreAttribNames.length; ++k) {
                        Vector vl = inputEstimation.getValueList(moreAttribNames[k]);
                        if (vl == null) continue;
                        for (String value : vl) {
                            int freq = inputEstimation.getNumberOfOccurrences(moreAttribNames[k], value);
                            this.accumulateFrequencies(valuesToFrequencies, value, freq);
                        }
                    }
                }
                Set allValues = valuesToFrequencies.keySet();
                for (String oneValue : allValues) {
                    Integer frequency = (Integer)valuesToFrequencies.get(oneValue);
                    int fr = frequency;
                    if (fr == 0) continue;
                    outputEstimation.setNumberOfOccurrences(outBaName, oneValue, fr);
                }
            } else {
                Concept[] inputConcepts = this.getConceptsForParamNames(inNames, (edu.udo.cs.miningmart.m4.core.Step)whichStep);
                EstimatedStatistics[] inputESs = new EstimatedStatistics[inputConcepts.length];
                for (int j = 0; j < inputConcepts.length; ++j) {
                    inputESs[j] = (EstimatedStatistics)inputConcepts[j].getEstimatedStatistics(whichStep);
                }
                Concept refConc = inputConcepts[0];
                Collection refBAs = refConc.getAllBaseAttributes();
                for (BaseAttribute refBA : refBAs) {
                    if (!whichStep.isVisible(refBA)) continue;
                    HashMap valuesToFrequencies = new HashMap();
                    for (int j = 0; j < inputESs.length; ++j) {
                        Vector valueList;
                        BaseAttribute corrBA = (BaseAttribute)inputConcepts[j].getBaseAttribute(refBA.getName());
                        if (corrBA == null || (valueList = inputESs[j].getValueList(corrBA.getName())) == null) continue;
                        for (String value : valueList) {
                            int freq = inputESs[j].getNumberOfOccurrences(corrBA.getName(), value);
                            this.accumulateFrequencies(valuesToFrequencies, value, freq);
                        }
                    }
                    Set allValues = valuesToFrequencies.keySet();
                    for (String oneValue : allValues) {
                        Integer frequency = (Integer)valuesToFrequencies.get(oneValue);
                        int fr = frequency;
                        if (fr == 0) continue;
                        outputEstimation.setNumberOfOccurrences(refBA.getName(), oneValue, fr);
                    }
                }
            }
        }
        if (this.getAssertionType().equals(ESTIMATE_VALFREQ_TAKE_FROM) && !whichStep.usesAggregation()) {
            boolean done;
            String[] outBaNames = this.getNamesOfAttribParameterForAllLoops(this.getObj2(), (edu.udo.cs.miningmart.m4.core.Step)whichStep);
            String[] inBaNames = this.getNamesOfAttribParameterForAllLoops(this.getObj1(), (edu.udo.cs.miningmart.m4.core.Step)whichStep);
            if (outBaNames == null) {
                outBaNames = this.getOutputAttribsForInputAttribs(inBaNames, (edu.udo.cs.miningmart.m4.core.Step)whichStep);
            }
            if (done = this.handleReversingSteps(inBaNames, outBaNames, (EstimatedStatistics)outputEstimation, (edu.udo.cs.miningmart.m4.core.Step)whichStep)) {
                return;
            }
            if (outBaNames.length > inBaNames.length && inBaNames.length != 1) {
                throw new M4Exception("Assertion '" + this.getAssertionType() + "' in Step '" + whichStep.getName() + "': don't know how to map a few input attribs to more output attribs!");
            }
            for (int outputIndex = 0; outputIndex < outBaNames.length; ++outputIndex) {
                Vector vl;
                int inputIndex;
                int n = inputIndex = inBaNames.length > 1 ? outputIndex : 0;
                if (!this.attribBelongsToConcept((edu.udo.cs.miningmart.m4.core.Step)whichStep, inBaNames[inputIndex], (Concept)inputEstimation.getConcept()) || (vl = inputEstimation.getValueList(inBaNames[inputIndex])) == null) continue;
                for (String value : vl) {
                    int inputFrequency = inputEstimation.getNumberOfOccurrences(inBaNames[inputIndex], value);
                    outputEstimation.setNumberOfOccurrences(outBaNames[outputIndex], value, inputFrequency);
                }
            }
        }
        if (this.getAssertionType().equals(ESTIMATE_VALFREQ_MULT_BY)) {
            String[] inputAttribs = this.getNamesOfAttribParameterForAllLoops(this.getObj1(), (edu.udo.cs.miningmart.m4.core.Step)whichStep);
            String[] outputAttribs = this.getNamesOfAttribParameterForAllLoops(this.getObj2(), (edu.udo.cs.miningmart.m4.core.Step)whichStep);
            int factor = 1;
            if (outputAttribs == null) {
                String theFactor = this.getValueParameter(this.getObj1(), (edu.udo.cs.miningmart.m4.core.Step)whichStep);
                try {
                    factor = Integer.parseInt(theFactor);
                }
                catch (NumberFormatException nfe) {
                    throw new M4Exception("Assertion '" + this.getAssertionType() + "' in Step '" + whichStep.getName() + "': expected an attrib or numeric value parameter or a numeric constant in Obj1!");
                }
            } else {
                factor = outputAttribs.length;
            }
            for (int i = 0; i < inputAttribs.length; ++i) {
                Vector vl = inputEstimation.getValueList(inputAttribs[i]);
                if (vl == null) continue;
                for (String value : vl) {
                    int freq = inputEstimation.getNumberOfOccurrences(inputAttribs[i], value);
                    freq = freq == Integer.MIN_VALUE ? freq : factor * freq;
                    outputEstimation.setNumberOfOccurrences(inputAttribs[i], value, freq);
                }
            }
        }
    }

    private void applyVfSelectivity(EstimatedStatistics inputEstimation, EstimatedStatistics outputEstimation, String inBaName, String outBaName) {
        double selectivity = (double)outputEstimation.getNumberOfRows() / (double)inputEstimation.getNumberOfRows();
        Vector vl = inputEstimation.getValueList(inBaName);
        if (vl != null && !vl.isEmpty()) {
            for (String value : vl) {
                int inputValFreq;
                int outputValFreq = inputValFreq = inputEstimation.getNumberOfOccurrences(inBaName, value);
                if (inputValFreq != Integer.MIN_VALUE) {
                    outputValFreq = (int)(selectivity * (double)inputValFreq);
                }
                if (outputValFreq == 0 && inputValFreq >= 1) {
                    outputValFreq = 1;
                }
                outputEstimation.setNumberOfOccurrences(outBaName, value, outputValFreq);
            }
        }
    }

    private void accumulateFrequencies(Map valuesToFrequencies, String value, int frequency) {
        if (valuesToFrequencies == null || value == null) {
            return;
        }
        Integer frequencySoFar = (Integer)valuesToFrequencies.get(value);
        if (frequencySoFar == null) {
            frequencySoFar = new Integer(frequency);
            valuesToFrequencies.put(value, frequencySoFar);
        } else {
            int oldFreq = frequencySoFar;
            if (oldFreq != Integer.MIN_VALUE) {
                int newFreq = oldFreq + frequency;
                valuesToFrequencies.put(value, new Integer(newFreq));
            }
        }
    }

    private int getProductOfOtherFrequencies(String[] namesOfAttribs, int positionToLeaveOut, EstimatedStatistics inputEstimation) {
        int product = 1;
        for (int i = 0; i < namesOfAttribs.length; ++i) {
            Vector vl;
            if (i == positionToLeaveOut || (vl = inputEstimation.getValueList(namesOfAttribs[i])) == null) continue;
            product *= vl.size();
        }
        return product;
    }

    private void doBoundsEstimation(Step whichStep, edu.udo.cs.miningmart.m4.EstimatedStatistics inputEstimation, edu.udo.cs.miningmart.m4.EstimatedStatistics outputEstimation) throws M4Exception {
        int i;
        if (this.getAssertionType().equals(ESTIMATE_NO_CHANGE)) {
            Concept outputConcept = (Concept)whichStep.getOutputConcept();
            Collection outBAs = outputConcept.getAllBaseAttributes();
            for (BaseAttribute outBA : outBAs) {
                if (!whichStep.isVisible(outBA)) continue;
                outputEstimation.setBiggestValue(outBA.getName(), inputEstimation.getBiggestValue(outBA.getName()));
                outputEstimation.setLowestValue(outBA.getName(), inputEstimation.getLowestValue(outBA.getName()));
            }
        }
        boolean max = false;
        max = this.getAssertionType().equals(ESTIMATE_MAXIMUM_FROM_PARAM);
        if (max || this.getAssertionType().equals(ESTIMATE_MINIMUM_FROM_PARAM)) {
            String[] attribNames = this.getNamesOfAttribParameterForAllLoops(this.getObj1(), (edu.udo.cs.miningmart.m4.core.Step)whichStep);
            double value = this.getDoubleFromValueParameter(this.getObj2(), (edu.udo.cs.miningmart.m4.core.Step)whichStep);
            if (attribNames != null) {
                for (i = 0; i < attribNames.length; ++i) {
                    if (max) {
                        outputEstimation.setBiggestValue(attribNames[i], value);
                        continue;
                    }
                    outputEstimation.setLowestValue(attribNames[i], value);
                }
            }
        }
        if (this.getAssertionType().equals(ESTIMATE_MINMAX_UNCHANGED)) {
            Concept outputConcept = (Concept)whichStep.getOutputConcept();
            Concept inputConcept = (Concept)inputEstimation.getConcept();
            for (BaseAttribute outputBa : outputConcept.getAllBaseAttributes()) {
                String outBaName = outputBa.getName();
                BaseAttribute inputBa = (BaseAttribute)inputConcept.getBaseAttribute(outBaName);
                if (inputBa == null) {
                    inputBa = this.getMappedInput(outputBa, inputConcept, (edu.udo.cs.miningmart.m4.core.Step)whichStep);
                }
                if (inputBa == null) continue;
                String inBaName = inputBa.getName();
                outputEstimation.setBiggestValue(outBaName, inputEstimation.getBiggestValue(inBaName));
                outputEstimation.setLowestValue(outBaName, inputEstimation.getLowestValue(inBaName));
            }
        }
        if (this.getAssertionType().equals(ESTIMATE_MINMAX_TAKE_FROM) && !whichStep.usesAggregation()) {
            boolean done;
            String[] outBaNames = this.getNamesOfAttribParameter(this.getObj2(), (edu.udo.cs.miningmart.m4.core.Step)whichStep);
            String[] inBaNames = this.getNamesOfAttribParameter(this.getObj1(), (edu.udo.cs.miningmart.m4.core.Step)whichStep);
            if (outBaNames == null) {
                outBaNames = this.getOutputAttribsForInputAttribs(inBaNames, (edu.udo.cs.miningmart.m4.core.Step)whichStep);
            }
            if (done = this.handleReversingSteps(inBaNames, outBaNames, (EstimatedStatistics)outputEstimation, (edu.udo.cs.miningmart.m4.core.Step)whichStep)) {
                return;
            }
            if (outBaNames.length > inBaNames.length && inBaNames.length != 1) {
                throw new M4Exception("Assertion '" + this.getAssertionType() + "' in Step '" + whichStep.getName() + "': don't know how to map a few input attribs to more output attribs!");
            }
            for (int outputIndex = 0; outputIndex < outBaNames.length; ++outputIndex) {
                int inputIndex;
                int n = inputIndex = inBaNames.length > 1 ? outputIndex : 0;
                if (!this.attribBelongsToConcept((edu.udo.cs.miningmart.m4.core.Step)whichStep, inBaNames[inputIndex], (Concept)inputEstimation.getConcept())) continue;
                outputEstimation.setBiggestValue(outBaNames[outputIndex], inputEstimation.getBiggestValue(inBaNames[inputIndex]));
                outputEstimation.setLowestValue(outBaNames[outputIndex], inputEstimation.getLowestValue(inBaNames[inputIndex]));
            }
        }
        if (this.getAssertionType().equals(ESTIMATE_MINMAX_COMBINE)) {
            String outBaName = this.getNameOfAttribParameter(this.getObj2(), (edu.udo.cs.miningmart.m4.core.Step)whichStep);
            StringTokenizer st = new StringTokenizer(this.getObj1(), ", ");
            String[] inNames = new String[st.countTokens()];
            i = 0;
            while (st.hasMoreTokens()) {
                inNames[i] = st.nextToken();
                ++i;
            }
            if (outBaName != null) {
                double maxSoFar = Double.MIN_VALUE;
                double minSoFar = Double.MAX_VALUE;
                boolean maxUnknown = false;
                boolean minUnknown = false;
                for (int j = 0; j < inNames.length; ++j) {
                    String[] moreInputNames = this.getNamesOfAttribParameterForAllLoops(inNames[j], (edu.udo.cs.miningmart.m4.core.Step)whichStep);
                    if (moreInputNames == null) continue;
                    for (int k = 0; k < moreInputNames.length; ++k) {
                        double mini;
                        double maxi = inputEstimation.getBiggestValue(moreInputNames[k]);
                        if (this.doublesAreEqual(maxi, Double.NaN)) {
                            maxUnknown = true;
                        }
                        if (maxi > maxSoFar) {
                            maxSoFar = maxi;
                        }
                        if (this.doublesAreEqual(mini = inputEstimation.getLowestValue(moreInputNames[k]), Double.NaN)) {
                            minUnknown = true;
                        }
                        if (!(mini > minSoFar)) continue;
                        minSoFar = mini;
                    }
                }
                maxSoFar = maxUnknown ? Double.NaN : maxSoFar;
                minSoFar = minUnknown ? Double.NaN : minSoFar;
                outputEstimation.setLowestValue(outBaName, minSoFar);
                outputEstimation.setBiggestValue(outBaName, maxSoFar);
            } else {
                Concept[] inputConcepts = this.getConceptsForParamNames(inNames, (edu.udo.cs.miningmart.m4.core.Step)whichStep);
                EstimatedStatistics[] inputESs = new EstimatedStatistics[inputConcepts.length];
                for (int j = 0; j < inputConcepts.length; ++j) {
                    inputESs[j] = (EstimatedStatistics)inputConcepts[j].getEstimatedStatistics(whichStep);
                }
                Concept refConc = inputConcepts[0];
                Collection refBAs = refConc.getAllBaseAttributes();
                for (BaseAttribute refBA : refBAs) {
                    if (!whichStep.isVisible(refBA)) continue;
                    double[] inputMinimums = new double[inputConcepts.length];
                    double[] inputMaximums = new double[inputConcepts.length];
                    inputMinimums[0] = inputESs[0].getLowestValue(refBA.getName());
                    inputMaximums[0] = inputESs[0].getBiggestValue(refBA.getName());
                    for (int j = 1; j < inputConcepts.length; ++j) {
                        BaseAttribute corrBa = (BaseAttribute)inputConcepts[j].getBaseAttribute(refBA.getName());
                        if (corrBa == null) continue;
                        inputMinimums[j] = inputESs[j].getLowestValue(corrBa.getName());
                        inputMaximums[j] = inputESs[j].getBiggestValue(corrBa.getName());
                    }
                    outputEstimation.setLowestValue(refBA.getName(), this.combineBounds(inputMinimums, true));
                    outputEstimation.setBiggestValue(refBA.getName(), this.combineBounds(inputMaximums, false));
                }
            }
        }
    }

    private boolean doRowSelectionEstimation(Step whichStep, edu.udo.cs.miningmart.m4.EstimatedStatistics inputEstimation, edu.udo.cs.miningmart.m4.EstimatedStatistics outputEstimation) throws M4Exception {
        if (this.getAssertionType().equals(ESTIMATE_ROW_SELECTION)) {
            if (!whichStep.getTheOperator().getName().equals("RowSelectionByQuery")) {
                throw new M4Exception("Assertion '" + this.getAssertionType() + "' in Step '" + whichStep.getName() + "': expected the operator to be 'RowSelectionByQuery'!");
            }
            String[] leftConditions = this.getNamesOfAttribParameterForAllLoops("TheLeftCondition", (edu.udo.cs.miningmart.m4.core.Step)whichStep);
            String[] rightConditions = this.getValueParametersForAllLoops("TheRightCondition", (edu.udo.cs.miningmart.m4.core.Step)whichStep);
            String[] conditionOps = this.getValueParametersForAllLoops("TheConditionOperator", (edu.udo.cs.miningmart.m4.core.Step)whichStep);
            int startLoop = whichStep.getLoopCount() > 0 ? 1 : 0;
            int endLoop = whichStep.getLoopCount();
            for (int i = startLoop; i <= endLoop; ++i) {
                Vector valueList;
                if (inputEstimation.getNumberOfMissingValues(leftConditions[i]) == 0) {
                    outputEstimation.setNumberOfMissingValues(leftConditions[i], 0);
                }
                if ((valueList = inputEstimation.getValueList(leftConditions[i])) == null) continue;
                if (conditionOps[i].equals("=")) {
                    double numericValue;
                    rightConditions[i] = this.dequote(rightConditions[i]);
                    if (!valueList.contains(rightConditions[i])) continue;
                    int noOfOcc = inputEstimation.getNumberOfOccurrences(leftConditions[i], rightConditions[i]);
                    if (whichStep.getLoopCount() == 0) {
                        outputEstimation.setNumberOfRows(noOfOcc);
                    }
                    if (!this.doublesAreEqual(numericValue = this.isNumeric(rightConditions[i]), Double.NaN)) {
                        outputEstimation.setBiggestValue(leftConditions[i], numericValue);
                        outputEstimation.setLowestValue(leftConditions[i], numericValue);
                    }
                    int freq = inputEstimation.getNumberOfOccurrences(leftConditions[i], rightConditions[i]);
                    outputEstimation.setValueList(leftConditions[i], new Vector());
                    outputEstimation.addValueInformation(leftConditions[i], rightConditions[i], freq);
                    continue;
                }
                Vector remainingValues = this.findRemainingValues(valueList, conditionOps[i], rightConditions[i]);
                if (remainingValues == null) continue;
                outputEstimation.setValueList(leftConditions[i], new Vector());
                Iterator allValIt = remainingValues.iterator();
                Integer numberOfRemainingRows = new Integer(0);
                double biggestRemainingValue = Double.MIN_VALUE;
                double smallestRemainingValue = Double.MAX_VALUE;
                while (allValIt.hasNext()) {
                    String aValue = (String)allValIt.next();
                    double numericValue = this.isNumeric(aValue);
                    if (!this.doublesAreEqual(numericValue, Double.NaN)) {
                        if (numericValue > biggestRemainingValue) {
                            biggestRemainingValue = numericValue;
                        }
                        if (numericValue < smallestRemainingValue) {
                            smallestRemainingValue = numericValue;
                        }
                    }
                    int noOfOcc = Integer.MIN_VALUE;
                    noOfOcc = inputEstimation.getNumberOfOccurrences(leftConditions[i], aValue);
                    if (noOfOcc != Integer.MIN_VALUE && noOfOcc > 0) {
                        if (numberOfRemainingRows != null) {
                            numberOfRemainingRows = new Integer(numberOfRemainingRows + noOfOcc);
                        }
                    } else {
                        numberOfRemainingRows = null;
                    }
                    if (noOfOcc <= 0) continue;
                    outputEstimation.addValueInformation(leftConditions[i], aValue, noOfOcc);
                }
                if (numberOfRemainingRows != null) {
                    outputEstimation.setNumberOfRows(numberOfRemainingRows.intValue());
                }
                if (!this.doublesAreEqual(biggestRemainingValue, Double.MIN_VALUE)) {
                    outputEstimation.setBiggestValue(leftConditions[i], biggestRemainingValue);
                }
                if (this.doublesAreEqual(smallestRemainingValue, Double.MAX_VALUE)) continue;
                outputEstimation.setLowestValue(leftConditions[i], smallestRemainingValue);
            }
            long inputSize = inputEstimation.getNumberOfRows();
            long outputSize = outputEstimation.getNumberOfRows();
            if (inputSize != Integer.MIN_VALUE && outputSize != Integer.MIN_VALUE && outputSize < inputSize) {
                Concept outputConcept = (Concept)outputEstimation.getConcept();
                for (BaseAttribute outBA : outputConcept.getAllBaseAttributes()) {
                    if (!whichStep.isVisible(outBA) || this.arrayContains(leftConditions, outBA.getName())) continue;
                    this.applyVfSelectivity((EstimatedStatistics)inputEstimation, (EstimatedStatistics)outputEstimation, outBA.getName(), outBA.getName());
                    double selectivity = (double)outputSize / (double)inputSize;
                    int inputMv = inputEstimation.getNumberOfMissingValues(outBA.getName());
                    int outputMv = (int)(selectivity * (double)inputMv);
                    outputEstimation.setNumberOfMissingValues(outBA.getName(), outputMv);
                }
            }
            return true;
        }
        return false;
    }

    private boolean arrayContains(String[] anArray, String anElement) {
        for (int i = 0; i < anArray.length; ++i) {
            if (!anArray[i].equals(anElement)) continue;
            return true;
        }
        return false;
    }

    private String dequote(String quoted) {
        quoted = quoted.trim();
        while (quoted.startsWith("'")) {
            if (!(quoted = quoted.substring(1)).endsWith("'")) continue;
            quoted = quoted.substring(0, quoted.length() - 1);
        }
        return quoted.trim();
    }

    private String debracket(String bracketed) {
        bracketed = bracketed.trim();
        while (bracketed.startsWith("(")) {
            if (!(bracketed = bracketed.substring(1)).endsWith(")")) continue;
            bracketed = bracketed.substring(0, bracketed.length() - 1);
        }
        return bracketed.trim();
    }

    private double isNumeric(String value) {
        double ret = Double.NaN;
        try {
            ret = Double.parseDouble(value);
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        return ret;
    }

    private Vector findRemainingValues(Vector listOfValues, String operator, String right) {
        if (operator.equalsIgnoreCase("in")) {
            right = this.debracket(right).trim();
            StringTokenizer st = new StringTokenizer(right, ",");
            Vector<String> theValues = new Vector<String>();
            while (st.hasMoreTokens()) {
                String oneValue = st.nextToken();
                if (!listOfValues.contains(oneValue = this.dequote(oneValue).trim())) continue;
                theValues.add(oneValue);
            }
            if (theValues.isEmpty()) {
                return null;
            }
            return theValues;
        }
        boolean smaller = operator.startsWith("<");
        boolean bigger = operator.startsWith(">");
        boolean orEqual = operator.endsWith("=");
        if (smaller || bigger) {
            String compareToValue = this.dequote(right).trim();
            double compareToD = Double.NaN;
            try {
                compareToD = Double.parseDouble(compareToValue);
            }
            catch (NumberFormatException e) {
                return null;
            }
            Vector<String> remainingValues = new Vector<String>();
            for (String testValue : listOfValues) {
                double testD = Double.NaN;
                try {
                    testD = Double.parseDouble(testValue);
                }
                catch (NumberFormatException nfe) {
                    return null;
                }
                if (!(bigger && testD > compareToD || smaller && testD < compareToD || bigger && orEqual && testD >= compareToD) && (!smaller || !orEqual || !(testD <= compareToD))) continue;
                remainingValues.add(testValue);
            }
            if (remainingValues.isEmpty()) {
                return null;
            }
            return remainingValues;
        }
        return null;
    }

    private BaseAttribute getMappedInput(BaseAttribute outputBa, Concept inputConcept, edu.udo.cs.miningmart.m4.core.Step whichStep) throws M4Exception {
        Collection outputPar = outputBa.getParameterReferences();
        if (outputPar != null) {
            Iterator paramIt = outputPar.iterator();
            Parameter outputParam = null;
            while (paramIt.hasNext() && (outputParam = (Parameter)paramIt.next()).isInputParam()) {
            }
            if (outputParam == null || outputParam.isInputParam()) {
                return null;
            }
            for (Constraint myCon : whichStep.getTheOperator().getConstraints()) {
                BaseAttribute correspondingInputBa;
                Parameter inputParam;
                ParameterObject parObj;
                if (!myCon.getType().equals("RENAME_OUT") || !outputParam.getName().startsWith(myCon.getObj2()) || !((parObj = (ParameterObject)(inputParam = (Parameter)whichStep.getParameterTuple(myCon.getObj1(), outputParam.getLoopNr())).getTheParameterObject()) instanceof BaseAttribute) || !(correspondingInputBa = (BaseAttribute)parObj).getConcept().equals(inputConcept)) continue;
                return correspondingInputBa;
            }
        }
        return null;
    }

    private Concept[] getConceptsForParamNames(String[] paramNames, edu.udo.cs.miningmart.m4.core.Step whichStep) throws M4Exception {
        Vector allConcepts = new Vector();
        for (int i = 0; i < paramNames.length; ++i) {
            Collection pars;
            OpParam theOpPar = (OpParam)whichStep.getTheOperator().getOpParam(paramNames[i]);
            if (theOpPar == null || !theOpPar.isConceptParameter() || (pars = whichStep.getParameter(theOpPar, 0)) == null) continue;
            Iterator it = pars.iterator();
            while (it.hasNext()) {
                allConcepts.add(it.next());
            }
        }
        Concept[] ret = new Concept[allConcepts.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (Concept)allConcepts.get(i);
        }
        return ret;
    }

    private double combineBounds(double[] someBounds, boolean useMinimum) {
        double extremeBound = useMinimum ? Double.MAX_VALUE : Double.MIN_VALUE;
        for (int i = 0; i < someBounds.length; ++i) {
            if (this.doublesAreEqual(someBounds[i], Double.NaN)) {
                return Double.NaN;
            }
            if (!(useMinimum && someBounds[i] < extremeBound) && (useMinimum || !(someBounds[i] > extremeBound))) continue;
            extremeBound = someBounds[i];
        }
        return extremeBound;
    }

    private boolean doublesAreEqual(double a, double b) {
        Double aA = new Double(a);
        Double bB = new Double(b);
        return aA.compareTo(bB) == 0;
    }

    private String[] getInputAttribsForOutputAttribs(String[] outputAttribNames, String outputParamName, edu.udo.cs.miningmart.m4.core.Step theStep) throws M4Exception {
        Collection constraints = theStep.getTheOperator().getConstraints();
        Iterator constrIt = constraints.iterator();
        String targetParameterName = null;
        while (constrIt.hasNext()) {
            Constraint myConstr = (Constraint)constrIt.next();
            if (!myConstr.getType().equals("SAME_TYPE")) continue;
            if (myConstr.getObj1().equalsIgnoreCase(outputParamName)) {
                targetParameterName = myConstr.getObj2();
                continue;
            }
            if (!myConstr.getObj2().equalsIgnoreCase(outputParamName)) continue;
            targetParameterName = myConstr.getObj1();
        }
        if (targetParameterName == null) {
            return null;
        }
        return this.getNamesOfAttribParameterForAllLoops(targetParameterName, theStep);
    }

    private String[] getOutputAttribsForInputAttribs(String[] inputAttribNames, edu.udo.cs.miningmart.m4.core.Step theStep) throws M4Exception {
        String[] ret = new String[inputAttribNames.length];
        Concept outputConcept = (Concept)theStep.getOutputConcept();
        Collection outBAs = outputConcept.getAllBaseAttributes();
        boolean allOutputAttribsFound = true;
        for (int i = 0; i < inputAttribNames.length; ++i) {
            Iterator it = outBAs.iterator();
            boolean found = false;
            while (it.hasNext()) {
                BaseAttribute outBA = (BaseAttribute)it.next();
                if (!outBA.getName().startsWith(inputAttribNames[i])) continue;
                ret[i] = outBA.getName();
                found = true;
            }
            if (found) continue;
            allOutputAttribsFound = false;
        }
        if (allOutputAttribsFound) {
            return ret;
        }
        throw new M4Exception("Assertion '" + this.getAssertionType() + "' for step '" + theStep.getName() + "': could not find matching output attribs for all input attribs!");
    }

    private void doValueListEstimation(Step whichStep, edu.udo.cs.miningmart.m4.EstimatedStatistics inputEstimation, edu.udo.cs.miningmart.m4.EstimatedStatistics outputEstimation) throws M4Exception {
        Concept outputConcept;
        if (this.getAssertionType().equals(ESTIMATE_NO_CHANGE)) {
            outputConcept = (Concept)whichStep.getOutputConcept();
            Collection outBAs = outputConcept.getAllBaseAttributes();
            for (BaseAttribute outBA : outBAs) {
                if (!whichStep.isVisible(outBA)) continue;
                outputEstimation.setValueList(outBA.getName(), inputEstimation.getValueList(outBA.getName()));
            }
        }
        if (this.getAssertionType().equals(ESTIMATE_VALLIST_ADD_VALUE)) {
            String[] outBaNames = this.getNamesOfAttribParameterForAllLoops(this.getObj1(), (edu.udo.cs.miningmart.m4.core.Step)whichStep);
            String value = this.getValueParameter(this.getObj2(), (edu.udo.cs.miningmart.m4.core.Step)whichStep);
            for (int i = 0; i < outBaNames.length; ++i) {
                outputEstimation.addValueInformation(outBaNames[i], value, Integer.MIN_VALUE);
            }
        }
        if (this.getAssertionType().equals(ESTIMATE_VALLIST_FROM_LIST)) {
            String[] outAttribNames = this.getNamesOfAttribParameterForAllLoops(this.getObj1(), (edu.udo.cs.miningmart.m4.core.Step)whichStep);
            String[] valueLists = this.getValueParametersForAllLoops(this.getObj2(), (edu.udo.cs.miningmart.m4.core.Step)whichStep);
            if (valueLists == null) {
                for (int i = 0; i < outAttribNames.length; ++i) {
                    StringTokenizer st = new StringTokenizer(this.getObj2(), ", ");
                    while (st.hasMoreTokens()) {
                        String oneValue = st.nextToken();
                        outputEstimation.addValueInformation(outAttribNames[i], oneValue, Integer.MIN_VALUE);
                    }
                }
            } else {
                int i;
                Vector[] valuesPerOutAttrib = new Vector[outAttribNames.length];
                for (i = 0; i < valueLists.length; ++i) {
                    StringTokenizer st = new StringTokenizer(valueLists[i], ", ");
                    if (st.countTokens() != outAttribNames.length) {
                        throw new M4Exception("Assertion '" + this.getAssertionType() + "' in Step '" + whichStep.getName() + "': found unmatching number of values in Obj2 parameter!");
                    }
                    int k = 0;
                    while (st.hasMoreTokens()) {
                        String oneValue = st.nextToken();
                        if (valuesPerOutAttrib[k] == null) {
                            valuesPerOutAttrib[k] = new Vector();
                        }
                        if (!valuesPerOutAttrib[k].contains(oneValue)) {
                            valuesPerOutAttrib[k].add(oneValue);
                        }
                        ++k;
                    }
                }
                for (i = 0; i < outAttribNames.length; ++i) {
                    outputEstimation.setValueList(outAttribNames[i], valuesPerOutAttrib[i]);
                }
            }
        }
        if (this.getAssertionType().equals(ESTIMATE_VALLIST_UNCHANGED)) {
            outputConcept = (Concept)whichStep.getOutputConcept();
            Concept inputConcept = (Concept)inputEstimation.getConcept();
            for (BaseAttribute outputBa : outputConcept.getAllBaseAttributes()) {
                String outBaName = outputBa.getName();
                BaseAttribute inputBa = (BaseAttribute)inputConcept.getBaseAttribute(outBaName);
                if (inputBa == null) {
                    inputBa = this.getMappedInput(outputBa, inputConcept, (edu.udo.cs.miningmart.m4.core.Step)whichStep);
                }
                if (inputBa == null) continue;
                String inBaName = inputBa.getName();
                outputEstimation.setValueList(outBaName, inputEstimation.getValueList(inBaName));
            }
        }
        if (this.getAssertionType().equals(ESTIMATE_VALLIST_FROM_PARAM)) {
            String attribName = this.getNameOfAttribParameter(this.getObj1(), (edu.udo.cs.miningmart.m4.core.Step)whichStep);
            String[] values = this.getValueParametersForAllLoops(this.getObj2(), (edu.udo.cs.miningmart.m4.core.Step)whichStep);
            if (attribName != null && values != null) {
                for (int i = 0; i < values.length; ++i) {
                    outputEstimation.addValueInformation(attribName, values[i], Integer.MIN_VALUE);
                }
            }
        }
        if (this.getAssertionType().equals(ESTIMATE_VALLIST_BY_SYMBOL)) {
            int noOfSymbols = this.getIntegerFromValueParameter(this.getObj2(), (edu.udo.cs.miningmart.m4.core.Step)whichStep);
            String attribName = this.getNameOfAttribParameter(this.getObj1(), (edu.udo.cs.miningmart.m4.core.Step)whichStep);
            if (attribName != null) {
                Vector vl = outputEstimation.getValueList(attribName);
                if (vl.size() >= noOfSymbols) {
                    return;
                }
                for (int i = vl.size(); i < noOfSymbols; ++i) {
                    outputEstimation.addValueInformation(attribName, OUTVAL_SYMBOL + i, Integer.MIN_VALUE);
                }
            }
        }
        if (this.getAssertionType().equals(ESTIMATE_VALLIST_TAKE_FROM) && !whichStep.usesAggregation()) {
            boolean done;
            String[] outBaNames = this.getNamesOfAttribParameterForAllLoops(this.getObj2(), (edu.udo.cs.miningmart.m4.core.Step)whichStep);
            String[] inBaNames = this.getNamesOfAttribParameterForAllLoops(this.getObj1(), (edu.udo.cs.miningmart.m4.core.Step)whichStep);
            if (outBaNames == null) {
                outBaNames = this.getOutputAttribsForInputAttribs(inBaNames, (edu.udo.cs.miningmart.m4.core.Step)whichStep);
            }
            if (done = this.handleReversingSteps(inBaNames, outBaNames, (EstimatedStatistics)outputEstimation, (edu.udo.cs.miningmart.m4.core.Step)whichStep)) {
                return;
            }
            if (outBaNames.length > inBaNames.length && inBaNames.length != 1) {
                throw new M4Exception("Assertion '" + this.getAssertionType() + "' in Step '" + whichStep.getName() + "': don't know how to map a few input attribs to more output attribs!");
            }
            for (int outputIndex = 0; outputIndex < outBaNames.length; ++outputIndex) {
                Vector vl;
                int inputIndex;
                int n = inputIndex = inBaNames.length > 1 ? outputIndex : 0;
                if (!this.attribBelongsToConcept((edu.udo.cs.miningmart.m4.core.Step)whichStep, inBaNames[inputIndex], (Concept)inputEstimation.getConcept()) || (vl = inputEstimation.getValueList(inBaNames[inputIndex])) == null) continue;
                for (String value : vl) {
                    int inputFrequency = inputEstimation.getNumberOfOccurrences(inBaNames[inputIndex], value);
                    outputEstimation.addValueInformation(outBaNames[outputIndex], value, inputFrequency);
                }
            }
        }
        if (this.getAssertionType().equals(ESTIMATE_VALLIST_COMBINE)) {
            String outBaName = this.getNameOfAttribParameter(this.getObj2(), (edu.udo.cs.miningmart.m4.core.Step)whichStep);
            StringTokenizer st = new StringTokenizer(this.getObj1(), ", ");
            String[] inNames = new String[st.countTokens()];
            int i = 0;
            while (st.hasMoreTokens()) {
                inNames[i] = st.nextToken();
                ++i;
            }
            if (outBaName != null) {
                Vector allValues = new Vector();
                for (int j = 0; j < inNames.length; ++j) {
                    String[] moreInputBas = this.getNamesOfAttribParameterForAllLoops(inNames[j], (edu.udo.cs.miningmart.m4.core.Step)whichStep);
                    if (moreInputBas == null) continue;
                    for (int k = 0; k < moreInputBas.length; ++k) {
                        this.addAllIfNotContained(inputEstimation.getValueList(moreInputBas[k]), allValues);
                    }
                }
                outputEstimation.setValueList(outBaName, allValues);
            } else {
                Concept[] inputConcepts = this.getConceptsForParamNames(inNames, (edu.udo.cs.miningmart.m4.core.Step)whichStep);
                EstimatedStatistics[] inputESs = new EstimatedStatistics[inputConcepts.length];
                for (int j = 0; j < inputConcepts.length; ++j) {
                    inputESs[j] = (EstimatedStatistics)inputConcepts[j].getEstimatedStatistics(whichStep);
                }
                Concept refConc = inputConcepts[0];
                Collection refBAs = refConc.getAllBaseAttributes();
                for (BaseAttribute refBA : refBAs) {
                    if (!whichStep.isVisible(refBA)) continue;
                    Vector allValues = new Vector();
                    allValues.addAll(inputESs[0].getValueList(refBA.getName()));
                    for (int j = 1; j < inputConcepts.length; ++j) {
                        BaseAttribute corrBa = (BaseAttribute)inputConcepts[j].getBaseAttribute(refBA.getName());
                        if (corrBa == null) continue;
                        this.addAllIfNotContained(inputESs[j].getValueList(corrBa.getName()), allValues);
                    }
                    outputEstimation.setValueList(refBA.getName(), allValues);
                }
            }
        }
    }

    private boolean handleReversingSteps(String[] inputNames, String[] outBaNames, EstimatedStatistics outputEstimation, edu.udo.cs.miningmart.m4.core.Step whichStep) throws M4Exception {
        if (inputNames == null || inputNames[0] == null) {
            String[] namesOfAttribs = this.getValueParametersForAllLoops(this.getObj1(), whichStep);
            edu.udo.cs.miningmart.m4.core.Step originalStep = (edu.udo.cs.miningmart.m4.core.Step)whichStep.getReversedStep();
            if (originalStep == null) {
                return true;
            }
            if (namesOfAttribs == null) {
                namesOfAttribs = this.getNamesOfAttribParameterForAllLoops("TheTargetAttribute", originalStep);
            }
            if (namesOfAttribs == null || namesOfAttribs.length != outBaNames.length) {
                throw new M4Exception("Assertion '" + this.getAssertionType() + "' of Step '" + whichStep.getName() + "' (handling reversed step): unequal numbers of attributes!");
            }
            Collection inputConcepts = originalStep.getAllInputConcepts();
            for (Concept oneInConc : inputConcepts) {
                EstimatedStatistics inES = (EstimatedStatistics)oneInConc.getEstimatedStatistics(originalStep);
                for (int i = 0; i < namesOfAttribs.length; ++i) {
                    Vector vl;
                    BaseAttribute inBa = (BaseAttribute)oneInConc.getBaseAttribute(namesOfAttribs[i]);
                    if (inBa == null) continue;
                    double min = inES.getLowestValue(namesOfAttribs[i]);
                    double max = inES.getBiggestValue(namesOfAttribs[i]);
                    int noMv = inES.getNumberOfMissingValues(namesOfAttribs[i]);
                    if (this.getAssertionType().equals(ESTIMATE_MINMAX_TAKE_FROM)) {
                        outputEstimation.setBiggestValue(outBaNames[i], max);
                        outputEstimation.setLowestValue(outBaNames[i], min);
                    }
                    if (this.getAssertionType().equals(ESTIMATE_MV_TAKE_FROM)) {
                        outputEstimation.setNumberOfMissingValues(outBaNames[i], noMv);
                    }
                    if ((vl = inES.getValueList(namesOfAttribs[i])) == null) continue;
                    if (this.getAssertionType().equals(ESTIMATE_VALLIST_TAKE_FROM)) {
                        outputEstimation.setValueList(outBaNames[i], vl);
                    }
                    if (!this.getAssertionType().equals(ESTIMATE_VALFREQ_TAKE_FROM)) continue;
                    for (String value : vl) {
                        int valueFrequency = inES.getNumberOfOccurrences(namesOfAttribs[i], value);
                        outputEstimation.setNumberOfOccurrences(outBaNames[i], value, valueFrequency);
                    }
                }
            }
            return true;
        }
        return false;
    }

    private void addAllIfNotContained(Collection addWhat, Collection addTo) {
        if (addTo == null || addWhat == null) {
            return;
        }
        for (Object o : addWhat) {
            if (addTo.contains(o)) continue;
            addTo.add(o);
        }
    }

    private boolean attribBelongsToConcept(edu.udo.cs.miningmart.m4.core.Step theStep, String theAttribName, Concept theConcept) throws M4Exception {
        for (OpParam inputOpPar : theStep.getTheOperator().getAllInputOperatorParameters()) {
            if (!inputOpPar.isBaseAttribParameter() && !inputOpPar.isFeatureParameter()) continue;
            int loopstart = 0;
            if (inputOpPar.isLoopable() && theStep.getLoopCount() > 0) {
                loopstart = 1;
            }
            do {
                Collection c;
                if ((c = theStep.getParameter(inputOpPar, loopstart)) == null) continue;
                for (ParameterObject parObj : c) {
                    BaseAttribute ba = (BaseAttribute)parObj;
                    if (!ba.getName().equalsIgnoreCase(theAttribName) || !theConcept.hasFeature(ba)) continue;
                    return true;
                }
            } while (++loopstart < theStep.getLoopCount());
        }
        return false;
    }

    private void doMissingValuesEstimation(Step whichStep, edu.udo.cs.miningmart.m4.EstimatedStatistics inputEstimation, edu.udo.cs.miningmart.m4.EstimatedStatistics outputEstimation) throws M4Exception {
        String[] outBaNames;
        if (this.getAssertionType().equals(ESTIMATE_NO_CHANGE)) {
            Concept outputConcept = (Concept)whichStep.getOutputConcept();
            Collection outBAs = outputConcept.getAllBaseAttributes();
            for (BaseAttribute outBA : outBAs) {
                if (!whichStep.isVisible(outBA)) continue;
                outputEstimation.setNumberOfMissingValues(outBA.getName(), inputEstimation.getNumberOfMissingValues(outBA.getName()));
            }
        }
        if (this.getAssertionType().equals(ASSERTION_NOT_NULL) && (outBaNames = this.getNamesOfAttribParameterForAllLoops(this.getObj1(), (edu.udo.cs.miningmart.m4.core.Step)whichStep)) != null) {
            for (int i = 0; i < outBaNames.length; ++i) {
                outputEstimation.setNumberOfMissingValues(outBaNames[i], 0);
            }
        }
        if (this.getAssertionType().equals(ESTIMATE_MV_BY_SELECTIVITY) && inputEstimation.getNumberOfRows() != Integer.MIN_VALUE && outputEstimation.getNumberOfRows() != Integer.MIN_VALUE) {
            double selectivity = (double)outputEstimation.getNumberOfRows() / (double)inputEstimation.getNumberOfRows();
            Concept outputConcept = (Concept)whichStep.getOutputConcept();
            Concept inputConcept = (Concept)inputEstimation.getConcept();
            for (BaseAttribute outputBa : outputConcept.getAllBaseAttributes()) {
                String outBaName = outputBa.getName();
                BaseAttribute inputBa = (BaseAttribute)inputConcept.getBaseAttribute(outBaName);
                if (inputBa == null) {
                    inputBa = this.getMappedInput(outputBa, inputConcept, (edu.udo.cs.miningmart.m4.core.Step)whichStep);
                }
                if (this.existsMoreImportantMvAssertion(whichStep, outputBa, inputBa) || inputBa == null) continue;
                String inBaName = inputBa.getName();
                int estimatedNoOfMv = (int)(selectivity * (double)inputEstimation.getNumberOfMissingValues(inBaName));
                outputEstimation.setNumberOfMissingValues(outBaName, estimatedNoOfMv);
            }
        }
        if (this.getAssertionType().equals(ESTIMATE_MV_TAKE_FROM)) {
            String[] outBaNames2;
            String[] inBaNames = this.getNamesOfAttribParameterForAllLoops(this.getObj1(), (edu.udo.cs.miningmart.m4.core.Step)whichStep);
            boolean done = this.handleReversingSteps(inBaNames, outBaNames2 = this.getNamesOfAttribParameterForAllLoops(this.getObj2(), (edu.udo.cs.miningmart.m4.core.Step)whichStep), (EstimatedStatistics)outputEstimation, (edu.udo.cs.miningmart.m4.core.Step)whichStep);
            if (done) {
                return;
            }
            if (inBaNames.length != outBaNames2.length) {
                throw new M4Exception("Assertion '" + this.getAssertionType() + "' in Step '" + whichStep.getName() + "': found unequal number of output and target attributes!");
            }
            for (int i = 0; i < outBaNames2.length; ++i) {
                outputEstimation.setNumberOfMissingValues(outBaNames2[i], inputEstimation.getNumberOfMissingValues(inBaNames[i]));
            }
        }
        if (this.getAssertionType().equals(ESTIMATE_MV_ADD_INPUTS)) {
            String outBaName = this.getNameOfAttribParameter(this.getObj2(), (edu.udo.cs.miningmart.m4.core.Step)whichStep);
            StringTokenizer st = new StringTokenizer(this.getObj1(), ", ");
            String[] inNames = new String[st.countTokens()];
            int i = 0;
            while (st.hasMoreTokens()) {
                inNames[i] = st.nextToken();
                ++i;
            }
            if (outBaName != null) {
                int sumOfMvNumbers = 0;
                for (int j = 0; j < inNames.length; ++j) {
                    String[] moreInputs = this.getNamesOfAttribParameterForAllLoops(inNames[j], (edu.udo.cs.miningmart.m4.core.Step)whichStep);
                    if (moreInputs == null) continue;
                    for (int k = 0; k < moreInputs.length; ++k) {
                        int inputMv = inputEstimation.getNumberOfMissingValues(moreInputs[k]);
                        if (inputMv == Integer.MIN_VALUE) {
                            outputEstimation.setNumberOfMissingValues(outBaName, Integer.MIN_VALUE);
                            return;
                        }
                        sumOfMvNumbers += inputMv;
                    }
                }
                outputEstimation.setNumberOfMissingValues(outBaName, sumOfMvNumbers);
            } else {
                Concept[] inputConcepts = this.getConceptsForParamNames(inNames, (edu.udo.cs.miningmart.m4.core.Step)whichStep);
                EstimatedStatistics[] inputESs = new EstimatedStatistics[inputConcepts.length];
                for (int j = 0; j < inputConcepts.length; ++j) {
                    inputESs[j] = (EstimatedStatistics)inputConcepts[j].getEstimatedStatistics(whichStep);
                }
                Concept refConc = inputConcepts[0];
                Collection refBAs = refConc.getAllBaseAttributes();
                for (BaseAttribute refBA : refBAs) {
                    if (!whichStep.isVisible(refBA)) continue;
                    int inputMv = inputESs[0].getNumberOfMissingValues(refBA.getName());
                    if (inputMv == Integer.MIN_VALUE) {
                        outputEstimation.setNumberOfMissingValues(refBA.getName(), Integer.MIN_VALUE);
                        return;
                    }
                    int sumOfMvNumbers = inputMv;
                    for (int j = 1; j < inputConcepts.length; ++j) {
                        BaseAttribute corrBa = (BaseAttribute)inputConcepts[j].getBaseAttribute(refBA.getName());
                        if (corrBa == null) continue;
                        inputMv = inputESs[j].getNumberOfMissingValues(corrBa.getName());
                        if (inputMv == Integer.MIN_VALUE) {
                            outputEstimation.setNumberOfMissingValues(refBA.getName(), Integer.MIN_VALUE);
                            return;
                        }
                        sumOfMvNumbers += inputMv;
                    }
                    outputEstimation.setNumberOfMissingValues(refBA.getName(), sumOfMvNumbers);
                }
            }
        }
    }

    private boolean existsMoreImportantMvAssertion(Step theStep, BaseAttribute outBa, BaseAttribute inBa) throws M4Exception {
        if (outBa == null && inBa == null) {
            return false;
        }
        Vector params = outBa != null ? outBa.getParameterReferences() : new Vector();
        if (inBa != null) {
            params.addAll(inBa.getParameterReferences());
        }
        for (Parameter par : params) {
            if (!par.getTheStep().equals(theStep)) continue;
            Collection assertions = par.getTheOperator().getAssertions();
            for (Assertion a : assertions) {
                if (!a.getAssertionType().equals(ASSERTION_NOT_NULL) && !a.getAssertionType().equals(ESTIMATE_MV_ADD_INPUTS) && !a.getAssertionType().equals(ESTIMATE_MV_TAKE_FROM)) continue;
                return true;
            }
        }
        return false;
    }

    private void doSizeEstimationSingleInput(Step whichStep, edu.udo.cs.miningmart.m4.EstimatedStatistics inputEstimation, edu.udo.cs.miningmart.m4.EstimatedStatistics outputEstimation) throws M4Exception {
        String nameOfTargetAttrib;
        int noOfMvInInput;
        Vector vl;
        Parameter attribParam;
        if (inputEstimation.getNumberOfRows() == Integer.MIN_VALUE) {
            outputEstimation.setNumberOfRows(Integer.MIN_VALUE);
        }
        if (this.getAssertionType().equals(ESTIMATE_NO_CHANGE)) {
            outputEstimation.setNumberOfRows(inputEstimation.getNumberOfRows());
        }
        if (this.getAssertionType().equals(ESTIMATE_SIZE_BY_VALUE)) {
            long newOutputSize = this.getIntegerFromValueParameter(this.getObj1(), (edu.udo.cs.miningmart.m4.core.Step)whichStep);
            if (inputEstimation.getNumberOfRows() != Integer.MIN_VALUE) {
                newOutputSize = Math.min(newOutputSize, inputEstimation.getNumberOfRows());
            }
            outputEstimation.setNumberOfRows(newOutputSize);
        }
        if (this.getAssertionType().equals(ESTIMATE_SIZE_BY_DIVISION) && inputEstimation.getNumberOfRows() != Integer.MIN_VALUE && (attribParam = (Parameter)whichStep.getParameterTuple(this.getObj1(), 0)) != null && attribParam.getTheParameterObject() != null) {
            ParameterObject parObj = (ParameterObject)attribParam.getTheParameterObject();
            if (parObj instanceof BaseAttribute) {
                String attribName = attribParam.getTheParameterObject().getName();
                vl = inputEstimation.getValueList(attribName);
                if (vl == null || vl.isEmpty()) {
                    outputEstimation.setNumberOfRows(Integer.MIN_VALUE);
                } else {
                    int divisor = vl.size();
                    outputEstimation.setNumberOfRows(inputEstimation.getNumberOfRows() / (long)divisor);
                }
            } else {
                int divisor = this.getIntegerFromValueParameter(this.getObj1(), (edu.udo.cs.miningmart.m4.core.Step)whichStep);
                outputEstimation.setNumberOfRows(inputEstimation.getNumberOfRows() / (long)divisor);
            }
        }
        if (this.getAssertionType().equals(ESTIMATE_SIZE_MULTIPLY_BY) && inputEstimation.getNumberOfRows() != Integer.MIN_VALUE) {
            String[] namesOfAttribs = this.getNamesOfAttribParameterForAllLoops(this.getObj1(), (edu.udo.cs.miningmart.m4.core.Step)whichStep);
            int factor = 1;
            if (namesOfAttribs == null) {
                String theFactor = this.getValueParameter(this.getObj1(), (edu.udo.cs.miningmart.m4.core.Step)whichStep);
                try {
                    factor = Integer.parseInt(theFactor);
                }
                catch (NumberFormatException nfe) {
                    throw new M4Exception("Assertion '" + this.getAssertionType() + "' in Step '" + whichStep.getName() + "': expected an attrib or numeric value parameter or a numeric constant in Obj1!");
                }
            } else {
                factor = namesOfAttribs.length;
            }
            outputEstimation.setNumberOfRows((long)factor * inputEstimation.getNumberOfRows());
        }
        if (this.getAssertionType().equals(ESTIMATE_SIZE_REDUCE_MV) && inputEstimation.getNumberOfRows() != Integer.MIN_VALUE && (noOfMvInInput = inputEstimation.getNumberOfMissingValues(nameOfTargetAttrib = this.getNameOfAttribParameter(this.getObj1(), (edu.udo.cs.miningmart.m4.core.Step)whichStep))) != Integer.MIN_VALUE) {
            outputEstimation.setNumberOfRows(inputEstimation.getNumberOfRows() - (long)noOfMvInInput);
        }
        if (this.getAssertionType().equals(ESTIMATE_SIZE_BY_VALLIST)) {
            String[] nameOfAttribs = this.getNamesOfAttribParameterForAllLoops(this.getObj1(), (edu.udo.cs.miningmart.m4.core.Step)whichStep);
            if (nameOfAttribs == null) {
                long outSize = inputEstimation.getNumberOfRows();
                if (whichStep.getTheOperator().getName().equals("SpecifiedStatistics")) {
                    outSize = 1L;
                }
                outputEstimation.setNumberOfRows(outSize);
                return;
            }
            int outputSize = 1;
            for (int i = 0; i < nameOfAttribs.length; ++i) {
                vl = inputEstimation.getValueList(nameOfAttribs[i]);
                if (vl == null) {
                    outputEstimation.setNumberOfRows(Integer.MIN_VALUE);
                    return;
                }
                outputSize *= vl.size();
            }
            outputEstimation.setNumberOfRows(outputSize);
        }
    }

    private void doSizeEstimationSeveralInputs(Step whichStep, edu.udo.cs.miningmart.m4.EstimatedStatistics[] inputEstimations, edu.udo.cs.miningmart.m4.EstimatedStatistics outputEstimation) throws M4Exception {
        Relation[] theRelations;
        boolean ok;
        if (this.getAssertionType().equals(ESTIMATE_SIZE_ADD_INPUTS)) {
            int sum = 0;
            for (int i = 0; i < inputEstimations.length; ++i) {
                long oneInputSize = inputEstimations[i].getNumberOfRows();
                if (oneInputSize == Integer.MIN_VALUE) {
                    outputEstimation.setNumberOfRows(Integer.MIN_VALUE);
                    return;
                }
                sum = (int)((long)sum + oneInputSize);
            }
            outputEstimation.setNumberOfRows(sum);
        }
        if (this.getAssertionType().equals(ESTIMATE_SIZE_BY_RELATIONS) && (ok = this.checkKeysAreUsedInRelations(theRelations = this.getRelationsForJoin(this.getObj1(), (edu.udo.cs.miningmart.m4.core.Step)whichStep), (edu.udo.cs.miningmart.m4.core.Step)whichStep)) && theRelations != null && theRelations.length > 0 && theRelations.length == 1) {
            Concept manyConcept;
            if (theRelations[0].isOneToManyRelation() && (manyConcept = (Concept)theRelations[0].getTheFromConcept()) != null) {
                long noOfRowsOnManySide = manyConcept.getEstimatedStatistics(whichStep).getNumberOfRows();
                outputEstimation.setNumberOfRows(noOfRowsOnManySide);
            }
            if (theRelations[0].isManyToManyRelation()) {
                long outputSize = Integer.MIN_VALUE;
                Columnset cs = (Columnset)theRelations[0].getCrossLinkColumnSet();
                if (cs == null) {
                    Concept from = (Concept)theRelations[0].getTheFromConcept();
                    Concept to = (Concept)theRelations[0].getTheToConcept();
                    if (from != null && to != null) {
                        long in1 = from.getEstimatedStatistics(whichStep).getNumberOfRows();
                        long in2 = to.getEstimatedStatistics(whichStep).getNumberOfRows();
                        if (in1 != Integer.MIN_VALUE && in2 != Integer.MIN_VALUE) {
                            outputSize = in1 * in2;
                        }
                    }
                } else {
                    outputSize = cs.getStatisticsAll();
                }
                outputEstimation.setNumberOfRows(outputSize);
            }
        }
    }

    private boolean checkKeysAreUsedInRelations(Relation[] theRels, edu.udo.cs.miningmart.m4.core.Step theStep) throws M4Exception {
        OpParam theOpPar = (OpParam)theStep.getTheOperator().getOpParam(this.getObj1());
        if (theOpPar.isRelationParameter()) {
            return true;
        }
        if (theRels == null || theRels.length == 0) {
            return false;
        }
        if (theOpPar.isConceptParameter()) {
            OpParam theKeyOpPar = (OpParam)theStep.getTheOperator().getOpParam("TheKeys");
            if (theKeyOpPar == null) {
                return false;
            }
            Collection allKeys = theStep.getParameter(theKeyOpPar, 0);
            boolean allKeysAreUsedAsRelationKeys = true;
            for (ParameterObject theKeyAttrib : allKeys) {
                boolean found = false;
                for (int i = 0; i < theRels.length; ++i) {
                    Concept theConc = (Concept)theRels[i].getTheFromConcept();
                    if (theConc.hasFeature((BaseAttribute)theKeyAttrib)) {
                        found = true;
                    }
                    if (!(theConc = (Concept)theRels[i].getTheToConcept()).hasFeature((BaseAttribute)theKeyAttrib)) continue;
                    found = true;
                }
                if (found) continue;
                allKeysAreUsedAsRelationKeys = false;
            }
            return allKeysAreUsedAsRelationKeys;
        }
        return false;
    }

    private Relation[] getRelationsForJoin(String nameOfParameter, edu.udo.cs.miningmart.m4.core.Step theStep) throws M4Exception {
        OpParam theOpPar = (OpParam)theStep.getTheOperator().getOpParam(nameOfParameter);
        if (theOpPar.isRelationParameter()) {
            Collection theRelParams = theStep.getParameter(theOpPar, 0);
            Relation[] ret = new Relation[theRelParams.size()];
            Iterator it = theRelParams.iterator();
            int i = 0;
            while (it.hasNext()) {
                ParameterObject parObj = (ParameterObject)it.next();
                ret[i] = (Relation)parObj;
                ++i;
            }
            return ret;
        }
        if (theOpPar.isConceptParameter()) {
            Collection theConceptParams = theStep.getParameter(theOpPar, 0);
            Iterator concIt = theConceptParams.iterator();
            Vector<Relation> allFoundRelationsBetweenTheConcepts = new Vector<Relation>();
            while (concIt.hasNext()) {
                Concept oneConcept = (Concept)concIt.next();
                for (Relation oneRel : oneConcept.getTheFromRelationships()) {
                    if (!theConceptParams.contains(oneRel.getTheToConcept())) continue;
                    allFoundRelationsBetweenTheConcepts.add(oneRel);
                }
            }
            if (allFoundRelationsBetweenTheConcepts.isEmpty()) {
                return null;
            }
            Relation[] ret = new Relation[allFoundRelationsBetweenTheConcepts.size()];
            Iterator relIt = allFoundRelationsBetweenTheConcepts.iterator();
            int i = 0;
            while (relIt.hasNext()) {
                ret[i] = (Relation)relIt.next();
                ++i;
            }
            return ret;
        }
        return null;
    }

    private String getNameOfAttribParameter(String paramName, edu.udo.cs.miningmart.m4.core.Step whichStep) throws M4Exception {
        if (paramName == null || whichStep == null) {
            return null;
        }
        Parameter theParam = (Parameter)whichStep.getParameterTuple(paramName, 0);
        if (theParam != null) {
            ParameterObject parObj = (ParameterObject)theParam.getTheParameterObject();
            if (parObj != null && parObj instanceof Feature) {
                return parObj.getName();
            }
            return null;
        }
        return null;
    }

    private String[] getNamesOfAttribParameter(String paramName, edu.udo.cs.miningmart.m4.core.Step whichStep) throws M4Exception {
        if (paramName == null || whichStep == null) {
            return null;
        }
        OpParam theOpPar = (OpParam)whichStep.getTheOperator().getOpParam(paramName);
        Collection allParams = whichStep.getParameter(theOpPar, 0);
        if (allParams != null) {
            String[] allNames = new String[allParams.size()];
            Iterator it = allParams.iterator();
            int i = 0;
            while (it.hasNext()) {
                ParameterObject parObj = (ParameterObject)it.next();
                if (parObj != null && parObj instanceof Feature) {
                    allNames[i] = parObj.getName();
                }
                ++i;
            }
            return allNames;
        }
        return null;
    }

    private String[] getNamesOfAttribParameterForAllLoops(String paramName, edu.udo.cs.miningmart.m4.core.Step whichStep) throws M4Exception {
        if (paramName == null || whichStep == null) {
            return null;
        }
        OpParam theOpPar = (OpParam)whichStep.getTheOperator().getOpParam(paramName);
        if (theOpPar == null) {
            return null;
        }
        Vector allParams = new Vector();
        int startLoop = 0;
        if (theOpPar.isLoopable() && whichStep.getLoopCount() > 0) {
            startLoop = 1;
        }
        boolean end = false;
        int loop = startLoop;
        while (!end) {
            Collection c = whichStep.getParameter(theOpPar, loop);
            if (c == null || c.isEmpty()) {
                end = true;
                continue;
            }
            allParams.addAll(c);
            ++loop;
        }
        if (!allParams.isEmpty()) {
            String[] allNames = new String[allParams.size()];
            Iterator it = allParams.iterator();
            int i = 0;
            while (it.hasNext()) {
                ParameterObject parObj = (ParameterObject)it.next();
                if (parObj != null && parObj instanceof Feature) {
                    allNames[i] = parObj.getName();
                }
                ++i;
            }
            return allNames;
        }
        return null;
    }

    private String getValueParameter(String paramName, edu.udo.cs.miningmart.m4.core.Step whichStep) throws M4Exception {
        Parameter theParam;
        OpParam theOpParam = (OpParam)whichStep.getTheOperator().getOpParam(paramName);
        int loopNr = 0;
        if (theOpParam != null && theOpParam.isLoopable() && whichStep.getLoopCount() > 0) {
            loopNr = 1;
        }
        if ((theParam = (Parameter)whichStep.getParameterTuple(paramName, loopNr)) != null) {
            ParameterObject parObj = (ParameterObject)theParam.getTheParameterObject();
            if (parObj != null && parObj instanceof Value) {
                return ((Value)parObj).getValue();
            }
            throw new M4Exception("Assertion '" + this.getAssertionType() + "' in Step '" + whichStep.getName() + "': expected value parameter!");
        }
        return null;
    }

    private String[] getValueParametersForAllLoops(String paramName, edu.udo.cs.miningmart.m4.core.Step whichStep) throws M4Exception {
        if (paramName == null || whichStep == null) {
            return null;
        }
        OpParam theOpPar = (OpParam)whichStep.getTheOperator().getOpParam(paramName);
        if (theOpPar == null) {
            return null;
        }
        Vector allParams = new Vector();
        int startLoop = 0;
        if (theOpPar.isLoopable() && whichStep.getLoopCount() > 0) {
            startLoop = 1;
        }
        boolean end = false;
        int loop = startLoop;
        while (!end) {
            Collection c = whichStep.getParameter(theOpPar, loop);
            if (c == null || c.isEmpty()) {
                end = true;
                continue;
            }
            allParams.addAll(c);
            ++loop;
        }
        if (!allParams.isEmpty()) {
            String[] allNames = new String[allParams.size()];
            Iterator it = allParams.iterator();
            int i = 0;
            while (it.hasNext()) {
                ParameterObject parObj = (ParameterObject)it.next();
                if (parObj != null && parObj instanceof Value) {
                    allNames[i] = ((Value)parObj).getValue();
                }
                ++i;
            }
            return allNames;
        }
        return null;
    }

    private int getIntegerFromValueParameter(String paramName, edu.udo.cs.miningmart.m4.core.Step whichStep) throws M4Exception {
        String value = this.getValueParameter(paramName, whichStep);
        if (value == null) {
            value = paramName;
        }
        int theNumber = Integer.MIN_VALUE;
        if (value != null) {
            try {
                theNumber = Integer.parseInt(value);
            }
            catch (NumberFormatException nfe) {
                throw new M4Exception("Assertion '" + this.getAssertionType() + "' in Step '" + whichStep.getName() + "': could not handle '" + paramName + "', expected integer or value parameter!");
            }
        }
        return theNumber;
    }

    private double getDoubleFromValueParameter(String paramName, edu.udo.cs.miningmart.m4.core.Step whichStep) throws M4Exception {
        String value = this.getValueParameter(paramName, whichStep);
        if (value == null) {
            value = paramName;
        }
        double theNumber = Double.NaN;
        if (value != null) {
            try {
                theNumber = Double.parseDouble(value);
            }
            catch (NumberFormatException nfe) {
                throw new M4Exception("Assertion '" + this.getAssertionType() + "' in Step '" + whichStep.getName() + "': could not handle '" + paramName + "', expected integer or value parameter!");
            }
        }
        return theNumber;
    }

    private void assertNotNull(ExecutableOperator exOp, int loop) throws M4CompilerError {
        try {
            String obj1 = this.getObj1();
            edu.udo.cs.miningmart.m4.ParameterObject[] parArray = (ParameterObject[])exOp.getParameter(obj1, loop);
            Collection columns = Condition.getColumnsForParameter(parArray);
            for (Column column : columns) {
                column.setNumberOfMissingValues(0);
            }
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 exception caught when checking assertion '" + this.getAssertionType() + "': " + m4e.getMessage());
        }
    }

    private void assertUniqueness(ExecutableOperator exOp, int loop) throws M4CompilerError {
        try {
            String obj1 = this.getObj1();
            edu.udo.cs.miningmart.m4.ParameterObject[] parArray = (ParameterObject[])exOp.getParameter(obj1, loop);
            Collection columns = Condition.getColumnsForParameter(parArray);
            for (Column column : columns) {
                String countS = column.getColumnset().readOrComputeCount();
                try {
                    int count = Integer.parseInt(countS);
                    column.setNumberOfUniqueValues(count);
                    column.setNumberOfMissingValues(0);
                }
                catch (NumberFormatException e) {
                    this.doPrint(Print.WARNING, "Could not compute count for Columnset with ID " + column.getColumnset().getId());
                }
            }
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 exception caught when checking assertion '" + this.getAssertionType() + "': " + m4e.getMessage());
        }
    }
}

