/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.m4;

import edu.udo.cs.miningmart.compiler.CompilerAccess;
import edu.udo.cs.miningmart.compiler.CompilerAccessLogic;
import edu.udo.cs.miningmart.db.DB;
import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.m4.Case;
import edu.udo.cs.miningmart.m4.Concept;
import edu.udo.cs.miningmart.m4.Operator;
import edu.udo.cs.miningmart.m4.OperatorGroup;
import edu.udo.cs.miningmart.m4.core.M4InterfaceImpl;
import edu.udo.cs.miningmart.m4.utils.Print;
import edu.udo.cs.miningmart.schemamatching.MmSchemaMatcher;
import edu.udo.cs.miningmart.schemamatching.SchemaMatchException;
import java.util.Collection;

public abstract class M4Interface {
    private static transient M4Interface instance = new M4InterfaceImpl();
    protected static Case currentCase;
    protected static transient CompilerAccess currentCompilerAccess;
    public static transient Print print;
    public static final String SYSTEM_PROP_PRINT_VERBOSITY = "PRINT_VERBOSITY";
    public static final String SYSTEM_PROP_DB_CONFIG_PATH = "DB_CONFIG_PATH";
    public static final String MATCHER_SIMPLE = "SimpleMatcher";
    public static final String MATCHER_SOUNDEX = "SoundexMatcher";
    public static final String MATCHER_EDITDISTANCE = "EditDistanceMatcher";
    public static final String MATCHER_NGRAM = "N-Gram-Matcher";
    public static final String[] AVAILABLE_MATCHERS;

    public static M4Interface getInstance() {
        return instance;
    }

    protected static void setInstance(M4Interface m4Instance) {
        instance = m4Instance;
    }

    public abstract Case createCase(String var1, boolean var2) throws M4Exception;

    public abstract Operator createOperator(String var1) throws M4Exception;

    public abstract Collection getAllCaseNames() throws M4Exception;

    public abstract Collection getNamesOfBusinessTablesAndViews(boolean var1) throws M4Exception;

    public abstract boolean isBusinessTable(String var1) throws M4Exception;

    public abstract boolean isBusinessView(String var1) throws M4Exception;

    public abstract boolean existsCase(String var1);

    public abstract DB getM4db();

    public abstract OperatorGroup getOperatorGroup();

    public abstract Operator findOperator(String var1);

    public abstract Collection getAllOperatorNames();

    public abstract Case findCaseForReadOnlyAccess(String var1, boolean var2) throws CaseLockedException;

    public abstract Case findCaseForUpdate(String var1, boolean var2) throws CaseLockedException;

    public abstract boolean canRemoveM4Access(String var1);

    public abstract boolean isCaseLockedForReading(String var1);

    public abstract boolean isCaseLockedForWriting(String var1);

    public abstract void releaseCase(String var1);

    public abstract void releaseCaseWithoutStoring(String var1) throws M4Exception;

    public static Case getCurrentCase() {
        return currentCase;
    }

    public static void setCurrentCase(Case currentCase) {
        M4Interface.currentCase = currentCase;
        print.doPrint(Print.M4_OBJECT, "Current case set to:  " + currentCase.getName());
    }

    public static void removeCurrentCase() {
        currentCase = null;
    }

    public static void setCurrentCompilerAccess(CompilerAccess currentCompilerAccess) {
        M4Interface.currentCompilerAccess = currentCompilerAccess;
        print.doPrint(Print.MIN, "Current CompilerAccess set!");
    }

    public static CompilerAccess getCurrentCompilerAccess() {
        if (currentCompilerAccess == null) {
            try {
                currentCompilerAccess = new CompilerAccessLogic(M4Interface.getInstance().getM4db(), print);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return currentCompilerAccess;
    }

    public abstract Collection findConnection(Concept var1, Collection var2, String var3) throws M4Exception;

    public abstract void connectConceptToCs(Concept var1, Concept var2, MmSchemaMatcher var3) throws M4Exception, SchemaMatchException;

    static {
        print = Print.getGlobalPrintObject();
        AVAILABLE_MATCHERS = new String[]{MATCHER_NGRAM, MATCHER_SOUNDEX, MATCHER_EDITDISTANCE, MATCHER_SIMPLE};
    }

    public class CaseLockedException
    extends Exception {
        public CaseLockedException() {
        }

        public CaseLockedException(String message) {
            super(message);
        }
    }
}

