/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.installer;

import edu.udo.cs.miningmart.db.ConfigReader;
import edu.udo.cs.miningmart.db.DB;
import edu.udo.cs.miningmart.exception.DbConnectionClosed;
import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.gui.application.MiningMartApplication;
import edu.udo.cs.miningmart.gui.util.DbConfigEditorWindow;
import edu.udo.cs.miningmart.gui.util.DbConfigEditorWindowForMysql;
import edu.udo.cs.miningmart.gui.util.DbConfigEditorWindowForOracle;
import edu.udo.cs.miningmart.gui.util.DbConfigEditorWindowForPostgres;
import edu.udo.cs.miningmart.installer.AskForDbmsDialog;
import edu.udo.cs.miningmart.m4.M4Interface;
import edu.udo.cs.miningmart.m4.core.M4InterfaceImpl;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintStream;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JOptionPane;

public class MmInstallerTools {
    private DB db;
    boolean usingOracle;
    boolean usingMysql;
    private static boolean mmHomeOk = false;
    private static boolean dbConfigOk = false;
    private static boolean m4SchemaOk = false;
    private static boolean aprioriOk = false;
    private static boolean svmOk = false;
    private static boolean c45Ok = false;
    private static boolean kmeansOk = false;
    private static boolean featSelectOk = false;
    private static boolean opsOk = false;
    private static boolean m4extensionOk = false;
    private static short userDbmsSelection = (short)-1;
    public static final boolean debugInstallation = false;
    private static final boolean useFileForDebugMessages = false;
    private static PrintStream debugOut;
    String[] operatorTables = new String[]{"op_constr_t", "op_cond_t", "op_assert_t", "op_params_t", "op_group_t", "operator_t"};

    public MmInstallerTools(DB myM4Db) throws M4Exception {
        try {
            this.db = myM4Db;
            this.usingOracle = this.db.getM4Dbms() == 1;
            this.usingMysql = this.db.getM4Dbms() == 3;
        }
        catch (DbConnectionClosed dbc) {
            throw new M4Exception("MmInstallerTools: error accessing DB (connection closed): " + dbc.getMessage());
        }
        catch (NullPointerException npe) {
            throw new M4Exception("MmInstallerTools: error accessing DB (no connection)!");
        }
    }

    public static boolean installationIsValid() {
        String dbFileName;
        File f;
        MmInstallerTools.printDebugMessage("Called 'installationIsValid'.");
        String home = System.getProperty("MM_HOME");
        if (home != null) {
            f = new File(home);
            mmHomeOk = f.exists();
        } else {
            MmInstallerTools.printDebugMessage("Variable 'home' could not be initialised!");
        }
        if (mmHomeOk) {
            home = home + File.separator + "config";
            f = new File(home);
            mmHomeOk = f.exists();
        }
        if ((dbFileName = System.getProperty("DB_CONFIG_PATH")) == null) {
            MmInstallerTools.printDebugMessage("dbFileName is Null!");
            dbConfigOk = false;
        } else {
            File f2 = new File(dbFileName);
            if (!f2.exists()) {
                MmInstallerTools.printDebugMessage("File 'dbFileName' does not exist, value is: " + dbFileName);
                dbConfigOk = false;
            } else {
                try {
                    MmInstallerTools.printDebugMessage("Opening ConfigReader with 'dbFileName' = " + dbFileName);
                    new ConfigReader(dbFileName);
                    MmInstallerTools.printDebugMessage("Opened ConfigReader successfully.");
                    DB theDb = M4Interface.getInstance().getM4db();
                    if (theDb != null) {
                        MmInstallerTools.printDebugMessage("Db connection seems to work.");
                        dbConfigOk = true;
                    } else {
                        MmInstallerTools.printDebugMessage("Got >null< as DB object, DB connection does not seem to work.");
                        dbConfigOk = false;
                    }
                }
                catch (M4Exception m) {
                    MmInstallerTools.printDebugMessage("Error connecting to database: " + m.getMessage());
                    dbConfigOk = false;
                }
            }
        }
        MmInstallerTools m4sc = null;
        if (!dbConfigOk) {
            m4SchemaOk = false;
        } else {
            try {
                m4sc = new MmInstallerTools(M4Interface.getInstance().getM4db());
                m4SchemaOk = m4sc.m4TablesExist();
            }
            catch (M4Exception m) {
                m4SchemaOk = false;
            }
        }
        if (!m4SchemaOk) {
            opsOk = false;
        } else {
            try {
                m4sc = new MmInstallerTools(M4Interface.getInstance().getM4db());
                opsOk = m4sc.staticOperatorEntriesExist();
            }
            catch (M4Exception m) {
                opsOk = false;
            }
        }
        if (mmHomeOk) {
            String osName = System.getProperty("os.name");
            String[] filesToCheck = new String[]{};
            home = System.getProperty("MM_HOME");
            if (!home.endsWith(File.separator)) {
                home = home + File.separator;
            }
            String path = null;
            if (!osName.substring(0, 3).equalsIgnoreCase("win")) {
                if (osName.equalsIgnoreCase("SunOS")) {
                    path = home + "ext/bin/SunOS/";
                } else if (osName.equalsIgnoreCase("Linux")) {
                    path = home + "ext/bin/Linux";
                }
                filesToCheck = new String[]{path + "apriori"};
                if (MmInstallerTools.allFilesExist(filesToCheck)) {
                    aprioriOk = true;
                }
                if (MmInstallerTools.allFilesExist(filesToCheck = new String[]{path + "mysvm", path + "predict"})) {
                    svmOk = true;
                }
                if (!osName.equalsIgnoreCase("Linux")) {
                    filesToCheck = new String[]{path + "C4.5_script", path + "c4.5", path + "c4.5rules", path + "rules2dlf", path + "tree2dlf"};
                    if (MmInstallerTools.allFilesExist(filesToCheck)) {
                        c45Ok = true;
                    }
                    if (MmInstallerTools.allFilesExist(filesToCheck = new String[]{path + "mms3"})) {
                        kmeansOk = true;
                    }
                    if (MmInstallerTools.allFilesExist(filesToCheck = new String[]{path + "fsgenetic", path + "c4.5_fselect", path + "fsstat"})) {
                        featSelectOk = true;
                    }
                }
            }
        }
        if (m4SchemaOk && m4sc != null) {
            try {
                m4extensionOk = m4sc.checkM4Extension();
            }
            catch (M4Exception m4e) {
                m4extensionOk = false;
            }
        }
        return mmHomeOk && dbConfigOk && m4SchemaOk && opsOk && m4extensionOk;
    }

    public static boolean doInstallation(String possibleHomeDirectory) {
        MmInstallerTools m4sc = null;
        MmInstallerTools.printDebugMessage("Calling 'doInstallation' with arg '" + possibleHomeDirectory + "'");
        String home = System.getProperty("MM_HOME");
        MmInstallerTools.printDebugMessage("Got '" + home + "' for system property '" + "MM_HOME" + "'");
        File f = null;
        if (home != null && (f = new File(home)).exists()) {
            mmHomeOk = true;
        }
        if (!mmHomeOk && (f = new File(home = possibleHomeDirectory)).exists()) {
            mmHomeOk = true;
        }
        MmInstallerTools.printDebugMessage("Variable 'mmHomeOk' is " + mmHomeOk);
        while (!mmHomeOk) {
            if ((home = JOptionPane.showInputDialog(null, "Please enter the Home directory for MiningMart,\nwhich is the complete path up to and including 'MiningMart-1.0'.", home)) != null) {
                f = new File(home);
                mmHomeOk = f.exists();
                continue;
            }
            mmHomeOk = false;
            return false;
        }
        if (!home.endsWith(File.separator)) {
            home = home + File.separator;
        }
        MmInstallerTools.printDebugMessage("'home' is '" + home + "'");
        String propertiesFile = home + "config" + File.separator + "MiningMartHome.properties";
        MmInstallerTools.printDebugMessage("'propertiesFile' is '" + propertiesFile + "'");
        f = new File(propertiesFile);
        if (!f.exists()) {
            JOptionPane.showConfirmDialog(null, "File '" + propertiesFile + "' should exist but doesn't!", "Error during installation", 2, 0);
            return false;
        }
        if (mmHomeOk) {
            if (!home.endsWith(File.separator)) {
                home = home + File.separator;
            }
        } else {
            return false;
        }
        MmInstallerTools.setKeyValuePair(propertiesFile, "MM_HOME", home);
        System.setProperty("MM_HOME", home);
        MiningMartApplication.setDefaultProperties();
        String dbFileName = null;
        HashMap connectionValues = null;
        if (!dbConfigOk) {
            dbFileName = System.getProperty("DB_CONFIG_PATH");
            boolean dbConfFileOk = false;
            f = null;
            if (dbFileName != null) {
                f = new File(dbFileName);
            }
            if (dbFileName == null || f != null && !f.exists()) {
                boolean endsWithSlash = home.endsWith(File.separator);
                String suggestion = home + (endsWithSlash ? "" : File.separator) + "config" + File.separator + "db.config.myname";
                dbFileName = JOptionPane.showInputDialog(null, "Please enter the complete path and file name for a\nfile that will contain the database connection information.", suggestion);
                if (dbFileName == null) {
                    return false;
                }
                f = new File(dbFileName);
                if (!f.exists()) {
                    MmInstallerTools.printDebugMessage("Creating Db Config File. 'dbFileName' is " + dbFileName);
                    connectionValues = MmInstallerTools.makeDbConfigFile(dbFileName, propertiesFile, connectionValues);
                    if (connectionValues == null) {
                        MmInstallerTools.printDebugMessage("Not ready after creating Db Config File.");
                        return false;
                    }
                } else {
                    MmInstallerTools.printDebugMessage("Adding DB_CONFIG_PATH to 'propertiesFile' which is " + propertiesFile);
                    MmInstallerTools.setKeyValuePair(propertiesFile, "DB_CONFIG_PATH", dbFileName);
                }
                MmInstallerTools.printDebugMessage("Setting system property DB_CONFIG_PATH to " + dbFileName);
                System.setProperty("DB_CONFIG_PATH", dbFileName);
            }
            try {
                MmInstallerTools.printDebugMessage("Trying to open ConfigReader on " + dbFileName);
                ConfigReader cr = new ConfigReader(dbFileName);
                MmInstallerTools.printDebugMessage("Success opening ConfigReader on " + dbFileName);
                connectionValues = MmInstallerTools.storeValuesFromFileInMap(cr);
                dbConfFileOk = true;
            }
            catch (M4Exception m4e) {
                MmInstallerTools.printDebugMessage("Could not open ConfigReader.");
                dbConfFileOk = false;
            }
            if (!dbConfFileOk) {
                MmInstallerTools.printDebugMessage("Calling makeDbConfigFile, 'home' is " + home);
                connectionValues = MmInstallerTools.makeDbConfigFile(dbFileName, home, connectionValues);
                if (connectionValues == null) {
                    MmInstallerTools.printDebugMessage("No success calling makeDbConfigFile.");
                    return false;
                }
                MmInstallerTools.setKeyValuePair(propertiesFile, "DB_CONFIG_PATH", dbFileName);
                System.setProperty("DB_CONFIG_PATH", dbFileName);
            }
        }
        if (!(dbConfigOk = MmInstallerTools.makeNewDbConnection(dbConfigOk, connectionValues, dbFileName, propertiesFile))) {
            return false;
        }
        try {
            m4sc = new MmInstallerTools(M4Interface.getInstance().getM4db());
        }
        catch (M4Exception m4e) {
            JOptionPane.showMessageDialog(null, "Error trying to instantiate DB connection: " + m4e.getMessage(), "Error during installation", 0);
            return false;
        }
        MmInstallerTools.installationIsValid();
        if (!m4SchemaOk) {
            try {
                if (m4sc.m4TablesExist()) {
                    m4SchemaOk = true;
                } else {
                    boolean usingMysql;
                    int choice = JOptionPane.showConfirmDialog(null, "Warning: the system has not found all M4 tables. It will now create the M4 tables in the schema that was given\nas M4 schema in the database. If you have old M4 tables or tables with names identical\nto any M4 table, they will be deleted! Do you want to continue?", "Database warning", 2, 2);
                    if (choice == 2) {
                        return false;
                    }
                    String s = File.separator;
                    String fileName = home + s + "m4install" + s + M4Interface.getInstance().getM4db().getM4InstallationDirectory(false);
                    String createTablesFileName = fileName + s + "CreateM4Tables.sql";
                    m4sc.removeM4Tables();
                    m4sc.createM4Tables(createTablesFileName);
                    boolean bl = usingMysql = M4Interface.getInstance().getM4db().getM4Dbms() == 3;
                    if (!usingMysql) {
                        m4sc.installM4Sequence();
                    }
                    String insertOpsFileName = fileName + s + "Operators.sql";
                    m4sc.writeOperatorsIntoSchema(insertOpsFileName);
                    m4sc.db.commitM4Transactions();
                    m4SchemaOk = true;
                }
            }
            catch (M4Exception m4e) {
                JOptionPane.showMessageDialog(null, "Error trying to create M4 tables:\n" + m4e.getMessage(), "Error during installation", 0);
                return false;
            }
            catch (DbConnectionClosed d) {
                JOptionPane.showMessageDialog(null, "Error trying to create M4 tables: database connection closed!\n" + d.getMessage(), "Error during installation", 0);
                return false;
            }
        }
        if (!opsOk) {
            try {
                opsOk = m4sc.staticOperatorEntriesExist();
                if (!opsOk) {
                    MmInstallerTools.ensureOperatorsAreInserted();
                }
            }
            catch (M4Exception m4e) {
                JOptionPane.showConfirmDialog(null, "An error occurred when checking for operator entries or\nwhen inserting operators into M4 tables. Error message:\n" + m4e.getMessage(), "Error during installation", 2, 0);
                return false;
            }
        }
        try {
            if (!aprioriOk) {
                m4sc.removeOperatorFromM4("Apriori");
            }
            if (!c45Ok) {
                String[] opsToDelete = new String[]{"MissingValuesWithDecisionTree", "MissingValuesWithDecisionRules", "PredictionWithDecisionTree", "PredictionWithDecisionRules", "DecisionTreeForRegression", "AssignPredictedValueCategorial"};
                for (int i = 0; i < opsToDelete.length; ++i) {
                    m4sc.removeOperatorFromM4(opsToDelete[i]);
                }
            }
            if (!svmOk) {
                String[] opsToDelete = new String[]{"SupportVectorMachineForClassification", "MissingValuesWithRegressionSVM", "FeatureSelectionWithSVM", "ComputeSVMError", "SupportVectorMachineForRegression"};
                for (int i = 0; i < opsToDelete.length; ++i) {
                    m4sc.removeOperatorFromM4(opsToDelete[i]);
                }
            }
            if (!featSelectOk) {
                String[] opsToDelete = new String[]{"StatisticalFeatureSelection", "GeneticFeatureSelection", "SGFeatureSelection"};
                for (int i = 0; i < opsToDelete.length; ++i) {
                    m4sc.removeOperatorFromM4(opsToDelete[i]);
                }
            }
            if (!kmeansOk) {
                m4sc.removeOperatorFromM4("SegmentationWithKMean");
            }
        }
        catch (M4Exception m4e) {
            JOptionPane.showMessageDialog(null, "An error occurred when some operators that depend on external algorithms\nwere disabled. Depending on the type of error some of your machine learning\noperators may be defect. Error message:\n" + m4e.getMessage(), "Error during installation", 2);
        }
        if (m4SchemaOk && m4sc != null && !m4extensionOk) {
            try {
                home = System.getProperty("MM_HOME");
                if (!home.endsWith(File.separator)) {
                    home = home + File.separator;
                }
                String s = File.separator;
                String fileName = home + s + "m4install" + s + M4Interface.getInstance().getM4db().getM4InstallationDirectory(false) + s + "UpdateM4Tables.sql";
                m4sc.ensureM4Extension(fileName);
                m4extensionOk = true;
            }
            catch (M4Exception m4e) {
                JOptionPane.showMessageDialog(null, "An error occurred when trying to update your M4 schema (with ROLES).\nSome of the information about BaseAttributes that MiningMart displays may be incorrect.\nError message: " + m4e.getMessage(), "Error during installation", 2);
                return true;
            }
        }
        return true;
    }

    public static boolean makeNewDbConnection(boolean dbConfigOk, HashMap connectionValues, String dbFileName, String propertiesFile) {
        while (!dbConfigOk) {
            try {
                MmInstallerTools.printDebugMessage("Creating MmInstallerTools object.");
                M4InterfaceImpl mi = (M4InterfaceImpl)M4Interface.getInstance();
                mi.getNewDbConnection();
                new MmInstallerTools(M4Interface.getInstance().getM4db());
                MmInstallerTools.printDebugMessage("Success creating MmInstallerTools object.");
                dbConfigOk = true;
            }
            catch (M4Exception m4e) {
                MmInstallerTools.printDebugMessage("Error creating MmInstallerTools object.");
                int answer = JOptionPane.showConfirmDialog(null, "Error trying to connect to database:\n" + m4e.getMessage() + "\n\n* Click 'YES' to edit the connection settings.\n" + "* Click 'NO' to stop; then you can edit the file\n   " + dbFileName + "\nto change the current connection info, and re-start the system afterwards.", "Error during DB connection", 0);
                if (answer == 1) {
                    return false;
                }
                connectionValues = MmInstallerTools.makeDbConfigFile(dbFileName, propertiesFile, connectionValues);
            }
        }
        return dbConfigOk;
    }

    public static HashMap storeValuesFromFileInMap(ConfigReader theReader) {
        if (theReader == null) {
            return null;
        }
        HashMap<String, String> theMap = new HashMap<String, String>();
        theMap.put("busDbName", theReader.getBusDbName());
        theMap.put("busPass", theReader.getBusPw());
        theMap.put("busUser", theReader.getBusUser());
        theMap.put("jdbcDriver", theReader.getBusDriver());
        theMap.put("dbHost", theReader.getBusHost());
        theMap.put("dbName", theReader.getBusDbName());
        theMap.put("dbPort", theReader.getBusPort());
        theMap.put("m4DbName", theReader.getM4DbName());
        theMap.put("m4User", theReader.getM4User());
        theMap.put("m4Pass", theReader.getM4Pw());
        if (theReader.getBusDriver().indexOf("postgres") > -1) {
            theMap.put("DBMS_TYPE", "POSTGRES");
        }
        if (theReader.getBusDriver().indexOf("mysql") > -1) {
            theMap.put("DBMS_TYPE", "MYSQL");
        }
        if (theReader.getBusDriver().indexOf("oracle") > -1) {
            theMap.put("DBMS_TYPE", "ORACLE");
        }
        return theMap;
    }

    public static void prepareExtraDebugMessageLogFile(String path) {
    }

    public static void printDebugMessage(String what) {
    }

    public static void endDebugMessaging() {
    }

    public static String createHomePropertiesFile(String homeDirectory) {
        String configDirectory;
        File f = new File(homeDirectory);
        if (!f.exists()) {
            JOptionPane.showMessageDialog(null, "You have entered the home directory\n" + homeDirectory + "\n but it does not exist!", "File error", 0);
            return null;
        }
        if (!homeDirectory.endsWith(File.separator)) {
            homeDirectory = homeDirectory + File.separator;
        }
        if (!(f = new File(configDirectory = homeDirectory + "config" + File.separator)).exists()) {
            JOptionPane.showMessageDialog(null, "You have entered the home directory\n" + homeDirectory + "\n but it does not have the required subdirectory 'config'!", "Installation error", 0);
            return null;
        }
        String propFile = configDirectory + "MiningMartHome.properties";
        f = new File(propFile);
        try {
            if (!f.exists()) {
                f.createNewFile();
            }
            PrintStream out = new PrintStream(new FileOutputStream(f));
            out.println("# Main configuration file for MiningMart.\n#\n#");
            out.println("# You should enter here the path to the MiningMart system directory.");
            out.println("# Example (Windows): MM_HOME=C:\\Programs\\MiningMart-1.0\\");
            out.println("# Example (Linux):   MM_HOME=/home/myname/analysis/MiningMart-1.0/");
            out.println("\nMM_HOME = " + homeDirectory + "\n");
            out.println("# You may enter here the complete path to the file db.config; this file");
            out.println("# is usually in MM_HOME/config/ and if this is the case, the system");
            out.println("# finds out for itself.");
            out.println("\nDB_CONFIG_PATH = ...");
            out.flush();
            out.close();
            return propFile;
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(null, "Error trying to write properties to '" + propFile + ":\n" + ioe.getMessage(), "Error during installation", 0);
            return null;
        }
    }

    public static void readSystemPropsFromHomeProperties(String propFilename) {
        File f = new File(propFilename);
        if (!f.exists()) {
            MmInstallerTools.printDebugMessage("'propFileName' in 'readSystemPropsFromHomeProperties' is '" + propFilename + "', File does not exist!");
            return;
        }
        try {
            LineNumberReader lnr = new LineNumberReader(new FileReader(f));
            String line = lnr.readLine();
            while (line != null) {
                if ((line = line.trim()).equals("") || line.startsWith("#")) {
                    line = lnr.readLine();
                    continue;
                }
                int indexOfEqualSign = line.indexOf("=");
                if (indexOfEqualSign == -1) {
                    throw new IOException("Found invalid key-value pair, line: " + line);
                }
                String readKey = line.substring(0, indexOfEqualSign).trim();
                if (readKey.equals("")) {
                    throw new IOException("Found invalid key-value pair, line: " + line);
                }
                String readValue = null;
                if (line.length() > indexOfEqualSign + 1) {
                    readValue = line.substring(indexOfEqualSign + 1).trim();
                }
                if (readKey.equalsIgnoreCase("DB_CONFIG_PATH") && readValue != null) {
                    MmInstallerTools.printDebugMessage("Setting system property 'DB_CONFIG_PATH' to '" + readValue + "'!");
                    System.setProperty("DB_CONFIG_PATH", readValue);
                }
                if (readKey.equalsIgnoreCase("MM_HOME") && readValue != null) {
                    MmInstallerTools.printDebugMessage("Setting system property 'MM_HOME' to '" + readValue + "'!");
                    System.setProperty("MM_HOME", readValue);
                }
                line = lnr.readLine();
            }
            lnr.close();
        }
        catch (IOException i) {
            JOptionPane.showMessageDialog(null, "Error reading properties from '" + propFilename + ":\n" + i.getMessage(), "Error during startup", 0);
            return;
        }
    }

    public static HashMap makeDbConfigFile(String nameForDbConfigFile, String homePropertiesFileName, HashMap initialValues) {
        final HashMap theValues = initialValues == null ? new HashMap() : initialValues;
        final String dbFileName = nameForDbConfigFile;
        ActionListener a = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MmInstallerTools.writeDbConfigValuesToFile(theValues, dbFileName);
            }
        };
        String formerDbms = (String)theValues.get("DBMS_TYPE");
        short whichDbms = MmInstallerTools.askForDbms(formerDbms);
        DbConfigEditorWindow w = null;
        MmInstallerTools.printDebugMessage("'whichDbms' in 'makeDbConfigFile' has value " + whichDbms);
        if (whichDbms == 3) {
            if (formerDbms != null && !formerDbms.equals("MYSQL")) {
                theValues.clear();
            }
            theValues.put("DBMS_TYPE", "MYSQL");
            w = new DbConfigEditorWindowForMysql(null, theValues, a);
        }
        if (whichDbms == 1) {
            if (formerDbms != null && !formerDbms.equals("ORACLE")) {
                theValues.clear();
            }
            theValues.put("DBMS_TYPE", "ORACLE");
            w = new DbConfigEditorWindowForOracle(null, theValues, a);
        }
        if (whichDbms == 2) {
            if (formerDbms != null && !formerDbms.equals("POSTGRES")) {
                theValues.clear();
            }
            theValues.put("DBMS_TYPE", "POSTGRES");
            w = new DbConfigEditorWindowForPostgres(null, theValues, a);
        }
        if (w == null) {
            return null;
        }
        w.setRestartWarning(false);
        w.prepareWindow();
        w.setVisible(true);
        if (w.isCanceled()) {
            return theValues;
        }
        MmInstallerTools.setKeyValuePair(homePropertiesFileName, "DB_CONFIG_PATH", nameForDbConfigFile);
        System.setProperty("DB_CONFIG_PATH", nameForDbConfigFile);
        return theValues;
    }

    private static short askForDbms(String initialChoice) {
        final Vector<Short> theChoice = new Vector<Short>();
        if (initialChoice != null) {
            if (initialChoice.equals("MYSQL")) {
                theChoice.add(new Short(3));
            }
            if (initialChoice.equals("POSTGRES")) {
                theChoice.add(new Short(2));
            }
            if (initialChoice.equals("ORACLE")) {
                theChoice.add(new Short(1));
            }
        }
        ActionListener a = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MmInstallerTools.setChoice(theChoice);
            }
        };
        new AskForDbmsDialog(null, theChoice, a);
        return userDbmsSelection;
    }

    private static void setChoice(Vector theDbmsChoice) {
        userDbmsSelection = theDbmsChoice.isEmpty() ? (short)-1 : (Short)theDbmsChoice.get(0);
    }

    private static boolean setKeyValuePair(String givenFile, String key, String value) {
        try {
            File f = new File(givenFile);
            if (!f.exists()) {
                f.createNewFile();
            }
            Vector<String> newLines = new Vector<String>();
            LineNumberReader lnr = new LineNumberReader(new FileReader(f));
            String line = lnr.readLine();
            while (line != null) {
                if ((line = line.trim()).equals("") || line.startsWith("#")) {
                    newLines.add(line);
                    line = lnr.readLine();
                    continue;
                }
                int indexOfEqualSign = line.indexOf("=");
                if (indexOfEqualSign == -1) {
                    throw new IOException("Found invalid key-value pair, line: " + line);
                }
                String readKey = line.substring(0, indexOfEqualSign).trim();
                if (readKey.equals("")) {
                    throw new IOException("Found invalid key-value pair, line: " + line);
                }
                String readValue = null;
                if (line.length() > indexOfEqualSign + 1) {
                    readValue = line.substring(indexOfEqualSign + 1).trim();
                }
                if ((value == null || value.equals("")) && readValue != null) {
                    value = readValue;
                }
                if (readKey.equalsIgnoreCase(key)) {
                    line = key + " = " + value;
                }
                newLines.add(line);
                line = lnr.readLine();
            }
            PrintStream out = new PrintStream(new FileOutputStream(f));
            for (String nextLine : newLines) {
                out.println(nextLine);
            }
            out.flush();
            out.close();
            return true;
        }
        catch (IOException ioe) {
            JOptionPane.showConfirmDialog(null, "Error trying to read or write properties from/to '" + givenFile + ":\n" + ioe.getMessage(), "Error during installation", 2, 0);
            return false;
        }
    }

    private static boolean writeDbConfigValuesToFile(HashMap theMap, String nameForFile) {
        try {
            File f = new File(nameForFile);
            if (!f.exists()) {
                f.createNewFile();
            }
            PrintStream out = new PrintStream(new FileOutputStream(f));
            MmInstallerTools.writeStartComment(out);
            String type = (String)theMap.get("DBMS_TYPE");
            String dbName = null;
            if (type != null && type.equals("MYSQL")) {
                dbName = (String)theMap.get("m4DbName");
                if (dbName == null) {
                    dbName = (String)theMap.get("dbName");
                }
            } else {
                dbName = (String)theMap.get("dbName");
                if (dbName == null) {
                    dbName = (String)theMap.get("m4DbName");
                }
            }
            out.println("# Name of database used for M4 tables:");
            out.println("M4_DBNAME = " + dbName + "\n");
            String driver = (String)theMap.get("jdbcDriver");
            out.println("# Path to JDBC driver used to access M4 tables.");
            out.println("# For Oracle this is probably 'jdbc:oracle:thin:'.");
            out.println("# For Postgres this is probably 'jdbc:postgresql:'.");
            out.println("# For Mysql this is probably 'jdbc:mysql:'.");
            out.println("M4_JDBC_DRIVER = " + driver + "\n");
            String host = (String)theMap.get("dbHost");
            String port = (String)theMap.get("dbPort");
            out.println("# Access to database server for M4 tables.");
            out.println("# Format for Oracle: @<host>:<port>:");
            out.println("# Format for Postgres: //<host>:<port>    (note: no final colon)");
            out.println("# Format for Mysql: //<host>:<port>    (note: no final colon)");
            boolean oracle = driver.indexOf("oracle") > -1;
            boolean postgr = driver.indexOf("postgres") > -1;
            boolean mysql = driver.indexOf("mysql") > -1;
            String location = null;
            if (oracle) {
                location = "@" + host + ":" + port + ":";
            }
            if (postgr || mysql) {
                location = "//" + host + ":" + port;
            }
            out.println("M4_HOST_PORT = " + location + "\n");
            String m4user = (String)theMap.get("m4User");
            out.println("# Name of DB user who owns M4 tables:");
            out.println("M4_USER = " + m4user + "\n");
            String m4pass = (String)theMap.get("m4Pass");
            out.println("# Password for DB user who owns M4 tables:");
            out.println("M4_PASSWORD = " + m4pass + "\n");
            if (type != null && type.equals("MYSQL")) {
                dbName = (String)theMap.get("busDbName");
                if (dbName == null) {
                    dbName = (String)theMap.get("dbName");
                }
            } else {
                dbName = (String)theMap.get("dbName");
                if (dbName == null) {
                    dbName = (String)theMap.get("busDbName");
                }
            }
            out.println("# Name of database used for business tables:");
            out.println("BUS_DBNAME = " + dbName + "\n");
            out.println("# Path to JDBC driver used to access business tables.");
            out.println("# For Oracle this is probably 'jdbc:oracle:thin:'.");
            out.println("# For Postgres this is probably 'jdbc:postgresql:'.");
            out.println("# For Mysql this is probably 'jdbc:mysql:'.");
            out.println("BUS_JDBC_DRIVER = " + driver + "\n");
            out.println("# Access to database server for business tables.");
            out.println("# Format for Oracle: @<host>:<port>:");
            out.println("# Format for Postgres: //<host>:<port>    (note: no final colon)");
            out.println("# Format for Mysql: //<host>:<port>    (note: no final colon)");
            out.println("BUS_HOST_PORT = " + location + "\n");
            String bususer = (String)theMap.get("busUser");
            out.println("# Name of DB user who owns business tables:");
            out.println("BUS_USER = " + bususer + "\n");
            String buspass = (String)theMap.get("busPass");
            out.println("# Password for DB user who owns business tables:");
            out.println("BUS_PASSWORD = " + buspass + "\n");
            out.flush();
            out.close();
            return true;
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(null, "Error trying to read database connection info from user or writing it to a config file:\n" + ioe.getMessage(), "Error during installation", 0);
            return false;
        }
    }

    private static void writeStartComment(PrintStream out) {
        out.println("# This file contains the information that tells\n# the MiningMart system how to connect to your database.\n#\n# There are two sets of values. The first set is for\n# the M4 database schema. This is the schema where you\n# installed the M4 tables when you followed the instructions\n# in the file MM_HOME/m4install/<DbmsName>/README.txt. \n# The second set of values is for the database schema that \n# holds the data which you want to prepare or analyse.\n# The values given in the two sets may be identical.\n#\n# You might want to entertain several copies of this file\n# with different database connection information. In order\n# to start MiningMart with the connection you choose, enter\n# the name and path of the correct version of this file as\n# the value of DB_CONFIG_PATH into the file\n# MM_HOME/config/MiningMartHome.properties.");
    }

    private static boolean allFilesExist(String[] fileNames) {
        for (int i = 0; i < fileNames.length; ++i) {
            File f = new File(fileNames[i]);
            if (f.exists()) continue;
            return false;
        }
        return true;
    }

    public void removeM4Tables() throws M4Exception {
        String[] tablenames = DB.ORDER_FOR_WRITING;
        for (int i = tablenames.length - 1; i >= 0; --i) {
            this.db.dropM4Table(tablenames[i]);
        }
        this.db.dropM4Table("revstep_t");
        this.db.dropM4Table("roles_t");
        this.db.commitM4Transactions();
    }

    public void writeOperatorsIntoSchema(String fileAndPathWithOperatorInfo) throws M4Exception {
        if (!this.m4TablesExist()) {
            throw new M4Exception("MmInstallerTools: cannot update operators since the M4 tables do not seem to exist!");
        }
        File f = new File(fileAndPathWithOperatorInfo);
        if (!f.exists()) {
            throw new M4Exception("MmInstallerTools: cannot update operators since Operator information file could not be found!");
        }
        try {
            String syntax = "CONSTRAINT";
            if (this.usingMysql) {
                syntax = "FOREIGN KEY";
            }
            String query = "ALTER TABLE step_t DROP " + syntax + " stopid_fk";
            try {
                this.db.executeM4SqlWrite(query);
                query = "ALTER TABLE parameter_t DROP " + syntax + " paropid_fk";
                this.db.executeM4SqlWrite(query);
            }
            catch (SQLException s) {
                // empty catch block
            }
            query = "DELETE FROM docu_t WHERE doc_objtype = 'OPERATOR'";
            this.db.executeM4SqlWrite(query);
            for (int i = 0; i < this.operatorTables.length; ++i) {
                query = "DELETE FROM " + this.operatorTables[i];
                this.db.executeM4SqlWrite(query);
            }
            this.writeSqlCommandsFromFileIntoDb(f, true);
            query = "ALTER TABLE step_t ADD (CONSTRAINT stopid_fk FOREIGN KEY (st_opid) REFERENCES operator_t (op_id))";
            if (this.db.getM4Dbms() == 2 || this.db.getM4Dbms() == 3) {
                query = "ALTER TABLE step_t ADD CONSTRAINT stopid_fk FOREIGN KEY (st_opid) REFERENCES operator_t (op_id)";
            }
            this.db.executeM4SqlWrite(query);
            query = "ALTER TABLE parameter_t ADD (CONSTRAINT paropid_fk FOREIGN KEY (par_opid) REFERENCES operator_t (op_id))";
            if (this.db.getM4Dbms() == 2 || this.db.getM4Dbms() == 3) {
                query = "ALTER TABLE parameter_t ADD CONSTRAINT paropid_fk FOREIGN KEY (par_opid) REFERENCES operator_t (op_id)";
            }
            this.db.executeM4SqlWrite(query);
            this.db.commitM4Transactions();
        }
        catch (SQLException sql) {
            try {
                this.db.rollbackOnM4();
            }
            catch (DbConnectionClosed dbc) {
                throw new M4Exception("MmInstallerTools: error accessing DB (connection closed): " + dbc.getMessage());
            }
            catch (SQLException sqle) {
                throw new M4Exception("MmInstallerTools: SQL error accessing DB: " + sqle.getMessage());
            }
            throw new M4Exception("MmInstallerTools: SQL error updating operator information: " + sql.getMessage());
        }
        catch (DbConnectionClosed dbc) {
            throw new M4Exception("MmInstallerTools: error accessing DB (connection closed): " + dbc.getMessage());
        }
    }

    public static void ensureOperatorsAreInserted() {
        String homeDir = System.getProperty("MM_HOME");
        if (!homeDir.endsWith(File.separator)) {
            homeDir = homeDir + File.separator;
        }
        DB mdb = null;
        try {
            mdb = M4Interface.getInstance().getM4db();
            String opsFile = homeDir + "m4install" + File.separator + mdb.getM4InstallationDirectory(false) + File.separator + "Operators.sql";
            MmInstallerTools m4sc = new MmInstallerTools(mdb);
            m4sc.writeOperatorsIntoSchema(opsFile);
        }
        catch (M4Exception m) {
            JOptionPane.showMessageDialog(null, "Error trying to insert operators into M4 tables. Error message:\n" + m.getMessage(), "System cannot start", 0);
            System.exit(-1);
        }
    }

    public void createM4Tables(String fileNameAndPath) throws M4Exception {
        if (this.m4TablesExist()) {
            throw new M4Exception("MmInstallerTools: cannot create M4 tables since they seem to exist already!");
        }
        File f = new File(fileNameAndPath);
        if (!f.exists()) {
            throw new M4Exception("MmInstallerTools: cannot create M4 tables since the file with their creation commands could not be found!");
        }
        this.writeSqlCommandsFromFileIntoDb(f, false);
    }

    public void ensureM4Extension(String fileNameWithExtensions) throws M4Exception {
        if (this.checkM4Extension()) {
            return;
        }
        File f = new File(fileNameWithExtensions);
        if (!f.exists()) {
            throw new M4Exception("MmInstallerTools: cannot create ROLES table in M4 since the file with its creation commands could not be found!");
        }
        MmInstallerTools.printDebugMessage("Starting with M4 update (Roles)...");
        this.writeSqlCommandsFromFileIntoDb(f, false);
        MmInstallerTools.printDebugMessage("Successfully done M4 update (Roles).");
    }

    public boolean checkM4Extension() throws M4Exception {
        return this.db.tableExistsInM4("roles_t");
    }

    public void removeM4Sequence() throws M4Exception {
        String seqname = "ALL_SQ";
        String query = "DROP SEQUENCE " + seqname;
        try {
            this.db.executeM4SqlWrite(query);
        }
        catch (SQLException s) {
        }
        catch (DbConnectionClosed dbc) {
            throw new M4Exception("MmInstallerTools: error accessing DB (connection closed): " + dbc.getMessage());
        }
    }

    public void installM4Sequence() throws M4Exception {
        this.removeM4Sequence();
        String seqname = "ALL_SQ";
        try {
            String query = "CREATE SEQUENCE " + seqname + " INCREMENT ";
            if (this.usingOracle) {
                query = query + "BY ";
            }
            query = query + "1 START ";
            if (this.usingOracle) {
                query = query + "WITH ";
            }
            query = query + "100000000 MAXVALUE 199999999 MINVALUE 100000000 ";
            if (this.usingOracle) {
                query = query + "NOCYCLE ";
            }
            query = query + "CACHE 20";
            if (this.usingOracle) {
                query = query + " NOORDER";
            }
            this.db.executeM4SqlWrite(query);
        }
        catch (SQLException sql) {
            try {
                this.db.rollbackOnM4();
            }
            catch (DbConnectionClosed dbc) {
                throw new M4Exception("MmInstallerTools: error accessing DB (connection closed): " + dbc.getMessage());
            }
            catch (SQLException sqle) {
                throw new M4Exception("MmInstallerTools: SQL error accessing DB: " + sqle.getMessage());
            }
            throw new M4Exception("MmInstallerTools: SQL error installing M4 sequence: " + sql.getMessage());
        }
        catch (DbConnectionClosed dbc) {
            throw new M4Exception("MmInstallerTools: error accessing DB (connection closed): " + dbc.getMessage());
        }
    }

    private void writeSqlCommandsFromFileIntoDb(File commandFile, boolean useDrops) throws M4Exception {
        String line = null;
        try {
            LineNumberReader lnr = new LineNumberReader(new FileReader(commandFile));
            line = lnr.readLine();
            int lineCount = 0;
            while (line != null) {
                String nextLine;
                if ((line = line.trim()).startsWith("--")) {
                    line = lnr.readLine();
                    continue;
                }
                if (line.equals("")) {
                    line = lnr.readLine();
                    continue;
                }
                while (!line.endsWith(";") && (nextLine = lnr.readLine()) != null) {
                    line = line + " " + nextLine.trim();
                }
                line = line.substring(0, line.length() - 1);
                if (!useDrops && line.toUpperCase().startsWith("DROP ")) {
                    line = lnr.readLine();
                    continue;
                }
                if (line.toLowerCase().startsWith("exi")) {
                    MmInstallerTools.printDebugMessage("Skipping line '" + line + "'!");
                    line = lnr.readLine();
                    continue;
                }
                this.db.executeM4SqlWrite(line);
                if (++lineCount % 500 == 0) {
                    this.db.commitM4Transactions();
                    this.db.getFreshM4Connection();
                }
                line = lnr.readLine();
            }
            MmInstallerTools.printDebugMessage("Final commit after writing SQL commands from file '" + commandFile.getName() + "'");
            this.db.commitM4Transactions();
            this.db.getFreshM4Connection();
        }
        catch (IOException ioe) {
            try {
                this.db.rollbackOnM4();
            }
            catch (DbConnectionClosed dbc) {
                throw new M4Exception("MmInstallerTools: error accessing DB (connection closed): " + dbc.getMessage());
            }
            catch (SQLException sqle) {
                throw new M4Exception("MmInstallerTools: SQL error accessing DB: " + sqle.getMessage());
            }
            throw new M4Exception("MmInstallerTools: error accessing file: " + ioe.getMessage());
        }
        catch (SQLException sql) {
            try {
                this.db.rollbackOnM4();
            }
            catch (DbConnectionClosed dbc) {
                throw new M4Exception("MmInstallerTools: error accessing DB (connection closed): " + dbc.getMessage());
            }
            catch (SQLException sqle) {
                throw new M4Exception("MmInstallerTools: SQL error accessing DB: " + sqle.getMessage() + "\nPrevious SQL exception was: " + sql.getMessage());
            }
            throw new M4Exception("MmInstallerTools: SQL error executing command from file.\nLine: " + line + "\nMessage: " + sql.getMessage());
        }
        catch (DbConnectionClosed dbc) {
            throw new M4Exception("MmInstallerTools: error accessing DB (connection closed): " + dbc.getMessage());
        }
    }

    private boolean m4TablesExist() throws M4Exception {
        String[] tablenames = DB.ORDER_FOR_WRITING;
        for (int i = tablenames.length - 1; i >= 0; --i) {
            if (this.db.tableExistsInM4(tablenames[i])) continue;
            return false;
        }
        return true;
    }

    private boolean staticOperatorEntriesExist() throws M4Exception {
        for (int i = 0; i < this.operatorTables.length; ++i) {
            if (!this.m4TableIsEmpty(this.operatorTables[i])) continue;
            return false;
        }
        return true;
    }

    private boolean m4TableIsEmpty(String tableName) throws M4Exception {
        String query = "SELECT COUNT(*) FROM " + tableName;
        try {
            Long l = this.db.executeM4SingleValueSqlReadL(query);
            return l == 0L;
        }
        catch (DbConnectionClosed d) {
            throw new M4Exception("MmInstallerTools: Db connection closed when checking if table '" + tableName + "' is empty: " + d.getMessage());
        }
        catch (SQLException s) {
            throw new M4Exception("MmInstallerTools: SQL error when checking if table '" + tableName + "' is empty: " + s.getMessage());
        }
    }

    private void removeOperatorFromM4(String operatorName) throws M4Exception {
        String query = "SELECT op_id FROM operator_t WHERE op_name = '" + operatorName + "'";
        Long l = null;
        try {
            l = this.db.executeM4SingleValueSqlReadL(query);
            String[] operatorTableIdFields = new String[]{"constr_opid", "cond_opid", "assert_opid", "op_id", "opg_opid", "op_id"};
            if (l != null) {
                query = "DELETE FROM docu_t WHERE doc_objid = " + l;
                this.db.executeM4SqlWrite(query);
                for (int i = 0; i < this.operatorTables.length; ++i) {
                    query = "DELETE FROM " + this.operatorTables[i] + " WHERE " + operatorTableIdFields[i] + " = " + l;
                    this.db.executeM4SqlWrite(query);
                }
            }
        }
        catch (SQLException sqle) {
            throw new M4Exception("SQL error removing operator '" + operatorName + "': " + sqle.getMessage());
        }
        catch (DbConnectionClosed dbc) {
            throw new M4Exception("MmInstallerTools: Connection to M4-DB was closed: " + dbc.getMessage());
        }
    }
}

