/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.gui.util;

import java.util.Iterator;
import java.util.LinkedList;

public class RecentFiles {
    private LinkedList files = new LinkedList();
    private int maxsize;

    public RecentFiles(int max_size) {
        this.maxsize = max_size;
    }

    public int getMaxSize() {
        return this.maxsize;
    }

    public int getSize() {
        return this.files.size();
    }

    public String getFile(int index) {
        return (String)this.files.get(index);
    }

    public void setRecentFile(String file) {
        this.setRecentFile(file, 1);
    }

    public void setRecentFile(String file, int position) {
        int index;
        if (position > this.files.size() + 1) {
            position = this.files.size() + 1;
        }
        if ((index = position - 1) >= this.maxsize) {
            return;
        }
        if (this.files.contains(file)) {
            this.files.remove(file);
            this.files.add(index, file);
            return;
        }
        this.files.add(index, file);
        if (this.files.size() > this.maxsize) {
            this.files.removeLast();
        }
    }

    public void removeRecentFile(String file) {
        this.files.remove(file);
    }

    public String toString() {
        String back = new String("");
        Iterator iter = this.files.iterator();
        int i = 0;
        while (iter.hasNext()) {
            if (i > 0) {
                back = back + ";";
            }
            back = back + (String)iter.next();
            ++i;
        }
        return back;
    }
}

