/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.gui.util;

import edu.udo.cs.miningmart.m4.M4Interface;
import edu.udo.cs.miningmart.m4.utils.Print;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.musoft.limo.application.Resource;

public abstract class DbConfigEditorWindow
extends JDialog {
    private final HashMap values;
    private final ActionListener saveAction;
    private JPanel panel;
    private JTextField[] theGuiValues;
    private boolean restart = false;
    private boolean canceled = true;
    private boolean showRestartWarning;

    public DbConfigEditorWindow(JFrame parent, HashMap values, ActionListener saveAction) {
        super(parent, Resource.getString("DBCONFIG_TITLE"), true);
        this.values = values;
        this.saveAction = saveAction;
    }

    protected abstract String[][] getMapping();

    private String getValueFor(String variable) {
        return (String)this.values.get(variable);
    }

    private void setVariable(String variable, String value) {
        this.values.put(variable, value);
    }

    public void prepareWindow() {
        if (this.panel == null) {
            this.panel = this.createMainPanel();
            this.getContentPane().add(this.panel);
        } else {
            this.setValues();
        }
        this.pack();
        Dimension size = this.getSize();
        this.setLocation((Toolkit.getDefaultToolkit().getScreenSize().width - size.width) / 2, (Toolkit.getDefaultToolkit().getScreenSize().height - size.height) / 2);
        this.canceled = true;
    }

    void saveButtonAction() {
        this.canceled = false;
        if (this.saveAction != null) {
            for (int i = 0; i < this.getMapping().length; ++i) {
                String var = this.getMapping()[i][0];
                if (var == null) continue;
                String value = this.theGuiValues[i].getText().trim();
                this.values.put(var, value);
            }
            this.saveAction.actionPerformed(null);
        }
        this.dispose();
        if (this.showRestartWarning) {
            this.restart = true;
            M4Interface.print.doPrint(Print.MAX, Resource.getString("DBCONFIG_RESTART_MSG1") + "\n \t\t" + Resource.getString("DBCONFIG_RESTART_MSG2"));
            JOptionPane.showMessageDialog(null, Resource.getString("DBCONFIG_RESTART_MSG1") + "\n" + Resource.getString("DBCONFIG_RESTART_MSG2"), Resource.getString("DBCONFIG_RESTART_TITLE"), 1);
        }
        this.cancelButtonAction();
    }

    void cancelButtonAction() {
        this.dispose();
    }

    private void helpButtonAction() {
        String helpText = "Please see the MiningMart user guide, section 1.4, for\nhelp on the meaning of these fields. You can download the user guide at\nhttp://mmart.cs.uni-dortmund.de/downloads/downloads.html";
        JOptionPane.showMessageDialog(this, helpText, "DB Connection Info", 1);
    }

    private JPanel createMainPanel() {
        int mappingLength = this.getMapping().length;
        this.theGuiValues = new JTextField[mappingLength];
        JPanel theFields = new JPanel();
        JPanel theNames = new JPanel();
        JPanel theValues = new JPanel();
        theNames.setLayout(new GridLayout(mappingLength, 1));
        theValues.setLayout(new GridLayout(mappingLength, 1));
        for (int i = 0; i < mappingLength; ++i) {
            JTextField valueTa;
            String[] currentMapping = this.getMapping()[i];
            String name = currentMapping[1];
            if (currentMapping[0] != null) {
                JLabel nameTa = new JLabel(name);
                theNames.add(nameTa);
                String value = this.getValueFor(currentMapping[0]);
                if ((value == null || value.length() == 0) && (value = currentMapping[2]) == null) {
                    value = "";
                }
                valueTa = currentMapping[0].equals("m4Pass") || currentMapping[0].equals("busPass") ? new JPasswordField(value, 40) : new JTextField(value, 40);
                valueTa.setEditable(true);
                theValues.add(valueTa);
            } else {
                theNames.add(new JPanel());
                theValues.add(new JPanel());
                valueTa = new JTextField("", 40);
            }
            this.theGuiValues[i] = valueTa;
        }
        theFields.setLayout(new BorderLayout(5, 5));
        theFields.add((Component)theNames, "West");
        theFields.add((Component)theValues, "Center");
        JPanel theButtons = new JPanel();
        theButtons.setLayout(new BorderLayout(5, 5));
        JPanel center = new JPanel();
        center.setLayout(new BoxLayout(center, 0));
        JButton saveButton = new JButton(Resource.getString("SAVE"));
        JButton cancelButton = new JButton(Resource.getString("CANCEL"));
        JButton helpButton = new JButton(Resource.getString("DBCONFIG_INFO"));
        center.add(saveButton);
        center.add(cancelButton);
        center.add(helpButton);
        theButtons.add((Component)center, "East");
        saveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DbConfigEditorWindow.this.saveButtonAction();
            }
        });
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DbConfigEditorWindow.this.cancelButtonAction();
            }
        });
        helpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DbConfigEditorWindow.this.helpButtonAction();
            }
        });
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout(5, 5));
        panel.add((Component)theFields, "North");
        panel.add((Component)theButtons, "South");
        panel.setBorder(BorderFactory.createEmptyBorder(20, 10, 5, 10));
        return panel;
    }

    private void setValues() {
        for (int i = 0; i < this.getMapping().length; ++i) {
            String[] currentMapping = this.getMapping()[i];
            String varName = currentMapping[0];
            if (varName == null) continue;
            String value = this.getValueFor(varName);
            if ((value == null || value.length() == 0) && (value = currentMapping[2]) == null) {
                value = "";
            }
            this.theGuiValues[i].setText(value);
        }
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public void setRestartWarning(boolean showRestartWarning) {
        this.showRestartWarning = showRestartWarning;
    }

    public boolean shouldRestart() {
        return this.restart;
    }
}

