/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.gui.util;

import edu.udo.cs.miningmart.db.ConfigReader;
import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.gui.util.DbConfigEditorWindow;
import edu.udo.cs.miningmart.gui.util.DbConfigEditorWindowForMysql;
import edu.udo.cs.miningmart.m4.M4Interface;
import edu.udo.cs.miningmart.m4.core.M4InterfaceImpl;
import edu.udo.cs.miningmart.m4.utils.Print;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import javax.swing.JFrame;

public class DbConfigEditor {
    public static final String VAR_DB_NAME = "dbName";
    public static final String VAR_BUS_DB_NAME = "busDbName";
    public static final String VAR_M4_DB_NAME = "m4DbName";
    public static final String VAR_DB_HOST = "dbHost";
    public static final String VAR_DB_PORT = "dbPort";
    public static final String VAR_DB_DRIV = "jdbcDriver";
    public static final String VAR_M4_USER = "m4User";
    public static final String VAR_M4_PASS = "m4Pass";
    public static final String VAR_BUS_USER = "busUser";
    public static final String VAR_BUS_PASS = "busPass";
    public static final String DBMS_TYPE = "DBMS_TYPE";
    public static final String DBMS_POSTGRES = "POSTGRES";
    public static final String DBMS_MYSQL = "MYSQL";
    public static final String DBMS_ORACLE = "ORACLE";
    String[] fileVars = new String[]{"busDbName", "m4User", "m4Pass", "jdbcDriver", "dbHost", null, "m4DbName", "busUser", "busPass", "jdbcDriver", "dbHost"};
    private final HashMap values = new HashMap();
    private final File dbConfig;
    private final DbConfigEditorWindow frame;
    private boolean showRestartWarning;

    public DbConfigEditor(JFrame parent) {
        String dbcFileS = System.getProperty("DB_CONFIG_PATH");
        File f = null;
        if (dbcFileS != null && dbcFileS.length() > 0) {
            f = new File(dbcFileS);
            if (!f.exists()) {
                try {
                    f.createNewFile();
                }
                catch (IOException e) {
                    f = null;
                }
            } else if (!f.isFile()) {
                f = null;
            }
        }
        this.dbConfig = f;
        this.frame = new DbConfigEditorWindowForMysql(parent, this.values, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DbConfigEditor.this.save();
            }
        });
    }

    private String getValueFor(String variable) {
        return (String)this.values.get(variable);
    }

    private void setVariable(String variable, String value) {
        this.values.put(variable, value);
    }

    private void readValues() {
        try {
            this.readValuesFromFile();
            this.mapFileVariableToGui();
        }
        catch (M4Exception e) {
            M4Interface.print.doPrint(Print.ERROR, e.getMessage(), e);
        }
    }

    private void readValuesFromFile() throws M4Exception {
        boolean exception = false;
        ConfigReader cfr = null;
        try {
            cfr = new ConfigReader(this.dbConfig.getAbsolutePath());
        }
        catch (M4Exception e) {
            exception = true;
        }
        this.setVariable(this.fileVars[0], exception ? "DBName" : cfr.getM4DbName());
        this.setVariable(this.fileVars[1], exception ? "M4User" : cfr.getM4User());
        this.setVariable(this.fileVars[2], exception ? "Password" : cfr.getM4Pw());
        String url = exception ? "@host.domain.de:1521:" : cfr.getM4Url();
        int atIndex = url.indexOf("@");
        int offset = 1;
        if (atIndex == -1) {
            atIndex = url.indexOf("//");
            offset = 2;
        }
        String driver = url.substring(0, atIndex);
        String host = url.substring(atIndex + offset, url.length());
        this.setVariable(this.fileVars[3], driver);
        this.setVariable(this.fileVars[4], host);
        this.setVariable(this.fileVars[6], exception ? "DBName" : cfr.getBusDbName());
        this.setVariable(this.fileVars[7], exception ? "BusinessUser" : cfr.getBusUser());
        this.setVariable(this.fileVars[8], exception ? "Password" : cfr.getBusPw());
        url = exception ? "@host.domain.de:1521:" : cfr.getBusUrl();
        atIndex = url.indexOf("@");
        offset = 1;
        if (atIndex == -1) {
            atIndex = url.indexOf("//");
            offset = 2;
        }
        driver = url.substring(0, atIndex);
        host = url.substring(atIndex + offset, url.length());
        this.setVariable(this.fileVars[9], driver);
        this.setVariable(this.fileVars[10], host);
    }

    private void mapFileVariableToGui() {
        String jdbcDriver;
        String hostAndPort = this.getValueFor(VAR_DB_HOST);
        if (hostAndPort != null && hostAndPort.length() > 0) {
            String port;
            String host;
            int index = hostAndPort.indexOf(":");
            if (index == -1) {
                host = hostAndPort;
                port = "";
            } else {
                host = hostAndPort.substring(0, index).trim();
                port = hostAndPort.substring(index + 1).trim();
            }
            if (host.startsWith("@")) {
                host = host.substring(1);
            }
            if (port.endsWith(":")) {
                port = port.substring(0, port.length() - 1);
            }
            this.setVariable(VAR_DB_HOST, host);
            this.setVariable(VAR_DB_PORT, port);
        }
        if ((jdbcDriver = this.getValueFor(VAR_DB_DRIV)) != null) {
            this.setVariable(VAR_DB_DRIV, jdbcDriver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save() {
        this.dbConfig.delete();
        OutputStreamWriter out = null;
        try {
            this.dbConfig.createNewFile();
            out = new FileWriter(this.dbConfig);
            String[] lines = new String[this.fileVars.length];
            for (int i = 0; i < lines.length; ++i) {
                String line = null;
                if (this.fileVars[i] != null) {
                    line = this.getValueFor(this.fileVars[i]);
                }
                lines[i] = line == null ? "" : line;
            }
            String host = lines[4].trim();
            String port = this.getValueFor(VAR_DB_PORT);
            if (!host.startsWith("@")) {
                host = "@" + host;
            }
            if (port != null) {
                host = (port = port.trim()).startsWith(":") ? host + port : host + ":" + port;
            }
            if (!host.endsWith(":")) {
                host = host + ":";
            }
            lines[4] = host;
            lines[10] = host;
            String jdbcDriver = lines[3].trim();
            if (!jdbcDriver.endsWith(":")) {
                jdbcDriver = jdbcDriver + ":";
            }
            lines[3] = jdbcDriver;
            lines[9] = jdbcDriver;
            for (int i = 0; i < lines.length; ++i) {
                out.write(lines[i] + "\n");
            }
        }
        catch (IOException e) {
            M4Interface.print.doPrint(Print.ERROR, e.getMessage(), e);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {}
        }
        M4InterfaceImpl m4i = (M4InterfaceImpl)M4InterfaceImpl.getInstance();
        if (m4i != null) {
            m4i.getNewDbConnection();
        }
    }

    public void init() {
        if (this.dbConfig == null) {
            System.err.println("Could not find db.config file. Please make sure the environment variable 'DB_CONFIG_PATH' is set and that the specified file is accessible.");
            return;
        }
        this.readValues();
        this.frame.setRestartWarning(this.showRestartWarning);
        this.frame.prepareWindow();
        this.frame.setVisible(true);
    }

    public void setRestartWarning(boolean showRestartWarning) {
        this.showRestartWarning = showRestartWarning;
    }

    public boolean frameActive() {
        return this.frame.isActive();
    }

    public boolean shouldRestart() {
        return this.frame.shouldRestart();
    }

    public boolean isCanceled() {
        return this.frame.isCanceled();
    }
}

