/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.gui.stepsettings;

import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.gui.application.MiningMartApplication;
import edu.udo.cs.miningmart.gui.application.ValueSelectionDialog;
import edu.udo.cs.miningmart.gui.concepteditor.EstimatedStatisticsDialog;
import edu.udo.cs.miningmart.gui.model.MiningMartStep;
import edu.udo.cs.miningmart.gui.model.StepTransition;
import edu.udo.cs.miningmart.gui.stepsettings.ConceptViewDialog;
import edu.udo.cs.miningmart.gui.stepsettings.GroupsDialog;
import edu.udo.cs.miningmart.gui.stepsettings.LoopListener;
import edu.udo.cs.miningmart.gui.stepsettings.OutputEditor;
import edu.udo.cs.miningmart.gui.stepsettings.ParameterEditor;
import edu.udo.cs.miningmart.gui.stepsettings.SingleSelectDialog;
import edu.udo.cs.miningmart.gui.stepsettings.StepLoopPanel;
import edu.udo.cs.miningmart.gui.stepsettings.StepParameterModel;
import edu.udo.cs.miningmart.gui.stepsettings.StepParameterTable;
import edu.udo.cs.miningmart.m4.BaseAttribute;
import edu.udo.cs.miningmart.m4.Concept;
import edu.udo.cs.miningmart.m4.Constraint;
import edu.udo.cs.miningmart.m4.M4Interface;
import edu.udo.cs.miningmart.m4.OpParam;
import edu.udo.cs.miningmart.m4.Operator;
import edu.udo.cs.miningmart.m4.Step;
import edu.udo.cs.miningmart.m4.utils.Print;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.musoft.limo.application.Resource;
import org.musoft.limo.model.Model;
import org.musoft.limo.model.ModelConnectionElement;

public class StepSettingsPanel
extends JPanel
implements ActionListener {
    public static final int NOT_TESTED = 0;
    public static final int VALID = 1;
    public static final int NOT_VALID = 2;
    private static final Color COLOR_NOT_TESTED = Resource.getColor("STEPSETTINGS_COLOR_NOT_TESTED");
    private static final Color COLOR_VALID = Resource.getColor("STEPSETTINGS_COLOR_VALID");
    private static final Color COLOR_NOT_VALID = Resource.getColor("STEPSETTINGS_COLOR_NOT_VALID");
    private MiningMartApplication app;
    private MiningMartStep mstep;
    private Step step;
    private Operator operator;
    private JLabel stepname;
    private JButton savebutton;
    private JButton closebutton;
    private JButton cancelbutton;
    private JButton validbutton;
    private JButton showgroupsbutton;
    private JButton estimationsbutton;
    private JButton showConceptsButton;
    private JButton wizardButton;
    private StepLoopPanel looppanel;
    private StepParameterTable paramtable;
    private LoopListener looplistener;
    private int validity;
    private boolean inputchanged;
    private boolean outputchanged;
    private boolean loopcountlower;
    private boolean loopcounthigher;
    private int minloopnr_changes_input;
    private int minloopnr_changes_output;
    private OpParam valueOpParam;
    private OpParam attribOpParam;

    public StepSettingsPanel(MiningMartApplication app, MiningMartStep step) {
        this.app = app;
        this.mstep = step;
        this.step = step.getStep();
        this.operator = this.step.getTheOperator();
        this.validity = 0;
        this.inputchanged = false;
        this.outputchanged = false;
        this.loopcountlower = false;
        this.loopcounthigher = false;
        this.minloopnr_changes_input = Integer.MAX_VALUE;
        this.minloopnr_changes_output = Integer.MAX_VALUE;
        this.initComponents();
    }

    private void initComponents() {
        JPanel toppanel = new JPanel();
        toppanel.setLayout(new BorderLayout());
        JScrollPane scrollpanel = new JScrollPane(toppanel);
        this.setLayout(new BorderLayout());
        this.add((Component)scrollpanel, "Center");
        JPanel northpanel = new JPanel();
        northpanel.setLayout(new BorderLayout());
        toppanel.add((Component)northpanel, "North");
        JPanel oppanel = new JPanel();
        oppanel.setLayout(new GridLayout(2, 1, 5, 5));
        oppanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        northpanel.add((Component)oppanel, "North");
        JLabel oplabel1 = new JLabel();
        oplabel1.setText(this.step.getTheOperator().getName());
        Font opfont = new Font("SansSerif", 0, 15);
        oplabel1.setFont(opfont);
        oplabel1.setHorizontalAlignment(0);
        oppanel.add(oplabel1);
        this.stepname = new JLabel();
        this.stepname.setText(this.step.getName());
        Font stepfont = new Font("SansSerif", 0, 13);
        this.stepname.setFont(stepfont);
        this.stepname.setHorizontalAlignment(0);
        this.stepname.setForeground(Color.BLUE);
        oppanel.add(this.stepname);
        try {
            if (this.operator.isLoopable() && !this.step.usesLoopsForCoordination()) {
                this.looppanel = new StepLoopPanel(this.app, this.step);
                northpanel.add((Component)this.looppanel, "Center");
            }
        }
        catch (M4Exception error) {
            M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
        }
        JPanel southpanel = new JPanel();
        southpanel.setLayout(new BorderLayout());
        toppanel.add((Component)southpanel, "South");
        JPanel buttonpanel = new JPanel();
        buttonpanel.setLayout(new GridLayout(2, 2));
        buttonpanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        southpanel.add((Component)buttonpanel, "East");
        this.showConceptsButton = new JButton(Resource.getString("STEPSETTINGS_SHOW_CONCEPT"));
        this.showConceptsButton.addActionListener(this);
        buttonpanel.add(this.showConceptsButton);
        JPanel buttonpanel1 = new JPanel();
        buttonpanel1.setLayout(new GridLayout(1, 3));
        buttonpanel.add(buttonpanel1);
        this.estimationsbutton = new JButton(Resource.getString("STEPSETTINGS_ESTIMATIONS"));
        this.estimationsbutton.addActionListener(this);
        buttonpanel.add(this.estimationsbutton);
        JPanel buttonpanel2 = new JPanel();
        buttonpanel2.setLayout(new GridLayout(1, 3));
        buttonpanel.add(buttonpanel2);
        this.savebutton = new JButton(Resource.getString("STEPSETTINGS_SAVE"));
        this.savebutton.setEnabled(false);
        buttonpanel2.add(this.savebutton);
        this.cancelbutton = new JButton(Resource.getString("STEPSETTINGS_CANCEL"));
        this.cancelbutton.setEnabled(false);
        buttonpanel2.add(this.cancelbutton);
        this.closebutton = new JButton(Resource.getString("STEPSETTINGS_CLOSE"));
        this.closebutton.addActionListener(this);
        buttonpanel2.add(this.closebutton);
        if (this.hasCoordinates()) {
            this.showgroupsbutton = new JButton(Resource.getString("STEPSETTINGS_SHOW_GROUPS"));
            this.showgroupsbutton.addActionListener(this);
            buttonpanel1.add(this.showgroupsbutton);
        }
        this.validbutton = new JButton(Resource.getString("STEPSETTINGS_VALID"));
        buttonpanel1.add(this.validbutton);
        this.setValidity(0);
        if (this.app.getViewMode() == 0) {
            this.savebutton.addActionListener(this);
            this.cancelbutton.addActionListener(this);
            this.validbutton.addActionListener(this);
        } else {
            this.savebutton.setEnabled(false);
            this.cancelbutton.setEnabled(false);
            this.validbutton.setEnabled(false);
        }
        this.paramtable = new StepParameterTable(this.app, this.step, this.app.getViewMode() == 0, new ParameterChangeListener());
        this.paramtable.createEditorAndRenderer();
        JScrollPane scrollpane = new JScrollPane(this.paramtable);
        this.wizardButton = this.getWizardButton();
        if (this.wizardButton != null) {
            JPanel paramPanel = new JPanel();
            paramPanel.setLayout(new BorderLayout());
            paramPanel.add((Component)scrollpane, "Center");
            paramPanel.add((Component)this.wizardButton, "South");
            this.wizardButton.addActionListener(this);
            toppanel.add((Component)paramPanel, "Center");
        } else {
            toppanel.add((Component)scrollpane, "Center");
        }
        try {
            if (this.operator.isLoopable() && !this.step.usesLoopsForCoordination()) {
                this.looplistener = new LoopListener(this, this.paramtable);
                this.looppanel.getIteratorList().addIteratorListener(this.looplistener);
                this.looppanel.addNrOfLoopsListener(this.looplistener);
            }
        }
        catch (M4Exception error) {
            M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
        }
    }

    private JButton getWizardButton() {
        try {
            if (this.step.getTheOperator().isLoopable()) {
                Collection opParams = this.step.getTheOperator().getAllInputOperatorParameters();
                if (opParams == null) {
                    return null;
                }
                for (OpParam oneOpPar : opParams) {
                    Collection constraints = oneOpPar.getApplicableConstraints();
                    if (constraints == null) {
                        return null;
                    }
                    for (Constraint constr : constraints) {
                        if (!constr.getType().equals("USE_VALS")) continue;
                        String nameOfValParam = constr.getObj1();
                        String nameOfAttribParam = constr.getObj2();
                        if (nameOfValParam == null || nameOfAttribParam == null) {
                            return null;
                        }
                        this.valueOpParam = this.step.getTheOperator().getOpParam(nameOfValParam);
                        this.attribOpParam = this.step.getTheOperator().getOpParam(nameOfAttribParam);
                        if (this.valueOpParam == null || this.attribOpParam == null) {
                            return null;
                        }
                        if (!this.valueOpParam.isLoopable()) continue;
                        return new JButton(Resource.getString("STEPSETTINGS_VALUE_WIZARD"));
                    }
                }
            }
        }
        catch (M4Exception m4e) {
            M4Interface.print.doPrint(Print.ERROR, m4e.getMessage(), m4e);
        }
        return null;
    }

    private void startWizard() {
        if (this.wizardButton == null) {
            return;
        }
        if (this.wizardButton.getText().equalsIgnoreCase(Resource.getString("STEPSETTINGS_VALUE_WIZARD"))) {
            Collection editors = this.paramtable.getEditor();
            if (editors == null) {
                return;
            }
            for (ParameterEditor paramEd : editors) {
                BaseAttribute myBA2 = null;
                if (!paramEd.opParam.equals(this.attribOpParam)) continue;
                Collection paramsSet = paramEd.getAllParameterCollections();
                if (paramsSet == null) {
                    return;
                }
                for (Collection paramsForOneLoop : paramsSet) {
                    if (paramsForOneLoop == null) {
                        return;
                    }
                    for (BaseAttribute myBA2 : paramsForOneLoop) {
                    }
                }
                if (myBA2 == null) continue;
                ValueSelectionDialog vsd = new ValueSelectionDialog(myBA2, this.step);
                String[] vals = vsd.getSelectedValues();
                if (vals == null || vals.length == 0) {
                    return;
                }
                this.paramtable.setNrOfLoops(vals.length);
                this.looppanel.setNumberOfLoops(vals.length);
                OutputEditor oe = this.findOutputAttributeEditor();
                if (oe == null) {
                    return;
                }
                String suffix = this.findOutputAttributeSuffix();
                if (suffix == null) {
                    suffix = "Flagge";
                }
                for (int i = 0; i < vals.length; ++i) {
                    this.paramtable.setValueOfValueParameter(vals[i], this.valueOpParam.getName(), i + 1);
                    this.paramtable.setValueOfValueParameter(myBA2.getName() + "_" + suffix + "_" + vals[i], oe.opParam.getName(), i + 1);
                }
                this.paramtable.repaint();
                this.repaint();
                return;
            }
        }
    }

    private OutputEditor findOutputAttributeEditor() {
        Collection editors = this.paramtable.getEditor();
        if (editors == null) {
            return null;
        }
        for (ParameterEditor paramEd : editors) {
            if (!(paramEd instanceof OutputEditor)) continue;
            OutputEditor oe = (OutputEditor)paramEd;
            return oe;
        }
        return null;
    }

    private String findOutputAttributeSuffix() {
        try {
            Collection constrs = this.attribOpParam.getApplicableConstraints();
            if (constrs == null) {
                return null;
            }
            for (Constraint constr : constrs) {
                if (!constr.getType().equals("CR_SUFFIX")) continue;
                return constr.getObj2();
            }
        }
        catch (M4Exception m4e) {
            M4Interface.print.doPrint(Print.ERROR, m4e.getMessage(), m4e);
        }
        return null;
    }

    public void setStepName(String name) {
        this.stepname.setText(name);
    }

    public MiningMartStep getMiningMartStep() {
        return this.mstep;
    }

    private boolean hasCoordinates() {
        try {
            Iterator iter = this.step.getTheOperator().getOpParamsIterator();
            while (iter.hasNext()) {
                OpParam opParam = (OpParam)iter.next();
                if (!opParam.isCoordinated()) continue;
                return true;
            }
        }
        catch (M4Exception error) {
            M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
        }
        return false;
    }

    public int getValidity() {
        return this.validity;
    }

    public void setValidity(int v) {
        this.validity = v;
        switch (this.validity) {
            case 0: {
                this.validbutton.setBackground(COLOR_NOT_TESTED);
                break;
            }
            case 1: {
                this.validbutton.setBackground(COLOR_VALID);
                break;
            }
            case 2: {
                this.validbutton.setBackground(COLOR_NOT_VALID);
                break;
            }
            default: {
                this.validbutton.setBackground(Color.WHITE);
            }
        }
    }

    public String toString() {
        return Resource.getString("STEPSETTINGS");
    }

    public void actionPerformed(ActionEvent e) {
        String titleForWindow;
        Concept theConcept;
        String command = e.getActionCommand();
        if (this.wizardButton != null && command.equals(this.wizardButton.getText())) {
            this.startWizard();
        }
        if (command.equals(Resource.getString("STEPSETTINGS_SAVE"))) {
            this.saveParameter();
        } else if (command.equals(Resource.getString("STEPSETTINGS_CANCEL"))) {
            this.cancelEditing();
        } else if (command.equals(Resource.getString("STEPSETTINGS_CLOSE"))) {
            this.app.removeStepSettingsPanel();
        } else if (command.equals(Resource.getString("STEPSETTINGS_SHOW_GROUPS"))) {
            new GroupsDialog(this.app, this.step, this.paramtable.getEditor());
        } else if (command.equals(Resource.getString("STEPSETTINGS_VALID"))) {
            this.testValidity(false);
        } else if (command.equals(Resource.getString("STEPSETTINGS_ESTIMATIONS"))) {
            String titleForWindow2 = Resource.getString("STEPSETTINGS_ESTIMATIONS_SELECT_TITLE");
            Concept inputConcept = this.getConcept(titleForWindow2, true);
            if (inputConcept != null) {
                new EstimatedStatisticsDialog(this.app, inputConcept, this.step);
            }
        } else if (command.equals(Resource.getString("STEPSETTINGS_SHOW_CONCEPT")) && (theConcept = this.getConcept(titleForWindow = Resource.getString("STEPSETTINGS_SHOW_CONCEPT_SELECT_TITLE"), false)) != null) {
            new ConceptViewDialog(this.app, theConcept, this.step);
        }
    }

    private Concept getConcept(String titleMessageForSelectWindow, boolean onlyInputs) {
        try {
            Iterator inputOpParamsIt = this.step.getTheOperator().getAllInputOperatorParameters().iterator();
            Vector<String> conceptNames = new Vector<String>();
            while (inputOpParamsIt.hasNext()) {
                OpParam opPar = (OpParam)inputOpParamsIt.next();
                if (!opPar.isConceptParameter()) continue;
                conceptNames.addAll(this.paramtable.getConceptEditorValues(opPar.getName()));
            }
            if (!onlyInputs) {
                for (OpParam opPar : this.step.getTheOperator().getAllOutputOperatorParameters()) {
                    Concept outputConcept;
                    if (!opPar.isConceptParameter() || (outputConcept = this.step.getOutputConcept()) == null) continue;
                    conceptNames.add(outputConcept.getName());
                }
            }
            if (conceptNames.isEmpty()) {
                return null;
            }
            String theChosenConceptName = null;
            if (conceptNames.size() == 1) {
                theChosenConceptName = (String)conceptNames.iterator().next();
            } else {
                String[] listToSelectFrom = new String[conceptNames.size()];
                Iterator it = conceptNames.iterator();
                int i = 0;
                while (it.hasNext()) {
                    listToSelectFrom[i] = (String)it.next();
                    ++i;
                }
                SingleSelectDialog dialog = new SingleSelectDialog(this.app, titleMessageForSelectWindow, "", listToSelectFrom, true);
                if (dialog.getExitAction() == 1) {
                    theChosenConceptName = dialog.getSelectedDataItem();
                }
            }
            return this.step.getTheCase().getConcept(theChosenConceptName);
        }
        catch (M4Exception m4e) {
            JOptionPane.showMessageDialog(this.app, "Error trying to find candidate input concept(s): " + m4e.getMessage(), "Estimation problem", 0);
            return null;
        }
    }

    public void enableCancelSave(boolean bool) {
        this.cancelbutton.setEnabled(bool);
        this.savebutton.setEnabled(bool);
    }

    public void cancelEditing() {
        if (this.looppanel != null) {
            this.looppanel.setNumberOfLoops(((StepParameterModel)this.paramtable.getModel()).getOldNrOfLoops());
        }
        try {
            this.paramtable.cancelEditing();
        }
        catch (M4Exception error) {
            M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
            JOptionPane.showMessageDialog(this.app, error.getMessage(), Resource.getString("STEPSETTINGS_SETTING_INPUT"), 0);
            return;
        }
        this.app.saveModel();
        this.inputchanged = false;
        this.outputchanged = false;
        this.loopcountlower = false;
        this.loopcounthigher = false;
        this.minloopnr_changes_input = Integer.MAX_VALUE;
        this.minloopnr_changes_output = Integer.MAX_VALUE;
        this.savebutton.setEnabled(false);
        this.cancelbutton.setEnabled(false);
    }

    public boolean testValidity(boolean save) {
        boolean isValid = false;
        try {
            this.paramtable.setParameterCollectionsInStep(save);
        }
        catch (M4Exception error) {
            M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
            JOptionPane.showMessageDialog(this.app, error.getMessage(), Resource.getString("STEPSETTINGS_SETTING_INPUT"), 0);
            this.setValidity(2);
            return false;
        }
        int loop = this.step.getLoopCount();
        if (loop == 0) {
            loop = 1;
        }
        if (((StepParameterModel)this.paramtable.getModel()).getNrOfLoops() < loop) {
            this.loopcountlower = true;
        }
        if (((StepParameterModel)this.paramtable.getModel()).getNrOfLoops() > loop) {
            this.loopcounthigher = true;
        }
        try {
            isValid = this.step.checkInputParameterEntries();
        }
        catch (M4Exception error) {
            M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
            JOptionPane.showMessageDialog(this.app, error.getMessage(), Resource.getString("STEPSETTINGS_CHECK_INPUT"), 0);
            isValid = false;
        }
        if (isValid) {
            this.setValidity(1);
        } else {
            this.setValidity(2);
        }
        return isValid;
    }

    public void saveParameter() {
        if (this.testValidity(false)) {
            if (((StepParameterModel)this.paramtable.getModel()).getNrOfLoops() < this.minloopnr_changes_input) {
                this.inputchanged = false;
            }
            if (((StepParameterModel)this.paramtable.getModel()).getNrOfLoops() < this.minloopnr_changes_output) {
                this.outputchanged = false;
            }
            try {
                this.paramtable.makeOutput(this.inputchanged, this.outputchanged, this.loopcountlower, this.loopcounthigher);
                this.step.handleOldInput();
                this.step.propagateOutputChanges();
            }
            catch (M4Exception error) {
                M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
                JOptionPane.showMessageDialog(this.app, error.getMessage(), Resource.getString("STEPSETTINGS_MAKE_OUTPUT"), 0);
            }
            Model model = (Model)this.mstep.getParent();
            for (int i = 0; i < model.getConnectionCount(); ++i) {
                ModelConnectionElement conn = model.getConnection(i);
                if (!conn.getStart().getName().equals(this.step.getName())) continue;
                ((StepTransition)conn).refreshName();
            }
            this.app.saveModel();
            this.inputchanged = false;
            this.outputchanged = false;
            this.loopcountlower = false;
            this.loopcounthigher = false;
            this.minloopnr_changes_input = Integer.MAX_VALUE;
            this.minloopnr_changes_output = Integer.MAX_VALUE;
            this.savebutton.setEnabled(false);
        } else {
            boolean save_input;
            boolean bl = save_input = JOptionPane.showConfirmDialog(this.app, Resource.getString("STEPSETTINGS_SAVE_MSG1") + "\n" + Resource.getString("STEPSETTINGS_SAVE_MSG2") + "\n" + Resource.getString("STEPSETTINGS_SAVE_MSG3"), Resource.getString("STEPSETTINGS_SAVE_TITLE"), 0, 2) == 0;
            if (save_input) {
                this.app.saveModel();
            }
        }
    }

    private class ParameterChangeListener
    implements ChangeListener {
        public void stateChanged(ChangeEvent event) {
            StepSettingsPanel.this.setValidity(0);
            StepSettingsPanel.this.savebutton.setEnabled(true);
            StepSettingsPanel.this.cancelbutton.setEnabled(true);
            ParameterEditor parameditor = (ParameterEditor)event.getSource();
            if (parameditor.getTheOpParam().isInput()) {
                try {
                    if (StepSettingsPanel.this.step.inputChangeCanAffectOutput(parameditor.getTheOpParam())) {
                        StepSettingsPanel.this.inputchanged = true;
                    }
                }
                catch (M4Exception error) {
                    M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
                    JOptionPane.showMessageDialog(StepSettingsPanel.this.app, error.getMessage(), Resource.getString("STEPSETTINGS"), 0);
                }
                StepSettingsPanel.this.minloopnr_changes_input = Math.min(StepSettingsPanel.this.minloopnr_changes_input, parameditor.getLoopNumber());
            } else {
                StepSettingsPanel.this.outputchanged = true;
                StepSettingsPanel.this.minloopnr_changes_output = Math.min(StepSettingsPanel.this.minloopnr_changes_output, parameditor.getLoopNumber());
            }
        }
    }
}

