/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.gui.stepsettings;

import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.gui.application.MiningMartApplication;
import edu.udo.cs.miningmart.gui.stepsettings.ListBaseAttributeEditor;
import edu.udo.cs.miningmart.gui.stepsettings.ListConceptEditor;
import edu.udo.cs.miningmart.gui.stepsettings.ListFeatureEditor;
import edu.udo.cs.miningmart.gui.stepsettings.ListMCFeatureEditor;
import edu.udo.cs.miningmart.gui.stepsettings.ListOneOfValueEditor;
import edu.udo.cs.miningmart.gui.stepsettings.ListOutputEditor;
import edu.udo.cs.miningmart.gui.stepsettings.ListRelationEditor;
import edu.udo.cs.miningmart.gui.stepsettings.ListSelectEditor;
import edu.udo.cs.miningmart.gui.stepsettings.ListValueEditor;
import edu.udo.cs.miningmart.gui.stepsettings.OutputEditor;
import edu.udo.cs.miningmart.gui.stepsettings.ParameterEditor;
import edu.udo.cs.miningmart.gui.stepsettings.SelectEditor;
import edu.udo.cs.miningmart.gui.stepsettings.SingleBaseAttributeEditor;
import edu.udo.cs.miningmart.gui.stepsettings.SingleConceptEditor;
import edu.udo.cs.miningmart.gui.stepsettings.SingleFeatureEditor;
import edu.udo.cs.miningmart.gui.stepsettings.SingleMCFeatureEditor;
import edu.udo.cs.miningmart.gui.stepsettings.SingleOneOfValueEditor;
import edu.udo.cs.miningmart.gui.stepsettings.SingleRelationEditor;
import edu.udo.cs.miningmart.gui.stepsettings.SingleValueEditor;
import edu.udo.cs.miningmart.gui.stepsettings.StepParameterModel;
import edu.udo.cs.miningmart.gui.stepsettings.StepParameterRenderer;
import edu.udo.cs.miningmart.m4.Constraint;
import edu.udo.cs.miningmart.m4.M4Interface;
import edu.udo.cs.miningmart.m4.OpParam;
import edu.udo.cs.miningmart.m4.Step;
import edu.udo.cs.miningmart.m4.Value;
import edu.udo.cs.miningmart.m4.utils.Print;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.musoft.limo.application.Resource;

public class StepParameterTable
extends JTable {
    private MiningMartApplication app;
    private Step step;
    private StepParameterModel tablemodel;
    private StepParameterRenderer tablerenderer;
    private boolean editable;
    private Vector editors;
    private ChangeListener changelistener;

    public StepParameterTable(MiningMartApplication app, Step step, boolean editable, ChangeListener listener) {
        this.app = app;
        this.step = step;
        this.editable = editable;
        this.changelistener = listener;
        this.setSelectionMode(0);
        this.setRowHeight(this.getRowHeight() + Resource.getInt("STEPSETTINGS_TABLE_ROW_EXTRA_HEIGHT"));
        this.getTableHeader().setReorderingAllowed(false);
        this.tablemodel = new StepParameterModel(step, editable);
        this.setModel(this.tablemodel);
        this.tablerenderer = new StepParameterRenderer(step);
    }

    public void createEditorAndRenderer() {
        this.editors = new Vector();
        for (int row = 0; row < this.tablemodel.getRowCount(); ++row) {
            try {
                ParameterEditor parameditor;
                if (this.tablemodel.isInput(row)) {
                    if (this.tablemodel.getOpParam(row).isValueParameter()) {
                        if (this.tablemodel.getOpParam(row).isArray()) {
                            if (this.tablemodel.getOpParam(row).isOneOf()) {
                                parameditor = new ListOneOfValueEditor(this.app, this.step, this.tablemodel.getOpParam(row));
                            } else {
                                SelectEditor lbae = this.getEditorOfAttribsForValues(this.tablemodel.getOpParam(row));
                                parameditor = new ListValueEditor(this.app, this.step, this.tablemodel.getOpParam(row), lbae);
                            }
                            if (this.editable) {
                                parameditor.addChangeListener(this.changelistener);
                            }
                            this.editors.add(parameditor);
                            continue;
                        }
                        if (this.tablemodel.getOpParam(row).isOneOf()) {
                            Collection list = this.tablemodel.getOpParam(row).getOneOfList();
                            parameditor = new SingleOneOfValueEditor(this.app, this.step, this.tablemodel.getOpParam(row), list);
                        } else {
                            parameditor = new SingleValueEditor(this.app, this.step, this.tablemodel.getOpParam(row));
                        }
                        if (this.editable) {
                            parameditor.addChangeListener(this.changelistener);
                        }
                        this.editors.add(parameditor);
                        continue;
                    }
                    if (this.tablemodel.getOpParam(row).isConceptParameter()) {
                        parameditor = this.tablemodel.getOpParam(row).isArray() ? new ListConceptEditor(this.app, this.step, this.tablemodel.getOpParam(row)) : new SingleConceptEditor(this.app, this.step, this.tablemodel.getOpParam(row));
                        if (this.editable) {
                            parameditor.addChangeListener(this.changelistener);
                        }
                        this.editors.add(parameditor);
                        continue;
                    }
                    if (this.tablemodel.getOpParam(row).isRelationParameter()) {
                        parameditor = this.tablemodel.getOpParam(row).isArray() ? new ListRelationEditor(this.app, this.step, this.tablemodel.getOpParam(row)) : new SingleRelationEditor(this.app, this.step, this.tablemodel.getOpParam(row));
                        if (this.editable) {
                            parameditor.addChangeListener(this.changelistener);
                        }
                        this.editors.add(parameditor);
                        continue;
                    }
                    if (this.tablemodel.getOpParam(row).isBaseAttribParameter()) {
                        parameditor = this.tablemodel.getOpParam(row).isArray() ? new ListBaseAttributeEditor(this.app, this, this.tablemodel.getOpParam(row)) : new SingleBaseAttributeEditor(this.app, this, this.tablemodel.getOpParam(row));
                        if (this.editable) {
                            parameditor.addChangeListener(this.changelistener);
                        }
                        this.editors.add(parameditor);
                        continue;
                    }
                    if (this.tablemodel.getOpParam(row).isMcfParameter()) {
                        parameditor = this.tablemodel.getOpParam(row).isArray() ? new ListMCFeatureEditor(this.app, this, this.tablemodel.getOpParam(row)) : new SingleMCFeatureEditor(this.app, this, this.tablemodel.getOpParam(row));
                        if (this.editable) {
                            parameditor.addChangeListener(this.changelistener);
                        }
                        this.editors.add(parameditor);
                        continue;
                    }
                    if (this.tablemodel.getOpParam(row).isFeatureParameter()) {
                        parameditor = this.tablemodel.getOpParam(row).isArray() ? new ListFeatureEditor(this.app, this, this.tablemodel.getOpParam(row)) : new SingleFeatureEditor(this.app, this, this.tablemodel.getOpParam(row));
                        if (this.editable) {
                            parameditor.addChangeListener(this.changelistener);
                        }
                        this.editors.add(parameditor);
                        continue;
                    }
                    System.out.println("Unexpected Parameter!");
                    System.out.println("Step: " + this.step.getName());
                    System.out.println("Operator: " + this.step.getTheOperator().getName());
                    System.out.println("OpParam: " + this.tablemodel.getOpParam(row).getName());
                    parameditor = new ParameterEditor();
                    if (this.editable) {
                        parameditor.addChangeListener(this.changelistener);
                    }
                    this.editors.add(parameditor);
                    continue;
                }
                Collection coll = null;
                if (this.tablemodel.getOpParam(row).isFeatureParameter() || this.tablemodel.getOpParam(row).isBaseAttribParameter() || this.tablemodel.getOpParam(row).isMcfParameter()) {
                    try {
                        coll = this.step.getOpParamsToSelectFeatureParamObjectsFrom(this.tablemodel.getOpParam(row));
                    }
                    catch (M4Exception error) {
                        M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
                    }
                }
                if (coll != null && !coll.isEmpty()) {
                    if (this.tablemodel.getOpParam(row).isBaseAttribParameter()) {
                        parameditor = this.tablemodel.getOpParam(row).isArray() ? new ListBaseAttributeEditor(this.app, this, this.tablemodel.getOpParam(row)) : new SingleBaseAttributeEditor(this.app, this, this.tablemodel.getOpParam(row));
                        if (this.editable) {
                            parameditor.addChangeListener(this.changelistener);
                        }
                        this.editors.add(parameditor);
                        continue;
                    }
                    if (this.tablemodel.getOpParam(row).isMcfParameter()) {
                        parameditor = this.tablemodel.getOpParam(row).isArray() ? new ListMCFeatureEditor(this.app, this, this.tablemodel.getOpParam(row)) : new SingleMCFeatureEditor(this.app, this, this.tablemodel.getOpParam(row));
                        if (this.editable) {
                            parameditor.addChangeListener(this.changelistener);
                        }
                        this.editors.add(parameditor);
                        continue;
                    }
                    if (this.tablemodel.getOpParam(row).isFeatureParameter()) {
                        parameditor = this.tablemodel.getOpParam(row).isArray() ? new ListFeatureEditor(this.app, this, this.tablemodel.getOpParam(row)) : new SingleFeatureEditor(this.app, this, this.tablemodel.getOpParam(row));
                        if (this.editable) {
                            parameditor.addChangeListener(this.changelistener);
                        }
                        this.editors.add(parameditor);
                        continue;
                    }
                    if (this.tablemodel.getOpParam(row).isRelationParameter()) {
                        parameditor = this.tablemodel.getOpParam(row).isArray() ? new ListRelationEditor(this.app, this, this.tablemodel.getOpParam(row)) : new SingleRelationEditor(this.app, this, this.tablemodel.getOpParam(row));
                        if (this.editable) {
                            parameditor.addChangeListener(this.changelistener);
                        }
                        this.editors.add(parameditor);
                        continue;
                    }
                    System.out.println("Unexpected Parameter!");
                    System.out.println("Step: " + this.step.getName());
                    System.out.println("Operator: " + this.step.getTheOperator().getName());
                    System.out.println("OpParam: " + this.tablemodel.getOpParam(row).getName());
                    parameditor = new ParameterEditor();
                    if (this.editable) {
                        parameditor.addChangeListener(this.changelistener);
                    }
                    this.editors.add(parameditor);
                    continue;
                }
                if (this.tablemodel.getOpParam(row).getMaxArg() == 1) {
                    parameditor = new OutputEditor(this.app, this.step, this.tablemodel.getOpParam(row));
                    if (this.editable) {
                        parameditor.addChangeListener(this.changelistener);
                    }
                    this.editors.add(parameditor);
                    continue;
                }
                parameditor = new ListOutputEditor(this.app, this.step, this.tablemodel.getOpParam(row));
                if (this.editable) {
                    parameditor.addChangeListener(this.changelistener);
                }
                this.editors.add(parameditor);
                continue;
            }
            catch (M4Exception error) {
                M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
            }
        }
    }

    void setValueOfValueParameter(String value, String parameterName, int loopNumber) {
        if (value == null || parameterName == null || loopNumber < 0) {
            return;
        }
        Iterator edIt = this.editors.iterator();
        try {
            while (edIt.hasNext()) {
                ParameterEditor oneParamEd = (ParameterEditor)edIt.next();
                if (!oneParamEd.opParam.getName().equals(parameterName)) continue;
                if (!(oneParamEd instanceof ListOneOfValueEditor || oneParamEd instanceof ListValueEditor || oneParamEd instanceof OutputEditor || oneParamEd instanceof SingleValueEditor)) {
                    return;
                }
                if (oneParamEd instanceof OutputEditor) {
                    Vector<String> c = new Vector<String>();
                    c.add(value);
                    oneParamEd.setParameterCollection(c, loopNumber);
                } else {
                    Value v = oneParamEd.opParam.createValueObject();
                    v.setValue(value);
                    Vector<Value> c = new Vector<Value>();
                    c.add(v);
                    oneParamEd.setParameterCollection(c, loopNumber);
                }
                if (oneParamEd instanceof ListSelectEditor) {
                    ListSelectEditor lse = (ListSelectEditor)oneParamEd;
                    String[] old = lse.getDataItems();
                    int newSize = loopNumber <= old.length ? old.length : old.length + 1;
                    String[] newstr = new String[newSize];
                    System.arraycopy(old, 0, newstr, 0, loopNumber - 1);
                    newstr[loopNumber - 1] = value;
                    System.arraycopy(old, loopNumber - 1, newstr, loopNumber, newSize - loopNumber);
                    lse.setDataItems(newstr);
                }
                if (oneParamEd instanceof SingleValueEditor) {
                    ((SingleValueEditor)oneParamEd).setFieldValue(value);
                }
                if (oneParamEd instanceof OutputEditor) {
                    ((OutputEditor)oneParamEd).setFieldValue(value);
                }
                oneParamEd.fireStateChanged();
                return;
            }
        }
        catch (M4Exception m4e) {
            M4Interface.print.doPrint(Print.ERROR, m4e.getMessage(), m4e);
        }
    }

    private SelectEditor getEditorOfAttribsForValues(OpParam valueOpParam) {
        if (valueOpParam == null) {
            return null;
        }
        SelectEditor lbae = null;
        try {
            Collection constraints = valueOpParam.getApplicableConstraints();
            if (constraints == null) {
                return null;
            }
            Iterator constrIt = constraints.iterator();
            String nameOfAttribParameter = null;
            while (constrIt.hasNext()) {
                Constraint oneConstr = (Constraint)constrIt.next();
                if (!oneConstr.getType().equals("USE_VALS")) continue;
                nameOfAttribParameter = oneConstr.getObj2();
            }
            if (nameOfAttribParameter == null) {
                return null;
            }
            for (ParameterEditor paramEd : this.editors) {
                OpParam opp = paramEd.getTheOpParam();
                if (!opp.getName().equalsIgnoreCase(nameOfAttribParameter)) continue;
                lbae = (SelectEditor)paramEd;
            }
        }
        catch (M4Exception error) {
            M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
        }
        return lbae;
    }

    public TableCellEditor getCellEditor(int row, int column) {
        return (TableCellEditor)this.editors.get(row);
    }

    public TableCellRenderer getCellRenderer(int row, int column) {
        if (column == 1 && row < this.editors.size()) {
            return (TableCellRenderer)this.editors.get(row);
        }
        return this.tablerenderer;
    }

    public void setNrOfLoops(int nrOfLoops) {
        if (nrOfLoops == 0) {
            nrOfLoops = 1;
        }
        this.tablemodel.setNrOfLoops(nrOfLoops);
        for (int e = 0; e < this.editors.size(); ++e) {
            ParameterEditor editor = (ParameterEditor)this.editors.get(e);
            editor.setNumberOfLoops(nrOfLoops);
        }
    }

    public void setLoopNumber(int loopnumber) {
        this.tablemodel.setLoopNumber(loopnumber);
        for (int e = 0; e < this.editors.size(); ++e) {
            ParameterEditor editor = (ParameterEditor)this.editors.get(e);
            editor.setLoopNumber(loopnumber);
        }
    }

    public Step getTheStep() {
        return this.step;
    }

    public Collection getConceptEditorValues(String opParamName) {
        LinkedList<String> values = new LinkedList<String>();
        int row = this.tablemodel.getRowOfOpParamByName(opParamName);
        Object object = this.editors.get(row);
        if (object instanceof ListConceptEditor) {
            values.addAll(((ListConceptEditor)object).getSelectedValues());
        } else if (object instanceof SingleConceptEditor) {
            values.add(((SingleConceptEditor)object).getSelectedValue());
        }
        return values;
    }

    public Collection getRelationEditorValues(String opParamName) {
        LinkedList<String> values = new LinkedList<String>();
        int row = this.tablemodel.getRowOfOpParamByName(opParamName);
        Object object = this.editors.get(row);
        if (object instanceof ListRelationEditor) {
            values.addAll(((ListRelationEditor)object).getSelectedValues());
        } else if (object instanceof SingleRelationEditor) {
            values.add(((SingleRelationEditor)object).getSelectedValue());
        }
        return values;
    }

    public void setParameterCollectionsInStep(boolean save) throws M4Exception {
        if (this.tablemodel.getNrOfLoops() != this.step.getLoopCount()) {
            try {
                if (this.tablemodel.getNrOfLoops() == 1) {
                    this.step.setLoopCount(0);
                } else {
                    this.step.setLoopCount(this.tablemodel.getNrOfLoops());
                }
            }
            catch (M4Exception error) {
                M4Interface.print.doPrint(Print.ERROR, Resource.getString("STEPSETTINGS_ERROR_SET_LOOPCOUNT") + "\n" + error.getMessage(), error);
                JOptionPane.showMessageDialog(this.app, Resource.getString("STEPSETTINGS_ERROR_SET_LOOPCOUNT") + "\n" + error.getMessage(), Resource.getString("DIALOG_ERROR_TITLE"), 0);
                return;
            }
        }
        for (int e = 0; e < this.editors.size(); ++e) {
            ParameterEditor editor = (ParameterEditor)this.editors.get(e);
            editor.setCollectionsInStep();
        }
        if (save) {
            this.app.saveModel();
        }
    }

    public void cancelEditing() throws M4Exception {
        this.setNrOfLoops(this.tablemodel.getOldNrOfLoops());
        for (int e = 0; e < this.editors.size(); ++e) {
            ParameterEditor editor = (ParameterEditor)this.editors.get(e);
            editor.cancelEditing();
        }
        this.repaint();
    }

    public void makeOutput(boolean inputchanged, boolean outputchanged, boolean loopcountlower, boolean loopcounthigher) throws M4Exception {
        ParameterEditor editor;
        Vector<ParameterEditor> editoren = new Vector<ParameterEditor>();
        for (int e = 0; e < this.editors.size(); ++e) {
            editor = (ParameterEditor)this.editors.get(e);
            if (editor.getTheOpParam().isInput()) continue;
            if (editor.getTheOpParam().isConceptParameter()) {
                editoren.add(0, editor);
                continue;
            }
            editoren.add(editor);
        }
        for (int i = 0; i < editoren.size(); ++i) {
            editor = (ParameterEditor)editoren.get(i);
            editor.makeOutput(inputchanged, outputchanged, loopcountlower, loopcounthigher);
        }
    }

    public Collection getEditor() {
        return this.editors;
    }
}

