/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.gui.stepsettings;

import edu.udo.cs.miningmart.exception.MiningMartException;
import edu.udo.cs.miningmart.m4.M4Interface;
import edu.udo.cs.miningmart.m4.OpParam;
import edu.udo.cs.miningmart.m4.Step;
import edu.udo.cs.miningmart.m4.utils.Print;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.musoft.limo.application.Resource;

public class StepParameterRenderer
extends DefaultTableCellRenderer {
    private Step step;

    public StepParameterRenderer(Step step) {
        this.step = step;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int rowIndex, int colIndex) {
        String key = new String("");
        if (value instanceof String) {
            key = (String)value;
        }
        Component c = super.getTableCellRendererComponent(table, key, isSelected, hasFocus, rowIndex, colIndex);
        if (colIndex != 0) {
            return c;
        }
        JLabel label = (JLabel)c;
        c.setFont(c.getFont().deriveFont(1, c.getFont().getSize()));
        try {
            OpParam opparam = (OpParam)this.step.getTheOperator().getOpParams().toArray()[rowIndex];
            if (opparam.isInput()) {
                label.setBackground(Resource.getColor("STEPSETTINGS_COLOR_INPUT"));
            } else {
                label.setBackground(Resource.getColor("STEPSETTINGS_COLOR_OUTPUT"));
            }
            if (opparam.isOptional()) {
                c.setFont(c.getFont().deriveFont(0, c.getFont().getSize()));
            } else {
                c.setFont(c.getFont().deriveFont(1, c.getFont().getSize()));
            }
            if (opparam.isCoordinated()) {
                label.setBorder(BorderFactory.createLineBorder(Resource.getColor("STEPSETTINGS_COLOR_COORDINATED"), 2));
            }
            label.setToolTipText(opparam.getDocumentation());
        }
        catch (MiningMartException error) {
            M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
        }
        return label;
    }
}

