/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.gui.stepsettings;

import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.gui.application.MiningMartApplication;
import edu.udo.cs.miningmart.gui.stepsettings.ParameterEditor;
import edu.udo.cs.miningmart.m4.M4Interface;
import edu.udo.cs.miningmart.m4.OpParam;
import edu.udo.cs.miningmart.m4.Step;
import edu.udo.cs.miningmart.m4.Value;
import edu.udo.cs.miningmart.m4.utils.Print;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class SingleValueEditor
extends ParameterEditor {
    private JTextField field;

    public SingleValueEditor(MiningMartApplication app, Step step, OpParam opParam) {
        super(app, step, opParam);
        this.editorComponent = new JPanel(new BorderLayout());
        this.field = new JTextField();
        ((JPanel)this.editorComponent).add((Component)this.field, "Center");
        this.field.setHorizontalAlignment(2);
        this.init();
        this.setEditable();
    }

    public void init() {
        Iterator iter;
        Value value = null;
        String text = null;
        this.field.setText("");
        Collection coll = this.getParameterCollection();
        if (coll != null && (iter = coll.iterator()).hasNext()) {
            value = (Value)iter.next();
        }
        if (value != null) {
            text = "";
            if (value.getValue() != null) {
                text = value.getValue();
            }
            this.field.setText(text);
            try {
                this.field.setToolTipText(value.getDocumentation());
            }
            catch (M4Exception error) {
                error.printStackTrace();
            }
        }
    }

    public boolean stopCellEditing() {
        Iterator iter;
        String text = this.field.getText();
        Value value = null;
        Collection coll = this.getParameterCollection();
        if (coll != null && (iter = coll.iterator()).hasNext()) {
            value = (Value)iter.next();
        }
        try {
            String valuestr;
            if (value == null) {
                value = this.opParam.createValueObject();
            }
            if ((valuestr = value.getValue()) == null) {
                valuestr = "";
            }
            if (!valuestr.equals(this.field.getText())) {
                this.fireStateChanged();
            }
            value.setValue(text);
            value.setType(this.opParam.getConceptualDatatypeForValue());
            LinkedList<Value> list = new LinkedList<Value>();
            if (value.getValue().length() > 0) {
                list.add(value);
            }
            this.setParameterCollection(list);
        }
        catch (M4Exception error) {
            M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
        }
        return super.stopCellEditing();
    }

    void setFieldValue(String text) {
        if (this.field != null) {
            this.field.setText(text);
        }
    }

    public void setLoopNumber(int loopnumber) {
        super.setLoopNumber(loopnumber);
    }

    public boolean existsOutput() {
        return false;
    }

    public void setEditable() {
        super.setEditable();
        this.field.setEditable(this.editable);
    }
}

