/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.gui.stepsettings;

import edu.udo.cs.miningmart.gui.application.MiningMartApplication;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.musoft.limo.application.Resource;

public class SingleSelectDialog
extends JDialog
implements ActionListener,
ListSelectionListener {
    public static final int CANCEL = 0;
    public static final int OK = 1;
    private JList datalist;
    private JButton cancel;
    private JButton ok;
    private int exitAction = 0;
    private String[] data;
    private boolean sortdata;
    private String selecttitle;

    public SingleSelectDialog(MiningMartApplication parent, String title, String selecttitle, String[] data, boolean sortdata) {
        super(parent, title, true);
        this.data = data;
        this.sortdata = sortdata;
        this.selecttitle = selecttitle;
        this.initComponents();
        this.setDefaultCloseOperation(2);
        this.pack();
        this.setSize(300, 300);
        Dimension size = this.getSize();
        this.setLocation((Toolkit.getDefaultToolkit().getScreenSize().width - size.width) / 2, (Toolkit.getDefaultToolkit().getScreenSize().height - size.height) / 2);
        this.setVisible(true);
    }

    private String[] selectionSort(String[] data) {
        for (int i = 1; i < data.length - 1; ++i) {
            int min = i;
            for (int j = i + 1; j < data.length; ++j) {
                if (data[j].compareTo(data[min]) >= 0) continue;
                min = j;
            }
            this.swap((Comparable[])data, min, i);
        }
        return data;
    }

    private void swap(Comparable[] a, int i, int j) {
        Comparable tmp = a[i];
        a[i] = a[j];
        a[j] = tmp;
    }

    public void initComponents() {
        JPanel top_panel = new JPanel();
        top_panel.setLayout(new BorderLayout(5, 5));
        this.datalist = new JList();
        this.datalist.setSelectionMode(0);
        this.datalist.setLayoutOrientation(0);
        this.datalist.setVisibleRowCount(-1);
        this.datalist.addListSelectionListener(this);
        if (this.sortdata) {
            this.data = this.selectionSort(this.data);
        }
        this.datalist.setListData(this.data);
        JScrollPane scrollpane = new JScrollPane(this.datalist);
        JPanel mid_panel = new JPanel();
        mid_panel.setLayout(new BorderLayout());
        mid_panel.add((Component)scrollpane, "Center");
        top_panel.add((Component)mid_panel, "Center");
        this.cancel = new JButton(Resource.getString("CANCEL"));
        this.ok = new JButton(Resource.getString("OK"));
        this.ok.setEnabled(false);
        this.cancel.addActionListener(this);
        this.ok.addActionListener(this);
        JPanel bottom = new JPanel();
        bottom.setLayout(new BoxLayout(bottom, 0));
        bottom.add(Box.createHorizontalGlue());
        bottom.add(this.ok);
        bottom.add(Box.createRigidArea(new Dimension(10, 0)));
        bottom.add(this.cancel);
        top_panel.add((Component)bottom, "South");
        JLabel label = new JLabel(this.selecttitle);
        top_panel.add((Component)label, "North");
        top_panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.getContentPane().add(top_panel);
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals(Resource.getString("CANCEL"))) {
            this.exitAction = 0;
            this.dispose();
        }
        if (cmd.equals(Resource.getString("OK"))) {
            this.exitAction = 1;
            this.dispose();
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        if (!this.datalist.isSelectionEmpty()) {
            this.ok.setEnabled(true);
        }
    }

    public int getExitAction() {
        return this.exitAction;
    }

    public String getSelectedDataItem() {
        if (this.exitAction == 1) {
            return (String)this.datalist.getSelectedValue();
        }
        return null;
    }
}

