/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.gui.stepsettings;

import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.gui.application.MiningMartApplication;
import edu.udo.cs.miningmart.gui.stepsettings.ParameterEditor;
import edu.udo.cs.miningmart.m4.M4Interface;
import edu.udo.cs.miningmart.m4.OpParam;
import edu.udo.cs.miningmart.m4.Step;
import edu.udo.cs.miningmart.m4.Value;
import edu.udo.cs.miningmart.m4.utils.Print;
import java.awt.Color;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JComboBox;

public class SingleOneOfValueEditor
extends ParameterEditor
implements ItemListener {
    private Collection oneOfList;
    private boolean propagate;
    private int itemindex;

    public SingleOneOfValueEditor(MiningMartApplication app, Step step, OpParam opParam, Collection oneoflist) {
        super(app, step, opParam);
        this.oneOfList = oneoflist;
        this.propagate = true;
        this.editorComponent = new JComboBox<Object>(oneoflist.toArray());
        ((JComboBox)this.editorComponent).addItemListener(this);
        this.editorComponent.setForeground(Color.BLACK);
        this.editorComponent.setBackground(Color.WHITE);
        this.setClickCountToStart(1);
        this.init();
        this.setEditable();
    }

    public void init() {
        Iterator iter;
        Collection coll;
        Value value = null;
        String text = null;
        if (text == null) {
            text = (String)this.oneOfList.toArray()[0];
        }
        if ((coll = this.getParameterCollection()) != null && (iter = coll.iterator()).hasNext()) {
            value = (Value)iter.next();
        }
        if (value != null) {
            if (value.getValue() != null) {
                text = value.getValue();
            }
            try {
                ((JComboBox)this.editorComponent).setToolTipText(value.getDocumentation());
            }
            catch (M4Exception error) {
                M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
            }
        }
        try {
            value = this.opParam.createValueObject();
            value.setValue(text);
            LinkedList<Value> list = new LinkedList<Value>();
            list.add(value);
            this.setParameterCollection(list);
        }
        catch (M4Exception error) {
            M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
        }
        ((JComboBox)this.editorComponent).setSelectedItem(text);
    }

    public void setLoopNumber(int loopnumber) {
        super.setLoopNumber(loopnumber);
    }

    public void itemStateChanged(ItemEvent e) {
        try {
            String valuestr;
            Iterator iter;
            Value value = null;
            String text = (String)((JComboBox)this.editorComponent).getSelectedItem();
            Collection coll = this.getParameterCollection();
            if (coll != null && (iter = coll.iterator()).hasNext()) {
                value = (Value)iter.next();
            }
            if (value == null) {
                value = this.opParam.createValueObject();
            }
            if ((valuestr = value.getValue()) == null) {
                valuestr = (String)this.oneOfList.toArray()[0];
            }
            if (!valuestr.equals(text)) {
                this.fireStateChanged();
            }
            value.setValue(text);
            LinkedList<Value> list = new LinkedList<Value>();
            list.add(value);
            this.setParameterCollection(list);
        }
        catch (M4Exception error) {
            M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
        }
        this.stopCellEditing();
    }

    public boolean existsOutput() {
        return false;
    }

    public void setEditable() {
        super.setEditable();
        ((JComboBox)this.editorComponent).setEnabled(this.editable);
    }
}

