/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.gui.stepsettings;

import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.gui.application.MiningMartApplication;
import edu.udo.cs.miningmart.gui.stepsettings.SingleSelectDialog;
import edu.udo.cs.miningmart.gui.stepsettings.SingleSelectEditor;
import edu.udo.cs.miningmart.gui.stepsettings.StepParameterTable;
import edu.udo.cs.miningmart.m4.M4Interface;
import edu.udo.cs.miningmart.m4.MultiColumnFeature;
import edu.udo.cs.miningmart.m4.OpParam;
import edu.udo.cs.miningmart.m4.utils.Print;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import org.musoft.limo.application.Resource;

public class SingleMCFeatureEditor
extends SingleSelectEditor {
    private Vector features;

    public SingleMCFeatureEditor(MiningMartApplication app, StepParameterTable table, OpParam opParam) {
        super(app, table.getTheStep(), opParam);
        this.table = table;
    }

    public void init() {
        super.init();
        if (this.opParam.isInput()) {
            if (this.paramobject != null && this.paramobject instanceof MultiColumnFeature) {
                try {
                    String name = new String("");
                    if (((MultiColumnFeature)this.paramobject).getConcept() != null) {
                        name = ((MultiColumnFeature)this.paramobject).getConcept().getName();
                    }
                    this.textfield.setText(((MultiColumnFeature)this.paramobject).getName() + " [" + name + "]");
                }
                catch (M4Exception error) {
                    M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
                }
            }
        } else {
            Collection coll = this.getFeatureCollection();
            Iterator iter = coll.iterator();
            if (iter.hasNext()) {
                MultiColumnFeature mcfeat = (MultiColumnFeature)iter.next();
                try {
                    String name = new String("");
                    if (mcfeat.getConcept() != null) {
                        name = mcfeat.getConcept().getName();
                    }
                    this.textfield.setText(mcfeat.getName() + " [" + name + "]");
                }
                catch (M4Exception error) {
                    M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
                }
            }
        }
    }

    public void actionPerformed(ActionEvent e) {
        try {
            String name;
            Collection battribs = this.getListOfAttributesToSelectAttributeFrom(this.opParam);
            if (battribs == null) {
                this.showErrorMessage();
                return;
            }
            String[] data = new String[battribs.size() + 1];
            data[0] = Resource.getString("STEPSETTINGS_NONE_SELECTION");
            Iterator iter = battribs.iterator();
            int c = 1;
            while (iter.hasNext()) {
                MultiColumnFeature mcfeat = (MultiColumnFeature)iter.next();
                name = new String("");
                if (mcfeat.getConcept() != null) {
                    name = mcfeat.getConcept().getName();
                }
                data[c] = mcfeat.getName() + " [" + name + "]";
                ++c;
            }
            SingleSelectDialog dialog = new SingleSelectDialog(this.app, Resource.getString("STEPSETTINGS_TITLE_MCFEATURE"), Resource.getString("STEPSETTINGS_TITLE_SELECT_MCFEATURE"), data, true);
            if (dialog.getExitAction() == 1) {
                String selected = dialog.getSelectedDataItem();
                if (selected.equals(data[0])) {
                    selected = "";
                }
                this.textfield.setText(selected);
                iter = battribs.iterator();
                MultiColumnFeature selectedMCF = null;
                boolean found = false;
                while (iter.hasNext() && !found) {
                    selectedMCF = (MultiColumnFeature)iter.next();
                    name = new String("");
                    if (selectedMCF.getConcept() != null) {
                        name = selectedMCF.getConcept().getName();
                    }
                    if (!(selectedMCF.getName() + " [" + name + "]").equals(selected)) continue;
                    found = true;
                }
                LinkedList<MultiColumnFeature> list = new LinkedList<MultiColumnFeature>();
                if (found) {
                    list.add(selectedMCF);
                    this.paramobject = selectedMCF;
                }
                this.setParameterCollection(list);
                this.fireStateChanged();
            }
        }
        catch (M4Exception error) {
            M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
        }
    }

    private void initFeatures() {
        this.features = new Vector();
        this.numberofloops = this.step.getLoopCount();
        if (this.numberofloops == 0) {
            this.numberofloops = 1;
        }
        try {
            for (int i = 0; i < this.numberofloops; ++i) {
                Collection coll;
                if (this.opParam.isCoordinated()) {
                    coll = this.step.getParameter(this.opParam, 0);
                    if (coll == null) {
                        coll = new LinkedList();
                    }
                    this.features.add(coll);
                    continue;
                }
                if (this.opParam.isLoopable() && this.numberofloops == 1) {
                    coll = this.step.getParameter(this.opParam, 0);
                    if (coll == null) {
                        coll = new LinkedList();
                    }
                    this.features.add(coll);
                    continue;
                }
                if (this.opParam.isLoopable() && this.numberofloops > 1) {
                    coll = this.step.getParameter(this.opParam, i + 1);
                    if (coll == null) {
                        coll = new LinkedList();
                    }
                    this.features.add(coll);
                    continue;
                }
                coll = this.step.getParameter(this.opParam, 0);
                if (coll == null) {
                    coll = new LinkedList();
                }
                this.features.add(coll);
            }
        }
        catch (M4Exception error) {
            M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
        }
    }

    public void setParameterCollection(Collection collection, int loopnumber) {
        super.setParameterCollection(collection, loopnumber);
        boolean loopable = true;
        try {
            loopable = this.opParam.isLoopable();
        }
        catch (M4Exception error) {
            M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
            loopable = true;
        }
        if (this.features == null) {
            this.initFeatures();
        }
        if (loopable) {
            this.features.set(loopnumber - 1, collection);
        } else {
            for (int i = 0; i < this.paramcollections.size(); ++i) {
                this.features.set(i, collection);
            }
        }
    }

    private Collection getFeatureCollection(int loopnumber) {
        boolean loopable = true;
        try {
            loopable = this.opParam.isLoopable();
        }
        catch (M4Exception error) {
            M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
            loopable = true;
        }
        if (this.features == null) {
            this.initFeatures();
        }
        if (loopable) {
            return (Collection)this.features.get(loopnumber - 1);
        }
        return (Collection)this.features.get(0);
    }

    private Collection getFeatureCollection() {
        return this.getFeatureCollection(this.loopnumber);
    }

    public void makeOutput(boolean inputchanged, boolean outputchanged, boolean loopcountlower, boolean loopcounthigher) throws M4Exception {
        super.makeOutput(inputchanged, outputchanged, loopcountlower, loopcounthigher);
        this.initFeatures();
    }

    public boolean existsOutput() {
        if (this.opParam.isInput()) {
            return false;
        }
        for (int loop = 1; loop <= this.numberofloops; ++loop) {
            Collection coll = (Collection)this.oldparamcollections.get(loop - 1);
            LinkedList actual = (LinkedList)this.paramcollections.get(loop - 1);
            if (coll == null) {
                return false;
            }
            if (coll.isEmpty()) {
                return false;
            }
            if (actual == null) {
                actual = new LinkedList();
            }
            if (coll.size() != actual.size()) {
                return false;
            }
            Iterator iter = coll.iterator();
            while (iter.hasNext()) {
                if (actual.contains(iter.next())) continue;
                return false;
            }
        }
        return true;
    }

    public void setNumberOfLoops(int numberofloops) {
        if (numberofloops == 0) {
            numberofloops = 1;
        }
        if (this.features == null) {
            this.initFeatures();
        }
        if (this.features.size() < numberofloops) {
            while (this.features.size() != numberofloops) {
                this.features.add(new LinkedList());
            }
        } else if (this.features.size() > numberofloops) {
            for (int i = this.features.size(); i != numberofloops; --i) {
                this.features.remove(i - 1);
            }
        }
        super.setNumberOfLoops(numberofloops);
    }
}

