/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.gui.stepsettings;

import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.gui.application.MiningMartApplication;
import edu.udo.cs.miningmart.gui.stepsettings.ParameterEditor;
import edu.udo.cs.miningmart.gui.stepsettings.StepParameterTable;
import edu.udo.cs.miningmart.m4.BaseAttribute;
import edu.udo.cs.miningmart.m4.Concept;
import edu.udo.cs.miningmart.m4.M4Interface;
import edu.udo.cs.miningmart.m4.OpParam;
import edu.udo.cs.miningmart.m4.Relation;
import edu.udo.cs.miningmart.m4.Step;
import edu.udo.cs.miningmart.m4.utils.Print;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JOptionPane;

public abstract class SelectEditor
extends ParameterEditor {
    protected StepParameterTable table;
    protected JButton button;

    public SelectEditor(MiningMartApplication app, Step step, OpParam opParam) {
        super(app, step, opParam);
    }

    protected Collection getListOfAttributesToSelectAttributeFrom(OpParam theAttribOpParam) {
        try {
            Collection opParamsToSelectFrom = null;
            opParamsToSelectFrom = this.step.getOpParamsToSelectFeatureParamObjectsFrom(theAttribOpParam);
            if (opParamsToSelectFrom == null) {
                return null;
            }
            Vector<String> conceptsToSelectAttribFrom = new Vector<String>();
            for (OpParam anOpPar : opParamsToSelectFrom) {
                if (anOpPar.isConceptParameter()) {
                    Collection theConcepts = this.table.getConceptEditorValues(anOpPar.getName());
                    if (theConcepts != null) {
                        conceptsToSelectAttribFrom.addAll(theConcepts);
                    } else {
                        return null;
                    }
                }
                if (!anOpPar.isRelationParameter()) continue;
                boolean takeFrom = this.step.isAttribToTakeFromFromConcept(theAttribOpParam, anOpPar);
                boolean takeTo = this.step.isAttribToTakeFromToConcept(theAttribOpParam, anOpPar);
                if (!takeFrom && !takeTo || takeFrom & takeTo) {
                    this.showErrorMessage("Cannot determine whether the parameter is from the FromConcept\nor the ToConcept of the relation given by another parameter.");
                    return null;
                }
                Collection rels = this.table.getRelationEditorValues(anOpPar.getName());
                Relation rel = null;
                if (rels == null || rels.isEmpty()) {
                    return null;
                }
                String relName = (String)rels.iterator().next();
                rel = this.step.getTheCase().getRelation(relName);
                if (rel == null) {
                    return null;
                }
                if (takeFrom) {
                    conceptsToSelectAttribFrom.add(rel.getTheFromConcept().getName());
                }
                if (!takeTo) continue;
                conceptsToSelectAttribFrom.add(rel.getTheToConcept().getName());
            }
            LinkedList<BaseAttribute> battribs = new LinkedList<BaseAttribute>();
            for (String conceptName : conceptsToSelectAttribFrom) {
                Concept concept = M4Interface.getCurrentCase().getConcept(conceptName);
                if (concept == null) continue;
                Collection c = concept.getAllBaseAttributes();
                for (BaseAttribute ba : c) {
                    if (!this.step.isVisible(ba)) continue;
                    battribs.add(ba);
                }
            }
            if (battribs == null || battribs.isEmpty()) {
                return null;
            }
            return battribs;
        }
        catch (M4Exception error) {
            M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
            return null;
        }
    }

    protected void showErrorMessage() {
        String standardMessage = "Please specify other parameters first, so that the selection for this one is known!";
        this.showErrorMessage(standardMessage);
    }

    protected void showErrorMessage(String message) {
        JOptionPane.showMessageDialog(null, message, "Error during parameter editing", 1);
    }
}

