/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.gui.stepsettings;

import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.gui.application.MiningMartApplication;
import edu.udo.cs.miningmart.gui.stepsettings.ListSelectDialog;
import edu.udo.cs.miningmart.gui.stepsettings.ListSelectEditor;
import edu.udo.cs.miningmart.gui.stepsettings.SelectEditor;
import edu.udo.cs.miningmart.m4.BaseAttribute;
import edu.udo.cs.miningmart.m4.M4Interface;
import edu.udo.cs.miningmart.m4.OpParam;
import edu.udo.cs.miningmart.m4.Step;
import edu.udo.cs.miningmart.m4.Value;
import edu.udo.cs.miningmart.m4.utils.Print;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import org.musoft.limo.application.Resource;

public class ListValueEditor
extends ListSelectEditor {
    private SelectEditor lbae;

    public ListValueEditor(MiningMartApplication app, Step step, OpParam opParam, SelectEditor editorWithAttribParams) {
        super(app, step, opParam);
        this.lbae = editorWithAttribParams;
    }

    public void init() {
        super.init();
        this.selected_data = new String[0];
        Collection coll = this.getParameterCollection();
        if (coll != null) {
            this.selected_data = new String[coll.size()];
            Iterator iter = coll.iterator();
            int index = 0;
            while (iter.hasNext()) {
                this.selected_data[index] = this.opParam.isInput() ? ((Value)iter.next()).getValue() : (String)iter.next();
                ++index;
            }
        }
        this.setDataItems(this.selected_data);
    }

    public void actionPerformed(ActionEvent e) {
        ListSelectDialog dialog = null;
        boolean useEstimations = false;
        try {
            useEstimations = this.opParam.isDependentValueParameter();
        }
        catch (M4Exception m4e) {
            M4Interface.print.doPrint(Print.ERROR, m4e.getMessage(), m4e);
        }
        if (useEstimations) {
            BaseAttribute[] attribs = this.getAttribs();
            dialog = new ListSelectDialog(this.app, Resource.getString("STEPSETTINGS_TITLE_VALUE"), Resource.getString("STEPSETTINGS_TITLE_SELECT_VALUE"), this.selected_data, this.opParam.getMinArg(), this.opParam.getMaxArg(), attribs, this.step);
        } else {
            dialog = new ListSelectDialog(this.app, Resource.getString("STEPSETTINGS_TITLE_VALUE"), Resource.getString("STEPSETTINGS_TITLE_SELECT_VALUE"), this.selected_data, this.opParam.getMinArg(), this.opParam.getMaxArg());
        }
        if (dialog.getExitAction() == 1) {
            this.selected_data = dialog.getSelectedDataItems();
            this.setDataItems(this.selected_data);
            Collection coll = this.getParameterCollection();
            Iterator iter = null;
            if (coll != null) {
                iter = coll.iterator();
            }
            LinkedList<Value> list = new LinkedList<Value>();
            try {
                for (int s = 0; s < this.selected_data.length; ++s) {
                    Value value = iter != null && iter.hasNext() ? (Value)iter.next() : this.opParam.createValueObject();
                    value.setValue(this.selected_data[s]);
                    list.add(value);
                }
            }
            catch (M4Exception error) {
                M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
            }
            this.setParameterCollection(list);
            this.fireStateChanged();
        }
    }

    private BaseAttribute[] getAttribs() {
        if (this.lbae == null) {
            return null;
        }
        Vector allSetParams = this.lbae.paramcollections;
        Iterator loopIt = allSetParams.iterator();
        Vector<BaseAttribute> v = new Vector<BaseAttribute>();
        while (loopIt.hasNext()) {
            Collection oneLoopParams = (Collection)loopIt.next();
            for (BaseAttribute ba : oneLoopParams) {
                v.add(ba);
            }
        }
        BaseAttribute[] ret = new BaseAttribute[v.size()];
        Iterator vIt = v.iterator();
        int i = 0;
        while (vIt.hasNext()) {
            ret[i] = (BaseAttribute)vIt.next();
            ++i;
        }
        return ret;
    }

    public boolean existsOutput() {
        return false;
    }
}

