/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.gui.stepsettings;

import edu.udo.cs.miningmart.gui.application.MiningMartApplication;
import edu.udo.cs.miningmart.gui.application.ValueSelectionDialog;
import edu.udo.cs.miningmart.m4.BaseAttribute;
import edu.udo.cs.miningmart.m4.Step;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jhotdraw.util.Iconkit;
import org.musoft.limo.application.Resource;

public class ListSelectDialog
extends JDialog
implements ActionListener,
ListSelectionListener {
    public static final int CANCEL = 0;
    public static final int OK = 1;
    private JList datalist;
    private JTextField valuefield;
    private JComboBox valuebox;
    private JList selectedlist;
    private JList attributeList;
    private JButton cancel;
    private JButton ok;
    private JButton useEstimatesButton;
    private JButton add;
    private JButton up;
    private JButton down;
    private JButton remove;
    private JButton order;
    private int exitAction;
    private String[] data;
    private boolean sortdata;
    private String[] selectdata;
    private int minselection;
    private int maxselection;
    private BaseAttribute[] attribsWhoseValuesCanBeTaken;
    private String estButtonText;
    private String currentEstimationAttrib;
    private Step currentStep;
    private String selecttitle;
    private Collection list;
    private int list_type;
    public final int LIST_TO_LIST = 0;
    public final int VALUE_TO_LIST = 1;
    public final int ONE_OF_VALUE_TO_LIST = 2;

    public ListSelectDialog(MiningMartApplication parent, String title, String selecttitle, String[] data, String[] selected_data, boolean sortdata, int minselection, int maxselection) {
        super(parent, title, true);
        this.exitAction = 0;
        this.data = data;
        this.selectdata = selected_data;
        this.sortdata = sortdata;
        this.minselection = minselection;
        this.maxselection = maxselection;
        if (maxselection == -1) {
            this.maxselection = Integer.MAX_VALUE;
        }
        this.selecttitle = selecttitle;
        this.list_type = 0;
        this.initComponents(false);
        this.setDefaultCloseOperation(2);
        this.pack();
        this.setSize(600, 300);
        Dimension size = this.getSize();
        this.setLocation((Toolkit.getDefaultToolkit().getScreenSize().width - size.width) / 2, (Toolkit.getDefaultToolkit().getScreenSize().height - size.height) / 2);
        this.setVisible(true);
    }

    public ListSelectDialog(MiningMartApplication parent, String title, String selecttitle, String[] selected_data, int minselection, int maxselection) {
        this(parent, title, selecttitle, selected_data, minselection, maxselection, false, null, null);
    }

    private ListSelectDialog(MiningMartApplication parent, String title, String selecttitle, String[] selected_data, int minselection, int maxselection, boolean useValueEstimations, BaseAttribute[] theAttribs, Step theStep) {
        super(parent, title, true);
        this.attribsWhoseValuesCanBeTaken = theAttribs;
        this.currentStep = theStep;
        this.exitAction = 0;
        this.selectdata = selected_data;
        this.sortdata = false;
        this.minselection = minselection;
        this.maxselection = maxselection;
        if (maxselection == -1) {
            this.maxselection = Integer.MAX_VALUE;
        }
        this.selecttitle = selecttitle;
        this.list_type = 1;
        this.initComponents(useValueEstimations);
        this.setDefaultCloseOperation(2);
        this.pack();
        this.setSize(600, 300);
        Dimension size = this.getSize();
        this.setLocation((Toolkit.getDefaultToolkit().getScreenSize().width - size.width) / 2, (Toolkit.getDefaultToolkit().getScreenSize().height - size.height) / 2);
        this.setVisible(true);
    }

    public ListSelectDialog(MiningMartApplication parent, String title, String selecttitle, Collection list, String[] selected_data, int minselection, int maxselection) {
        super(parent, title, true);
        this.exitAction = 0;
        this.list = list;
        this.selectdata = selected_data;
        this.sortdata = false;
        this.minselection = minselection;
        this.maxselection = maxselection;
        if (maxselection == -1) {
            this.maxselection = Integer.MAX_VALUE;
        }
        this.selecttitle = selecttitle;
        this.list_type = 2;
        this.initComponents(false);
        this.setDefaultCloseOperation(2);
        this.pack();
        this.setSize(600, 300);
        Dimension size = this.getSize();
        this.setLocation((Toolkit.getDefaultToolkit().getScreenSize().width - size.width) / 2, (Toolkit.getDefaultToolkit().getScreenSize().height - size.height) / 2);
        this.setVisible(true);
    }

    public ListSelectDialog(MiningMartApplication parent, String title, String selecttitle, String[] selected_data, int minselection, int maxselection, BaseAttribute[] attribsToSelectValuesFrom, Step currentStep) {
        this(parent, title, selecttitle, selected_data, minselection, maxselection, true, attribsToSelectValuesFrom, currentStep);
    }

    private String[] selectionSort(String[] data) {
        for (int i = 0; i < data.length - 1; ++i) {
            int min = i;
            for (int j = i + 1; j < data.length; ++j) {
                if (data[j].compareTo(data[min]) >= 0) continue;
                min = j;
            }
            this.swap((Comparable[])data, min, i);
        }
        return data;
    }

    private void swap(Comparable[] a, int i, int j) {
        Comparable tmp = a[i];
        a[i] = a[j];
        a[j] = tmp;
    }

    private void initComponents(boolean useEstimations) {
        Iconkit kit = Iconkit.instance();
        JPanel top_panel = new JPanel();
        top_panel.setLayout(new BorderLayout(5, 5));
        JPanel center_panel = new JPanel();
        center_panel.setLayout(new GridLayout(1, 2, 5, 5));
        top_panel.add((Component)center_panel, "Center");
        JPanel left_panel = new JPanel();
        left_panel.setLayout(new BorderLayout());
        if (this.list_type == 0) {
            this.initDataList();
            JScrollPane scrollpane = new JScrollPane(this.datalist);
            left_panel.add((Component)scrollpane, "Center");
        }
        if (this.list_type == 1) {
            left_panel.add((Component)this.initValueTextField(), "Center");
            if (useEstimations && this.attribsWhoseValuesCanBeTaken != null && this.attribsWhoseValuesCanBeTaken.length > 0) {
                JPanel estimPanel = new JPanel();
                estimPanel.setLayout(new BorderLayout());
                this.attributeList = new JList();
                this.attributeList.setSelectionMode(0);
                this.attributeList.setLayoutOrientation(0);
                this.attributeList.setVisibleRowCount(3);
                this.attributeList.addListSelectionListener(this);
                this.attributeList.setListData(this.getAttribNames());
                this.estButtonText = Resource.getString("STEPSETTINGS_LIST_USE_ESTIMATES");
                this.useEstimatesButton = new JButton(this.estButtonText);
                this.useEstimatesButton.setEnabled(false);
                this.useEstimatesButton.addActionListener(this);
                JLabel heading = new JLabel(Resource.getString("STEPSETTINGS_USE_ESTIMATES_FROM"));
                JScrollPane scrollpane = new JScrollPane(this.attributeList);
                estimPanel.add((Component)heading, "North");
                estimPanel.add((Component)scrollpane, "Center");
                estimPanel.add((Component)this.useEstimatesButton, "South");
                left_panel.add((Component)estimPanel, "South");
            }
        }
        if (this.list_type == 2) {
            left_panel.add((Component)this.initValueComboBox(), "Center");
        }
        center_panel.add(left_panel);
        this.add = new JButton(new ImageIcon(kit.loadImageResource(Resource.getString("STEPSETTINGS_LIST_ADD_ICON"))));
        if (this.list_type == 0) {
            this.add.setEnabled(false);
        }
        this.add.setToolTipText(Resource.getString("STEPSETTINGS_LIST_ADD_TOOLTIP"));
        this.add.setName("add");
        this.add.addActionListener(this);
        this.up = new JButton(new ImageIcon(kit.loadImageResource(Resource.getString("STEPSETTINGS_LIST_UP_ICON"))));
        this.up.setEnabled(false);
        this.up.setToolTipText(Resource.getString("STEPSETTINGS_LIST_UP_TOOLTIP"));
        this.up.setName("up");
        this.up.addActionListener(this);
        this.down = new JButton(new ImageIcon(kit.loadImageResource(Resource.getString("STEPSETTINGS_LIST_DOWN_ICON"))));
        this.down.setEnabled(false);
        this.down.setToolTipText(Resource.getString("STEPSETTINGS_LIST_DOWN_TOOLTIP"));
        this.down.setName("down");
        this.down.addActionListener(this);
        this.remove = new JButton(new ImageIcon(kit.loadImageResource(Resource.getString("STEPSETTINGS_LIST_REMOVE_ICON"))));
        this.remove.setEnabled(false);
        this.remove.setToolTipText(Resource.getString("STEPSETTINGS_LIST_REMOVE_TOOLTIP"));
        this.remove.setName("remove");
        this.remove.addActionListener(this);
        this.order = new JButton(new ImageIcon(kit.loadImageResource(Resource.getString("STEPSETTINGS_LIST_SORT_ICON"))));
        this.order.setEnabled(false);
        this.order.setToolTipText(Resource.getString("STEPSETTINGS_LIST_SORT_TOOLTIP"));
        this.order.setName("order");
        this.order.addActionListener(this);
        JPanel midbuttons2 = new JPanel();
        midbuttons2.setLayout(new BorderLayout(5, 5));
        midbuttons2.add((Component)this.add, "North");
        left_panel.add((Component)midbuttons2, "East");
        JPanel midbuttons = new JPanel();
        midbuttons.setLayout(new BorderLayout(5, 5));
        JPanel downbuttons = new JPanel();
        if (this.sortdata) {
            downbuttons.setLayout(new GridLayout(4, 1, 5, 5));
        } else {
            downbuttons.setLayout(new GridLayout(3, 1, 5, 5));
        }
        downbuttons.add(this.up);
        downbuttons.add(this.down);
        downbuttons.add(this.remove);
        if (this.sortdata) {
            downbuttons.add(this.order);
        }
        midbuttons.add((Component)downbuttons, "South");
        this.selectedlist = new JList();
        this.selectedlist.setSelectionMode(2);
        this.selectedlist.setLayoutOrientation(0);
        this.selectedlist.setVisibleRowCount(-1);
        this.selectedlist.addListSelectionListener(this);
        this.selectedlist.setListData(this.selectdata);
        JScrollPane scrollpane = new JScrollPane(this.selectedlist);
        JPanel right_panel = new JPanel();
        right_panel.setLayout(new BorderLayout());
        right_panel.add((Component)scrollpane, "Center");
        right_panel.add((Component)midbuttons, "West");
        center_panel.add(right_panel);
        this.cancel = new JButton(Resource.getString("CANCEL"));
        this.ok = new JButton(Resource.getString("OK"));
        this.ok.setEnabled(false);
        this.checkMinMaxSelection();
        this.cancel.addActionListener(this);
        this.ok.addActionListener(this);
        JPanel bottom = new JPanel();
        bottom.setLayout(new BoxLayout(bottom, 0));
        bottom.add(Box.createHorizontalGlue());
        bottom.add(this.ok);
        bottom.add(Box.createRigidArea(new Dimension(10, 0)));
        bottom.add(this.cancel);
        top_panel.add((Component)bottom, "South");
        JLabel label = new JLabel(this.selecttitle);
        left_panel.add((Component)label, "North");
        String labeltext = "";
        labeltext = labeltext + "min: " + this.minselection;
        if (this.maxselection != Integer.MAX_VALUE) {
            labeltext = labeltext + "    max: " + this.maxselection;
        }
        label = new JLabel(labeltext);
        right_panel.add((Component)label, "North");
        top_panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.getContentPane().add(top_panel);
    }

    private void initDataList() {
        this.datalist = new JList();
        this.datalist.setSelectionMode(2);
        this.datalist.setLayoutOrientation(0);
        this.datalist.setVisibleRowCount(-1);
        this.datalist.addListSelectionListener(this);
        if (this.sortdata) {
            this.data = this.selectionSort(this.data);
        }
        this.datalist.setListData(this.data);
    }

    private String[] getAttribNames() {
        String[] s = new String[this.attribsWhoseValuesCanBeTaken.length];
        for (int i = 0; i < s.length; ++i) {
            s[i] = this.attribsWhoseValuesCanBeTaken[i].getName();
        }
        return s;
    }

    private JPanel initValueTextField() {
        this.valuefield = new JTextField("", 100);
        this.valuefield.setForeground(Color.BLACK);
        this.valuefield.setBackground(Color.WHITE);
        JPanel valuefieldpanel = new JPanel(new BorderLayout());
        valuefieldpanel.add((Component)this.valuefield, "North");
        return valuefieldpanel;
    }

    private JPanel initValueComboBox() {
        Vector vector = new Vector();
        vector.addAll(this.list);
        this.valuebox = new JComboBox(vector);
        this.valuebox.setForeground(Color.BLACK);
        this.valuebox.setBackground(Color.WHITE);
        JPanel valueboxpanel = new JPanel(new BorderLayout());
        valueboxpanel.add((Component)this.valuebox, "North");
        return valueboxpanel;
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals(Resource.getString("CANCEL"))) {
            this.exitAction = 0;
            this.dispose();
        } else if (cmd.equals(Resource.getString("OK"))) {
            this.exitAction = 1;
            this.dispose();
        } else if (e.getSource() instanceof JButton) {
            String tmp;
            int index;
            JButton source = (JButton)e.getSource();
            if (source.getText() != null && source.getText().equals(this.estButtonText)) {
                BaseAttribute selectedAttrib = this.getSelectedAttribute();
                if (selectedAttrib == null) {
                    return;
                }
                ValueSelectionDialog vsd = new ValueSelectionDialog(selectedAttrib, this.currentStep);
                if (vsd.wasCancelled()) {
                    return;
                }
                String values = vsd.getSelectionsAsOneString();
                if (values != null) {
                    this.addSelection(values);
                }
            }
            if (source.getName() != null && source.getName().equals("add")) {
                this.addSelection(null);
            }
            if (source.getName() != null && source.getName().equals("up") && (index = this.selectedlist.getSelectedIndex()) > 0) {
                tmp = this.selectdata[index];
                this.selectdata[index] = this.selectdata[index - 1];
                this.selectdata[index - 1] = tmp;
                this.selectedlist.setListData(this.selectdata);
                this.selectedlist.setSelectedIndex(index - 1);
                this.checkMinMaxSelection();
            }
            if (source.getName() != null && source.getName().equals("down") && (index = this.selectedlist.getSelectedIndex()) < this.selectdata.length - 1) {
                tmp = this.selectdata[index];
                this.selectdata[index] = this.selectdata[index + 1];
                this.selectdata[index + 1] = tmp;
                this.selectedlist.setListData(this.selectdata);
                this.selectedlist.setSelectedIndex(index + 1);
                this.checkMinMaxSelection();
            }
            if (source.getName() != null && source.getName().equals("remove")) {
                int[] indices = this.selectedlist.getSelectedIndices();
                String[] newselectdata = new String[this.selectdata.length - indices.length];
                int adding = 0;
                for (int s = 0; s < this.selectdata.length; ++s) {
                    if (this.containsIndex(s, indices)) continue;
                    newselectdata[adding] = this.selectdata[s];
                    ++adding;
                }
                this.selectdata = newselectdata;
                this.selectedlist.setListData(this.selectdata);
                this.checkMinMaxSelection();
            }
            if (source.getName() != null && source.getName().equals("order")) {
                this.selectdata = this.selectionSort(this.selectdata);
                this.selectedlist.setListData(this.selectdata);
            }
        }
    }

    private void addSelection(String what) {
        Object selection;
        if (this.list_type == 0) {
            selection = this.datalist.getSelectedValues();
            int adding = 0;
            for (int s = 0; s < ((Object[])selection).length; ++s) {
                if (this.containsItem((String)selection[s])) {
                    selection[s] = null;
                    continue;
                }
                ++adding;
            }
            String[] newselectdata = new String[this.selectdata.length + adding];
            System.arraycopy(this.selectdata, 0, newselectdata, 0, this.selectdata.length);
            adding = this.selectdata.length;
            for (int s = 0; s < ((Object)selection).length; ++s) {
                if (selection[s] == null) continue;
                newselectdata[adding] = (String)selection[s];
                ++adding;
            }
            this.selectdata = newselectdata;
            this.selectedlist.setListData(this.selectdata);
            this.checkMinMaxSelection();
        }
        if (this.list_type == 1) {
            Object object = selection = what == null ? this.valuefield.getText() : what;
            if (selection == null) {
                return;
            }
            if (((String)selection).length() == 0) {
                return;
            }
            String[] newselectdata = new String[this.selectdata.length + 1];
            System.arraycopy(this.selectdata, 0, newselectdata, 0, this.selectdata.length);
            newselectdata[newselectdata.length - 1] = selection;
            this.selectdata = newselectdata;
            this.selectedlist.setListData(this.selectdata);
            this.checkMinMaxSelection();
            this.valuefield.setText("");
        }
        if (this.list_type == 2) {
            selection = (String)this.valuebox.getSelectedItem();
            if (selection == null) {
                return;
            }
            String[] newselectdata = new String[this.selectdata.length + 1];
            System.arraycopy(this.selectdata, 0, newselectdata, 0, this.selectdata.length);
            newselectdata[newselectdata.length - 1] = selection;
            this.selectdata = newselectdata;
            this.selectedlist.setListData(this.selectdata);
            this.checkMinMaxSelection();
        }
    }

    private boolean containsIndex(int index, int[] indices) {
        for (int i = 0; i < indices.length; ++i) {
            if (indices[i] != index) continue;
            return true;
        }
        return false;
    }

    private boolean containsItem(String item) {
        for (int s = 0; s < this.selectdata.length; ++s) {
            if (!this.selectdata[s].equals(item)) continue;
            return true;
        }
        return false;
    }

    private BaseAttribute getSelectedAttribute() {
        if (this.attribsWhoseValuesCanBeTaken == null) {
            return null;
        }
        for (int i = 0; i < this.attribsWhoseValuesCanBeTaken.length; ++i) {
            if (!this.attribsWhoseValuesCanBeTaken[i].getName().equalsIgnoreCase(this.currentEstimationAttrib)) continue;
            return this.attribsWhoseValuesCanBeTaken[i];
        }
        return null;
    }

    private void checkMinMaxSelection() {
        if (this.selectdata.length > 1) {
            this.order.setEnabled(true);
        } else {
            this.order.setEnabled(false);
        }
        if (this.minselection <= this.selectdata.length && this.selectdata.length <= this.maxselection) {
            this.ok.setEnabled(true);
        } else {
            this.ok.setEnabled(false);
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        if (e.getSource().equals(this.attributeList)) {
            this.currentEstimationAttrib = (String)this.attributeList.getSelectedValue();
            this.useEstimatesButton.setEnabled(true);
        }
        if (this.list_type == 0) {
            if (this.datalist.isSelectionEmpty()) {
                this.add.setEnabled(false);
            } else {
                this.add.setEnabled(true);
            }
        }
        if (this.selectedlist.isSelectionEmpty()) {
            this.up.setEnabled(false);
            this.down.setEnabled(false);
            this.remove.setEnabled(false);
        } else {
            if (this.selectedlist.getSelectedValues().length == 1) {
                if (this.selectedlist.getSelectedIndex() != 0) {
                    this.up.setEnabled(true);
                }
                if (this.selectedlist.getSelectedIndex() != this.selectdata.length - 1) {
                    this.down.setEnabled(true);
                }
            }
            this.remove.setEnabled(true);
        }
    }

    public int getExitAction() {
        return this.exitAction;
    }

    public String[] getSelectedDataItems() {
        if (this.exitAction == 1) {
            return this.selectdata;
        }
        return null;
    }
}

