/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.gui.stepsettings;

import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.gui.application.MiningMartApplication;
import edu.udo.cs.miningmart.gui.stepsettings.ListSelectDialog;
import edu.udo.cs.miningmart.gui.stepsettings.ListSelectEditor;
import edu.udo.cs.miningmart.m4.Concept;
import edu.udo.cs.miningmart.m4.M4Interface;
import edu.udo.cs.miningmart.m4.OpParam;
import edu.udo.cs.miningmart.m4.Step;
import edu.udo.cs.miningmart.m4.utils.Print;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.musoft.limo.application.Resource;

public class ListConceptEditor
extends ListSelectEditor {
    public ListConceptEditor(MiningMartApplication app, Step step, OpParam opParam) {
        super(app, step, opParam);
    }

    public void init() {
        super.init();
        this.selected_data = new String[0];
        Collection coll = this.getParameterCollection();
        if (coll != null) {
            this.selected_data = new String[coll.size()];
            Iterator iter = coll.iterator();
            int index = 0;
            while (iter.hasNext()) {
                this.selected_data[index] = this.opParam.isInput() ? ((Concept)iter.next()).getName() : (String)iter.next();
                ++index;
            }
        }
        this.setDataItems(this.selected_data);
    }

    public void actionPerformed(ActionEvent e) {
        try {
            Collection concepts = this.step.getPossibleInputConcepts();
            this.data = new String[concepts.size()];
            Iterator iter = concepts.iterator();
            int c = 0;
            while (iter.hasNext()) {
                this.data[c] = ((Concept)iter.next()).getName();
                ++c;
            }
            ListSelectDialog dialog = new ListSelectDialog(this.app, Resource.getString("STEPSETTINGS_TITLE_CONCEPT"), Resource.getString("STEPSETTINGS_TITLE_SELECT_CONCEPT"), this.data, this.selected_data, true, this.opParam.getMinArg(), this.opParam.getMaxArg());
            if (dialog.getExitAction() == 1) {
                this.selected_data = dialog.getSelectedDataItems();
                this.setDataItems(this.selected_data);
                LinkedList<Concept> list = new LinkedList<Concept>();
                for (int s = 0; s < this.selected_data.length; ++s) {
                    iter = concepts.iterator();
                    Concept selectedC = null;
                    boolean found = false;
                    while (iter.hasNext() && !found) {
                        selectedC = (Concept)iter.next();
                        if (!selectedC.getName().equals(this.selected_data[s])) continue;
                        found = true;
                    }
                    if (!found) continue;
                    list.add(selectedC);
                }
                this.setParameterCollection(list);
                this.fireStateChanged();
            }
        }
        catch (M4Exception error) {
            M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
        }
    }

    public boolean existsOutput() {
        if (this.opParam.isInput()) {
            return false;
        }
        for (int loop = 1; loop <= this.numberofloops; ++loop) {
            Collection coll = (Collection)this.oldparamcollections.get(loop - 1);
            LinkedList actual = (LinkedList)this.paramcollections.get(loop - 1);
            if (coll == null) {
                return false;
            }
            if (coll.isEmpty()) {
                return false;
            }
            if (actual == null) {
                actual = new LinkedList();
            }
            if (coll.size() == actual.size()) continue;
            return false;
        }
        return true;
    }
}

