/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.gui.stepsettings;

import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.gui.application.IteratorList;
import edu.udo.cs.miningmart.gui.application.IteratorListener;
import edu.udo.cs.miningmart.gui.application.MiningMartApplication;
import edu.udo.cs.miningmart.gui.stepsettings.GroupTableCellRenderer;
import edu.udo.cs.miningmart.gui.stepsettings.ListSelectEditor;
import edu.udo.cs.miningmart.gui.stepsettings.ParameterEditor;
import edu.udo.cs.miningmart.m4.M4Interface;
import edu.udo.cs.miningmart.m4.OpParam;
import edu.udo.cs.miningmart.m4.Step;
import edu.udo.cs.miningmart.m4.utils.Print;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import org.musoft.limo.application.Resource;

public class GroupsDialog
extends JDialog
implements ActionListener,
IteratorListener {
    private MiningMartApplication app;
    private Step step;
    private Collection editor;
    private JButton closebutton;
    private IteratorList iterlist;
    private JTabbedPane tabbedpane;
    private int nrOfLoops;
    private int loopnumber;
    private Vector grouppanel;

    public GroupsDialog(MiningMartApplication app, Step step, Collection editor) {
        super(app, Resource.getString("STEPSETTINGS_GROUPS_TITLE") + " " + step.getName(), true);
        this.app = app;
        this.step = step;
        this.editor = editor;
        this.nrOfLoops = step.getLoopCount();
        this.loopnumber = 1;
        this.initComponents();
        this.setDefaultCloseOperation(2);
        this.pack();
        this.setSize(600, 300);
        Dimension size = this.getSize();
        this.setLocation((Toolkit.getDefaultToolkit().getScreenSize().width - size.width) / 2, (Toolkit.getDefaultToolkit().getScreenSize().height - size.height) / 2);
        this.setVisible(true);
    }

    private void initComponents() {
        JPanel mainpanel = new JPanel(new BorderLayout(5, 5));
        this.getContentPane().add(mainpanel);
        JPanel northpanel = new JPanel(new BorderLayout(5, 5));
        northpanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        mainpanel.add((Component)northpanel, "North");
        JLabel steplabel = new JLabel();
        steplabel.setText(this.step.getName());
        steplabel.getFont().deriveFont(1, 15.0f);
        steplabel.setHorizontalAlignment(2);
        northpanel.add((Component)steplabel, "West");
        if (this.step.getTheOperator().isLoopable() && this.nrOfLoops > 1) {
            JPanel looppanel = new JPanel(new FlowLayout(2));
            northpanel.add((Component)looppanel, "East");
            JLabel looplabel = new JLabel();
            looplabel.setText(Resource.getString("SHOW_LOOP_NUMBER"));
            looplabel.getFont().deriveFont(1, 15.0f);
            looplabel.setHorizontalAlignment(2);
            looppanel.add(looplabel);
            String[] data = new String[this.nrOfLoops];
            for (int i = 1; i <= this.nrOfLoops; ++i) {
                data[i - 1] = Integer.toString(i);
            }
            this.iterlist = new IteratorList(data);
            this.iterlist.addIteratorListener(this);
            looppanel.add(this.iterlist);
        }
        JPanel buttonpanel = new JPanel(new BorderLayout(5, 5));
        mainpanel.add((Component)buttonpanel, "South");
        this.closebutton = new JButton(Resource.getString("STEPSETTINGS_CLOSE"));
        this.closebutton.addActionListener(this);
        buttonpanel.add((Component)this.closebutton, "East");
        this.tabbedpane = new JTabbedPane();
        mainpanel.add((Component)this.tabbedpane, "Center");
        this.createGroupPanel();
        for (int i = 0; i < this.grouppanel.size(); ++i) {
            this.tabbedpane.addTab(Resource.getString("STEPSETTINGS_GROUP") + " " + Integer.toString(i + 1), (JPanel)this.grouppanel.get(i));
        }
    }

    private void createGroupPanel() {
        this.grouppanel = new Vector();
        Collection coll = null;
        try {
            coll = this.step.getTheOperator().getCoordinatedParameterArrays();
        }
        catch (M4Exception error) {
            M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
            return;
        }
        for (Collection coll2 : coll) {
            JPanel panel = this.createGroupPanel(coll2);
            this.grouppanel.add(panel);
        }
    }

    private JPanel createGroupPanel(Collection opParams) {
        OpParam opParam;
        if (opParams == null) {
            JPanel p = new JPanel();
            p.setBackground(Color.YELLOW);
            return p;
        }
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        Object[] colnames = new String[opParams.size()];
        Iterator iter = opParams.iterator();
        int rows = 0;
        int col = 0;
        while (iter.hasNext()) {
            opParam = (OpParam)iter.next();
            colnames[col] = opParam.getName();
            rows = Math.max(rows, this.getData(opParam).length);
            ++col;
        }
        Object[][] tabledata = new String[rows][opParams.size()];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < opParams.size(); ++j) {
                tabledata[i][j] = new String("");
            }
        }
        iter = opParams.iterator();
        col = 0;
        while (iter.hasNext()) {
            opParam = (OpParam)iter.next();
            String[] data = this.getData(opParam);
            for (int r = 0; r < data.length; ++r) {
                tabledata[r][col] = new String(data[r]);
            }
            ++col;
        }
        JTable table = new JTable(tabledata, colnames);
        table.setDefaultRenderer(Object.class, new GroupTableCellRenderer());
        JScrollPane scrollpane = new JScrollPane(table);
        panel.add(scrollpane);
        return panel;
    }

    private String[] getData(OpParam opParam) {
        Iterator iter = this.editor.iterator();
        ParameterEditor peditor = null;
        boolean found = false;
        while (!found && iter.hasNext()) {
            peditor = (ParameterEditor)iter.next();
            OpParam param = peditor.getTheOpParam();
            if (!param.getName().equals(opParam.getName())) continue;
            found = true;
        }
        String[] data = new String[]{};
        if (!found) {
            return data;
        }
        if (peditor != null && peditor instanceof ListSelectEditor) {
            ListSelectEditor listeditor = (ListSelectEditor)peditor;
            return listeditor.getDataItems();
        }
        return data;
    }

    public void actionPerformed(ActionEvent e) {
        this.dispose();
    }

    public void iterationChanged(String data, int index) {
    }
}

