/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.gui.stepsettings;

import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.gui.application.MiningMartApplication;
import edu.udo.cs.miningmart.m4.BaseAttribute;
import edu.udo.cs.miningmart.m4.Column;
import edu.udo.cs.miningmart.m4.Concept;
import edu.udo.cs.miningmart.m4.PrimaryKey;
import edu.udo.cs.miningmart.m4.Step;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import org.musoft.limo.application.Resource;

public class ConceptViewDialog
extends JDialog
implements ActionListener {
    private MiningMartApplication app;
    private JButton closebutton;
    private Concept myConcept;
    private Step myStep;
    private int noOfRowsInTable;

    public ConceptViewDialog(MiningMartApplication app, Concept theConcept, Step theStep) {
        super(app, Resource.getString("STEPSETTINGS_SHOW_CONCEPT_TITLE"), true);
        this.app = app;
        this.myConcept = theConcept;
        this.myStep = theStep;
        int heightOfTable = this.initComponents();
        if (heightOfTable == -1) {
            return;
        }
        this.setDefaultCloseOperation(2);
        this.pack();
        this.setSize(600, 100 + heightOfTable * 25);
        Dimension size = this.getSize();
        this.setLocation((Toolkit.getDefaultToolkit().getScreenSize().width - size.width) / 2, (Toolkit.getDefaultToolkit().getScreenSize().height - size.height) / 2);
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        this.dispose();
    }

    private int initComponents() {
        JPanel mainpanel = new JPanel(new BorderLayout(5, 5));
        this.getContentPane().add(mainpanel);
        JPanel northpanel = new JPanel(new BorderLayout(5, 5));
        northpanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        mainpanel.add((Component)northpanel, "North");
        JLabel namelabel = new JLabel();
        String text = "Concept " + this.myConcept.getName();
        try {
            if (this.myConcept.getCurrentColumnSet() != null) {
                text = text + " (Columnset: " + this.myConcept.getCurrentColumnSet().getName() + ")";
            }
        }
        catch (M4Exception m4e) {
            return -1;
        }
        namelabel.setText(text);
        namelabel.getFont().deriveFont(1, 15.0f);
        namelabel.setHorizontalAlignment(0);
        northpanel.add((Component)namelabel, "Center");
        JPanel buttonpanel = new JPanel(new BorderLayout(5, 5));
        mainpanel.add((Component)buttonpanel, "South");
        this.closebutton = new JButton(Resource.getString("STEPSETTINGS_CLOSE"));
        this.closebutton.addActionListener(this);
        buttonpanel.add((Component)this.closebutton, "East");
        JScrollPane theInfoTable = this.createInfoTable();
        if (theInfoTable == null) {
            JOptionPane.showMessageDialog(this.app, "No attribute information found!", "Error displaying concept information", 0);
            this.dispose();
            return -1;
        }
        mainpanel.add((Component)theInfoTable, "Center");
        return this.noOfRowsInTable;
    }

    private JScrollPane createInfoTable() {
        Collection allAttribs = null;
        try {
            allAttribs = this.myConcept.getBaseAttributesVisible(this.myStep);
        }
        catch (M4Exception m4e) {
            return null;
        }
        if (allAttribs == null || allAttribs.size() == 0) {
            this.noOfRowsInTable = -1;
            return null;
        }
        this.noOfRowsInTable = allAttribs.size();
        Object[][] tabledata = new String[this.noOfRowsInTable][6];
        Object[] columnNames = new String[]{"BA Name", "BA Role", "Data Type", "Column Name", "Column Type", "Primary Key"};
        try {
            Iterator attribIt = allAttribs.iterator();
            int rowIndex = 0;
            Collection keyCols = null;
            PrimaryKey pk = this.myConcept.getPrimaryKey();
            if (pk != null) {
                keyCols = pk.getAllColumns();
            }
            while (attribIt.hasNext()) {
                BaseAttribute myBA = (BaseAttribute)attribIt.next();
                if (myBA != null) {
                    tabledata[rowIndex][0] = myBA.getName();
                    tabledata[rowIndex][1] = myBA.getRoleName();
                    tabledata[rowIndex][2] = myBA.getConceptualDataTypeName();
                    Column col = myBA.getCurrentColumn();
                    if (col != null) {
                        tabledata[rowIndex][3] = col.getName();
                        tabledata[rowIndex][4] = col.getColumnDataTypeName();
                        tabledata[rowIndex][5] = keyCols != null && keyCols.contains(col) ? "YES" : "";
                    } else {
                        tabledata[rowIndex][3] = Resource.getString("MAPPING_NONE");
                        tabledata[rowIndex][4] = Resource.getString("MAPPING_NONE");
                        tabledata[rowIndex][5] = "";
                    }
                }
                ++rowIndex;
            }
        }
        catch (M4Exception m4e) {
            return null;
        }
        JTable table = new JTable(tabledata, columnNames);
        JScrollPane scrollpane = new JScrollPane(table);
        return scrollpane;
    }
}

