/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.gui.model;

import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.gui.application.MiningMartApplication;
import edu.udo.cs.miningmart.m4.M4Interface;
import edu.udo.cs.miningmart.m4.Relation;
import edu.udo.cs.miningmart.m4.utils.Print;
import org.musoft.limo.application.Resource;
import org.musoft.limo.model.Model;
import org.musoft.limo.model.ModelConnectionElement;
import org.musoft.limo.model.ModelFigureElement;
import org.musoft.limo.model.ModelPrimitiveAttribute;

public class MiningMartRelation
extends ModelConnectionElement {
    private Relation relation;
    private MiningMartApplication app;
    private boolean deleteInDatabase = true;

    public MiningMartRelation() {
    }

    public MiningMartRelation(MiningMartApplication app, Relation relation, String name, Model model, ModelFigureElement start, ModelFigureElement end) {
        super(name, model);
        this.relation = relation;
        this.setStart(start);
        this.setEnd(end);
        this.app = app;
    }

    public void setRelation(Relation relation) {
        this.relation = relation;
    }

    public void setMMartApplication(MiningMartApplication app) {
        if (this.app == null) {
            this.app = app;
        }
    }

    public MiningMartApplication getMMartApplication() {
        return this.app;
    }

    public void setDeleteInDatabase(boolean bool) {
        this.deleteInDatabase = bool;
    }

    public boolean canDeleteInDatabase() {
        return this.deleteInDatabase;
    }

    public boolean canConnect(ModelFigureElement start, ModelFigureElement end) {
        return true;
    }

    protected Class getStartClass() {
        return ModelFigureElement.class;
    }

    protected String getStartName() {
        return "outgoing";
    }

    protected Class getEndClass() {
        return ModelFigureElement.class;
    }

    protected String getEndName() {
        return "incoming";
    }

    public String toString() {
        return this.getName() + ": " + this.getType();
    }

    public boolean canDestroy() {
        return this.app.getViewMode() != 1;
    }

    public String getType() {
        return Resource.getString("RELATION");
    }

    public void destroy() {
        if (this.app.getViewMode() == 1) {
            return;
        }
        super.destroy();
        for (int i = 0; i < this.getListenerCount(); ++i) {
            this.getListener(i).onDestroy(this);
        }
        if (this.canDeleteInDatabase()) {
            try {
                String relationname = this.relation.getName();
                this.relation.deleteSoon();
                M4Interface.print.doPrint(Print.COMPILER_CASE_CONTROL, Resource.getString("DELETED_RELATION") + " " + relationname);
            }
            catch (M4Exception error) {
                M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
            }
        }
    }

    public boolean canSetName(String name) {
        return false;
    }

    public Relation getRelation() {
        return this.relation;
    }

    public void primitiveAttributeChanged(ModelPrimitiveAttribute mpa) {
        super.primitiveAttributeChanged(mpa);
        try {
            if (mpa.getName().equals("notes") && this.relation != null) {
                this.relation.setDocumentation(mpa.getString());
            }
        }
        catch (M4Exception error) {
            M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
        }
    }
}

