/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.gui.model;

import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.gui.application.MiningMartApplication;
import edu.udo.cs.miningmart.gui.model.MiningMartConcept;
import edu.udo.cs.miningmart.m4.Concept;
import edu.udo.cs.miningmart.m4.M4Interface;
import edu.udo.cs.miningmart.m4.Projection;
import edu.udo.cs.miningmart.m4.utils.Print;
import java.util.Collection;
import org.musoft.limo.application.Resource;
import org.musoft.limo.model.Model;
import org.musoft.limo.model.ModelConnectionElement;
import org.musoft.limo.model.ModelFigureElement;
import org.musoft.limo.model.ModelPrimitiveAttribute;

public class MiningMartProjection
extends ModelConnectionElement {
    private Projection projection;
    private MiningMartApplication app;
    private boolean deleteInDatabase = true;

    public MiningMartProjection() {
    }

    public MiningMartProjection(MiningMartApplication app, Projection projection, String name, Model model, ModelFigureElement start, ModelFigureElement end) {
        super(name, model);
        this.projection = projection;
        this.setStart(start);
        this.setEnd(end);
        this.app = app;
    }

    public void setMMartApplication(MiningMartApplication app) {
        if (this.app == null) {
            this.app = app;
        }
    }

    public MiningMartApplication getMMartApplication() {
        return this.app;
    }

    public void setDeleteInDatabase(boolean bool) {
        this.deleteInDatabase = bool;
    }

    public boolean canDeleteInDatabase() {
        return this.deleteInDatabase;
    }

    public boolean canConnect(ModelFigureElement start, ModelFigureElement end) {
        Concept from = ((MiningMartConcept)start).getConcept();
        Concept to = ((MiningMartConcept)end).getConcept();
        try {
            Collection fromproj = from.getProjectionsAsFromConcept();
            for (Projection proj : fromproj) {
                if (!proj.getToConcept().equals(to)) continue;
                return false;
            }
        }
        catch (M4Exception error) {
            return false;
        }
        return true;
    }

    protected Class getStartClass() {
        return ModelFigureElement.class;
    }

    protected String getStartName() {
        return "outgoing";
    }

    protected Class getEndClass() {
        return ModelFigureElement.class;
    }

    protected String getEndName() {
        return "incoming";
    }

    public String toString() {
        return this.getName() + ": " + this.getType();
    }

    public boolean canDestroy() {
        return this.app.getViewMode() != 1;
    }

    public String getType() {
        return Resource.getString("PROJECTION");
    }

    public void destroy() {
        if (this.app.getViewMode() == 1) {
            return;
        }
        super.destroy();
        for (int i = 0; i < this.getListenerCount(); ++i) {
            this.getListener(i).onDestroy(this);
        }
        if (this.canDeleteInDatabase()) {
            try {
                if (this.projection.isWaitingForDelete()) {
                    return;
                }
                Concept from = this.projection.getFromConcept();
                Concept to = this.projection.getToConcept();
                String projectionDescription = "from ";
                projectionDescription = from != null ? projectionDescription + from.getName() : projectionDescription + " unknown concept ";
                projectionDescription = projectionDescription + " to ";
                projectionDescription = to != null ? projectionDescription + to.getName() : projectionDescription + " unknown concept ";
                this.projection.deleteSoon();
                M4Interface.print.doPrint(Print.COMPILER_CASE_CONTROL, Resource.getString("DELETED_PROJECTION") + " " + projectionDescription);
            }
            catch (M4Exception error) {
                M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
            }
        }
    }

    public boolean canSetName(String name) {
        return false;
    }

    public Projection getProjection() {
        return this.projection;
    }

    public void primitiveAttributeChanged(ModelPrimitiveAttribute mpa) {
        super.primitiveAttributeChanged(mpa);
        try {
            if (mpa.getName().equals("notes") && this.projection != null) {
                this.projection.setDocumentation(mpa.getString());
            }
        }
        catch (M4Exception error) {
            M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
        }
    }
}

