/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.gui.model;

import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.gui.application.MiningMartApplication;
import edu.udo.cs.miningmart.gui.model.MiningMartModelFigureElement;
import edu.udo.cs.miningmart.gui.model.StepTransition;
import edu.udo.cs.miningmart.m4.M4Data;
import edu.udo.cs.miningmart.m4.M4Interface;
import edu.udo.cs.miningmart.m4.MultiColumnFeature;
import edu.udo.cs.miningmart.m4.utils.Print;
import java.awt.Point;
import java.awt.Rectangle;
import org.musoft.limo.application.Resource;
import org.musoft.limo.model.ModelAssociationEnd;
import org.musoft.limo.model.ModelFigureElement;
import org.musoft.limo.model.ModelPrimitiveAttribute;

public class MiningMartMultiColumnFeature
extends MiningMartModelFigureElement {
    private MultiColumnFeature mcfeature;
    private MiningMartApplication app;
    private boolean deleteInDatabase = true;

    public MiningMartMultiColumnFeature(MiningMartApplication app, MultiColumnFeature mcfeature, ModelFigureElement parent, Point position, Rectangle bounds) {
        super(mcfeature.getName(), bounds, parent);
        this.mcfeature = mcfeature;
        this.app = app;
        this.setPosition(position);
        this.addAttribute(new ModelAssociationEnd(this, "incoming", 3, true, StepTransition.class, "end"));
        this.addAttribute(new ModelAssociationEnd(this, "outgoing", 3, true, StepTransition.class, "start"));
        try {
            ((ModelPrimitiveAttribute)this.getAttribute("notes")).setString(mcfeature.getDocumentation());
        }
        catch (M4Exception error) {
            // empty catch block
        }
        ((ModelPrimitiveAttribute)this.getAttribute(Resource.getString("ATTR_COLOR"))).setColor(Resource.getColor("CONCEPT_NOTSELECTED_COLOR"));
        ((ModelPrimitiveAttribute)this.getAttribute(Resource.getString("ATTR_COLOR"))).setAccess(1);
    }

    public MiningMartApplication getMMartApplication() {
        return this.app;
    }

    public boolean canSetParent(ModelFigureElement parent) {
        return true;
    }

    public String getType() {
        return Resource.getString("MCFEATURE");
    }

    public String getName() {
        if (this.mcfeature != null) {
            return this.mcfeature.getName();
        }
        return "";
    }

    public void setName(String name) {
        if (this.mcfeature != null) {
            this.mcfeature.setName(name);
        }
        super.setName(name);
    }

    public MultiColumnFeature getMultiColumnFeature() {
        return this.mcfeature;
    }

    M4Data getAttachedM4Object() {
        return this.getMultiColumnFeature();
    }

    public void primitiveAttributeChanged(ModelPrimitiveAttribute mpa) {
        super.primitiveAttributeChanged(mpa);
        if (mpa.getName().equals(Resource.getString("ATTR_NAME")) && this.mcfeature != null) {
            this.setName(mpa.getString());
        }
    }

    public void setBounds(Rectangle bounds) {
        super.setBounds(bounds);
        if (bounds == null) {
            return;
        }
        if (this.mcfeature == null) {
            return;
        }
    }

    public void setPosition(Point p) {
        super.setPosition(p);
    }

    public boolean canDestroy() {
        return this.app.getViewMode() != 1;
    }

    public void destroy() {
        if (this.app.getViewMode() == 1) {
            return;
        }
        super.destroy();
        for (int i = 0; i < this.getListenerCount(); ++i) {
            this.getListener(i).onDestroy(this);
        }
        if (this.canDeleteInDatabase()) {
            try {
                String baseattribname = this.mcfeature.getName();
                this.mcfeature.deleteSoon();
                M4Interface.print.doPrint(Print.COMPILER_CASE_CONTROL, Resource.getString("DELETED_MCFEATURE") + " " + baseattribname);
            }
            catch (M4Exception error) {
                M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
            }
        }
    }

    public void setDeleteInDatabase(boolean bool) {
        this.deleteInDatabase = bool;
    }

    public boolean canDeleteInDatabase() {
        return this.deleteInDatabase;
    }
}

