/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.gui.model;

import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.gui.application.MiningMartApplication;
import edu.udo.cs.miningmart.gui.application.MiningMartMenuBar;
import edu.udo.cs.miningmart.gui.application.MiningMartToolBar;
import edu.udo.cs.miningmart.gui.application.OpenCaseThread;
import edu.udo.cs.miningmart.gui.concepteditor.CreateRelationDialog;
import edu.udo.cs.miningmart.gui.model.MiningMartConcept;
import edu.udo.cs.miningmart.gui.model.MiningMartProjection;
import edu.udo.cs.miningmart.gui.model.MiningMartRelation;
import edu.udo.cs.miningmart.gui.model.MiningMartSubConcept;
import edu.udo.cs.miningmart.m4.Concept;
import edu.udo.cs.miningmart.m4.M4Interface;
import edu.udo.cs.miningmart.m4.Projection;
import edu.udo.cs.miningmart.m4.Relation;
import edu.udo.cs.miningmart.m4.utils.Print;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.JOptionPane;
import org.musoft.limo.application.Resource;
import org.musoft.limo.model.Model;
import org.musoft.limo.model.ModelConnectionElement;
import org.musoft.limo.model.ModelFigureElement;
import org.musoft.limo.model.ModelListener;
import org.musoft.limo.model.ModelPrimitiveAttribute;

public class MiningMartConcepts
extends Model {
    private MiningMartApplication app;
    private boolean cansetdirty;
    private int subconceptcounter;
    private int projectioncounter;

    public MiningMartConcepts(MiningMartApplication app) {
        super(Resource.getString("CONCEPTS"));
        this.app = app;
        this.cansetdirty = true;
        this.subconceptcounter = 0;
        this.projectioncounter = 0;
        ((ModelPrimitiveAttribute)this.getAttribute(Resource.getString("ATTR_COLOR"))).setColor(Color.white);
    }

    public MiningMartApplication getMMartApplication() {
        return this.app;
    }

    public void initConcepts() {
        this.cansetdirty = false;
        try {
            Collection c = M4Interface.getCurrentCase().getAllConceptNames();
            if (this.app.hasDataModel()) {
                c = this.app.getDataModel();
            }
            Iterator iter = c.iterator();
            int i = 10;
            int nr = this.app.getNumberOfFeatures();
            while (iter.hasNext()) {
                Concept concept;
                String conceptname = (String)iter.next();
                if (conceptname == null || (concept = M4Interface.getCurrentCase().getConcept(conceptname)) == null) continue;
                Point p = concept.getPoint();
                if (p == null) {
                    p = new Point(i, i);
                    concept.setPoint(p);
                }
                int nrbas = concept.getAllBaseAttributes().size();
                int nrmcfs = concept.getAllMultiColumnFeatures().size();
                Rectangle rectangle = new Rectangle(p.x, p.y, 200, 50 + Math.min(nrbas, nr) * 21 + Math.min(nrmcfs, nr));
                rectangle = new Rectangle(p.x, p.y, 200, 70);
                MiningMartConcept mconcept = new MiningMartConcept(this.app, concept, this, p, rectangle);
                mconcept.initConcept();
                this.addMiningMartConcept(this, mconcept);
                i += 40;
            }
        }
        catch (M4Exception error) {
            M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
        }
        if (this.app.shouldDrawSubconceptLinks()) {
            for (int i = 0; i < this.getChildCount(); ++i) {
                MiningMartConcept superconcept = (MiningMartConcept)this.getChild(i);
                try {
                    Collection subconcepts = superconcept.getConcept().getSubConcepts();
                    Iterator iter = subconcepts.iterator();
                    while (iter.hasNext()) {
                        MiningMartConcept subconcept = (MiningMartConcept)this.getChild(((Concept)iter.next()).getName());
                        if (subconcept == null) continue;
                        this.createSubConceptTransition(null, superconcept, subconcept, true);
                    }
                    continue;
                }
                catch (M4Exception error) {
                    M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
                }
            }
        }
        if (this.app.shouldDrawRelationships()) {
            for (int i = 0; i < this.getChildCount(); ++i) {
                MiningMartConcept start = (MiningMartConcept)this.getChild(i);
                try {
                    Collection relationsStartingHere = start.getConcept().getTheFromRelationships();
                    for (Relation relation : relationsStartingHere) {
                        Concept toCon = relation.getTheToConcept();
                        if (toCon == null) {
                            this.showWarning("Relation '" + relation.getName() + "' (FromConcept: '" + start.getConcept().getName() + "') is not displayed, it has no ToConcept!");
                            continue;
                        }
                        MiningMartConcept end = (MiningMartConcept)this.getChild(relation.getTheToConcept().getName());
                        if (end == null) continue;
                        this.createMiningMartRelation(relation, start, end);
                    }
                    continue;
                }
                catch (M4Exception error) {
                    M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
                }
            }
        }
        if (this.app.shouldDrawProjections()) {
            for (int i = 0; i < this.getChildCount(); ++i) {
                MiningMartConcept from = (MiningMartConcept)this.getChild(i);
                try {
                    Collection toprojections = from.getConcept().getProjectionsAsFromConcept();
                    for (Projection projection : toprojections) {
                        Concept toCon = projection.getToConcept();
                        if (toCon == null) {
                            this.showWarning("A projection from concept '" + from.getConcept().getName() + "' is not displayed, it has no ToConcept!");
                            continue;
                        }
                        MiningMartConcept to = (MiningMartConcept)this.getChild(projection.getToConcept().getName());
                        if (to == null) continue;
                        this.createMiningMartProjection(projection, from, to);
                    }
                    continue;
                }
                catch (M4Exception error) {
                    M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
                }
            }
        }
        this.cansetdirty = true;
    }

    private void showWarning(String message) {
        JOptionPane.showMessageDialog(this.app, message, "Warning", 2);
    }

    public MiningMartConcept addMiningMartConcept(ModelFigureElement parent, MiningMartConcept concept) {
        if (!(parent instanceof Model)) {
            return null;
        }
        for (int i = 0; i < this.getListenerCount(); ++i) {
            this.getListener(i).onCreateChild(this, concept);
        }
        if (concept.canSetParent(this) && this.canAddChild(concept)) {
            concept.setParent(this);
        } else {
            concept.destroy();
            concept = null;
        }
        return concept;
    }

    public MiningMartSubConcept createSubConceptTransition(String name, MiningMartConcept superconcept, MiningMartConcept subconcept, boolean existsTransition) {
        if (name == null) {
            ++this.subconceptcounter;
            name = new String("SubConcept(" + this.subconceptcounter + ")");
        }
        MiningMartSubConcept result = new MiningMartSubConcept(this.app, name, this, superconcept, subconcept);
        if (!existsTransition) {
            try {
                superconcept.getConcept().addSubConcept(subconcept.getConcept());
            }
            catch (M4Exception error) {
                M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
            }
        }
        return this.addSubConceptTransition(result);
    }

    public MiningMartSubConcept addSubConceptTransition(MiningMartSubConcept transition) {
        for (int i = 0; i < this.getListenerCount(); ++i) {
            this.getListener(i).onCreateConnection(this, transition);
        }
        return transition;
    }

    public int countListener() {
        return this.getListenerCount();
    }

    public ModelListener getModelListener(int index) {
        return this.getListener(index);
    }

    public MiningMartConcept createMiningMartConcept(ModelFigureElement parent, String name, Point point, String type) {
        Concept concept;
        try {
            name = M4Interface.getCurrentCase().getValidName(name, Concept.class);
            concept = M4Interface.getCurrentCase().createConcept(name, type);
        }
        catch (M4Exception error) {
            M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
            JOptionPane.showMessageDialog(this.app, error.getMessage(), Resource.getString("DIALOG_ERROR_TITLE"), 0);
            return null;
        }
        int nr = this.app.getNumberOfFeatures();
        int nrbas = 0;
        int nrmcfs = 0;
        try {
            nrbas = concept.getAllBaseAttributes().size();
            nrmcfs = concept.getAllMultiColumnFeatures().size();
        }
        catch (M4Exception error) {
            M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
            nrbas = 0;
            nrmcfs = 0;
        }
        Rectangle rectangle = new Rectangle(point.x, point.y, 200, 50 + Math.min(nrbas, nr) * 21 + Math.min(nrmcfs, nr));
        rectangle = new Rectangle(point.x, point.y, 200, 70);
        MiningMartConcept result = new MiningMartConcept(this.app, concept, this, point, rectangle);
        result = this.addMiningMartConcept(parent, result);
        result.initConcept();
        return result;
    }

    public MiningMartConcept createMiningMartConcept(ModelFigureElement parent, Concept concept, Point point) {
        int nr = this.app.getNumberOfFeatures();
        int nrbas = 0;
        int nrmcfs = 0;
        try {
            nrbas = concept.getAllBaseAttributes().size();
            nrmcfs = concept.getAllMultiColumnFeatures().size();
        }
        catch (M4Exception error) {
            M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
            nrbas = 0;
            nrmcfs = 0;
        }
        Rectangle rectangle = new Rectangle(point.x, point.y, 200, 50 + Math.min(nrbas, nr) * 21 + Math.min(nrmcfs, nr));
        rectangle = new Rectangle(point.x, point.y, 200, 70);
        MiningMartConcept result = new MiningMartConcept(this.app, concept, parent, point, rectangle);
        result = this.addMiningMartConcept(parent, result);
        result.initConcept();
        return result;
    }

    public MiningMartRelation addMiningMartRelation(MiningMartRelation relation) {
        for (int i = 0; i < this.getListenerCount(); ++i) {
            this.getListener(i).onCreateConnection(this, relation);
        }
        return relation;
    }

    public MiningMartRelation createMiningMartRelation(String name, MiningMartConcept fromconcept, MiningMartConcept toconcept) {
        Relation relation;
        try {
            CreateRelationDialog dialog = new CreateRelationDialog(this.app, fromconcept, toconcept);
            if (dialog.getExitAction() == 0) {
                return null;
            }
            name = dialog.getName();
            if (name == null || name.equals("")) {
                name = Resource.getString("RELATION");
            }
            name = M4Interface.getCurrentCase().getValidName(name, Relation.class);
            relation = dialog.getRelation();
        }
        catch (M4Exception error) {
            M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
            JOptionPane.showMessageDialog(this.app, error.getMessage(), Resource.getString("DIALOG_ERROR_TITLE"), 0);
            return null;
        }
        if (relation == null) {
            return null;
        }
        MiningMartRelation result = new MiningMartRelation(this.app, relation, name, this, fromconcept, toconcept);
        return this.addMiningMartRelation(result);
    }

    public MiningMartRelation createMiningMartRelation(Relation relation, MiningMartConcept start, MiningMartConcept end) {
        String name = relation.getName();
        MiningMartRelation result = new MiningMartRelation(this.app, relation, name, this, start, end);
        return this.addMiningMartRelation(result);
    }

    public MiningMartProjection addMiningMartProjection(MiningMartProjection projection) {
        for (int i = 0; i < this.getListenerCount(); ++i) {
            this.getListener(i).onCreateConnection(this, projection);
        }
        return projection;
    }

    public MiningMartProjection createMiningMartProjection(Projection projection, MiningMartConcept from, MiningMartConcept to) {
        ++this.projectioncounter;
        String name = new String("Projection(" + this.projectioncounter + ")");
        MiningMartProjection result = new MiningMartProjection(this.app, projection, name, this, from, to);
        return this.addMiningMartProjection(result);
    }

    public MiningMartProjection createMiningMartProjection(String name, MiningMartConcept from, MiningMartConcept to) {
        Projection projection;
        try {
            Concept toconcept;
            if (name == null) {
                name = Resource.getString("PROJECTION");
            }
            name = M4Interface.getCurrentCase().getValidName(name, Projection.class);
            Concept fromconcept = from.getConcept();
            projection = fromconcept.createProjectionToConcept(toconcept = to.getConcept(), name);
            if (!projection.isValid()) {
                JOptionPane.showMessageDialog(this.app, "The projection isn't valid.", Resource.getString("DIALOG_ERROR_TITLE"), 0);
                projection.deleteSoon();
                projection = null;
            }
        }
        catch (M4Exception error) {
            M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
            JOptionPane.showMessageDialog(this.app, error.getMessage(), Resource.getString("DIALOG_ERROR_TITLE"), 0);
            return null;
        }
        if (projection == null) {
            return null;
        }
        ++this.projectioncounter;
        name = new String("Projection(" + this.projectioncounter + ")");
        MiningMartProjection result = new MiningMartProjection(this.app, projection, name, this, from, to);
        return this.addMiningMartProjection(result);
    }

    public boolean canAddChild(ModelFigureElement child) {
        return true;
    }

    public boolean canRemoveChild(ModelFigureElement child) {
        return true;
    }

    public boolean canSetParent(ModelFigureElement parent) {
        return false;
    }

    public String getType() {
        return Resource.getString("CONCEPTS");
    }

    public boolean canDestroy() {
        return this.app.getViewMode() != 1;
    }

    public void setDirty(boolean dirty) {
        if (!this.cansetdirty) {
            return;
        }
        if (this.app != null && this.app.getViewMode() == 1) {
            return;
        }
        super.setDirty(dirty);
        if (!OpenCaseThread.CURRENTLY_OPENING) {
            if (dirty && this.app != null) {
                ((MiningMartMenuBar)this.app.getJMenuBar()).setItemState(Resource.getString("MENU_CASE") + "." + Resource.getString("MENU_CASE_SAVE"), true);
                ((MiningMartToolBar)this.app.getToolbar()).enableTool(Resource.getString("TOOL_SAVECASE"), true);
            }
            if (this.app != null) {
                this.app.updateToolsAndMenus();
            }
        }
    }

    public void destroy() {
        for (int i = 0; i < this.getChildCount(); ++i) {
            MiningMartConcept concept = (MiningMartConcept)this.getChild(i);
            concept.setDeleteInDatabase(false, true);
        }
        for (int i = 0; i < this.getConnectionCount(); ++i) {
            ModelConnectionElement connection = this.getConnection(i);
            if (connection instanceof MiningMartSubConcept) {
                ((MiningMartSubConcept)connection).setDeleteInDatabase(false);
            }
            if (connection instanceof MiningMartRelation) {
                ((MiningMartRelation)connection).setDeleteInDatabase(false);
            }
            if (!(connection instanceof MiningMartProjection)) continue;
            ((MiningMartProjection)connection).setDeleteInDatabase(false);
        }
        super.destroy();
    }

    public boolean canSetName(String name) {
        return false;
    }
}

