/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.gui.model;

import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.gui.application.MiningMartApplication;
import edu.udo.cs.miningmart.gui.model.MiningMartBaseAttribute;
import edu.udo.cs.miningmart.gui.model.MiningMartConcepts;
import edu.udo.cs.miningmart.gui.model.MiningMartModelFigureElement;
import edu.udo.cs.miningmart.gui.model.MiningMartMultiColumnFeature;
import edu.udo.cs.miningmart.gui.model.MiningMartProjection;
import edu.udo.cs.miningmart.gui.model.MiningMartRelation;
import edu.udo.cs.miningmart.gui.model.MiningMartSubConcept;
import edu.udo.cs.miningmart.gui.model.StepTransition;
import edu.udo.cs.miningmart.m4.BaseAttribute;
import edu.udo.cs.miningmart.m4.Concept;
import edu.udo.cs.miningmart.m4.M4Data;
import edu.udo.cs.miningmart.m4.M4Interface;
import edu.udo.cs.miningmart.m4.MultiColumnFeature;
import edu.udo.cs.miningmart.m4.utils.Print;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JOptionPane;
import org.musoft.limo.application.Resource;
import org.musoft.limo.model.Model;
import org.musoft.limo.model.ModelAssociationEnd;
import org.musoft.limo.model.ModelConnectionElement;
import org.musoft.limo.model.ModelFigureElement;
import org.musoft.limo.model.ModelPrimitiveAttribute;

public class MiningMartConcept
extends MiningMartModelFigureElement {
    private Concept concept;
    private MiningMartApplication app;
    private boolean deleteInDatabase = true;

    public MiningMartConcept(MiningMartApplication app, Concept concept, ModelFigureElement parent, Point position, Rectangle bounds) {
        super(concept.getName(), bounds, parent);
        this.concept = concept;
        this.app = app;
        this.setPosition(position);
        this.addAttribute(new ModelPrimitiveAttribute(this, "Type", 1, String.class));
        this.addAttribute(new ModelAssociationEnd(this, "incoming", 3, true, StepTransition.class, "end"));
        this.addAttribute(new ModelAssociationEnd(this, "outgoing", 3, true, StepTransition.class, "start"));
        try {
            ((ModelPrimitiveAttribute)this.getAttribute("notes")).setString(concept.getDocumentation());
        }
        catch (M4Exception error) {
            // empty catch block
        }
        ((ModelPrimitiveAttribute)this.getAttribute("Type")).setString(concept.getType());
        ((ModelPrimitiveAttribute)this.getAttribute(Resource.getString("ATTR_COLOR"))).setColor(Resource.getColor("CONCEPT_NOTSELECTED_COLOR"));
        ((ModelPrimitiveAttribute)this.getAttribute(Resource.getString("ATTR_COLOR"))).setAccess(1);
    }

    public MiningMartApplication getMMartApplication() {
        return this.app;
    }

    public MiningMartConcepts getMiningMartConcepts() {
        return (MiningMartConcepts)this.getParent();
    }

    public void initConcept() {
    }

    public MiningMartBaseAttribute addMiningMartBaseAttribute(ModelFigureElement parent, MiningMartBaseAttribute baseattribute) {
        if (!(parent instanceof MiningMartConcept)) {
            return null;
        }
        for (int i = 0; i < this.getMiningMartConcepts().countListener(); ++i) {
            this.getMiningMartConcepts().getModelListener(i).onCreateChild(this, baseattribute);
        }
        if (baseattribute.canSetParent(this) && this.canAddChild(baseattribute)) {
            baseattribute.setParent(this);
        } else {
            baseattribute.destroy();
            baseattribute = null;
        }
        return baseattribute;
    }

    public MiningMartBaseAttribute createMiningMartBaseAttribute(ModelFigureElement parent, String name, Point point, Rectangle bounds) {
        BaseAttribute baseattribute;
        try {
            name = M4Interface.getCurrentCase().getValidName(name, BaseAttribute.class);
            baseattribute = null;
        }
        catch (M4Exception error) {
            M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
            JOptionPane.showMessageDialog(this.app, error.getMessage(), Resource.getString("DIALOG_ERROR_TITLE"), 0);
            return null;
        }
        MiningMartBaseAttribute result = new MiningMartBaseAttribute(this.app, baseattribute, parent, point, bounds);
        return this.addMiningMartBaseAttribute(parent, result);
    }

    public MiningMartBaseAttribute createMiningMartBaseAttribute(ModelFigureElement parent, BaseAttribute baseattribute, Point point, Rectangle bounds) {
        MiningMartBaseAttribute result = new MiningMartBaseAttribute(this.app, baseattribute, parent, point, bounds);
        return this.addMiningMartBaseAttribute(parent, result);
    }

    public MiningMartMultiColumnFeature addMiningMartMultiColumnFeature(ModelFigureElement parent, MiningMartMultiColumnFeature mcfeature) {
        if (!(parent instanceof Model)) {
            return null;
        }
        for (int i = 0; i < this.getListenerCount(); ++i) {
            this.getListener(i).onCreateChild(this, mcfeature);
        }
        if (mcfeature.canSetParent(this) && this.canAddChild(mcfeature)) {
            mcfeature.setParent(this);
        } else {
            mcfeature.destroy();
            mcfeature = null;
        }
        return mcfeature;
    }

    public MiningMartMultiColumnFeature createMiningMartMultiColumnFeature(ModelFigureElement parent, String name, Point point, Rectangle bounds) {
        MultiColumnFeature mcfeature;
        try {
            name = M4Interface.getCurrentCase().getValidName(name, MultiColumnFeature.class);
            mcfeature = null;
        }
        catch (M4Exception error) {
            M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
            JOptionPane.showMessageDialog(this.app, error.getMessage(), Resource.getString("DIALOG_ERROR_TITLE"), 0);
            return null;
        }
        MiningMartMultiColumnFeature result = new MiningMartMultiColumnFeature(this.app, mcfeature, parent, point, bounds);
        return this.addMiningMartMultiColumnFeature(parent, result);
    }

    public MiningMartMultiColumnFeature createMiningMartMultiColumnFeature(ModelFigureElement parent, MultiColumnFeature mcfeature, Point point, Rectangle bounds) {
        MiningMartMultiColumnFeature result = new MiningMartMultiColumnFeature(this.app, mcfeature, parent, point, bounds);
        return this.addMiningMartMultiColumnFeature(parent, result);
    }

    public boolean canSetParent(ModelFigureElement parent) {
        return true;
    }

    public String getType() {
        return Resource.getString("CONCEPT");
    }

    public String getName() {
        if (this.concept != null) {
            return this.concept.getName();
        }
        return "";
    }

    public void setName(String name) {
        if (this.concept != null) {
            this.concept.setName(name);
        }
        super.setName(name);
    }

    public Concept getConcept() {
        return this.concept;
    }

    M4Data getAttachedM4Object() {
        return this.getConcept();
    }

    public void primitiveAttributeChanged(ModelPrimitiveAttribute mpa) {
        super.primitiveAttributeChanged(mpa);
        if (mpa.getName().equals(Resource.getString("ATTR_NAME")) && this.concept != null) {
            this.setName(mpa.getString());
        }
    }

    public boolean canDestroy() {
        return this.app.getViewMode() != 1;
    }

    public void destroy() {
        int i;
        if (this.app.getViewMode() == 1) {
            return;
        }
        Model parentmodel = (Model)this.getParent();
        for (i = parentmodel.getConnectionCount() - 1; i >= 0; --i) {
            Concept concept2;
            Concept concept1;
            ModelConnectionElement connection = parentmodel.getConnection(i);
            if (connection instanceof MiningMartSubConcept) {
                concept1 = ((MiningMartConcept)connection.getStart()).getConcept();
                concept2 = ((MiningMartConcept)connection.getEnd()).getConcept();
            } else if (connection instanceof MiningMartProjection) {
                concept1 = ((MiningMartConcept)connection.getStart()).getConcept();
                concept2 = ((MiningMartConcept)connection.getEnd()).getConcept();
            } else {
                if (!(connection instanceof MiningMartRelation)) continue;
                concept1 = ((MiningMartConcept)connection.getStart()).getConcept();
                concept2 = ((MiningMartConcept)connection.getEnd()).getConcept();
            }
            if (!concept1.equals(this.getConcept()) && !concept2.equals(this.getConcept())) continue;
            connection.destroy();
        }
        super.destroy();
        for (i = 0; i < this.getListenerCount(); ++i) {
            this.getListener(i).onDestroy(this);
        }
        if (this.app.isShowingConceptPanel(this)) {
            this.app.removeConceptPanel();
        }
        if (this.canDeleteInDatabase()) {
            try {
                String conceptname = this.concept.getName();
                this.concept.deleteSoon();
                M4Interface.print.doPrint(Print.COMPILER_CASE_CONTROL, Resource.getString("DELETED_CONCEPT") + " " + conceptname);
            }
            catch (M4Exception error) {
                M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
            }
        }
    }

    public void setDeleteInDatabase(boolean bool, boolean propagate) {
        this.deleteInDatabase = bool;
        if (propagate) {
            for (int i = 0; i < this.getChildCount(); ++i) {
                ModelFigureElement child = this.getChild(i);
                if (child instanceof MiningMartBaseAttribute) {
                    ((MiningMartBaseAttribute)child).setDeleteInDatabase(bool);
                }
                if (!(child instanceof MiningMartMultiColumnFeature)) continue;
                ((MiningMartMultiColumnFeature)child).setDeleteInDatabase(bool);
            }
        }
    }

    public boolean canDeleteInDatabase() {
        return this.deleteInDatabase;
    }

    public boolean canAddChild(ModelFigureElement child) {
        return false;
    }
}

