/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.gui.model;

import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.gui.application.MiningMartApplication;
import edu.udo.cs.miningmart.gui.model.MiningMartModel;
import edu.udo.cs.miningmart.gui.model.MiningMartStep;
import edu.udo.cs.miningmart.gui.model.StepTransition;
import edu.udo.cs.miningmart.m4.Case;
import edu.udo.cs.miningmart.m4.Chain;
import edu.udo.cs.miningmart.m4.GraphicalM4Object;
import edu.udo.cs.miningmart.m4.M4Data;
import edu.udo.cs.miningmart.m4.M4Interface;
import edu.udo.cs.miningmart.m4.Step;
import edu.udo.cs.miningmart.m4.utils.Print;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JOptionPane;
import org.musoft.limo.application.Resource;
import org.musoft.limo.model.Model;
import org.musoft.limo.model.ModelAssociationEnd;
import org.musoft.limo.model.ModelFigureElement;
import org.musoft.limo.model.ModelPrimitiveAttribute;

public class MiningMartChain
extends MiningMartModel {
    private M4Interface m4Interface = M4Interface.getInstance();
    private Point point;
    private String casename;
    private Case thecase;
    private Chain chain;
    private MiningMartApplication app;
    private int transcounter;
    private boolean deleteInDatabase = true;

    public MiningMartChain(MiningMartApplication app, Case thecase, Chain chain, String casename, Point point, Rectangle bounds, ModelFigureElement parent) {
        super(chain.getName(), bounds, parent);
        this.thecase = thecase;
        this.chain = chain;
        this.point = point;
        this.app = app;
        this.casename = casename;
        this.transcounter = 0;
        this.addAttribute(new ModelAssociationEnd(this, "incoming", 3, true, StepTransition.class, "end"));
        this.addAttribute(new ModelAssociationEnd(this, "outgoing", 3, true, StepTransition.class, "start"));
        try {
            ((ModelPrimitiveAttribute)this.getAttribute("notes")).setString(chain.getDocumentation());
        }
        catch (M4Exception error) {
            // empty catch block
        }
        ((ModelPrimitiveAttribute)this.getAttribute(Resource.getString("ATTR_COLOR"))).setColor(Color.WHITE);
    }

    public void setDeleteInDatabase(boolean bool, boolean propagate) {
        this.deleteInDatabase = bool;
        if (propagate) {
            int i;
            for (i = 0; i < this.getConnectionCount(); ++i) {
                ((StepTransition)this.getConnection(i)).setDeleteInDatabase(bool);
            }
            for (i = 0; i < this.getChildCount(); ++i) {
                ModelFigureElement child = this.getChild(i);
                if (child instanceof MiningMartChain) {
                    ((MiningMartChain)child).setDeleteInDatabase(bool, true);
                }
                if (!(child instanceof MiningMartStep)) continue;
                ((MiningMartStep)child).setDeleteInDatabase(bool);
            }
        }
    }

    public boolean canDeleteInDatabase() {
        return this.deleteInDatabase;
    }

    public int getTransitionCounter() {
        return this.transcounter;
    }

    public int incrementTransitionCounter() {
        ++this.transcounter;
        return this.transcounter;
    }

    public int decrementTransitionCounter() {
        if (this.transcounter > 0) {
            --this.transcounter;
        }
        return this.transcounter;
    }

    public MiningMartApplication getMMartApplication() {
        return this.app;
    }

    public void initTheChain() {
        try {
            Point p;
            Collection c = this.chain.getDirectSubChains();
            Iterator iter = c.iterator();
            int i = 10;
            while (iter.hasNext()) {
                Chain chain = (Chain)iter.next();
                p = chain.getPoint();
                if (p == null) {
                    p = new Point(i, i);
                    chain.setPoint(p);
                }
                MiningMartChain mchain = new MiningMartChain(this.app, this.thecase, chain, this.chain.getTheCase().getName(), p, new Rectangle(p.x, p.y, 35, 35), this);
                mchain.initTheChain();
                this.addMiningMartChain(this, mchain);
                i += 60;
            }
            c = this.chain.getTopLevelSteps();
            iter = c.iterator();
            i = 10;
            while (iter.hasNext()) {
                Step step = (Step)iter.next();
                p = step.getPoint();
                if (p == null) {
                    p = new Point(i, i);
                    step.setPoint(p);
                }
                MiningMartStep mstep = new MiningMartStep(this.app, step, this, p, new Rectangle(p.x, p.y, 35, 35));
                this.addMiningMartStep(this, mstep);
                i += 60;
            }
            this.organizeTransitions(false);
        }
        catch (M4Exception error) {
            M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
        }
    }

    public void organizeTransitions(boolean check) throws M4Exception {
        int childs = this.getChildCount();
        MiningMartStep mstep1 = null;
        MiningMartStep mstep2 = null;
        MiningMartChain mchain1 = null;
        MiningMartChain mchain2 = null;
        Step step1 = null;
        Step step2 = null;
        Chain chain1 = null;
        Chain chain2 = null;
        boolean bchain1 = false;
        boolean bchain2 = false;
        boolean bstep1 = false;
        boolean bstep2 = false;
        for (int a = 0; a < childs; ++a) {
            ModelFigureElement elem1 = this.getChild(a);
            if (elem1 instanceof MiningMartChain) {
                mchain1 = (MiningMartChain)elem1;
                chain1 = mchain1.getChain();
                bchain1 = true;
                bstep1 = false;
            }
            if (elem1 instanceof MiningMartStep) {
                mstep1 = (MiningMartStep)elem1;
                step1 = mstep1.getStep();
                bchain1 = false;
                bstep1 = true;
            }
            for (int j = 0; j < childs; ++j) {
                StepTransition transition;
                ModelFigureElement elem2 = this.getChild(j);
                if (elem2 instanceof MiningMartChain) {
                    mchain2 = (MiningMartChain)elem2;
                    chain2 = mchain2.getChain();
                    bchain2 = true;
                    bstep2 = false;
                }
                if (elem2 instanceof MiningMartStep) {
                    mstep2 = (MiningMartStep)elem2;
                    step2 = mstep2.getStep();
                    bchain2 = false;
                    bstep2 = true;
                }
                boolean create = true;
                if (bchain1 && bchain2 && chain1.dependencyExists(chain2)) {
                    if (mchain1.getName().equals(mchain2.getName())) continue;
                    if (check) {
                        boolean bl = create = !this.existsTransition(mchain1, mchain2);
                    }
                    if (create) {
                        this.incrementTransitionCounter();
                        transition = new StepTransition(this.app, this.thecase, Resource.getString("DEPENDENCY") + "(" + this.getTransitionCounter() + ")", this, mchain1, mchain2);
                        this.addStepTransition(transition);
                    }
                }
                if (bchain1 && bstep2 && chain1.dependencyExists(step2)) {
                    if (check) {
                        boolean bl = create = !this.existsTransition(mchain1, mstep2);
                    }
                    if (create) {
                        this.incrementTransitionCounter();
                        transition = new StepTransition(this.app, this.thecase, Resource.getString("DEPENDENCY") + "(" + this.getTransitionCounter() + ")", this, mchain1, mstep2);
                        this.addStepTransition(transition);
                    }
                }
                if (bstep1 && bchain2 && step1.dependencyExists(chain2)) {
                    if (check) {
                        boolean bl = create = !this.existsTransition(mstep1, mchain2);
                    }
                    if (create) {
                        this.incrementTransitionCounter();
                        transition = new StepTransition(this.app, this.thecase, Resource.getString("DEPENDENCY") + "(" + this.getTransitionCounter() + ")", this, mstep1, mchain2);
                        this.addStepTransition(transition);
                    }
                }
                if (!bstep1 || !bstep2 || !this.thecase.containsDependency(step1, step2) || mstep1.getName().equals(mstep2.getName())) continue;
                if (check) {
                    boolean bl = create = !this.existsTransition(mstep1, mstep2);
                }
                if (!create) continue;
                this.incrementTransitionCounter();
                transition = new StepTransition(this.app, this.thecase, Resource.getString("DEPENDENCY") + "(" + this.getTransitionCounter() + ")", this, mstep1, mstep2);
                this.addStepTransition(transition);
            }
        }
    }

    public boolean existsTransition(ModelFigureElement start, ModelFigureElement end) {
        StepTransition trans = null;
        for (int c = 0; c < this.getConnectionCount(); ++c) {
            trans = (StepTransition)this.getConnection(c);
            if (!trans.getStartName().equals(start.getName()) || !trans.getEndName().equals(end.getName())) continue;
            return true;
        }
        return false;
    }

    public MiningMartStep addMiningMartStep(ModelFigureElement parent, MiningMartStep step) {
        if (!(parent instanceof MiningMartChain)) {
            return null;
        }
        for (int i = 0; i < this.getListenerCount(); ++i) {
            this.getListener(i).onCreateChild(this, step);
        }
        if (step.canSetParent(this) && this.canAddChild(step)) {
            step.setParent(this);
        } else {
            step.destroy();
            step = null;
        }
        return step;
    }

    public MiningMartStep createMiningMartStep(ModelFigureElement parent, String opname, String stepName, Point position, Rectangle bounds) {
        Step step;
        if (opname == null) {
            return null;
        }
        if (stepName == null) {
            stepName = new String(opname);
        }
        try {
            stepName = this.chain.getTheCase().getValidName(stepName, Step.class);
            step = this.chain.getTheCase().createStep(stepName);
            this.chain.addStep(step);
            step.setTheCase(this.chain.getTheCase());
            step.setTheOperator(this.m4Interface.findOperator(opname));
        }
        catch (M4Exception error) {
            M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
            JOptionPane.showMessageDialog(this.app, error.getMessage(), Resource.getString("DIALOG_ERROR_TITLE"), 0);
            return null;
        }
        MiningMartStep result = new MiningMartStep(this.app, step, parent, position, bounds);
        result.setName(stepName);
        return this.addMiningMartStep(parent, result);
    }

    public MiningMartStep createMiningMartStep(ModelFigureElement parent, Step step, Point position, Rectangle bounds) {
        MiningMartStep result = new MiningMartStep(this.app, step, parent, position, bounds);
        return this.addMiningMartStep(parent, result);
    }

    public MiningMartChain addMiningMartChain(ModelFigureElement parent, MiningMartChain chain) {
        if (!(parent instanceof Model)) {
            return null;
        }
        for (int i = 0; i < this.getListenerCount(); ++i) {
            this.getListener(i).onCreateChild(this, chain);
        }
        if (chain.canSetParent(this) && this.canAddChild(chain)) {
            chain.setParent(this);
        } else {
            chain.destroy();
            chain = null;
        }
        return chain;
    }

    public MiningMartChain createMiningMartChain(ModelFigureElement parent, String name, Point point, Rectangle bounds) {
        Chain subchain;
        try {
            name = this.chain.getTheCase().getValidName(name, Chain.class);
            subchain = this.chain.createSubChain(name, new LinkedList());
        }
        catch (M4Exception error) {
            M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
            JOptionPane.showMessageDialog(this.app, error.getMessage(), Resource.getString("DIALOG_ERROR_TITLE"), 0);
            return null;
        }
        MiningMartChain result = new MiningMartChain(this.app, this.thecase, subchain, this.casename, point, bounds, parent);
        result.initTheChain();
        return this.addMiningMartChain(parent, result);
    }

    public MiningMartChain createMiningMartChain(ModelFigureElement parent, Chain chain, Point point, Rectangle bounds) {
        MiningMartChain result = new MiningMartChain(this.app, this.thecase, chain, this.casename, point, bounds, parent);
        result.initTheChain();
        return this.addMiningMartChain(parent, result);
    }

    public StepTransition addStepTransition(StepTransition transition) {
        for (int i = 0; i < this.getListenerCount(); ++i) {
            this.getListener(i).onCreateConnection(this, transition);
        }
        return transition;
    }

    public StepTransition createTransition(String name, ModelFigureElement start, ModelFigureElement end, boolean existsTransition) {
        StepTransition result;
        boolean adding;
        if (name == null) {
            this.incrementTransitionCounter();
            name = Resource.getString("DEPENDENCY") + "(" + this.getTransitionCounter() + ")";
        }
        if ((adding = (result = new StepTransition(this.app, this.thecase, name, this, start, end)).addTransitionToCase()) && !existsTransition) {
            result.setName(name);
            result.setStart(start);
            result.setEnd(end);
            return this.addStepTransition(result);
        }
        return null;
    }

    public boolean canSetParent(ModelFigureElement parent) {
        return true;
    }

    public Point getOrigin() {
        return this.point;
    }

    public String getType() {
        return Resource.getString("CHAIN");
    }

    public String getName() {
        if (this.chain != null) {
            return this.chain.getName();
        }
        return "";
    }

    public void setName(String name) {
        if (this.chain != null) {
            this.chain.setName(name);
        }
        super.setName(name);
    }

    public void primitiveAttributeChanged(ModelPrimitiveAttribute mpa) {
        super.primitiveAttributeChanged(mpa);
        if (mpa.getName().equals(Resource.getString("ATTR_NAME")) && this.chain != null) {
            this.setName(mpa.getString());
        }
    }

    public Case getTheCase() {
        return this.thecase;
    }

    public Chain getChain() {
        return this.chain;
    }

    M4Data getAttachedM4Object() {
        return this.getChain();
    }

    public boolean canDestroy() {
        return this.app.getViewMode() != 1;
    }

    public void destroy() {
        int i;
        if (this.app.getViewMode() == 1) {
            return;
        }
        Model parentmodel = (Model)this.getParent();
        for (i = parentmodel.getConnectionCount() - 1; i >= 0; --i) {
            StepTransition trans = (StepTransition)parentmodel.getConnection(i);
            if (!trans.getStart().getName().equals(this.getName()) && !trans.getEnd().getName().equals(this.getName())) continue;
            trans.destroy();
        }
        super.destroy();
        for (i = 0; i < this.getListenerCount(); ++i) {
            this.getListener(i).onDestroy(this);
        }
        if (this.canDeleteInDatabase()) {
            try {
                String chainname = this.chain.getName();
                this.chain.deleteSoon();
                M4Interface.print.doPrint(Print.COMPILER_CASE_CONTROL, Resource.getString("DELETED_CHAIN") + " " + chainname);
            }
            catch (M4Exception error) {
                M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
            }
        }
    }

    public void dissolveMiningMartChain(MiningMartChain mchain) throws M4Exception {
        int i;
        LinkedList<GraphicalM4Object> subelements = new LinkedList<GraphicalM4Object>();
        for (i = 0; i < mchain.getChildCount(); ++i) {
            ModelFigureElement modelFigureElement = mchain.getChild(i);
            if (modelFigureElement instanceof MiningMartChain) {
                subelements.add(((MiningMartChain)modelFigureElement).getChain());
            }
            if (!(modelFigureElement instanceof MiningMartStep)) continue;
            subelements.add(((MiningMartStep)modelFigureElement).getStep());
        }
        this.app.getMiningMartCase().setDeleteInDatabase(false, true);
        this.chain.resolveSubChain(mchain.getChain());
        mchain.destroy();
        for (i = 0; i < this.getListenerCount(); ++i) {
            this.getListener(i).onRemoveChild(this, mchain);
        }
        this.app.getMiningMartCase().setDeleteInDatabase(true, true);
        for (Object e : subelements) {
            if (e instanceof Chain) {
                Chain subchain = (Chain)e;
                MiningMartChain submchain = this.createMiningMartChain((ModelFigureElement)this, subchain, subchain.getPoint(), new Rectangle(35, 35));
                for (int i2 = 0; i2 < this.getListenerCount(); ++i2) {
                    this.getListener(i2).onAddChild(submchain, this);
                }
            }
            if (!(e instanceof Step)) continue;
            Step substep = (Step)e;
            MiningMartStep submstep = this.createMiningMartStep(this, substep, substep.getPoint(), new Rectangle(35, 35));
            for (int i2 = 0; i2 < this.getListenerCount(); ++i2) {
                this.getListener(i2).onAddChild(submstep, this);
            }
        }
        this.organizeTransitions(true);
    }
}

