/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.gui.figures;

import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.gui.model.MiningMartStep;
import edu.udo.cs.miningmart.m4.M4Interface;
import edu.udo.cs.miningmart.m4.Step;
import edu.udo.cs.miningmart.m4.utils.Print;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.image.ImageObserver;
import javax.swing.ImageIcon;
import org.jhotdraw.figures.RectangleFigure;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.framework.FigureChangeEvent;
import org.jhotdraw.util.Iconkit;
import org.musoft.limo.application.Resource;
import org.musoft.limo.drawing.ModelDrawing;
import org.musoft.limo.drawing.ModelFigure;
import org.musoft.limo.model.ModelElement;
import org.musoft.limo.model.ModelFigureElement;
import org.musoft.limo.model.ModelPrimitiveAttribute;

public class StepFigure
extends ModelFigure
implements ImageObserver {
    public static boolean NO_DIRTYING = false;
    private String filename;
    private transient Image bound;
    private transient Image image;
    private Rectangle fDisplayBox;
    private Point origin;
    private Point corner;
    private String op_name;
    private String name;

    public StepFigure(ModelFigureElement element, ModelDrawing drawing) {
        super(element, drawing);
        this.op_name = ((ModelPrimitiveAttribute)element.getAttribute("Operator")).getString();
        this.name = element.getName();
        this.bound = this.getStepBoundImage();
        this.image = this.getStepFigureImage();
        this.filename = this.getStepFigureFileName();
        this.setPresentFigure();
        this.setSizeable(false);
        this.setLabelPosition(130);
        this.setLabel(this.getElement().getName());
    }

    public void bringToFront() {
        NO_DIRTYING = true;
        super.bringToFront();
        NO_DIRTYING = false;
    }

    public MiningMartStep getMiningMartStep() {
        return (MiningMartStep)this.getElement();
    }

    public String getStepFigureFileName() {
        String f = Resource.getString("ICON_OP_" + this.op_name.toUpperCase());
        if (f.equals("ICON_OP_" + this.op_name.toUpperCase())) {
            f = Resource.getString("ICON_OP_GENERICOPERATOR");
        }
        return this.getClass().getResource(f).getFile();
    }

    public Image getStepFigureImage() {
        String img = null;
        if (this.op_name != null) {
            img = Resource.getString("ICON_OP_" + this.op_name.toUpperCase());
        }
        if (img != null && img.equals("ICON_OP_" + this.op_name.toUpperCase())) {
            img = Resource.getString("ICON_OP_GENERICOPERATOR");
        }
        return new ImageIcon(this.getClass().getResource(img)).getImage();
    }

    private Image getStepBoundImage() {
        String img = null;
        img = Resource.getString("ICON_OP_BOUND");
        if (img != null && img.equals("ICON_OP_BOUND")) {
            img = Resource.getString("ICON_OP_GENERICOPERATOR");
        }
        return new ImageIcon(this.getClass().getResource(img)).getImage();
    }

    private void setPresentFigure() {
        Rectangle bounds = this.getElement().getBounds();
        this.origin = bounds.getLocation();
        this.corner = new Point(this.origin.x + bounds.width, this.origin.y + bounds.height);
        this.basicDisplayBox(this.origin, this.corner);
        RectangleFigure rf = new RectangleFigure(this.origin, this.corner);
        this.setPresentationFigure((Figure)rf);
    }

    public void basicDisplayBox(Point origin, Point corner) {
        super.basicDisplayBox(origin, corner);
    }

    public void moveBy(int dx, int dy) {
        if (dx == 0 && dy == 0) {
            return;
        }
        super.moveBy(dx, dy);
        this.origin = new Point(this.origin.x + dx, this.origin.y + dy);
        this.corner = new Point(this.corner.x + dx, this.corner.y + dy);
        MiningMartStep step = (MiningMartStep)this.getElement();
        step.setBounds(new Rectangle(this.origin.x, this.origin.y, 35, 35));
        try {
            step.getStep().setPoint(this.origin);
        }
        catch (M4Exception error) {
            M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
        }
    }

    public void draw(Graphics g) {
        super.draw(g);
        if (this.image == null) {
            this.image = Iconkit.instance().getImage(this.filename);
        }
        g.setColor(Resource.getColor("DRAWING_VIEW_BACKGROUNDCOLOR"));
        g.fillRect(this.origin.x, this.origin.y, 35, 35);
        g.setColor((Color)this.getElement().getAttribute(Resource.getString("ATTR_COLOR")).getValue());
        g.fillRect(this.origin.x + 3, this.origin.y + 3, 29, 29);
        if (this.bound != null) {
            g.drawImage(this.bound, this.origin.x, this.origin.y, 35, 35, this);
        }
        if (this.image != null) {
            g.drawImage(this.image, this.origin.x + 5, this.origin.y + 5, 25, 25, this);
        }
        g.setColor(Color.BLACK);
        try {
            Polygon polygon;
            Step step = ((MiningMartStep)this.getElement()).getStep();
            if (step.hasPredecessorOutsideChain()) {
                g.drawLine(this.origin.x - 20, this.origin.y + 15, this.origin.x, this.origin.y + 15);
                polygon = new Polygon();
                polygon.addPoint(this.origin.x, this.origin.y + 15);
                polygon.addPoint(this.origin.x - 8, this.origin.y + 12);
                polygon.addPoint(this.origin.x - 8, this.origin.y + 18);
                g.fillPolygon(polygon);
            }
            if (step.hasSuccessorOutsideChain()) {
                g.drawLine(this.origin.x + 35, this.origin.y + 15, this.origin.x + 55, this.origin.y + 15);
                polygon = new Polygon();
                polygon.addPoint(this.origin.x + 55, this.origin.y + 15);
                polygon.addPoint(this.origin.x + 47, this.origin.y + 12);
                polygon.addPoint(this.origin.x + 47, this.origin.y + 18);
                g.fillPolygon(polygon);
            }
        }
        catch (M4Exception error) {
            M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
        }
    }

    public boolean imageUpdate(Image img, int flags, int x, int y, int w, int h) {
        if ((flags & 0x30) != 0) {
            this.invalidate();
            if (this.listener() != null) {
                this.listener().figureRequestUpdate(new FigureChangeEvent((Figure)this));
            }
        }
        return (flags & 0xA0) == 0;
    }

    public void onSetName(ModelElement sender) {
        this.setLabel(this.getElement().getName());
        this.invalidate();
    }

    public void onSetAttribute(ModelElement sender, ModelPrimitiveAttribute mpa) {
        super.onSetAttribute(sender, mpa);
        String s = mpa.getName();
        if (s.equals("Operator")) {
            this.op_name = ((ModelPrimitiveAttribute)this.getElement().getAttribute("Operator")).getString();
        }
    }
}

