/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.gui.figures;

import edu.udo.cs.miningmart.gui.model.MiningMartBaseAttribute;
import edu.udo.cs.miningmart.gui.model.MiningMartMultiColumnFeature;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import org.jhotdraw.figures.RectangleFigure;
import org.jhotdraw.framework.Figure;
import org.musoft.limo.application.Resource;
import org.musoft.limo.drawing.ModelDrawing;
import org.musoft.limo.drawing.ModelFigure;
import org.musoft.limo.model.ModelElement;
import org.musoft.limo.model.ModelFigureElement;

public class FeatureFigure
extends ModelFigure {
    private boolean baseattribute;

    public FeatureFigure(MiningMartBaseAttribute element, ModelDrawing drawing) {
        this((ModelFigureElement)element, drawing);
        this.baseattribute = true;
    }

    public FeatureFigure(MiningMartMultiColumnFeature element, ModelDrawing drawing) {
        this((ModelFigureElement)element, drawing);
        this.baseattribute = false;
    }

    private FeatureFigure(ModelFigureElement element, ModelDrawing drawing) {
        super(element, drawing);
        Rectangle bounds = this.getElement().getBounds();
        Point origin = bounds.getLocation();
        Point corner = new Point(origin.x + bounds.width, origin.y + bounds.height);
        this.setPresentationFigure((Figure)new RectangleFigure(origin, corner));
        Rectangle rect = element.getBounds();
        Point start = new Point(rect.x, rect.y + rect.height - 1);
        Point end = new Point(rect.x + rect.width, rect.y + rect.height - 1);
        this.setAttribute("FrameColor", element.getAttribute(Resource.getString("ATTR_COLOR")).getValue());
        this.setLabelPosition(65);
        if (element instanceof MiningMartBaseAttribute) {
            this.setLabel("BA: " + this.getElement().getName());
        } else {
            this.setLabel("MCF: " + this.getElement().getName());
        }
        this.setSizeable(false);
    }

    public MiningMartBaseAttribute getMiningMartBaseAttribute() {
        if (this.baseattribute) {
            return (MiningMartBaseAttribute)this.getElement();
        }
        return null;
    }

    public MiningMartMultiColumnFeature getMiningMartMultiColumnFeature() {
        if (!this.baseattribute) {
            return (MiningMartMultiColumnFeature)this.getElement();
        }
        return null;
    }

    public void onSetName(ModelElement sender) {
        if (sender == this.getElement()) {
            if (this.baseattribute) {
                this.setLabel("BA: " + sender.getName());
            } else {
                this.setLabel("MCF: " + sender.getName());
            }
        }
    }

    public void moveBy(int dx, int dy) {
    }

    public void draw(Graphics g) {
        super.draw(g);
        Stroke saved = ((Graphics2D)g).getStroke();
        ((Graphics2D)g).setStroke(new BasicStroke(1.0f, 1, 1, 0.0f, new float[]{1.0f, 5.0f}, 0.0f));
        Rectangle rect = this.displayBox();
        g.setColor(Color.BLACK);
        g.drawLine(rect.x, rect.y + rect.height, rect.x + rect.width, rect.y + rect.height);
        ((Graphics2D)g).setStroke(saved);
    }
}

