/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.gui.figures;

import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.gui.figures.StepFigure;
import edu.udo.cs.miningmart.gui.model.MiningMartConcept;
import edu.udo.cs.miningmart.m4.Concept;
import edu.udo.cs.miningmart.m4.M4Interface;
import edu.udo.cs.miningmart.m4.utils.Print;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.ImageObserver;
import javax.swing.ImageIcon;
import org.jhotdraw.figures.LineFigure;
import org.jhotdraw.figures.RoundRectangleFigure;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.framework.FigureChangeEvent;
import org.musoft.limo.application.Resource;
import org.musoft.limo.drawing.ModelDrawing;
import org.musoft.limo.drawing.ModelFigure;
import org.musoft.limo.model.ModelElement;
import org.musoft.limo.model.ModelFigureElement;

public class ConceptFigure
extends ModelFigure
implements ImageObserver {
    private Concept concept;
    private Point origin;
    private LineFigure mainLine;
    private Image conceptimage;
    private final Color selected_color = Resource.getColor("CONCEPT_SELECTED_COLOR");
    private final Color not_selected_color = Resource.getColor("CONCEPT_NOTSELECTED_COLOR");
    private boolean isSelected = false;

    public ConceptFigure(ModelFigureElement element, ModelDrawing drawing) {
        super(element, drawing);
        this.concept = ((MiningMartConcept)this.getElement()).getConcept();
        Rectangle bounds = this.getElement().getBounds();
        this.origin = bounds.getLocation();
        Point corner = new Point(this.origin.x + bounds.width, this.origin.y + bounds.height);
        this.setPresentationFigure((Figure)new RoundRectangleFigure(this.origin, corner));
        this.setLabelPosition(33);
        this.setLabel(this.getElement().getName());
        this.mainLine = new LineFigure();
        this.add((Figure)this.mainLine);
        this.setLabelPosition(33);
        this.setLabel(this.getElement().getName());
        this.setSizeable(false);
        this.initConceptImage();
    }

    private void initConceptImage() {
        String img = null;
        if (this.concept.getType().equals("MINING")) {
            img = Resource.getString("CONCEPT_MINING_ICON");
        } else {
            try {
                img = this.concept.getColumnSets().size() > 0 ? Resource.getString("CONCEPT_DB_CONNECTED_ICON") : Resource.getString("CONCEPT_DB_NOTCONNECTED_ICON");
            }
            catch (M4Exception error) {
                M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
                img = Resource.getString("CONCEPT_DB_NOTCONNECTED_ICON");
            }
        }
        this.conceptimage = new ImageIcon(this.getClass().getResource(img)).getImage();
    }

    public void onSetName(ModelElement sender) {
        if (sender == this.getElement()) {
            this.setLabel(sender.getName());
        }
    }

    public void isSelected() {
        this.isSelected = true;
        this.update();
    }

    public void deSelected() {
        this.isSelected = false;
        this.update();
    }

    public MiningMartConcept getMiningMartConcept() {
        return (MiningMartConcept)this.getElement();
    }

    public void moveBy(int dx, int dy) {
        if (dx == 0 && dy == 0) {
            return;
        }
        super.moveBy(dx, dy);
        this.origin = new Point(this.origin.x + dx, this.origin.y + dy);
        MiningMartConcept concept = (MiningMartConcept)this.getElement();
        try {
            concept.getConcept().setPoint(this.origin);
        }
        catch (M4Exception error) {
            M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
        }
    }

    public void bringToFront() {
        StepFigure.NO_DIRTYING = true;
        super.bringToFront();
        StepFigure.NO_DIRTYING = false;
    }

    public void draw(Graphics g) {
        super.draw(g);
        Rectangle rect = this.displayBox();
        if (this.isSelected) {
            g.setColor(this.selected_color);
        } else {
            g.setColor(this.not_selected_color);
        }
        g.fillRoundRect(rect.x, rect.y, rect.width, rect.height, 10, 10);
        this.getLabelFigure().draw(g);
        g.setColor(Color.BLACK);
        g.drawRoundRect(rect.x, rect.y, rect.width, rect.height, 10, 10);
        g.drawLine(rect.x, rect.y + 20, rect.x + rect.width - 1, rect.y + 20);
        g.drawLine(rect.x + 30, rect.y + 20, rect.x + 30, rect.y + rect.height - 1);
        this.initConceptImage();
        if (this.conceptimage != null) {
            g.drawImage(this.conceptimage, this.origin.x + 3, this.origin.y + 23, 24, 24, this);
        }
        try {
            int nr_bas = this.concept.getAllBaseAttributes().size();
            int nr_colsets = this.concept.getColumnSets().size();
            Font font = g.getFont().deriveFont(0);
            g.setFont(font);
            g.drawString(Integer.toString(nr_bas) + " BaseAttributes", rect.x + 35, rect.y + 40);
            g.drawString(Integer.toString(nr_colsets) + " ColumnSets", rect.x + 35, rect.y + 60);
        }
        catch (M4Exception error) {
            M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
        }
    }

    public boolean imageUpdate(Image img, int flags, int x, int y, int width, int height) {
        if ((flags & 0x30) != 0) {
            this.invalidate();
            if (this.listener() != null) {
                this.listener().figureRequestUpdate(new FigureChangeEvent((Figure)this));
            }
        }
        return (flags & 0xA0) == 0;
    }
}

