/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.gui.figures;

import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.gui.figures.StepFigure;
import edu.udo.cs.miningmart.gui.model.MiningMartChain;
import edu.udo.cs.miningmart.m4.M4Interface;
import edu.udo.cs.miningmart.m4.utils.Print;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import javax.swing.ImageIcon;
import org.jhotdraw.figures.ImageFigure;
import org.jhotdraw.framework.Figure;
import org.musoft.limo.drawing.ModelDrawing;
import org.musoft.limo.drawing.ModelFigure;
import org.musoft.limo.model.Model;
import org.musoft.limo.model.ModelElement;

public class ChainFigure
extends ModelFigure {
    private ImageFigure present;
    private Point origin;

    public ChainFigure(Model element, ModelDrawing drawing) {
        super(element, drawing);
        Image img = new ImageIcon(this.getClass().getResource("/images/Operators/chain1.png")).getImage();
        String filename = this.getClass().getResource("/images/Operators/chain1.png").getFile();
        this.origin = ((MiningMartChain)element).getOrigin();
        this.present = new ImageFigure(img, filename, this.origin);
        this.setPresentationFigure((Figure)this.present);
        this.setLabelPosition(130);
        this.setLabel(element.getName());
    }

    public MiningMartChain getMiningMartChain() {
        return (MiningMartChain)this.getElement();
    }

    public void onSetName(ModelElement sender) {
        this.setLabel(this.getElement().getName());
        this.invalidate();
    }

    public void moveBy(int dx, int dy) {
        if (dx == 0 && dy == 0) {
            return;
        }
        super.moveBy(dx, dy);
        this.origin = new Point(this.origin.x + dx, this.origin.y + dy);
        try {
            if (this.getElement() instanceof MiningMartChain) {
                MiningMartChain c = (MiningMartChain)this.getElement();
                c.getChain().setPoint(this.origin);
            }
        }
        catch (M4Exception error) {
            M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
        }
    }

    public void bringToFront() {
        StepFigure.NO_DIRTYING = true;
        super.bringToFront();
        StepFigure.NO_DIRTYING = false;
    }

    public void draw(Graphics g) {
        super.draw(g);
        g.setColor(Color.BLACK);
        try {
            Polygon polygon;
            if (((MiningMartChain)this.getElement()).getChain().hasPredecessorOutside()) {
                g.drawLine(this.origin.x - 20, this.origin.y + 15, this.origin.x, this.origin.y + 15);
                polygon = new Polygon();
                polygon.addPoint(this.origin.x, this.origin.y + 15);
                polygon.addPoint(this.origin.x - 8, this.origin.y + 12);
                polygon.addPoint(this.origin.x - 8, this.origin.y + 18);
                g.fillPolygon(polygon);
            }
            if (((MiningMartChain)this.getElement()).getChain().hasSuccessorOutside()) {
                g.drawLine(this.origin.x + 35, this.origin.y + 15, this.origin.x + 55, this.origin.y + 15);
                polygon = new Polygon();
                polygon.addPoint(this.origin.x + 55, this.origin.y + 15);
                polygon.addPoint(this.origin.x + 47, this.origin.y + 12);
                polygon.addPoint(this.origin.x + 47, this.origin.y + 18);
                g.fillPolygon(polygon);
            }
        }
        catch (M4Exception error) {
            M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
        }
    }
}

