/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.gui.concepteditor;

import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.gui.application.MiningMartApplication;
import edu.udo.cs.miningmart.gui.concepteditor.ConceptPanel;
import edu.udo.cs.miningmart.gui.util.M4ObjectComparator;
import edu.udo.cs.miningmart.m4.BaseAttribute;
import edu.udo.cs.miningmart.m4.Column;
import edu.udo.cs.miningmart.m4.Columnset;
import edu.udo.cs.miningmart.m4.Concept;
import edu.udo.cs.miningmart.m4.M4Interface;
import edu.udo.cs.miningmart.m4.PrimaryKey;
import edu.udo.cs.miningmart.m4.utils.Print;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import org.musoft.limo.application.Resource;
import org.musoft.limo.drawing.ModelDrawingView;

public class MappingPanel
extends ConceptPanel
implements ActionListener {
    private MiningMartApplication app;
    private Concept concept;
    private Columnset columnset;
    private MappingTable table;
    private JButton okButton;
    private JButton cancelButton;
    private JButton clearButton;
    private Column[] allcolumns;
    private String[] allcolumnNames;
    private String[] baseattributes;
    private String[] ba_types;
    private Column[] Columns;
    private String[] columns;
    private String[] coltypes;
    private boolean[] primaryKey;

    public MappingPanel(MiningMartApplication app, Concept concept) {
        this.app = app;
        this.concept = concept;
        this.initData();
        this.initComponents();
    }

    private void initData() {
        LinkedList coll;
        try {
            coll = this.concept.getColumnSets();
        }
        catch (M4Exception error) {
            M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
            coll = new LinkedList();
        }
        if (coll.size() != 1) {
            this.baseattributes = new String[0];
            this.ba_types = new String[0];
            this.Columns = new Column[0];
            this.columns = new String[0];
            this.coltypes = new String[0];
            this.primaryKey = new boolean[0];
            return;
        }
        try {
            BaseAttribute ba;
            this.columnset = (Columnset)coll.toArray()[0];
            Collection columnscoll = this.columnset.getConnectableColumns();
            this.allcolumns = new Column[columnscoll.size()];
            this.allcolumnNames = new String[columnscoll.size() + 1];
            this.allcolumnNames[0] = Resource.getString("MAPPING_NONE");
            Iterator iter = columnscoll.iterator();
            int index = 0;
            while (iter.hasNext()) {
                this.allcolumns[index] = (Column)iter.next();
                this.allcolumnNames[index + 1] = this.allcolumns[index].getName() + "-" + this.allcolumns[index].getColumnDataTypeName().toLowerCase();
                ++index;
            }
            Collection bas = this.concept.getAllBaseAttributes();
            iter = bas.iterator();
            int nr_bas = 0;
            while (iter.hasNext()) {
                ba = (BaseAttribute)iter.next();
                if (!ba.getType().equalsIgnoreCase("DB")) continue;
                ++nr_bas;
            }
            this.baseattributes = new String[nr_bas];
            this.ba_types = new String[nr_bas];
            this.Columns = new Column[nr_bas];
            this.columns = new String[nr_bas];
            this.coltypes = new String[nr_bas];
            this.primaryKey = new boolean[nr_bas];
            PrimaryKey pkey = this.concept.getPrimaryKey();
            LinkedList pkeycoll = pkey == null ? new LinkedList() : pkey.getAllColumns();
            LinkedList baslist = new LinkedList();
            baslist.addAll(bas);
            Collections.sort(baslist, new M4ObjectComparator());
            iter = baslist.iterator();
            index = 0;
            while (iter.hasNext()) {
                ba = (BaseAttribute)iter.next();
                if (!ba.getType().equals("DB")) continue;
                this.baseattributes[index] = ba.getName();
                this.ba_types[index] = ba.getConceptualDataTypeName().toLowerCase();
                Collection columncoll = ba.getColumns();
                if (columncoll.size() != 1) {
                    this.Columns[index] = null;
                    this.columns[index] = Resource.getString("MAPPING_NONE");
                    this.coltypes[index] = "";
                    this.primaryKey[index] = false;
                } else {
                    Column column;
                    this.Columns[index] = column = (Column)columncoll.toArray()[0];
                    this.columns[index] = column.getName();
                    this.coltypes[index] = "-" + column.getColumnDataTypeName().toLowerCase();
                    this.primaryKey[index] = pkeycoll.contains(column);
                }
                ++index;
            }
        }
        catch (M4Exception error) {
            M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
        }
    }

    private void initComponents() {
        this.setLayout(new BorderLayout(5, 5));
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel infopanel = new JPanel();
        infopanel.setLayout(new GridLayout(2, 1, 5, 5));
        infopanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)infopanel, "North");
        JLabel label = new JLabel();
        label.setText(Resource.getString("BASEATTRIBUTE") + " - " + Resource.getString("MAPPING"));
        Font font = new Font("SansSerif", 0, 15);
        label.setFont(font);
        label.setHorizontalAlignment(0);
        infopanel.add(label);
        label = new JLabel();
        label.setText(this.concept.getName());
        font = new Font("SansSerif", 0, 13);
        label.setFont(font);
        label.setHorizontalAlignment(0);
        label.setForeground(Color.BLUE);
        infopanel.add(label);
        this.clearButton = new JButton(Resource.getString("CLEAR"));
        this.clearButton.addActionListener(this);
        this.okButton = new JButton(Resource.getString("OK"));
        this.okButton.addActionListener(this);
        this.okButton.setEnabled(false);
        this.cancelButton = new JButton(Resource.getString("CANCEL"));
        this.cancelButton.addActionListener(this);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(this.clearButton);
        buttonPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        buttonPanel.add(this.okButton);
        buttonPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        buttonPanel.add(this.cancelButton);
        this.add((Component)buttonPanel, "South");
        if (this.app.getViewMode() != 0) {
            this.clearButton.setEnabled(false);
            this.okButton.setEnabled(false);
        }
        this.table = new MappingTable();
        this.table.createEditor();
        JScrollPane scrollpane = new JScrollPane(this.table);
        this.add((Component)scrollpane, "Center");
    }

    public Concept getConcept() {
        return this.concept;
    }

    public String toString() {
        return Resource.getString("MAPPING");
    }

    private void createMapping() {
        try {
            LinkedList<BaseAttribute> pkeyslist = new LinkedList<BaseAttribute>();
            for (int i = 0; i < this.baseattributes.length; ++i) {
                BaseAttribute baseatt = this.concept.getBaseAttribute(this.baseattributes[i]);
                if (this.Columns[i] == null) {
                    baseatt.setColumns(new LinkedList());
                    continue;
                }
                LinkedList<Column> list = new LinkedList<Column>();
                list.add(this.Columns[i]);
                baseatt.setColumns(list);
                if (!this.primaryKey[i]) continue;
                pkeyslist.add(baseatt);
            }
            PrimaryKey pkey = this.concept.createPrimaryKey(pkeyslist);
            this.columnset.setPrimaryKey(pkey);
        }
        catch (M4Exception error) {
            M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
        }
        this.app.getModel().setDirty(true);
        ((ModelDrawingView)this.app.getDrawingView()).repaint();
    }

    private void clearMapping() {
        for (int row = 0; row < this.baseattributes.length; ++row) {
            this.Columns[row] = null;
            this.columns[row] = Resource.getString("MAPPING_NONE");
            this.coltypes[row] = "";
            this.primaryKey[row] = false;
        }
        ((AbstractTableModel)this.table.getModel()).fireTableDataChanged();
        this.okButton.setEnabled(true);
    }

    public void actionPerformed(ActionEvent event) {
        if (!(event.getSource() instanceof JButton)) {
            return;
        }
        JButton source = (JButton)event.getSource();
        if (source.getText().equals(this.cancelButton.getText())) {
            this.app.removeComponentFromTab(this);
        }
        if (source.getText().equals(this.okButton.getText())) {
            this.createMapping();
            this.app.removeComponentFromTab(this);
        }
        if (source.getText().equals(this.clearButton.getText())) {
            this.clearMapping();
        }
    }

    private class MappingTableModel
    extends AbstractTableModel {
        private MappingTableModel() {
        }

        public int getColumnCount() {
            return 3;
        }

        public int getRowCount() {
            return MappingPanel.this.baseattributes.length;
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                return MappingPanel.this.baseattributes[rowIndex] + "-" + MappingPanel.this.ba_types[rowIndex];
            }
            if (columnIndex == 1) {
                return MappingPanel.this.columns[rowIndex] + MappingPanel.this.coltypes[rowIndex];
            }
            if (columnIndex == 2) {
                return new Boolean(MappingPanel.this.primaryKey[rowIndex]);
            }
            return null;
        }

        public Class getColumnClass(int columnIndex) {
            if (columnIndex == 2) {
                return Boolean.class;
            }
            return String.class;
        }

        public String getColumnName(int column) {
            if (column == 0) {
                return Resource.getString("BASEATTRIBUTE");
            }
            if (column == 1) {
                return Resource.getString("COLUMN");
            }
            if (column == 2) {
                return Resource.getString("PRIMARYKEY");
            }
            return ":-)";
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            if (MappingPanel.this.app.getViewMode() != 0) {
                return false;
            }
            return columnIndex != 0;
        }

        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            MappingPanel.this.okButton.setEnabled(true);
            if (columnIndex == 1) {
                String value = (String)aValue;
                if (value.equals(Resource.getString("MAPPING_NONE"))) {
                    ((MappingPanel)MappingPanel.this).Columns[rowIndex] = null;
                    ((MappingPanel)MappingPanel.this).columns[rowIndex] = Resource.getString("MAPPING_NONE");
                    ((MappingPanel)MappingPanel.this).coltypes[rowIndex] = "";
                    ((MappingPanel)MappingPanel.this).primaryKey[rowIndex] = false;
                    this.fireTableDataChanged();
                    return;
                }
                ((MappingPanel)MappingPanel.this).columns[rowIndex] = value.substring(0, value.indexOf(45));
                try {
                    String nameOfColumnToConnect = MappingPanel.this.columns[rowIndex];
                    String typeOfColumnToConnect = value.substring(value.indexOf(45) + 1, value.length());
                    Column existingColumn = MappingPanel.this.columnset.getColumn(nameOfColumnToConnect);
                    if (existingColumn == null) {
                        existingColumn = MappingPanel.this.columnset.createColumn(nameOfColumnToConnect, typeOfColumnToConnect.toUpperCase());
                    }
                    ((MappingPanel)MappingPanel.this).Columns[rowIndex] = existingColumn;
                }
                catch (M4Exception error) {
                    M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
                    ((MappingPanel)MappingPanel.this).Columns[rowIndex] = null;
                    ((MappingPanel)MappingPanel.this).columns[rowIndex] = Resource.getString("MAPPING_NONE");
                    ((MappingPanel)MappingPanel.this).coltypes[rowIndex] = "";
                    ((MappingPanel)MappingPanel.this).primaryKey[rowIndex] = false;
                    this.fireTableDataChanged();
                    return;
                }
                ((MappingPanel)MappingPanel.this).coltypes[rowIndex] = value.substring(value.indexOf(45), value.length());
            }
            if (columnIndex == 2 && MappingPanel.this.Columns[rowIndex] != null) {
                ((MappingPanel)MappingPanel.this).primaryKey[rowIndex] = (Boolean)aValue;
            } else {
                this.fireTableDataChanged();
            }
        }
    }

    private class MappingTable
    extends JTable {
        public MappingTable() {
            this.setSelectionMode(0);
            this.getTableHeader().setReorderingAllowed(false);
            this.setRowHeight(this.getRowHeight() + 4);
            this.setModel(new MappingTableModel());
            this.getColumnModel().getColumn(2).setMaxWidth(90);
        }

        public void createEditor() {
            TableColumn tablecolumn = this.getColumnModel().getColumn(1);
            JComboBox<String> comboBox = new JComboBox<String>(MappingPanel.this.allcolumnNames);
            tablecolumn.setCellEditor(new DefaultCellEditor(comboBox));
        }
    }
}

