/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.gui.concepteditor;

import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.gui.application.MiningMartApplication;
import edu.udo.cs.miningmart.gui.util.M4ObjectComparator;
import edu.udo.cs.miningmart.m4.BaseAttribute;
import edu.udo.cs.miningmart.m4.Column;
import edu.udo.cs.miningmart.m4.ColumnStatistics2;
import edu.udo.cs.miningmart.m4.Columnset;
import edu.udo.cs.miningmart.m4.Concept;
import edu.udo.cs.miningmart.m4.EstimatedStatistics;
import edu.udo.cs.miningmart.m4.Step;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import org.musoft.limo.application.Resource;

public class EstimatedStatisticsDialog
extends JDialog
implements ActionListener {
    private static final String EMPTY_ATTRIBUTE = "<AttributeName>";
    private static final String EMPTY_VALUE = "<NewValue>";
    private Vector baseAttributes;
    private EstimatedStatistics myEstStat;
    private String conceptName;
    private JButton closeButton;
    private JButton storeButton;
    private JButton addValueButton;
    private JButton removeValueButton;
    private JTable statalltable;
    private JTable stat1table;
    private JTable stat2table;
    private Statistics2TableModel stat2tableModel;
    private MiningMartApplication myApplication;

    public EstimatedStatisticsDialog(MiningMartApplication app, Concept theConcept, Step estimationsForThisStep) {
        super((Frame)app, true);
        this.myApplication = app;
        try {
            this.conceptName = theConcept.getName();
            this.myEstStat = theConcept.getEstimatedStatistics(estimationsForThisStep);
            if (this.myEstStat == null) {
                throw new M4Exception("Got no estimations from this concept (NULL was returned).");
            }
            this.baseAttributes = new Vector();
            this.baseAttributes.addAll(theConcept.getAllBaseAttributes());
            Collections.sort(this.baseAttributes, new M4ObjectComparator());
        }
        catch (M4Exception error) {
            JOptionPane.showMessageDialog(app, "Error estimating statistics: " + error.getMessage(), "Estimation problem", 0);
            return;
        }
        this.updateDisplay();
    }

    private void updateDisplay() {
        this.setVisible(false);
        this.initComponents();
        this.setDefaultCloseOperation(2);
        this.pack();
        this.setSize(750, 600);
        Dimension size = this.getSize();
        this.setLocation((Toolkit.getDefaultToolkit().getScreenSize().width - size.width) / 2, (Toolkit.getDefaultToolkit().getScreenSize().height - size.height) / 2);
        this.setVisible(true);
    }

    private void initComponents() {
        JPanel toppanel = new JPanel();
        toppanel.setLayout(new BorderLayout(5, 5));
        toppanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.getContentPane().add(toppanel);
        JPanel infopanel = new JPanel();
        infopanel.setLayout(new GridLayout(2, 1, 5, 5));
        infopanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        toppanel.add((Component)infopanel, "North");
        JLabel label = new JLabel();
        label.setText(Resource.getString("ESTIMATES"));
        Font font = new Font("SansSerif", 1, 15);
        label.setFont(font);
        label.setHorizontalAlignment(0);
        infopanel.add(label);
        label = new JLabel();
        label.setText(this.conceptName);
        font = new Font("SansSerif", 0, 13);
        label.setFont(font);
        label.setHorizontalAlignment(0);
        label.setForeground(Color.BLUE);
        infopanel.add(label);
        boolean columnsetExists = false;
        try {
            if (this.myEstStat.getConcept().getCurrentColumnSet() != null) {
                columnsetExists = true;
            }
        }
        catch (M4Exception m4e) {
            JOptionPane.showMessageDialog(this.myApplication, "M4 error accessing columnset: " + m4e.getMessage(), "Internal error", 0);
        }
        boolean isEditable = !this.myApplication.isReadOnly();
        this.closeButton = new JButton(Resource.getString("CLOSE"));
        this.closeButton.addActionListener(this);
        this.storeButton = new JButton(Resource.getString("ESTIMATE_STORE"));
        this.storeButton.addActionListener(this);
        this.storeButton.setEnabled(columnsetExists && isEditable);
        this.addValueButton = new JButton(Resource.getString("ESTIMATE_ADD_VALUE"));
        this.addValueButton.addActionListener(this);
        this.addValueButton.setEnabled(isEditable);
        this.removeValueButton = new JButton(Resource.getString("ESTIMATE_REMOVE_VALUE"));
        this.removeValueButton.addActionListener(this);
        this.removeValueButton.setEnabled(isEditable);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        buttonPanel.add(this.storeButton);
        buttonPanel.add(this.addValueButton);
        buttonPanel.add(this.removeValueButton);
        buttonPanel.add(this.closeButton);
        toppanel.add((Component)buttonPanel, "South");
        JPanel midpanel = new JPanel();
        midpanel.setLayout(new BorderLayout(5, 5));
        toppanel.add((Component)midpanel, "Center");
        this.statalltable = new JTable();
        this.statalltable.setSelectionMode(2);
        this.statalltable.getTableHeader().setReorderingAllowed(false);
        this.statalltable.setRowHeight(this.statalltable.getRowHeight() + 2);
        this.statalltable.setModel(new StatisticsAllTableModel());
        JScrollPane scrollpane = new JScrollPane(this.statalltable);
        scrollpane.setPreferredSize(new Dimension(scrollpane.getWidth(), 36));
        midpanel.add((Component)scrollpane, "North");
        JPanel centerPanel = new JPanel();
        centerPanel.setLayout(new GridLayout(2, 1, 5, 5));
        midpanel.add((Component)centerPanel, "Center");
        JPanel stat1panel = new JPanel();
        stat1panel.setLayout(new BorderLayout(5, 5));
        centerPanel.add(stat1panel);
        label = new JLabel();
        label.setText(Resource.getString("ESTIMATED_ATTRIBDATA"));
        font = new Font("SansSerif", 1, 12);
        label.setFont(font);
        label.setHorizontalAlignment(0);
        stat1panel.add((Component)label, "North");
        this.stat1table = new JTable();
        this.stat1table.setSelectionMode(2);
        this.stat1table.getTableHeader().setReorderingAllowed(false);
        this.stat1table.setRowHeight(this.stat1table.getRowHeight() + 2);
        this.stat1table.setModel(new Statistics1TableModel());
        stat1panel.add((Component)new JScrollPane(this.stat1table), "Center");
        JPanel stat2panel = new JPanel();
        stat2panel.setLayout(new BorderLayout(5, 5));
        centerPanel.add(stat2panel);
        label = new JLabel();
        label.setText(Resource.getString("ESTIMATED_DISTRIBUTION"));
        font = new Font("SansSerif", 1, 12);
        label.setFont(font);
        label.setHorizontalAlignment(0);
        stat2panel.add((Component)label, "North");
        this.stat2tableModel = new Statistics2TableModel();
        this.stat2table = new JTable(this.stat2tableModel);
        this.stat2table.setSelectionMode(2);
        this.stat2table.getTableHeader().setReorderingAllowed(false);
        this.stat2table.setRowHeight(this.stat2table.getRowHeight() + 2);
        this.stat2table.setModel(this.stat2tableModel);
        stat2panel.add((Component)new JScrollPane(this.stat2table), "Center");
    }

    public void actionPerformed(ActionEvent event) {
        if (!(event.getSource() instanceof JButton)) {
            return;
        }
        JButton source = (JButton)event.getSource();
        if (source.getText().equals(this.closeButton.getText())) {
            this.dispose();
        }
        if (source.getText().equals(this.storeButton.getText())) {
            this.takeEstimatedStatisticsAsActualStatistics();
        }
        if (source.getText().equals(this.addValueButton.getText())) {
            this.stat2tableModel.addValue();
        }
        if (source.getText().equals(this.removeValueButton.getText())) {
            int[] selected = this.stat2table.getSelectedRows();
            this.stat2tableModel.removeValues(selected);
        }
    }

    private void takeEstimatedStatisticsAsActualStatistics() {
        try {
            Columnset myCs = this.myEstStat.getConcept().getCurrentColumnSet();
            if (myCs == null) {
                return;
            }
            if (this.myEstStat.getNumberOfRows() != Integer.MIN_VALUE) {
                myCs.setStatisticsAll(this.myEstStat.getNumberOfRows());
            }
            for (BaseAttribute myBa : this.baseAttributes) {
                Vector vl;
                String attribName = myBa.getName();
                Column myCol = myBa.getCurrentColumn();
                if (!myCs.hasColumn(myCol)) continue;
                if (Double.compare(this.myEstStat.getBiggestValue(attribName), Double.NaN) != 0) {
                    myCol.setMaxValue(this.myEstStat.getBiggestValue(attribName));
                }
                if (Double.compare(this.myEstStat.getLowestValue(attribName), Double.NaN) != 0) {
                    myCol.setMinValue(this.myEstStat.getLowestValue(attribName));
                }
                if (this.myEstStat.getNumberOfMissingValues(attribName) != Integer.MIN_VALUE) {
                    myCol.setNumberOfMissingValues(this.myEstStat.getNumberOfMissingValues(attribName));
                }
                if ((vl = this.myEstStat.getValueList(attribName)) == null) continue;
                Vector<ColumnStatistics2> allDistribInfos = new Vector<ColumnStatistics2>();
                for (String value : vl) {
                    if (this.myEstStat.getNumberOfOccurrences(attribName, value) == Integer.MIN_VALUE) continue;
                    ColumnStatistics2 cs2 = (ColumnStatistics2)((Object)myCs.getM4Db().createNewInstance(ColumnStatistics2.class));
                    cs2.setDistributionValue(value);
                    cs2.setDistributionCount(this.myEstStat.getNumberOfOccurrences(attribName, value));
                    allDistribInfos.add(cs2);
                }
                myCol.setDistributionStatistics(allDistribInfos);
            }
        }
        catch (M4Exception m4e) {
            JOptionPane.showMessageDialog(this.myApplication, "M4 error when storing these estimations as actual statistics: " + m4e.getMessage(), "Internal error", 0);
        }
    }

    private String getEstimatedValue(String dataTypeOfAttrib, int value) {
        if (this.isNotNumericType(dataTypeOfAttrib)) {
            return Resource.getString("ESTIMATE_NOT_APPLICABLE");
        }
        if (value == Integer.MIN_VALUE) {
            return Resource.getString("ESTIMATE_UNKNOWN");
        }
        return new Integer(value).toString();
    }

    private String getEstimatedValue(int value) {
        if (value == Integer.MIN_VALUE) {
            return Resource.getString("ESTIMATE_UNKNOWN");
        }
        return new Integer(value).toString();
    }

    private String getEstimatedValue(String dataTypeOfAttrib, double value) {
        if (this.isNotNumericType(dataTypeOfAttrib)) {
            return Resource.getString("ESTIMATE_NOT_APPLICABLE");
        }
        if (new Double(value).equals(new Double(Double.NaN))) {
            return Resource.getString("ESTIMATE_UNKNOWN");
        }
        return new Double(value).toString();
    }

    private boolean isNotNumericType(String conceptualDataType) {
        if (conceptualDataType == null) {
            return false;
        }
        return conceptualDataType.equals("CATEGORIAL") || conceptualDataType.equals("NOMINAL") || conceptualDataType.equals("KEYATTRIB");
    }

    private String getEstimatedValue(String value) {
        if (value == null || value.equals("<unknown>")) {
            return Resource.getString("ESTIMATE_UNKNOWN");
        }
        return value;
    }

    private int getIntValue(Object theValue) {
        String value = null;
        try {
            value = (String)theValue;
        }
        catch (ClassCastException cce) {
            JOptionPane.showMessageDialog(this.myApplication, "Please enter a String!", "Wrong format", 0);
            return -1;
        }
        if (value.equals(Resource.getString("ESTIMATE_UNKNOWN")) || value.equals(Resource.getString("ESTIMATE_NOT_APPLICABLE"))) {
            return Integer.MIN_VALUE;
        }
        int val = -1;
        try {
            val = Integer.parseInt(value);
        }
        catch (NumberFormatException nfe) {
            JOptionPane.showMessageDialog(this.myApplication, "Please enter a nonnegative integer!", "Wrong format", 0);
        }
        return val;
    }

    private double getDoubleValue(Object theValue) {
        String value = null;
        try {
            value = (String)theValue;
        }
        catch (ClassCastException cce) {
            JOptionPane.showMessageDialog(this.myApplication, "Please enter a String!", "Wrong format", 0);
            return Double.MAX_VALUE;
        }
        if (value.equals(Resource.getString("ESTIMATE_UNKNOWN")) || value.equals(Resource.getString("ESTIMATE_NOT_APPLICABLE"))) {
            return Double.NaN;
        }
        double val = Double.MAX_VALUE;
        try {
            val = Double.parseDouble(value);
        }
        catch (NumberFormatException nfe) {
            JOptionPane.showMessageDialog(this.myApplication, "Please enter a double!", "Wrong format", 0);
        }
        return val;
    }

    private class Statistics2TableModel
    extends AbstractTableModel {
        private String[] attribNames;
        private String[] values;

        public Statistics2TableModel() {
            this.initNameArrays();
        }

        public void initNameArrays() {
            Vector<String> attrNames = new Vector<String>();
            Vector<String> attrValues = new Vector<String>();
            for (BaseAttribute myBa : EstimatedStatisticsDialog.this.baseAttributes) {
                String name = myBa.getName();
                Vector vals = EstimatedStatisticsDialog.this.myEstStat.getValueList(name);
                for (String value : vals) {
                    attrNames.add(name);
                    attrValues.add(value);
                }
            }
            this.attribNames = new String[attrNames.size()];
            this.values = new String[attrValues.size()];
            if (this.attribNames.length != this.values.length) {
                System.err.println("Error reading estimated statistics!");
                return;
            }
            for (int i = 0; i < this.attribNames.length; ++i) {
                this.attribNames[i] = (String)attrNames.get(i);
                this.values[i] = (String)attrValues.get(i);
            }
        }

        public Class getColumnClass(int columnIndex) {
            return String.class;
        }

        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return Resource.getString("ESTIMATED_ATTRIBNAME");
                }
                case 1: {
                    return Resource.getString("ESTIMATED_VALUE");
                }
                case 2: {
                    return Resource.getString("ESTIMATED_OCCUR");
                }
            }
            return ":-)";
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return !EstimatedStatisticsDialog.this.myApplication.isReadOnly();
        }

        public int getColumnCount() {
            return 3;
        }

        public int getRowCount() {
            return this.attribNames.length;
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return this.attribNames[rowIndex];
                }
                case 1: {
                    return this.values[rowIndex];
                }
                case 2: {
                    if (this.attribNames[rowIndex].trim().equals("") || this.values[rowIndex].trim().equals("")) {
                        return "";
                    }
                    return EstimatedStatisticsDialog.this.getEstimatedValue(null, EstimatedStatisticsDialog.this.myEstStat.getNumberOfOccurrences(this.attribNames[rowIndex], this.values[rowIndex]));
                }
            }
            return ":-)";
        }

        public void setValueAt(Object theValue, int rowIndex, int columnIndex) {
            String val = (String)theValue;
            if (columnIndex == 0) {
                if (val.equals(EstimatedStatisticsDialog.EMPTY_ATTRIBUTE)) {
                    return;
                }
                if (!this.checkOccurs(val, EstimatedStatisticsDialog.this.baseAttributes)) {
                    String oldValue = (String)this.getValueAt(rowIndex, columnIndex);
                    this.setValueAt(oldValue, rowIndex, columnIndex);
                }
            }
            if (columnIndex == 1) {
                if (val.equals(EstimatedStatisticsDialog.EMPTY_VALUE)) {
                    return;
                }
                boolean valueIsNew = true;
                Vector vl = EstimatedStatisticsDialog.this.myEstStat.getValueList(this.attribNames[rowIndex]);
                if (vl != null && !vl.isEmpty()) {
                    for (String existingValue : vl) {
                        if (!existingValue.equalsIgnoreCase(val)) continue;
                        valueIsNew = false;
                    }
                }
                if (valueIsNew) {
                    String noOfOcc = (String)this.getValueAt(rowIndex, 2);
                    int newEntry = Integer.MIN_VALUE;
                    if (noOfOcc != null && !noOfOcc.trim().equals("")) {
                        newEntry = EstimatedStatisticsDialog.this.getIntValue(noOfOcc);
                    }
                    try {
                        Iterator attrIt = EstimatedStatisticsDialog.this.baseAttributes.iterator();
                        BaseAttribute theBA = null;
                        while (attrIt.hasNext()) {
                            BaseAttribute oneBa = (BaseAttribute)attrIt.next();
                            if (!oneBa.getName().equals(this.attribNames[rowIndex])) continue;
                            theBA = oneBa;
                        }
                        if (theBA == null) {
                            throw new M4Exception("Could not find BA with name '" + this.attribNames[rowIndex] + "'!");
                        }
                        String type = theBA.getConceptualDataTypeName();
                        if (!EstimatedStatisticsDialog.this.isNotNumericType(type)) {
                            double num = EstimatedStatisticsDialog.this.getDoubleValue(val);
                            if (Double.compare(num, Double.MAX_VALUE) == 0) {
                                return;
                            }
                            val = "" + num;
                        }
                        EstimatedStatisticsDialog.this.myEstStat.addValueInformation(this.attribNames[rowIndex], val, newEntry);
                    }
                    catch (M4Exception m4e) {
                        JOptionPane.showMessageDialog(EstimatedStatisticsDialog.this.myApplication, "M4 error: " + m4e.getMessage(), "Internal error", 0);
                    }
                } else {
                    int oldValue = EstimatedStatisticsDialog.this.getIntValue(this.getValueAt(rowIndex, 2));
                    EstimatedStatisticsDialog.this.myEstStat.setNumberOfOccurrences(this.attribNames[rowIndex], val, oldValue);
                }
                this.values[rowIndex] = val;
            }
            if (columnIndex == 2) {
                int intval = EstimatedStatisticsDialog.this.getIntValue(theValue);
                if (intval != -1) {
                    EstimatedStatisticsDialog.this.myEstStat.setNumberOfOccurrences(this.attribNames[rowIndex], this.values[rowIndex], intval);
                } else {
                    String oldValue = (String)this.getValueAt(rowIndex, columnIndex);
                    this.setValueAt(oldValue, rowIndex, columnIndex);
                }
            }
        }

        public void addValue() {
            int i;
            String[] temp1 = new String[this.attribNames.length + 1];
            String[] temp2 = new String[this.values.length + 1];
            for (i = 0; i < this.attribNames.length; ++i) {
                temp1[i] = this.attribNames[i];
                temp2[i] = this.values[i];
            }
            temp1[this.attribNames.length] = EstimatedStatisticsDialog.EMPTY_ATTRIBUTE;
            temp2[this.attribNames.length] = EstimatedStatisticsDialog.EMPTY_VALUE;
            this.attribNames = new String[temp1.length];
            this.values = new String[temp1.length];
            for (i = 0; i < temp1.length; ++i) {
                this.attribNames[i] = temp1[i];
                this.values[i] = temp2[i];
            }
            this.fireTableDataChanged();
        }

        public void removeValues(int[] rowIndicesToBeRemoved) {
            int i;
            int newLength = this.attribNames.length - rowIndicesToBeRemoved.length;
            String[] temp1 = new String[newLength];
            String[] temp2 = new String[newLength];
            int newIndex = 0;
            for (i = 0; i < this.attribNames.length; ++i) {
                if (this.contains(rowIndicesToBeRemoved, i)) {
                    EstimatedStatisticsDialog.this.myEstStat.removeValue(this.values[i], this.attribNames[i]);
                    continue;
                }
                temp1[newIndex] = this.attribNames[i];
                temp2[newIndex] = this.values[i];
                ++newIndex;
            }
            this.attribNames = new String[temp1.length];
            this.values = new String[temp1.length];
            for (i = 0; i < temp1.length; ++i) {
                this.attribNames[i] = temp1[i];
                this.values[i] = temp2[i];
            }
            this.fireTableDataChanged();
        }

        private boolean contains(int[] array, int number) {
            for (int i = 0; i < array.length; ++i) {
                if (array[i] != number) continue;
                return true;
            }
            return false;
        }

        private boolean checkOccurs(String name, Collection baseattribs) {
            for (BaseAttribute ba : baseattribs) {
                if (!ba.getName().equals(name)) continue;
                return true;
            }
            JOptionPane.showMessageDialog(EstimatedStatisticsDialog.this.myApplication, "Unknown attribute!", "Wrong input", 0);
            return false;
        }
    }

    private class Statistics1TableModel
    extends AbstractTableModel {
        private Statistics1TableModel() {
        }

        public Class getColumnClass(int columnIndex) {
            return String.class;
        }

        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return Resource.getString("ESTIMATED_ATTRIBNAME");
                }
                case 1: {
                    return Resource.getString("ESTIMATED_MIN");
                }
                case 2: {
                    return Resource.getString("ESTIMATED_MAX");
                }
                case 3: {
                    return Resource.getString("ESTIMATED_MISSING");
                }
            }
            return ":-)";
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return !EstimatedStatisticsDialog.this.myApplication.isReadOnly() && columnIndex > 0;
        }

        public int getColumnCount() {
            return 4;
        }

        public int getRowCount() {
            return EstimatedStatisticsDialog.this.baseAttributes.size();
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            try {
                BaseAttribute ba = (BaseAttribute)EstimatedStatisticsDialog.this.baseAttributes.get(rowIndex);
                String type = ba.getConceptualDataTypeName();
                String attrName = ba.getName();
                switch (columnIndex) {
                    case 0: {
                        return attrName;
                    }
                    case 1: {
                        return EstimatedStatisticsDialog.this.getEstimatedValue(type, EstimatedStatisticsDialog.this.myEstStat.getLowestValue(attrName));
                    }
                    case 2: {
                        return EstimatedStatisticsDialog.this.getEstimatedValue(type, EstimatedStatisticsDialog.this.myEstStat.getBiggestValue(attrName));
                    }
                    case 3: {
                        return EstimatedStatisticsDialog.this.getEstimatedValue(EstimatedStatisticsDialog.this.myEstStat.getNumberOfMissingValues(attrName));
                    }
                }
                return Resource.getString("ESTIMATE_UNKNOWN");
            }
            catch (M4Exception m4e) {
                return Resource.getString("ESTIMATE_UNKNOWN");
            }
        }

        public void setValueAt(Object theValue, int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                return;
            }
            BaseAttribute ba = (BaseAttribute)EstimatedStatisticsDialog.this.baseAttributes.get(rowIndex);
            String attrName = ba.getName();
            if (columnIndex == 1 || columnIndex == 2) {
                double val = EstimatedStatisticsDialog.this.getDoubleValue(theValue);
                if (Double.compare(val, Double.MAX_VALUE) == 0) {
                    String oldValue = (String)this.getValueAt(rowIndex, columnIndex);
                    this.setValueAt(oldValue, rowIndex, columnIndex);
                } else if (columnIndex == 1) {
                    EstimatedStatisticsDialog.this.myEstStat.setLowestValue(attrName, val);
                } else {
                    EstimatedStatisticsDialog.this.myEstStat.setBiggestValue(attrName, val);
                }
            }
            if (columnIndex == 3) {
                int val = EstimatedStatisticsDialog.this.getIntValue(theValue);
                if (val != -1) {
                    EstimatedStatisticsDialog.this.myEstStat.setNumberOfMissingValues(attrName, val);
                } else {
                    String oldValue = (String)this.getValueAt(rowIndex, columnIndex);
                    this.setValueAt(oldValue, rowIndex, columnIndex);
                }
            }
        }
    }

    private class StatisticsAllTableModel
    extends AbstractTableModel {
        private StatisticsAllTableModel() {
        }

        public Class getColumnClass(int columnIndex) {
            return String.class;
        }

        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return Resource.getString("ESTIMATED_ROWCOUNT");
                }
            }
            return ":-)";
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return !EstimatedStatisticsDialog.this.myApplication.isReadOnly();
        }

        public int getColumnCount() {
            return 1;
        }

        public int getRowCount() {
            return 1;
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return EstimatedStatisticsDialog.this.getEstimatedValue(null, EstimatedStatisticsDialog.this.myEstStat.getNumberOfRows());
                }
            }
            return Resource.getString("ESTIMATE_UNKNOWN");
        }

        public void setValueAt(Object theValue, int rowIndex, int columnIndex) {
            if (columnIndex != 0) {
                return;
            }
            int val = EstimatedStatisticsDialog.this.getIntValue(theValue);
            if (val != -1) {
                EstimatedStatisticsDialog.this.myEstStat.setNumberOfRows(val);
            } else {
                String oldValue = (String)this.getValueAt(rowIndex, columnIndex);
                this.setValueAt(oldValue, rowIndex, columnIndex);
            }
        }
    }
}

