/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.gui.concepteditor;

import edu.udo.cs.miningmart.db.DB;
import edu.udo.cs.miningmart.exception.DbConnectionClosed;
import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.gui.application.MiningMartApplication;
import edu.udo.cs.miningmart.gui.model.MiningMartConcept;
import edu.udo.cs.miningmart.gui.model.MiningMartRelation;
import edu.udo.cs.miningmart.gui.stepsettings.ListSelectDialog;
import edu.udo.cs.miningmart.m4.BaseAttribute;
import edu.udo.cs.miningmart.m4.Case;
import edu.udo.cs.miningmart.m4.Column;
import edu.udo.cs.miningmart.m4.Columnset;
import edu.udo.cs.miningmart.m4.Concept;
import edu.udo.cs.miningmart.m4.ForeignKey;
import edu.udo.cs.miningmart.m4.ForeignKeyLink;
import edu.udo.cs.miningmart.m4.M4Interface;
import edu.udo.cs.miningmart.m4.Relation;
import edu.udo.cs.miningmart.m4.utils.Print;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.musoft.limo.application.Resource;

public class CreateRelationDialog
extends JDialog
implements ActionListener,
ListSelectionListener {
    public static final int CANCEL = 0;
    public static final int OK = 1;
    private int exitAction;
    private MiningMartApplication app;
    private MiningMartConcept fromconcept;
    private MiningMartConcept toconcept;
    private MiningMartRelation mmartrelation;
    private Relation relation;
    private JButton cancelButton;
    private JButton okButton;
    private JButton foreignKeyButton1;
    private JButton foreignKeyButton2;
    private JRadioButton one2manyButton;
    private JRadioButton many2manyButton;
    private JTextField nameField;
    private JList fromlist;
    private JList tolist;
    private JList crosslist;
    private JList fromattlist;
    private JList toattlist;
    private JPanel fromlistPanel;
    private JPanel tolistPanel;
    private JPanel crosslistPanel;
    private JPanel attlistPanel;
    private JLabel fromlabel;
    private JLabel tolabel;
    private JLabel crosslabel1;
    private JLabel crosslabel2;
    private JLabel fromattlabel;
    private JLabel toattlabel;
    private JLabel crossattlabel;
    private JCheckBox useTrashObjectsBox;
    private boolean tablesloaded;
    private boolean tableselected;
    private boolean edit;
    private String includeMmTablesText;

    public CreateRelationDialog(MiningMartApplication app, MiningMartConcept fromconcept, MiningMartConcept toconcept) {
        super(app, Resource.getString("CREATE_RELATION_DIALOG_TITLE"), true);
        this.app = app;
        this.fromconcept = fromconcept;
        this.toconcept = toconcept;
        this.mmartrelation = null;
        this.relation = null;
        this.tablesloaded = false;
        this.tableselected = false;
        this.edit = false;
        this.initComponents();
        this.setDefaultCloseOperation(2);
        this.pack();
        this.setSize(850, 450);
        Dimension size = this.getSize();
        this.setLocation((Toolkit.getDefaultToolkit().getScreenSize().width - size.width) / 2, (Toolkit.getDefaultToolkit().getScreenSize().height - size.height) / 2);
        this.setVisible(true);
    }

    public CreateRelationDialog(MiningMartApplication app, MiningMartRelation relation) {
        super(app, Resource.getString("EDIT_RELATION_DIALOG_TITLE"), true);
        this.app = app;
        this.fromconcept = (MiningMartConcept)relation.getStart();
        this.toconcept = (MiningMartConcept)relation.getEnd();
        this.mmartrelation = relation;
        this.relation = relation.getRelation();
        this.tablesloaded = false;
        this.tableselected = false;
        this.edit = true;
        this.initComponents();
        try {
            boolean relationalLevelExists = this.fillComponents();
            if (!relationalLevelExists && this.relation.getTheFromConcept().getType().equals("MINING") && this.relation.getTheToConcept().getType().equals("MINING")) {
                JOptionPane.showMessageDialog(this.app, Resource.getString("INFO_NO_COLS_RELATION_MSG"), Resource.getString("INFO_NO_COLS_RELATION_TITLE"), 1);
            }
        }
        catch (M4Exception m4e) {
            // empty catch block
        }
        this.setDefaultCloseOperation(2);
        this.pack();
        this.setSize(850, 450);
        Dimension size = this.getSize();
        this.setLocation((Toolkit.getDefaultToolkit().getScreenSize().width - size.width) / 2, (Toolkit.getDefaultToolkit().getScreenSize().height - size.height) / 2);
        this.setVisible(true);
    }

    private void initComponents() {
        JPanel toppanel = new JPanel();
        toppanel.setLayout(new BorderLayout(15, 15));
        toppanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.getContentPane().add(toppanel);
        JLabel toplabel = new JLabel();
        String toplabelText = this.edit ? Resource.getString("EDIT_RELATION_DIALOG_SUBTITLE") : Resource.getString("CREATE_RELATION_DIALOG_SUBTITLE");
        toplabel.setText(toplabelText);
        Font opfont = new Font("SansSerif", 0, 15);
        toplabel.setFont(opfont);
        toplabel.setForeground(Color.BLUE);
        toplabel.setHorizontalAlignment(0);
        toplabel.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        toppanel.add((Component)toplabel, "North");
        this.cancelButton = new JButton(Resource.getString("CANCEL"));
        this.okButton = new JButton(Resource.getString("OK"));
        this.okButton.setEnabled(true);
        this.cancelButton.addActionListener(this);
        this.okButton.addActionListener(this);
        JPanel bottom = new JPanel();
        bottom.setLayout(new BoxLayout(bottom, 0));
        bottom.add(Box.createHorizontalGlue());
        bottom.add(this.okButton);
        bottom.add(Box.createRigidArea(new Dimension(10, 0)));
        bottom.add(this.cancelButton);
        bottom.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5));
        toppanel.add((Component)bottom, "South");
        JPanel midpanel = new JPanel();
        midpanel.setLayout(new BorderLayout(15, 15));
        toppanel.add((Component)midpanel, "Center");
        JPanel inputPanel1 = new JPanel();
        inputPanel1.setLayout(new BorderLayout());
        midpanel.add((Component)inputPanel1, "North");
        JPanel inputPanel2 = new JPanel();
        inputPanel2.setLayout(new GridLayout(2, 1, 5, 5));
        inputPanel1.add((Component)inputPanel2, "West");
        JPanel inputPanel3 = new JPanel();
        inputPanel3.setLayout(new BorderLayout(5, 5));
        inputPanel2.add(inputPanel3);
        inputPanel3.add((Component)new JLabel("Type:"), "West");
        JPanel inputPanel4 = new JPanel();
        inputPanel4.setLayout(new GridLayout(1, 2, 5, 5));
        inputPanel3.add((Component)inputPanel4, "Center");
        this.one2manyButton = new JRadioButton(Resource.getString("ONE_TO_MANY_RELATION"));
        this.many2manyButton = new JRadioButton(Resource.getString("MANY_TO_MANY_RELATION"));
        ButtonGroup bGroup = new ButtonGroup();
        bGroup.add(this.one2manyButton);
        bGroup.add(this.many2manyButton);
        this.one2manyButton.setSelected(true);
        this.one2manyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                if (CreateRelationDialog.this.one2manyButton.isSelected()) {
                    CreateRelationDialog.this.setOne2ManyType();
                } else {
                    CreateRelationDialog.this.setMany2ManyType();
                }
            }
        });
        this.many2manyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                if (CreateRelationDialog.this.one2manyButton.isSelected()) {
                    CreateRelationDialog.this.setOne2ManyType();
                } else {
                    CreateRelationDialog.this.setMany2ManyType();
                }
            }
        });
        inputPanel4.add(this.one2manyButton);
        inputPanel4.add(this.many2manyButton);
        inputPanel3 = new JPanel();
        inputPanel3.setLayout(new BorderLayout(5, 5));
        inputPanel2.add(inputPanel3);
        inputPanel3.add((Component)new JLabel(Resource.getString("ATTR_NAME") + ":"), "West");
        this.nameField = new JTextField();
        this.nameField.setText(Resource.getString("RELATION"));
        this.nameField.setPreferredSize(new Dimension(150, this.nameField.getHeight()));
        inputPanel3.add((Component)this.nameField, "Center");
        JPanel listPanel = new JPanel();
        listPanel.setLayout(new GridLayout(1, 4, 10, 10));
        midpanel.add((Component)listPanel, "Center");
        this.fromlistPanel = new JPanel();
        this.fromlistPanel.setLayout(new BorderLayout(5, 5));
        this.fromlist = new JList();
        this.fromlist.setVisibleRowCount(10);
        this.fromlistPanel.add((Component)new JScrollPane(this.fromlist), "Center");
        JPanel labelPanel = new JPanel();
        labelPanel.setLayout(new GridLayout(2, 1));
        this.fromlistPanel.add((Component)labelPanel, "North");
        Concept concept = this.fromconcept.getConcept();
        labelPanel.add(new JLabel(Resource.getString("FROM_CONCEPT") + " " + concept.getName()));
        this.fromlabel = new JLabel(Resource.getString("FOREIGNKEYS") + ":");
        labelPanel.add(this.fromlabel);
        JButton selectButton = new JButton(Resource.getString("SELECT") + "...");
        selectButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                Concept concept = CreateRelationDialog.this.fromconcept.getConcept();
                LinkedList bas = null;
                try {
                    bas = concept.getAllBaseAttributes();
                }
                catch (M4Exception e) {
                    bas = new LinkedList();
                }
                String[] data = new String[bas.size()];
                Iterator iter = bas.iterator();
                int index = 0;
                while (iter.hasNext()) {
                    data[index] = ((BaseAttribute)iter.next()).getName();
                    ++index;
                }
                ListModel model = CreateRelationDialog.this.fromlist.getModel();
                String[] selected_data = new String[model.getSize()];
                for (int i = 0; i < selected_data.length; ++i) {
                    selected_data[i] = (String)model.getElementAt(i);
                }
                ListSelectDialog dialog = new ListSelectDialog(CreateRelationDialog.this.app, Resource.getString("FEATURE_DIALOG_TITLE"), Resource.getString("FEATURE_DIALOG_SUBTITLE"), data, selected_data, true, 0, Integer.MAX_VALUE);
                if (dialog.getExitAction() == 1) {
                    selected_data = dialog.getSelectedDataItems();
                    CreateRelationDialog.this.fromlist.setListData(selected_data);
                }
            }
        });
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(selectButton);
        this.fromlistPanel.add((Component)buttonPanel, "South");
        listPanel.add(this.fromlistPanel);
        this.tolistPanel = new JPanel();
        this.tolistPanel.setLayout(new BorderLayout(5, 5));
        concept = this.toconcept.getConcept();
        this.tolist = new JList();
        this.tolist.setVisibleRowCount(10);
        this.tolistPanel.add((Component)new JScrollPane(this.tolist), "Center");
        labelPanel = new JPanel();
        labelPanel.setLayout(new GridLayout(2, 1));
        this.tolistPanel.add((Component)labelPanel, "North");
        labelPanel.add(new JLabel(Resource.getString("TO_CONCEPT") + " " + concept.getName()));
        this.tolabel = new JLabel(Resource.getString("PRIMARYKEYS") + ":");
        labelPanel.add(this.tolabel);
        selectButton = new JButton(Resource.getString("SELECT") + "...");
        selectButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                Concept concept = CreateRelationDialog.this.toconcept.getConcept();
                LinkedList bas = null;
                try {
                    bas = concept.getAllBaseAttributes();
                }
                catch (M4Exception e) {
                    bas = new LinkedList();
                }
                String[] data = new String[bas.size()];
                Iterator iter = bas.iterator();
                int index = 0;
                while (iter.hasNext()) {
                    data[index] = ((BaseAttribute)iter.next()).getName();
                    ++index;
                }
                ListModel model = CreateRelationDialog.this.tolist.getModel();
                String[] selected_data = new String[model.getSize()];
                for (int i = 0; i < selected_data.length; ++i) {
                    selected_data[i] = (String)model.getElementAt(i);
                }
                ListSelectDialog dialog = new ListSelectDialog(CreateRelationDialog.this.app, Resource.getString("FEATURE_DIALOG_TITLE"), Resource.getString("FEATURE_DIALOG_SUBTITLE"), data, selected_data, true, 0, Integer.MAX_VALUE);
                if (dialog.getExitAction() == 1) {
                    selected_data = dialog.getSelectedDataItems();
                    CreateRelationDialog.this.tolist.setListData(selected_data);
                }
            }
        });
        buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(selectButton);
        this.tolistPanel.add((Component)buttonPanel, "South");
        listPanel.add(this.tolistPanel);
        this.crosslistPanel = new JPanel();
        this.crosslistPanel.setLayout(new BorderLayout());
        labelPanel = new JPanel();
        labelPanel.setLayout(new GridLayout(1, 1));
        this.crosslistPanel.add((Component)labelPanel, "North");
        this.crosslabel1 = new JLabel(Resource.getString("SELECT") + " " + Resource.getString("CROSSTABLE"));
        labelPanel.add(this.crosslabel1);
        this.crosslist = new JList();
        this.crosslist.setVisibleRowCount(10);
        this.crosslist.addListSelectionListener(this);
        this.crosslistPanel.add((Component)new JScrollPane(this.crosslist), "Center");
        this.includeMmTablesText = Resource.getString("CONNECTION_SHOW_MM_TABLES");
        this.useTrashObjectsBox = new JCheckBox(this.includeMmTablesText);
        this.useTrashObjectsBox.setSelected(false);
        this.useTrashObjectsBox.setToolTipText(Resource.getString("CONNECTION_SHOW_MM_TABLES_TIP"));
        this.useTrashObjectsBox.addActionListener(this);
        this.crosslistPanel.add((Component)this.useTrashObjectsBox, "South");
        listPanel.add(this.crosslistPanel);
        this.attlistPanel = new JPanel();
        this.attlistPanel.setLayout(new GridLayout(2, 1, 5, 5));
        listPanel.add(this.attlistPanel);
        JPanel fromattPanel = new JPanel();
        this.attlistPanel.add(fromattPanel);
        fromattPanel.setLayout(new BorderLayout());
        JPanel fromlabelPanel = new JPanel();
        fromlabelPanel.setLayout(new GridLayout(2, 1, 5, 5));
        this.crossattlabel = new JLabel(Resource.getString("CROSSTABLE_SELECT_KEYS"));
        fromlabelPanel.add(this.crossattlabel);
        this.fromattlabel = new JLabel(Resource.getString("CROSSTABLE_FOREIGNKEYS") + " " + this.fromconcept.getName());
        fromlabelPanel.add(this.fromattlabel);
        fromattPanel.add((Component)fromlabelPanel, "North");
        this.fromattlist = new JList();
        fromattPanel.add((Component)new JScrollPane(this.fromattlist), "Center");
        this.foreignKeyButton1 = new JButton(Resource.getString("SELECT") + "...");
        this.foreignKeyButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                String table = (String)CreateRelationDialog.this.crosslist.getSelectedValue();
                table = table.substring(0, table.indexOf(" ("));
                DB m4DB = CreateRelationDialog.this.fromconcept.getConcept().getM4Db();
                String selectstring = m4DB.getSelectStringAllColumnsForDbObject(table);
                Vector<String> columns = new Vector<String>();
                try {
                    ResultSet resultset = m4DB.executeBusinessSqlRead(selectstring);
                    while (resultset.next()) {
                        columns.add(resultset.getString(1));
                    }
                    resultset.close();
                    Collections.sort(columns);
                }
                catch (DbConnectionClosed error) {
                    M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
                }
                catch (SQLException error) {
                    M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
                }
                String[] data = new String[columns.size()];
                for (int i = 0; i < columns.size(); ++i) {
                    data[i] = (String)columns.get(i);
                }
                ListModel model = CreateRelationDialog.this.fromattlist.getModel();
                String[] selected_data = new String[model.getSize()];
                for (int i = 0; i < selected_data.length; ++i) {
                    selected_data[i] = (String)model.getElementAt(i);
                }
                int min = CreateRelationDialog.this.fromlist.getModel().getSize();
                if (min == 0) {
                    JOptionPane.showMessageDialog(CreateRelationDialog.this.app, Resource.getString("DIALOG_PRIMARYKEY_MESSAGE1") + CreateRelationDialog.this.fromconcept.getName() + Resource.getString("DIALOG_PRIMARYKEY_MESSAGE2"), Resource.getString("DIALOG_PRIMARYKEY_TITLE"), 2);
                    return;
                }
                ListSelectDialog dialog = new ListSelectDialog(CreateRelationDialog.this.app, Resource.getString("DIALOG_FOREIGNKEY_TITLE"), Resource.getString("DIALOG_FOREIGNKEY_SUBTITLE"), data, selected_data, true, min, min);
                if (dialog.getExitAction() == 1) {
                    selected_data = dialog.getSelectedDataItems();
                    CreateRelationDialog.this.fromattlist.setListData(selected_data);
                }
            }
        });
        buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(this.foreignKeyButton1);
        fromattPanel.add((Component)buttonPanel, "South");
        JPanel toattPanel = new JPanel();
        this.attlistPanel.add(toattPanel);
        toattPanel.setLayout(new BorderLayout());
        this.toattlabel = new JLabel(Resource.getString("CROSSTABLE_FOREIGNKEYS") + " " + this.toconcept.getName());
        toattPanel.add((Component)this.toattlabel, "North");
        this.toattlist = new JList();
        toattPanel.add((Component)new JScrollPane(this.toattlist), "Center");
        this.foreignKeyButton2 = new JButton(Resource.getString("SELECT") + "...");
        this.foreignKeyButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                String table = (String)CreateRelationDialog.this.crosslist.getSelectedValue();
                table = table.substring(0, table.indexOf(" ("));
                DB m4DB = CreateRelationDialog.this.fromconcept.getConcept().getM4Db();
                String selectstring = m4DB.getSelectStringAllColumnsForDbObject(table);
                Vector<String> columns = new Vector<String>();
                try {
                    ResultSet resultset = m4DB.executeBusinessSqlRead(selectstring);
                    while (resultset.next()) {
                        columns.add(resultset.getString(1));
                    }
                    resultset.close();
                    Collections.sort(columns);
                }
                catch (DbConnectionClosed error) {
                    M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
                }
                catch (SQLException error) {
                    M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
                }
                String[] data = new String[columns.size()];
                for (int i = 0; i < columns.size(); ++i) {
                    data[i] = (String)columns.get(i);
                }
                ListModel model = CreateRelationDialog.this.toattlist.getModel();
                String[] selected_data = new String[model.getSize()];
                for (int i = 0; i < selected_data.length; ++i) {
                    selected_data[i] = (String)model.getElementAt(i);
                }
                int min = CreateRelationDialog.this.tolist.getModel().getSize();
                if (min == 0) {
                    JOptionPane.showMessageDialog(CreateRelationDialog.this.app, Resource.getString("DIALOG_PRIMARYKEY_MESSAGE1") + CreateRelationDialog.this.toconcept.getName() + Resource.getString("DIALOG_PRIMARYKEY_MESSAGE2"), Resource.getString("DIALOG_PRIMARYKEY_TITLE"), 2);
                    return;
                }
                ListSelectDialog dialog = new ListSelectDialog(CreateRelationDialog.this.app, Resource.getString("DIALOG_FOREIGNKEY_TITLE"), Resource.getString("DIALOG_FOREIGNKEY_SUBTITLE"), data, selected_data, true, min, min);
                if (dialog.getExitAction() == 1) {
                    selected_data = dialog.getSelectedDataItems();
                    CreateRelationDialog.this.toattlist.setListData(selected_data);
                }
            }
        });
        buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(this.foreignKeyButton2);
        toattPanel.add((Component)buttonPanel, "South");
        this.setOne2ManyType();
    }

    public void setOne2ManyType() {
        this.crosslist.setEnabled(false);
        this.crosslabel1.setEnabled(false);
        this.useTrashObjectsBox.setEnabled(false);
        this.fromlabel.setText(Resource.getString("FOREIGNKEYS") + ":");
        this.crosslist.clearSelection();
        this.valueChanged(null);
    }

    public void setMany2ManyType() {
        this.crosslist.setEnabled(true);
        this.crosslabel1.setEnabled(true);
        this.useTrashObjectsBox.setEnabled(true);
        this.fromattlist.setEnabled(false);
        this.toattlist.setEnabled(false);
        this.fromlabel.setText(Resource.getString("PRIMARYKEYS") + ":");
        if (!this.tablesloaded) {
            this.crosslist.setListData(this.getAllTableNames());
            this.tablesloaded = true;
        }
    }

    private String[] getAllTableNames() {
        Vector colls = new Vector();
        boolean includeMmTables = this.useTrashObjectsBox.isSelected();
        try {
            colls.addAll(MiningMartApplication.m4Interface.getNamesOfBusinessTablesAndViews(includeMmTables));
            Collections.sort(colls);
        }
        catch (M4Exception error) {
            M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
            colls = new Vector();
        }
        Iterator iter = colls.iterator();
        String[] tablenames = new String[colls.size()];
        int index = 0;
        while (iter.hasNext()) {
            tablenames[index] = (String)iter.next();
            try {
                if (MiningMartApplication.m4Interface.isBusinessTable(tablenames[index])) {
                    int n = index;
                    tablenames[n] = tablenames[n] + " (" + Resource.getString("TABLE") + ")";
                } else if (MiningMartApplication.m4Interface.isBusinessView(tablenames[index])) {
                    int n = index;
                    tablenames[n] = tablenames[n] + " (" + Resource.getString("VIEW") + ")";
                }
            }
            catch (M4Exception error) {
                M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
            }
            ++index;
        }
        return tablenames;
    }

    public void valueChanged(ListSelectionEvent event) {
        if (this.crosslist.isSelectionEmpty()) {
            this.foreignKeyButton1.setEnabled(false);
            this.foreignKeyButton2.setEnabled(false);
            this.fromattlist.setEnabled(false);
            this.toattlist.setEnabled(false);
            this.crossattlabel.setEnabled(false);
            this.fromattlabel.setEnabled(false);
            this.toattlabel.setEnabled(false);
            this.fromattlist.setListData(new Vector());
            this.toattlist.setListData(new Vector());
            this.tableselected = false;
        } else {
            if (this.tableselected) {
                // empty if block
            }
            this.foreignKeyButton1.setEnabled(true);
            this.foreignKeyButton2.setEnabled(true);
            this.fromattlist.setEnabled(true);
            this.toattlist.setEnabled(true);
            this.crossattlabel.setEnabled(true);
            this.fromattlabel.setEnabled(true);
            this.toattlabel.setEnabled(true);
            this.tableselected = true;
        }
    }

    private boolean fillComponents() {
        if (this.relation == null) {
            return false;
        }
        boolean relationalLevelExists = true;
        this.nameField.setText(this.relation.getName());
        if (this.relation.isOneToManyRelation()) {
            this.one2manyButton.setSelected(true);
            this.setOne2ManyType();
            try {
                ForeignKey fromKey = this.relation.getFromKey();
                if (fromKey == null) {
                    relationalLevelExists = false;
                    this.fromlist.setListData(new String[0]);
                    this.tolist.setListData(new String[0]);
                    return relationalLevelExists;
                }
                Collection fkLinks = fromKey.getAllColumnLinks();
                if (fkLinks.isEmpty()) {
                    relationalLevelExists = false;
                }
                Iterator iter = fkLinks.iterator();
                String[] dataFrom = new String[fkLinks.size()];
                String[] dataTo = new String[fkLinks.size()];
                int index = 0;
                while (iter.hasNext()) {
                    BaseAttribute baseatt;
                    ForeignKeyLink link = (ForeignKeyLink)iter.next();
                    Column column = link.getForeignKeyColumn();
                    if (column == null) {
                        relationalLevelExists = false;
                    } else {
                        baseatt = this.fromconcept.getConcept().getBaseAttribute(column.getName());
                        dataFrom[index] = baseatt.getName();
                    }
                    column = link.getPrimaryKeyColumn();
                    if (column == null) {
                        relationalLevelExists = false;
                    } else {
                        baseatt = this.toconcept.getConcept().getBaseAttribute(column.getName());
                        dataTo[index] = baseatt.getName();
                    }
                    ++index;
                }
                this.fromlist.setListData(dataFrom);
                this.tolist.setListData(dataTo);
            }
            catch (M4Exception error) {
                M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
            }
        } else {
            this.many2manyButton.setSelected(true);
            this.setMany2ManyType();
            try {
                BaseAttribute baseatt;
                Column column;
                ForeignKeyLink link;
                Columnset colset = this.relation.getCrossLinkColumnSet();
                String tableName = colset.getName();
                try {
                    if (MiningMartApplication.m4Interface.isBusinessTable(tableName)) {
                        tableName = tableName + " (" + Resource.getString("TABLE") + ")";
                    } else if (MiningMartApplication.m4Interface.isBusinessView(tableName)) {
                        tableName = tableName + " (" + Resource.getString("VIEW") + ")";
                    }
                }
                catch (M4Exception error) {
                    M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
                }
                String[] allTableNames = this.getAllTableNames();
                if (!this.arrayContainsString(allTableNames, tableName)) {
                    allTableNames = this.addStringToSortedArray(tableName, allTableNames);
                    this.crosslist.setListData(allTableNames);
                }
                this.crosslist.setSelectedValue(tableName, true);
                this.valueChanged(null);
                ForeignKey fromKey = this.relation.getFromKey();
                ForeignKey toKey = this.relation.getToKey();
                if (fromKey == null) {
                    relationalLevelExists = false;
                    this.fromlist.setListData(new String[0]);
                    this.tolist.setListData(new String[0]);
                    return relationalLevelExists;
                }
                Collection fkLinks = fromKey.getAllColumnLinks();
                if (fkLinks.isEmpty()) {
                    relationalLevelExists = false;
                }
                Iterator iter = fkLinks.iterator();
                String[] dataFrom = new String[fkLinks.size()];
                String[] dataTo = new String[fkLinks.size()];
                int index = 0;
                while (iter.hasNext()) {
                    link = (ForeignKeyLink)iter.next();
                    column = link.getForeignKeyColumn();
                    if (column == null) {
                        relationalLevelExists = false;
                    } else {
                        dataFrom[index] = column.getName();
                    }
                    column = link.getPrimaryKeyColumn();
                    if (column == null) {
                        relationalLevelExists = false;
                    } else {
                        baseatt = this.fromconcept.getConcept().getBaseAttribute(column.getName());
                        dataTo[index] = baseatt.getName();
                    }
                    ++index;
                }
                this.fromlist.setListData(dataTo);
                this.fromattlist.setListData(dataFrom);
                fkLinks = toKey.getAllColumnLinks();
                if (fkLinks.isEmpty()) {
                    relationalLevelExists = false;
                }
                iter = fkLinks.iterator();
                dataFrom = new String[fkLinks.size()];
                dataTo = new String[fkLinks.size()];
                index = 0;
                while (iter.hasNext()) {
                    link = (ForeignKeyLink)iter.next();
                    column = link.getForeignKeyColumn();
                    if (column == null) {
                        relationalLevelExists = false;
                    } else {
                        dataFrom[index] = column.getName();
                    }
                    column = link.getPrimaryKeyColumn();
                    if (column == null) {
                        relationalLevelExists = false;
                    } else {
                        baseatt = this.toconcept.getConcept().getBaseAttribute(column.getName());
                        dataTo[index] = baseatt.getName();
                    }
                    ++index;
                }
                this.tolist.setListData(dataTo);
                this.toattlist.setListData(dataFrom);
            }
            catch (M4Exception error) {
                M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
            }
        }
        return relationalLevelExists;
    }

    private boolean arrayContainsString(String[] theArray, String theString) {
        for (int i = 0; i < theArray.length; ++i) {
            if (!theArray[i].equalsIgnoreCase(theString)) continue;
            return true;
        }
        return false;
    }

    private String[] addStringToSortedArray(String theString, String[] theArray) {
        String[] ret = new String[theArray.length + 1];
        boolean done = false;
        for (int i = 0; i < ret.length; ++i) {
            if (i < theArray.length && theArray[i].compareTo(theString) < 0) {
                ret[i] = theArray[i];
                continue;
            }
            if (!done) {
                ret[i] = theString;
                ++i;
                done = true;
                continue;
            }
            ret[i] = theArray[i - 1];
        }
        return ret;
    }

    private void createRelation() {
        block24: {
            Case currentcase = M4Interface.getCurrentCase();
            String relName = this.nameField.getText();
            if (this.relation == null || !this.relation.getName().equals(relName)) {
                try {
                    relName = currentcase.getValidName(relName, Relation.class);
                }
                catch (M4Exception error) {
                    M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
                }
                this.nameField.setText(relName);
            }
            if (this.relation != null) {
                this.relation.setName(relName);
            }
            ListModel model = this.fromlist.getModel();
            Vector<BaseAttribute> fromfeatures = new Vector<BaseAttribute>();
            BaseAttribute baseatt = null;
            for (int i = 0; i < model.getSize(); ++i) {
                try {
                    baseatt = this.fromconcept.getConcept().getBaseAttribute((String)model.getElementAt(i));
                }
                catch (M4Exception error) {
                    M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
                    baseatt = null;
                }
                if (baseatt != null) {
                    fromfeatures.add(baseatt);
                }
                baseatt = null;
            }
            model = this.tolist.getModel();
            Vector<BaseAttribute> tofeatures = new Vector<BaseAttribute>();
            baseatt = null;
            for (int i = 0; i < model.getSize(); ++i) {
                try {
                    baseatt = this.toconcept.getConcept().getBaseAttribute((String)model.getElementAt(i));
                }
                catch (M4Exception error) {
                    M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
                    baseatt = null;
                }
                if (baseatt != null) {
                    tofeatures.add(baseatt);
                }
                baseatt = null;
            }
            if (this.one2manyButton.isSelected()) {
                try {
                    if (this.relation == null) {
                        this.relation = currentcase.createOneToManyRelation(relName, fromfeatures, tofeatures);
                        break block24;
                    }
                    this.relation.changeFromAndToKeys(fromfeatures, tofeatures);
                }
                catch (M4Exception error) {
                    M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
                    JOptionPane.showMessageDialog(this.app, error.getMessage(), Resource.getString("DIALOG_ERROR_TITLE"), 0);
                }
            } else {
                String crosstable = (String)this.crosslist.getSelectedValue();
                crosstable = crosstable.substring(0, crosstable.indexOf(" ("));
                Vector<String> fromattcolumns = new Vector<String>();
                model = this.fromattlist.getModel();
                for (int i = 0; i < model.getSize(); ++i) {
                    fromattcolumns.add((String)model.getElementAt(i));
                }
                Vector<String> toattcolumns = new Vector<String>();
                model = this.toattlist.getModel();
                for (int i = 0; i < model.getSize(); ++i) {
                    toattcolumns.add((String)model.getElementAt(i));
                }
                try {
                    if (this.relation == null) {
                        this.relation = currentcase.createManyToManyRelation(relName, fromfeatures, tofeatures, crosstable, fromattcolumns, toattcolumns);
                    } else {
                        this.relation.changeCrossTable(crosstable);
                        this.relation.changeAllKeys(fromfeatures, tofeatures, fromattcolumns, toattcolumns);
                    }
                }
                catch (M4Exception error) {
                    M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
                    JOptionPane.showMessageDialog(this.app, error.getMessage(), Resource.getString("DIALOG_ERROR_TITLE"), 0);
                }
            }
        }
        if (this.mmartrelation != null) {
            this.mmartrelation.setRelation(this.relation);
        }
    }

    public Relation getRelation() {
        return this.relation;
    }

    public void actionPerformed(ActionEvent e) {
        JCheckBox source;
        String cmd = e.getActionCommand();
        if (e.getSource() instanceof JCheckBox && (source = (JCheckBox)e.getSource()).getText().equals(this.includeMmTablesText)) {
            String[] listOfTableNames = this.getAllTableNames();
            String selected = (String)this.crosslist.getSelectedValue();
            this.crosslist.setListData(listOfTableNames);
            if (selected != null) {
                this.crosslist.setSelectedValue(selected, true);
            }
        }
        if (cmd.equals(Resource.getString("CANCEL"))) {
            this.exitAction = 0;
            this.dispose();
        } else if (cmd.equals(Resource.getString("OK"))) {
            this.exitAction = 1;
            this.createRelation();
            this.dispose();
        }
    }

    public int getExitAction() {
        return this.exitAction;
    }

    public String getName() {
        return this.nameField.getText();
    }
}

