/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.gui.concepteditor;

import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.gui.application.MiningMartApplication;
import edu.udo.cs.miningmart.gui.concepteditor.ConceptPanel;
import edu.udo.cs.miningmart.gui.concepteditor.DataDialog;
import edu.udo.cs.miningmart.gui.concepteditor.StatisticsDialog;
import edu.udo.cs.miningmart.m4.Column;
import edu.udo.cs.miningmart.m4.Columnset;
import edu.udo.cs.miningmart.m4.Concept;
import edu.udo.cs.miningmart.m4.M4Interface;
import edu.udo.cs.miningmart.m4.utils.Print;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import org.musoft.limo.application.Resource;
import org.musoft.limo.drawing.ModelDrawingView;

public class ColumnsetPanel
extends ConceptPanel
implements ActionListener {
    private MiningMartApplication app;
    private Concept concept;
    private Vector columnset;
    private JTable columntable;
    private JTable columnsettable;
    private JButton deletecolset;
    private JButton deletecolumn;
    private JButton showstats;
    private JButton showdata;
    private JButton closeButton;

    public ColumnsetPanel(MiningMartApplication app, Concept concept) {
        this.app = app;
        this.concept = concept;
        this.initColumnset();
        this.initComponents();
    }

    private void initColumnset() {
        Object[] sets = new Object[]{};
        try {
            sets = this.concept.getColumnSets().toArray();
        }
        catch (M4Exception error) {
            M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
            return;
        }
        this.columnset = new Vector();
        for (int i = 0; i < sets.length; ++i) {
            this.columnset.add((Columnset)sets[i]);
        }
    }

    private void initComponents() {
        this.setLayout(new BorderLayout(5, 5));
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel infopanel = new JPanel();
        infopanel.setLayout(new GridLayout(2, 1, 5, 5));
        infopanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)infopanel, "North");
        JLabel label = new JLabel();
        label.setText(Resource.getString("COLUMNSETS"));
        Font font = new Font("SansSerif", 0, 15);
        label.setFont(font);
        label.setHorizontalAlignment(0);
        infopanel.add(label);
        label = new JLabel();
        label.setText(this.concept.getName());
        font = new Font("SansSerif", 0, 13);
        label.setFont(font);
        label.setHorizontalAlignment(0);
        label.setForeground(Color.BLUE);
        infopanel.add(label);
        this.deletecolset = new JButton(Resource.getString("DELETE_COLUMNSET"));
        this.deletecolset.addActionListener(this);
        this.deletecolset.setEnabled(false);
        this.deletecolumn = new JButton(Resource.getString("DELETE_COLUMN"));
        this.deletecolumn.addActionListener(this);
        this.deletecolumn.setEnabled(false);
        this.showstats = new JButton(Resource.getString("SHOW_STATISTICS"));
        this.showstats.addActionListener(this);
        this.showstats.setEnabled(false);
        this.showdata = new JButton(Resource.getString("SHOW_DATA"));
        this.showdata.addActionListener(this);
        this.showdata.setEnabled(false);
        this.closeButton = new JButton(Resource.getString("CLOSE"));
        this.closeButton.addActionListener(this);
        JPanel southpanel = new JPanel();
        southpanel.setLayout(new GridLayout(3, 1, 5, 5));
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(this.deletecolset);
        buttonPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        buttonPanel.add(this.deletecolumn);
        southpanel.add(buttonPanel);
        buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(this.showstats);
        buttonPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        buttonPanel.add(this.showdata);
        southpanel.add(buttonPanel);
        buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(this.closeButton);
        southpanel.add(buttonPanel);
        this.add((Component)southpanel, "South");
        this.columnsettable = new JTable();
        this.columnsettable.setSelectionMode(2);
        this.columnsettable.getTableHeader().setReorderingAllowed(false);
        this.columnsettable.setRowHeight(this.columnsettable.getRowHeight() + 2);
        this.columnsettable.setModel(new ColumnsetTableModel());
        ListSelectionModel rowSM = this.columnsettable.getSelectionModel();
        rowSM.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ((ColumnTableModel)ColumnsetPanel.this.columntable.getModel()).fireTableDataChanged();
                if (ColumnsetPanel.this.columnsettable.getSelectedRow() == -1) {
                    if (ColumnsetPanel.this.app.getViewMode() == 0) {
                        ColumnsetPanel.this.deletecolset.setEnabled(false);
                    }
                    ColumnsetPanel.this.showstats.setEnabled(false);
                    ColumnsetPanel.this.showdata.setEnabled(false);
                } else {
                    if (ColumnsetPanel.this.app.getViewMode() == 0) {
                        ColumnsetPanel.this.deletecolset.setEnabled(true);
                    }
                    ColumnsetPanel.this.showstats.setEnabled(true);
                    ColumnsetPanel.this.showdata.setEnabled(true);
                }
            }
        });
        for (int i = 0; i < 4; ++i) {
            this.columnsettable.getColumnModel().getColumn(i).setMinWidth(150);
        }
        this.columnsettable.getColumnModel().getColumn(4).setMinWidth(300);
        this.columnsettable.setAutoResizeMode(0);
        this.columntable = new JTable();
        this.columntable.setSelectionMode(2);
        this.columntable.getTableHeader().setReorderingAllowed(false);
        this.columntable.setRowHeight(this.columntable.getRowHeight() + 2);
        this.columntable.setModel(new ColumnTableModel());
        TableColumnModel cmodel = this.columntable.getColumnModel();
        cmodel.getColumn(cmodel.getColumnCount() - 1).setMinWidth(500);
        cmodel.getColumn(cmodel.getColumnCount() - 1).setMaxWidth(Integer.MAX_VALUE);
        this.columntable.setAutoResizeMode(0);
        rowSM = this.columntable.getSelectionModel();
        rowSM.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                if (ColumnsetPanel.this.app.getViewMode() != 0) {
                    return;
                }
                if (ColumnsetPanel.this.columntable.getSelectedRow() == -1) {
                    ColumnsetPanel.this.deletecolumn.setEnabled(false);
                } else {
                    ColumnsetPanel.this.deletecolumn.setEnabled(true);
                }
            }
        });
        JSplitPane splitpane = new JSplitPane(0, new JScrollPane(this.columnsettable), new JScrollPane(this.columntable));
        splitpane.setOneTouchExpandable(true);
        splitpane.setResizeWeight(0.5);
        splitpane.setDividerLocation(splitpane.getSize().width - splitpane.getInsets().bottom - splitpane.getDividerSize() - 150);
        this.add((Component)splitpane, "Center");
        if (this.columnsettable.getModel().getRowCount() == 1) {
            this.columnsettable.getSelectionModel().setSelectionInterval(0, 0);
        }
    }

    public String toString() {
        return Resource.getString("COLUMNSETS");
    }

    private void deleteColumnset() {
        int[] rows = this.columnsettable.getSelectedRows();
        try {
            for (int i = rows.length - 1; i >= 0; --i) {
                if (rows[i] == -1) continue;
                Columnset colset = (Columnset)this.columnset.remove(rows[i]);
                this.concept.removeColumnset(colset);
                colset.deleteSoon();
            }
            ((ColumnsetTableModel)this.columnsettable.getModel()).fireTableDataChanged();
            ((ColumnTableModel)this.columntable.getModel()).fireTableDataChanged();
            this.app.getModel().setDirty(true);
            ((ModelDrawingView)this.app.getDrawingView()).repaint();
        }
        catch (M4Exception error) {
            M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
        }
    }

    private void deleteColumn() {
        int[] rows = this.columntable.getSelectedRows();
        try {
            int row = this.columnsettable.getSelectedRow();
            if (row == -1) {
                return;
            }
            Columnset colset = (Columnset)this.columnset.get(row);
            if (colset == null) {
                return;
            }
            for (int i = rows.length - 1; i >= 0; --i) {
                if (rows[i] == -1) continue;
                Column col = colset.getColumn(rows[i]);
                colset.removeColumn(col);
                col.deleteSoon();
            }
            ((ColumnTableModel)this.columntable.getModel()).fireTableDataChanged();
            this.app.getModel().setDirty(true);
            ((ModelDrawingView)this.app.getDrawingView()).repaint();
        }
        catch (M4Exception error) {
            M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
        }
    }

    private void showStatistics() {
        int row = this.columnsettable.getSelectedRow();
        if (row == -1) {
            return;
        }
        Columnset colset = (Columnset)this.columnset.get(row);
        if (colset == null) {
            return;
        }
        try {
            if (colset.getStatisticsAll() == 0L) {
                JOptionPane.showMessageDialog(this.app, Resource.getString("INFO_NO_DATA_MSG"), Resource.getString("INFO_NO_DATA_TITLE"), 1);
            } else {
                StatisticsDialog dialog = new StatisticsDialog(this.app, colset);
            }
        }
        catch (M4Exception error) {
            M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
        }
    }

    private void showData() {
        int row = this.columnsettable.getSelectedRow();
        if (row == -1) {
            return;
        }
        Columnset colset = (Columnset)this.columnset.get(row);
        if (colset == null) {
            return;
        }
        try {
            if (colset.getStatisticsAll() == 0L) {
                JOptionPane.showMessageDialog(this.app, Resource.getString("INFO_NO_DATA_MSG"), Resource.getString("INFO_NO_DATA_TITLE"), 1);
            } else {
                DataDialog dialog = new DataDialog(this.app, colset);
            }
        }
        catch (M4Exception error) {
            M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
        }
    }

    public void actionPerformed(ActionEvent event) {
        if (!(event.getSource() instanceof JButton)) {
            return;
        }
        JButton source = (JButton)event.getSource();
        if (source.getText().equals(this.closeButton.getText())) {
            this.app.removeComponentFromTab(this);
        }
        if (source.getText().equals(this.deletecolset.getText())) {
            this.deleteColumnset();
        }
        if (source.getText().equals(this.deletecolumn.getText())) {
            this.deleteColumn();
        }
        if (source.getText().equals(this.showstats.getText())) {
            this.showStatistics();
        }
        if (source.getText().equals(this.showdata.getText())) {
            this.showData();
        }
    }

    public Concept getConcept() {
        return this.concept;
    }

    private class ColumnTableModel
    extends AbstractTableModel {
        private ColumnTableModel() {
        }

        public Class getColumnClass(int columnIndex) {
            return String.class;
        }

        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return Resource.getString("COLUMN_NAME");
                }
                case 1: {
                    return Resource.getString("COLUMN_TYPE");
                }
                case 2: {
                    return Resource.getString("COLUMN_SQL");
                }
            }
            return Resource.getString("COLUMN_NAME");
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public int getColumnCount() {
            return 3;
        }

        public int getRowCount() {
            int row = ColumnsetPanel.this.columnsettable.getSelectedRow();
            if (row == -1) {
                return 0;
            }
            try {
                return ((Columnset)ColumnsetPanel.this.columnset.get(row)).getColumns().size();
            }
            catch (M4Exception error) {
                M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
                return 0;
            }
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            try {
                int colindex = ColumnsetPanel.this.columnsettable.getSelectedRow();
                if (colindex == -1) {
                    return new String("");
                }
                Column col = ((Columnset)ColumnsetPanel.this.columnset.get(colindex)).getColumn(rowIndex);
                if (col == null) {
                    return new String("");
                }
                switch (columnIndex) {
                    case 0: {
                        return col.getName();
                    }
                    case 1: {
                        return col.getColumnDataTypeName();
                    }
                    case 2: {
                        return col.getSQLDefinition();
                    }
                }
                return col.getName();
            }
            catch (M4Exception error) {
                M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
                return new String("");
            }
        }
    }

    private class ColumnsetTableModel
    extends AbstractTableModel {
        private ColumnsetTableModel() {
        }

        public Class getColumnClass(int columnIndex) {
            return String.class;
        }

        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return Resource.getString("COLUMN_NAME");
                }
                case 1: {
                    return Resource.getString("COLUMN_SCHEMA");
                }
                case 2: {
                    return Resource.getString("COLUMN_TYPE");
                }
                case 3: {
                    return Resource.getString("COLUMN_BRANCH");
                }
                case 4: {
                    return Resource.getString("COLUMN_SQL");
                }
            }
            return Resource.getString("COLUMN_NAME");
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public int getColumnCount() {
            return 5;
        }

        public int getRowCount() {
            return ColumnsetPanel.this.columnset.size();
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return ((Columnset)ColumnsetPanel.this.columnset.get(rowIndex)).getName();
                }
                case 1: {
                    return ((Columnset)ColumnsetPanel.this.columnset.get(rowIndex)).getSchema();
                }
                case 2: {
                    String type = ((Columnset)ColumnsetPanel.this.columnset.get(rowIndex)).getType();
                    if (type.equals("T")) {
                        return Resource.getString("TABLE");
                    }
                    return Resource.getString("VIEW");
                }
                case 3: {
                    return ((Columnset)ColumnsetPanel.this.columnset.get(rowIndex)).getMultiStepBranch();
                }
                case 4: {
                    return ((Columnset)ColumnsetPanel.this.columnset.get(rowIndex)).getSQLDefinition();
                }
            }
            return ((Columnset)ColumnsetPanel.this.columnset.get(rowIndex)).getName();
        }
    }
}

