/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.gui.concepteditor;

import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.m4.BaseAttribute;
import edu.udo.cs.miningmart.m4.ConceptualDatatypes;
import edu.udo.cs.miningmart.m4.M4Interface;
import edu.udo.cs.miningmart.m4.utils.Print;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;

public class BaseAttributeEditor
extends DefaultCellEditor
implements TableCellRenderer {
    public static final int NAME_EDITOR = 0;
    public static final int ATTRIBUTE_ROLE_EDITOR = 1;
    public static final int DATA_TYPE_EDITOR = 2;
    public static final int DEFAULT_EDITOR = 0;
    protected BaseAttribute baseattrib;

    public BaseAttributeEditor() {
        super(new JTextField());
        this.baseattrib = null;
    }

    public BaseAttributeEditor(BaseAttribute baseattrib, int editor) {
        super(new JTextField());
        this.baseattrib = baseattrib;
        switch (editor) {
            case 0: {
                this.editorComponent = new JTextField(baseattrib.getName());
                this.clickCountToStart = 2;
                this.delegate = new DefaultCellEditor.EditorDelegate(){

                    public void setValue(Object value) {
                        ((JTextField)BaseAttributeEditor.this.editorComponent).setText(value != null ? value.toString() : "");
                    }

                    public Object getCellEditorValue() {
                        return ((JTextField)BaseAttributeEditor.this.editorComponent).getText();
                    }
                };
                ((JTextField)this.editorComponent).addActionListener(this.delegate);
                break;
            }
            case 1: {
                Object[] roles = new Object[]{"PREDICTOR", "LABEL", "KEY", "NO_ROLE"};
                this.editorComponent = new JComboBox<Object>(roles);
                try {
                    ((JComboBox)this.editorComponent).setSelectedItem(baseattrib.getRoleName());
                }
                catch (M4Exception m4e) {
                    // empty catch block
                }
                this.clickCountToStart = 1;
                ((JComboBox)this.editorComponent).putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
                this.delegate = new DefaultCellEditor.EditorDelegate(){

                    public void setValue(Object value) {
                        ((JComboBox)BaseAttributeEditor.this.editorComponent).setSelectedItem(value);
                    }

                    public Object getCellEditorValue() {
                        return ((JComboBox)BaseAttributeEditor.this.editorComponent).getSelectedItem();
                    }

                    public boolean shouldSelectCell(EventObject anEvent) {
                        if (anEvent instanceof MouseEvent) {
                            MouseEvent e = (MouseEvent)anEvent;
                            return e.getID() != 506;
                        }
                        return true;
                    }

                    public boolean stopCellEditing() {
                        if (((JComboBox)BaseAttributeEditor.this.editorComponent).isEditable()) {
                            ((JComboBox)BaseAttributeEditor.this.editorComponent).actionPerformed(new ActionEvent(BaseAttributeEditor.this, 0, ""));
                        }
                        return super.stopCellEditing();
                    }
                };
                ((JComboBox)this.editorComponent).addActionListener(this.delegate);
                break;
            }
            case 2: {
                Object[] cdtypes = new Object[ConceptualDatatypes.CDTYPES.length];
                for (int i = 0; i < cdtypes.length; ++i) {
                    cdtypes[i] = ConceptualDatatypes.CDTYPES[i];
                }
                this.editorComponent = new JComboBox<Object>(cdtypes);
                try {
                    ((JComboBox)this.editorComponent).setSelectedItem(baseattrib.getConceptualDataTypeName());
                }
                catch (M4Exception error) {
                    M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
                }
                this.clickCountToStart = 1;
                ((JComboBox)this.editorComponent).putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
                this.delegate = new DefaultCellEditor.EditorDelegate(){

                    public void setValue(Object value) {
                        ((JComboBox)BaseAttributeEditor.this.editorComponent).setSelectedItem(value);
                    }

                    public Object getCellEditorValue() {
                        return ((JComboBox)BaseAttributeEditor.this.editorComponent).getSelectedItem();
                    }

                    public boolean shouldSelectCell(EventObject anEvent) {
                        if (anEvent instanceof MouseEvent) {
                            MouseEvent e = (MouseEvent)anEvent;
                            return e.getID() != 506;
                        }
                        return true;
                    }

                    public boolean stopCellEditing() {
                        if (((JComboBox)BaseAttributeEditor.this.editorComponent).isEditable()) {
                            ((JComboBox)BaseAttributeEditor.this.editorComponent).actionPerformed(new ActionEvent(BaseAttributeEditor.this, 0, ""));
                        }
                        return super.stopCellEditing();
                    }
                };
                ((JComboBox)this.editorComponent).addActionListener(this.delegate);
                break;
            }
            default: {
                this.editorComponent = new JTextField();
                this.clickCountToStart = 2;
                this.delegate = new DefaultCellEditor.EditorDelegate(){

                    public void setValue(Object value) {
                        ((JTextField)BaseAttributeEditor.this.editorComponent).setText(value != null ? value.toString() : "");
                    }

                    public Object getCellEditorValue() {
                        return ((JTextField)BaseAttributeEditor.this.editorComponent).getText();
                    }
                };
                ((JTextField)this.editorComponent).addActionListener(this.delegate);
            }
        }
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.editorComponent.setBackground((Color)UIManager.get("Table.background"));
        return this.editorComponent;
    }
}

