/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.gui.application;

import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.gui.application.MiningMartApplication;
import edu.udo.cs.miningmart.m4.BaseAttribute;
import edu.udo.cs.miningmart.m4.Concept;
import edu.udo.cs.miningmart.m4.EstimatedStatistics;
import edu.udo.cs.miningmart.m4.Step;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.musoft.limo.application.Resource;

public class ValueSelectionDialog
extends JDialog
implements ActionListener,
ListSelectionListener {
    public final int CANCEL = 0;
    public final int OK = 1;
    private int exitAction;
    private BaseAttribute myAttrib;
    private Step myStep;
    private JButton ok;
    private JButton cancel;
    private JList tables;
    private String[] selectedValues;
    private Component app;

    public ValueSelectionDialog(BaseAttribute theAttrib, Step theStep) {
        super(ValueSelectionDialog.getApplication(), Resource.getString("DIALOG_VALUELIST_TITLE"), true);
        this.myAttrib = theAttrib;
        this.myStep = theStep;
        if (this.myAttrib == null) {
            return;
        }
        this.exitAction = 0;
        this.initComponents();
        this.setDefaultCloseOperation(2);
        this.pack();
        this.setSize(250, 300);
        Dimension size = this.getSize();
        this.setLocation((Toolkit.getDefaultToolkit().getScreenSize().width - size.width) / 2, (Toolkit.getDefaultToolkit().getScreenSize().height - size.height) / 2);
        this.setVisible(true);
    }

    public void initComponents() {
        JPanel top_panel = new JPanel();
        top_panel.setLayout(new BorderLayout(5, 5));
        this.cancel = new JButton(Resource.getString("CANCEL"));
        this.ok = new JButton(Resource.getString("OK"));
        this.ok.setEnabled(false);
        this.cancel.addActionListener(this);
        this.ok.addActionListener(this);
        String text = Resource.getString("DIALOG_VALUELIST_MULT");
        JLabel label = new JLabel(text);
        top_panel.add((Component)label, "North");
        String[] tablenames = this.getValuesFromAttrib();
        this.tables = new JList<String>(tablenames);
        this.tables.setSelectionMode(2);
        this.tables.addListSelectionListener(this);
        JPanel center = new JPanel();
        center.setLayout(new BorderLayout(5, 5));
        JScrollPane scrollpane = new JScrollPane(this.tables);
        center.add((Component)scrollpane, "Center");
        top_panel.add((Component)center, "Center");
        JPanel bottom = new JPanel();
        bottom.setLayout(new BoxLayout(bottom, 0));
        bottom.add(Box.createHorizontalGlue());
        bottom.add(this.ok);
        bottom.add(Box.createRigidArea(new Dimension(10, 0)));
        bottom.add(this.cancel);
        top_panel.add((Component)bottom, "South");
        top_panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.getContentPane().add(top_panel);
    }

    private String[] getValuesFromAttrib() {
        try {
            Concept inCon = this.myAttrib.getConcept();
            if (inCon == null) {
                return null;
            }
            EstimatedStatistics es = inCon.getEstimatedStatistics(this.myStep);
            if (es == null) {
                return null;
            }
            Vector theValues = es.getValueList(this.myAttrib.getName());
            if (theValues == null) {
                return null;
            }
            String[] allValues = new String[theValues.size()];
            Iterator it = theValues.iterator();
            int i = 0;
            while (it.hasNext()) {
                allValues[i] = (String)it.next();
                ++i;
            }
            return allValues;
        }
        catch (M4Exception m4e) {
            JOptionPane.showConfirmDialog(this.app, "M4 error when reading estimated values for attrib '" + this.myAttrib.getName() + "':\n" + m4e.getMessage(), "Error", 0);
            return null;
        }
    }

    private static MiningMartApplication getApplication() {
        return null;
    }

    public boolean wasCancelled() {
        return this.getExitAction() == 0;
    }

    public String getSelectionsAsOneString() {
        if (this.selectedValues == null) {
            return null;
        }
        String ret = "";
        for (int i = 0; i < this.selectedValues.length; ++i) {
            ret = ret + this.selectedValues[i] + ", ";
        }
        ret = ret.substring(0, ret.length() - 2);
        return ret;
    }

    public String[] getSelectedValues() {
        return this.selectedValues;
    }

    public void actionPerformed(ActionEvent event) {
        String cmd = event.getActionCommand();
        if (cmd.equals(Resource.getString("CANCEL"))) {
            this.exitAction = 0;
            this.dispose();
        }
        if (cmd.equals(Resource.getString("OK"))) {
            this.exitAction = 1;
            Object[] selection = this.tables.getSelectedValues();
            if (selection == null) {
                this.selectedValues = null;
            } else {
                this.selectedValues = new String[selection.length];
                for (int i = 0; i < selection.length; ++i) {
                    this.selectedValues[i] = (String)selection[i];
                }
            }
            this.dispose();
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        if (!this.tables.isSelectionEmpty()) {
            this.ok.setEnabled(true);
        } else {
            this.ok.setEnabled(false);
        }
    }

    public int getExitAction() {
        return this.exitAction;
    }
}

