/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.gui.application;

import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.gui.application.MiningMartApplication;
import edu.udo.cs.miningmart.m4.Step;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.musoft.limo.application.Resource;

public class StepSelectionDialog
extends JDialog
implements ActionListener,
ListSelectionListener {
    public final int CANCEL = 0;
    public final int OK = 1;
    private int exitAction;
    private JButton ok;
    private JButton cancel;
    private JList tables;
    private String singleSelectedConcept;
    private String[] selectedObjects;
    private boolean singleSelectionRequired;
    private MiningMartApplication app;

    public StepSelectionDialog(MiningMartApplication parent, boolean selectOnlyOne) {
        super(parent, Resource.getString("DIALOG_STEPSELECT_TITLE"), true);
        this.app = parent;
        this.exitAction = 0;
        this.initComponents();
        this.setDefaultCloseOperation(2);
        this.singleSelectionRequired = selectOnlyOne;
        this.pack();
        this.setSize(250, 300);
        Dimension size = this.getSize();
        this.setLocation((Toolkit.getDefaultToolkit().getScreenSize().width - size.width) / 2, (Toolkit.getDefaultToolkit().getScreenSize().height - size.height) / 2);
        this.setVisible(true);
    }

    public void initComponents() {
        JPanel top_panel = new JPanel();
        top_panel.setLayout(new BorderLayout(5, 5));
        this.cancel = new JButton(Resource.getString("CANCEL"));
        this.ok = new JButton(Resource.getString("OK"));
        this.ok.setEnabled(false);
        this.cancel.addActionListener(this);
        this.ok.addActionListener(this);
        String text = this.singleSelectionRequired ? Resource.getString("DIALOG_STEPSELECT_SINGLE") : Resource.getString("DIALOG_STEPSELECT_MULT");
        JLabel label = new JLabel(text);
        top_panel.add((Component)label, "North");
        String[] tablenames = this.getListOfSteps();
        this.tables = new JList<String>(tablenames);
        if (!this.singleSelectionRequired) {
            this.tables.setSelectionMode(2);
        }
        this.tables.addListSelectionListener(this);
        JPanel center = new JPanel();
        center.setLayout(new BorderLayout(5, 5));
        JScrollPane scrollpane = new JScrollPane(this.tables);
        center.add((Component)scrollpane, "Center");
        top_panel.add((Component)center, "Center");
        JPanel bottom = new JPanel();
        bottom.setLayout(new BoxLayout(bottom, 0));
        bottom.add(Box.createHorizontalGlue());
        bottom.add(this.ok);
        bottom.add(Box.createRigidArea(new Dimension(10, 0)));
        bottom.add(this.cancel);
        top_panel.add((Component)bottom, "South");
        top_panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.getContentPane().add(top_panel);
    }

    private String[] getListOfSteps() {
        String[] tableEntries = null;
        try {
            int tableSize = MiningMartApplication.m4Interface.getCurrentCase().getNumberOfSteps();
            tableEntries = new String[tableSize];
            int index = 0;
            Iterator stepIt = MiningMartApplication.m4Interface.getCurrentCase().getStepIterator();
            while (stepIt.hasNext()) {
                Step oneStep = (Step)stepIt.next();
                tableEntries[index] = oneStep.getName() + "\t (Chain:" + oneStep.getTheChain().getName() + ")";
                ++index;
            }
        }
        catch (M4Exception error) {
            JOptionPane.showMessageDialog(this.app, "Error when reading tables and views from business schema:\n" + error.getMessage(), "DB error", 0);
            return new String[0];
        }
        return tableEntries;
    }

    public void actionPerformed(ActionEvent event) {
        String cmd = event.getActionCommand();
        if (cmd.equals(Resource.getString("CANCEL"))) {
            this.exitAction = 0;
            this.dispose();
        }
        if (cmd.equals(Resource.getString("OK"))) {
            this.exitAction = 1;
            Object[] selection = this.tables.getSelectedValues();
            if (selection == null) {
                this.selectedObjects = null;
            } else {
                this.selectedObjects = new String[selection.length];
                for (int i = 0; i < selection.length; ++i) {
                    this.selectedObjects[i] = (String)selection[i];
                    int index = -1;
                    index = this.selectedObjects[i].indexOf("(Chain:");
                    if (index <= -1) continue;
                    this.selectedObjects[i] = this.selectedObjects[i].substring(0, index).trim();
                }
                if (this.selectedObjects != null && this.selectedObjects.length > 0) {
                    this.singleSelectedConcept = this.selectedObjects[0];
                }
            }
            this.dispose();
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        if (!this.tables.isSelectionEmpty()) {
            this.ok.setEnabled(true);
        } else {
            this.ok.setEnabled(false);
        }
    }

    public int getExitAction() {
        return this.exitAction;
    }

    public String getStepName() {
        if (this.exitAction == 1) {
            return this.singleSelectedConcept;
        }
        return null;
    }

    public String[] getSelectionOfSteps() {
        if (this.exitAction == 1) {
            return this.selectedObjects;
        }
        return null;
    }
}

