/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.gui.application;

import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.gui.application.MiningMartApplication;
import edu.udo.cs.miningmart.gui.application.OperatorCheck;
import edu.udo.cs.miningmart.gui.application.PreferencesPanel;
import edu.udo.cs.miningmart.m4.M4Interface;
import edu.udo.cs.miningmart.m4.Operator;
import edu.udo.cs.miningmart.m4.OperatorGroup;
import edu.udo.cs.miningmart.m4.utils.Print;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import org.jhotdraw.util.Iconkit;
import org.musoft.limo.application.Resource;

public class OperatorPreferencesPanel
extends PreferencesPanel {
    private MiningMartApplication app;
    private Vector op_checks;
    private int size;
    private JPanel gridpanel;
    private JScrollPane scrollpane;
    private JTree jtree;

    public OperatorPreferencesPanel(MiningMartApplication app) {
        this.app = app;
        this.size = 0;
        this.op_checks = new Vector();
        this.initComponents();
    }

    private void initComponents() {
        this.createOpChecksVector();
        this.gridpanel = new JPanel();
        this.gridpanel.setLayout(new GridLayout(this.size, 1));
        DefaultMutableTreeNode top = new DefaultMutableTreeNode(new OperatorCheck(Resource.getString("OPERATORS"), false, 0, null), true);
        this.createTreeNodes(top);
        this.jtree = new JTree(top);
        this.jtree.setRootVisible(true);
        this.jtree.setVisibleRowCount(1);
        MyMouseListener mm = new MyMouseListener();
        MyTreeCellRenderer treecellrenderer = new MyTreeCellRenderer();
        this.jtree.addMouseListener(mm);
        this.jtree.setCellRenderer(treecellrenderer);
        this.scrollpane = new JScrollPane(this.jtree);
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)this.scrollpane, "Center");
    }

    private void createTreeNodes(DefaultMutableTreeNode top) {
        Object[] objects = new Object[this.op_checks.size()];
        for (int i = 0; i < this.op_checks.size(); ++i) {
            OperatorCheck check = (OperatorCheck)this.op_checks.get(i);
            this.createTreeNode(top, check);
        }
    }

    private void createTreeNode(DefaultMutableTreeNode top, OperatorCheck check) {
        DefaultMutableTreeNode treenode = new DefaultMutableTreeNode(check, !check.isOperator());
        top.add(treenode);
        for (int i = 0; i < check.getOpChecksSize(); ++i) {
            this.createTreeNode(treenode, check.getOperatorCheck(i));
        }
    }

    private void createOpChecksVector() {
        M4Interface m4i = M4Interface.getInstance();
        boolean success = true;
        if (m4i != null) {
            OperatorGroup opg = m4i.getOperatorGroup();
            for (Long opgId : opg.getTopLevelOperatorGroups()) {
                try {
                    this.op_checks.add(this.recurseThroughInsertOps(opgId, opg, 0, null));
                    ++this.size;
                }
                catch (M4Exception e) {
                    M4Interface.print.doPrint(Print.ERROR, e.getMessage(), e);
                    success = false;
                }
            }
        }
    }

    private OperatorCheck recurseThroughInsertOps(Long opGroupId, OperatorGroup opg, int depth, OperatorCheck parent) throws M4Exception {
        Collection col = opg.getChildGroups(opGroupId);
        Iterator it = col.iterator();
        String name = opg.getGroupName(opGroupId);
        OperatorCheck check = new OperatorCheck(name, false, depth, parent);
        check.setSelected(this.isPreferenced(check));
        while (it.hasNext()) {
            Long idNext = (Long)it.next();
            Collection down = opg.getChildGroups(idNext);
            if (down != null) {
                OperatorCheck ch2 = this.recurseThroughInsertOps(idNext, opg, depth + 1, check);
                ch2.setSelected(this.isPreferenced(ch2));
                check.addOperatorCheck(ch2);
                ++this.size;
                continue;
            }
            Operator op = opg.getOperator(idNext);
            if (op == null) continue;
            String opName = op.getName();
            OperatorCheck ch = new OperatorCheck(opName, true, depth + 1, check);
            ch.setSelected(this.isPreferenced(ch));
            check.addOperatorCheck(ch);
            ++this.size;
        }
        return check;
    }

    private boolean isPreferenced(OperatorCheck check) {
        Vector ops = this.app.getOperatorsInToolPanel();
        return ops.contains(check.getName().toLowerCase());
    }

    private Vector getOpsChecked() {
        Vector<String> ops = new Vector<String>();
        Vector allchecks = (Vector)this.op_checks.clone();
        while (allchecks.size() > 0) {
            OperatorCheck ch = (OperatorCheck)allchecks.remove(0);
            if (ch.isSelected()) {
                ops.add(ch.getName().toLowerCase());
            }
            if (ch.isOperator()) continue;
            Vector children = ch.getSubOperatorChecks();
            for (int i = 0; i < children.size(); ++i) {
                allchecks.add(children.get(i));
            }
        }
        return ops;
    }

    public void actionSave() {
        this.app.setOperatorInToolPanel(this.getOpsChecked());
        this.app.saveParams();
        this.app.refreshOperatorToolPanel();
    }

    public void actionOK() {
        this.app.setOperatorInToolPanel(this.getOpsChecked());
        this.app.refreshOperatorToolPanel();
    }

    public void actionCancel() {
    }

    private class MyTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private Icon op_selected;
        private Icon op_notselected;
        private Icon group_notselected;
        private Icon group_partly_selected;
        private Icon group_allselected;
        private Icon ops;

        public MyTreeCellRenderer() {
            Iconkit kit = Iconkit.instance();
            this.op_selected = new ImageIcon(kit.loadImageResource(Resource.getString("OP_SELECTED")));
            this.op_notselected = new ImageIcon(kit.loadImageResource(Resource.getString("OP_NOT_SELECTED")));
            this.group_notselected = new ImageIcon(kit.loadImageResource(Resource.getString("GROUP_NOT_SELECTED")));
            this.group_partly_selected = new ImageIcon(kit.loadImageResource(Resource.getString("GROUP_PARTLY_SELECTED")));
            this.group_allselected = new ImageIcon(kit.loadImageResource(Resource.getString("GROUP_ALL_SELECTED")));
            this.ops = new ImageIcon(kit.loadImageResource(Resource.getString("CaseIcon")));
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            DefaultMutableTreeNode treenode = (DefaultMutableTreeNode)value;
            OperatorCheck check = (OperatorCheck)treenode.getUserObject();
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (treenode.isRoot()) {
                this.setIcon(this.ops);
                return this;
            }
            if (leaf) {
                if (check.isSelected()) {
                    this.setIcon(this.op_selected);
                } else {
                    this.setIcon(this.op_notselected);
                }
            } else if (check.isAllSelected()) {
                this.setIcon(this.group_allselected);
            } else if (check.isPartlySelected()) {
                this.setIcon(this.group_partly_selected);
            } else {
                this.setIcon(this.group_notselected);
            }
            return this;
        }
    }

    private class MyMouseListener
    extends MouseAdapter {
        private MyMouseListener() {
        }

        public void mouseClicked(MouseEvent e) {
            int selRow = OperatorPreferencesPanel.this.jtree.getRowForLocation(e.getX(), e.getY());
            TreePath selPath = OperatorPreferencesPanel.this.jtree.getPathForLocation(e.getX(), e.getY());
            DefaultMutableTreeNode node = null;
            if (selPath != null) {
                node = (DefaultMutableTreeNode)selPath.getLastPathComponent();
            }
            OperatorCheck check = null;
            if (node != null) {
                check = (OperatorCheck)node.getUserObject();
            }
            if (check != null) {
                if (check.isAllSelected()) {
                    check.setSelected(false);
                } else {
                    check.setSelected(true);
                }
            }
            OperatorPreferencesPanel.this.jtree.repaint();
        }
    }
}

