/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.gui.application;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.JCheckBox;

public class OperatorCheck {
    private boolean isOperator;
    private boolean cascading;
    private String name;
    private Vector op_checks;
    private int depth;
    private OperatorCheck parent;
    private JCheckBox checkbox;

    public OperatorCheck(String name, boolean isOperator, int depth, OperatorCheck parent) {
        this.isOperator = isOperator;
        this.cascading = true;
        this.name = name;
        this.op_checks = !isOperator ? new Vector() : null;
        this.depth = depth;
        this.parent = parent;
        this.initComponents();
    }

    private void initComponents() {
        this.checkbox = new JCheckBox(this.name);
        this.checkbox.setSelected(false);
        this.checkbox.addItemListener(new CheckListener());
    }

    public boolean isOperator() {
        return this.isOperator;
    }

    public int getOpChecksSize() {
        if (!this.isOperator) {
            return this.op_checks.size();
        }
        return -1;
    }

    public OperatorCheck getOperatorCheck(int index) {
        if (index >= 0 && index < this.op_checks.size()) {
            return (OperatorCheck)this.op_checks.get(index);
        }
        return null;
    }

    public boolean addOperatorCheck(OperatorCheck check) {
        if (!this.isOperator) {
            this.op_checks.add(check);
        }
        return false;
    }

    public String toString() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public void setSelectedSimple(boolean bool) {
        this.setCascading(false);
        this.checkbox.setSelected(bool);
        this.setCascading(true);
    }

    public void setSelected(boolean bool) {
        OperatorCheck ch;
        int i;
        this.checkbox.setSelected(bool);
        if (bool && this.parent != null) {
            OperatorCheck p = this.parent;
            while (p != null) {
                p.setSelectedSimple(true);
                p = p.parent;
            }
        }
        if (!bool && this.parent != null) {
            boolean activated = false;
            for (i = 0; i < this.parent.op_checks.size() && !activated; ++i) {
                ch = (OperatorCheck)this.parent.op_checks.get(i);
                if (!ch.isSelected()) continue;
                activated = true;
            }
            if (!activated) {
                this.parent.setSelected(false);
            }
        }
        if (!this.isOperator) {
            Vector allchecks = (Vector)this.op_checks.clone();
            while (allchecks.size() > 0) {
                ch = (OperatorCheck)allchecks.remove(0);
                ch.setSelectedSimple(bool);
                if (ch.isOperator) continue;
                for (i = 0; i < ch.op_checks.size(); ++i) {
                    allchecks.add(ch.op_checks.get(i));
                }
            }
        }
    }

    public void setSelectedCascading(boolean bool) {
        OperatorCheck ch;
        int i;
        this.checkbox.setSelected(bool);
        if (this.isOperator) {
            return;
        }
        if (this.checkbox.isSelected() && this.parent != null) {
            this.parent.setSelectedCascadingTop(true);
        }
        if (!this.isOperator && this.checkbox.isSelected()) {
            for (i = 0; i < this.op_checks.size(); ++i) {
                ch = (OperatorCheck)this.op_checks.get(i);
                ch.setSelectedCascading(true);
            }
        }
        if (!this.isOperator && !this.checkbox.isSelected()) {
            for (i = 0; i < this.op_checks.size(); ++i) {
                ch = (OperatorCheck)this.op_checks.get(i);
                ch.setSelectedCascading(false);
            }
        }
        if (!this.checkbox.isSelected() && this.parent != null) {
            boolean deactivated = true;
            for (int i2 = 0; i2 < this.parent.op_checks.size() && deactivated; ++i2) {
                OperatorCheck ch2 = (OperatorCheck)this.parent.op_checks.get(i2);
                if (!ch2.isSelected()) continue;
                deactivated = false;
            }
            if (deactivated) {
                this.parent.setSelectedCascading(false);
            }
        }
    }

    public void setSelectedCascadingTop(boolean bool) {
        this.checkbox.setSelected(bool);
        this.parent.setSelectedCascadingTop(bool);
    }

    public void setSelectedCascadingDown(boolean bool) {
    }

    public boolean isSelected() {
        return this.checkbox.isSelected();
    }

    public boolean isPartlySelected() {
        if (this.isOperator()) {
            return this.isSelected();
        }
        boolean partly_selected = true;
        for (int i = 0; i < this.op_checks.size(); ++i) {
            OperatorCheck ch = (OperatorCheck)this.op_checks.get(i);
            if (!ch.isPartlySelected()) continue;
            return true;
        }
        return false;
    }

    public boolean isAllSelected() {
        if (this.isOperator()) {
            return this.isSelected();
        }
        for (int i = 0; i < this.op_checks.size(); ++i) {
            OperatorCheck ch = (OperatorCheck)this.op_checks.get(i);
            if (ch.isAllSelected()) continue;
            return false;
        }
        return true;
    }

    public void setCascading(boolean bool) {
        this.cascading = bool;
    }

    public boolean getCascading() {
        return this.cascading;
    }

    public Vector getSubOperatorChecks() {
        return this.op_checks;
    }

    private class CheckListener
    implements ItemListener {
        public void itemStateChanged(ItemEvent e) {
            if (OperatorCheck.this.cascading) {
                OperatorCheck.this.setSelected(OperatorCheck.this.checkbox.isSelected());
            }
        }
    }
}

