/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.gui.application;

import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.gui.application.ConceptToolPanel;
import edu.udo.cs.miningmart.gui.application.MiningMartApplication;
import edu.udo.cs.miningmart.gui.application.MiningMartMenuBar;
import edu.udo.cs.miningmart.gui.application.MiningMartToolBar;
import edu.udo.cs.miningmart.gui.application.OperatorToolPanel;
import edu.udo.cs.miningmart.m4.M4Interface;
import edu.udo.cs.miningmart.m4.utils.Print;
import javax.swing.JOptionPane;
import org.musoft.limo.application.Resource;

public class OpenCaseThread
extends Thread {
    public static boolean CURRENTLY_OPENING = false;
    private MiningMartApplication app;
    private String casename;
    private boolean opened;
    private boolean openCaseForUpdating;
    private boolean ready;
    private boolean caseHasChanged;
    private boolean isImporting;
    private String comment;

    public OpenCaseThread(MiningMartApplication app, String casename, boolean openCaseForUpdating, boolean caseHasChanged, boolean forImport) {
        this.app = app;
        this.casename = casename;
        this.opened = false;
        this.ready = false;
        this.caseHasChanged = caseHasChanged;
        this.openCaseForUpdating = openCaseForUpdating;
        this.comment = Resource.getString("LOADING_CASE");
        this.isImporting = forImport;
    }

    public boolean isOpened() {
        return this.opened;
    }

    public String getComment() {
        return this.comment;
    }

    public boolean isReady() {
        return this.ready;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.app.setActualCaseName(this.casename);
        try {
            if (!this.openCaseForUpdating) {
                if (this.caseHasChanged) {
                    this.app.currentcase = MiningMartApplication.m4Interface.findCaseForReadOnlyAccess(this.casename, true);
                }
                this.app.setViewMode(1);
            } else {
                if (this.caseHasChanged) {
                    this.app.currentcase = MiningMartApplication.m4Interface.findCaseForUpdate(this.casename, true);
                }
                this.app.setViewMode(0);
            }
        }
        catch (M4Interface.CaseLockedException e) {
            M4Interface.print.doPrint(Print.ERROR, Resource.getString("ERROR_LOCKED_CASE") + " " + this.casename, e);
            if (MiningMartApplication.m4Interface.canRemoveM4Access(this.casename)) {
                String message = Resource.getString("ERROR_LOCKED_CASE") + " " + this.casename + "\n" + Resource.getString("REMOVE_CASELOCK1") + "\n" + Resource.getString("REMOVE_CASELOCK2");
                int confirm = JOptionPane.showConfirmDialog(this.app, message, Resource.getString("ERROR_LOCKED_CASE_TITLE"), 0, 3);
                if (confirm == 0) {
                    try {
                        MiningMartApplication.m4Interface.releaseCaseWithoutStoring(this.casename);
                    }
                    catch (M4Exception m4e) {}
                }
            } else {
                JOptionPane.showMessageDialog(this.app, Resource.getString("ERROR_LOCKED_CASE") + " " + this.casename + "\n" + Resource.getString("LOCKED_CASE_DIFF_USER"), Resource.getString("ERROR_LOCKED_CASE_TITLE"), 2);
            }
            this.ready = true;
            return;
        }
        try {
            CURRENTLY_OPENING = true;
            ((MiningMartMenuBar)this.app.getJMenuBar()).promptOpenItemStates();
            ((MiningMartToolBar)this.app.getToolbar()).promptOpenItemStates();
            this.comment = Resource.getString("CREATE_MODEL");
            this.app.setModel(this.app.createModel());
            this.comment = Resource.getString("CREATE_DRAWINGVIEW");
            this.app.createDrawing(this.app.getModel());
            this.app.getModel().setDirty(false);
            this.app.modelLoaded();
            this.comment = Resource.getString("ADD_NAVIGATOR");
            this.app.showComponentInTab(this.app.getNavigator(), 4, true);
            this.comment = Resource.getString("ADD_CONCEPTEDITOR");
            this.comment = Resource.getString("ADD_BIRDSEYE");
            this.app.showComponentInTab(this.app.getBirdsEye(), 4, false);
            this.comment = Resource.getString("ADD_INSPECTOR");
            this.app.showComponentInTab(this.app.getInspector(), 8, true);
            this.app.showComponentInTab(this.app.getNotepad(), 8, false);
            this.comment = Resource.getString("ADD_ANNOTATION");
            this.app.showAnnotations();
            if (this.app.getViewMode() == 0 && this.app.getEditorMode() == 0) {
                this.comment = Resource.getString("ADD_OPTOOLS");
                OperatorToolPanel operatortoolpanel = new OperatorToolPanel(this.app);
                this.app.setOperatorToolPanel(operatortoolpanel);
                this.app.showOperatorTools();
            } else if (this.app.getViewMode() == 0 && this.app.getEditorMode() == 1) {
                this.comment = Resource.getString("ADD_CONCEPTTOOLS");
                ConceptToolPanel concepttoolpanel = new ConceptToolPanel(this.app);
                this.app.setConceptToolPanel(concepttoolpanel);
                this.app.showConceptTools();
            }
            ((MiningMartMenuBar)this.app.getJMenuBar()).setItemState(Resource.getString("MENU_CASE") + "." + Resource.getString("MENU_CASE_SAVE"), false);
            ((MiningMartToolBar)this.app.getToolbar()).enableTool(Resource.getString("TOOL_SAVECASE"), false);
            ((MiningMartMenuBar)this.app.getJMenuBar()).getRecentCases().setRecentFile(this.casename);
            ((MiningMartMenuBar)this.app.getJMenuBar()).setRecentCasesGUI();
            this.comment = Resource.getString("OPENCASE_READY");
            if (this.caseHasChanged) {
                M4Interface.print.doPrint(Print.COMPILER_CASE_CONTROL, Resource.getString("OPENED_CASE") + " " + M4Interface.getCurrentCase().getName());
            }
            this.app.activateFrameOfElement(this.app.getModel());
            this.ready = true;
            if (this.isImporting) {
                this.app.getModel().setDirty(true);
                this.app.updateToolsAndMenus();
            }
        }
        finally {
            CURRENTLY_OPENING = false;
        }
    }
}

