/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.gui.application;

import edu.udo.cs.miningmart.gui.application.MiningMartApplication;
import edu.udo.cs.miningmart.gui.figures.ChainFigure;
import edu.udo.cs.miningmart.gui.figures.ConceptFigure;
import edu.udo.cs.miningmart.gui.figures.FeatureFigure;
import edu.udo.cs.miningmart.gui.figures.ProjectionFigure;
import edu.udo.cs.miningmart.gui.figures.RelationFigure;
import edu.udo.cs.miningmart.gui.figures.StepFigure;
import edu.udo.cs.miningmart.gui.figures.SubConceptFigure;
import edu.udo.cs.miningmart.gui.figures.TransitionFigure;
import edu.udo.cs.miningmart.gui.model.MiningMartBaseAttribute;
import edu.udo.cs.miningmart.gui.model.MiningMartChain;
import edu.udo.cs.miningmart.gui.model.MiningMartConcept;
import edu.udo.cs.miningmart.gui.model.MiningMartMultiColumnFeature;
import edu.udo.cs.miningmart.gui.model.MiningMartProjection;
import edu.udo.cs.miningmart.gui.model.MiningMartRelation;
import edu.udo.cs.miningmart.gui.model.MiningMartStep;
import edu.udo.cs.miningmart.gui.model.MiningMartSubConcept;
import edu.udo.cs.miningmart.gui.model.StepTransition;
import org.jhotdraw.framework.DrawingView;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.framework.FigureEnumeration;
import org.jhotdraw.framework.FigureSelectionListener;

public class MiningMartSelectionListener
implements FigureSelectionListener {
    private MiningMartApplication app;
    private MiningMartStep mstep;
    private MiningMartChain mchain;
    private StepTransition steptrans;
    private MiningMartConcept mconcept;
    private MiningMartBaseAttribute mbaseatt;
    private MiningMartMultiColumnFeature mmcfeat;
    private MiningMartSubConcept msubconcept;
    private MiningMartRelation mrelation;
    private MiningMartProjection mprojection;
    private ConceptFigure conceptfigure;
    private boolean stepselected;
    private boolean chainselected;
    private boolean transselected;
    private boolean conceptselected;
    private boolean baseattributeselected;
    private boolean mcfeatselected;
    private boolean subconceptselected;
    private boolean projectionselected;
    private boolean relationselected;

    public MiningMartSelectionListener(MiningMartApplication app) {
        this.app = app;
        this.initSelection();
    }

    private void initSelection() {
        this.mstep = null;
        this.mchain = null;
        this.steptrans = null;
        this.mconcept = null;
        this.mbaseatt = null;
        this.mmcfeat = null;
        this.msubconcept = null;
        this.mprojection = null;
        this.mrelation = null;
        this.stepselected = false;
        this.chainselected = false;
        this.transselected = false;
        this.conceptselected = false;
        this.baseattributeselected = false;
        this.mcfeatselected = false;
        this.subconceptselected = false;
        this.projectionselected = false;
        this.relationselected = false;
    }

    public void figureSelectionChanged(DrawingView view) {
        this.initSelection();
        FigureEnumeration fenum = view.selection();
        if (fenum.hasNextFigure()) {
            Figure fig = fenum.nextFigure();
            if (fig instanceof ChainFigure) {
                this.chainselected = true;
                this.mchain = ((ChainFigure)fig).getMiningMartChain();
            } else if (fig instanceof StepFigure) {
                this.stepselected = true;
                this.mstep = ((StepFigure)fig).getMiningMartStep();
            } else if (fig instanceof TransitionFigure) {
                this.transselected = true;
                this.steptrans = ((TransitionFigure)fig).getStepTransition();
            } else if (fig instanceof ConceptFigure) {
                this.conceptselected = true;
                if (this.conceptfigure != null) {
                    this.conceptfigure.deSelected();
                }
                this.conceptfigure = (ConceptFigure)fig;
                this.conceptfigure.isSelected();
                this.mconcept = this.conceptfigure.getMiningMartConcept();
            } else if (fig instanceof FeatureFigure && ((FeatureFigure)fig).getElement() instanceof MiningMartBaseAttribute) {
                this.baseattributeselected = true;
                this.mbaseatt = ((FeatureFigure)fig).getMiningMartBaseAttribute();
            } else if (fig instanceof FeatureFigure && ((FeatureFigure)fig).getElement() instanceof MiningMartMultiColumnFeature) {
                this.mcfeatselected = true;
                this.mmcfeat = ((FeatureFigure)fig).getMiningMartMultiColumnFeature();
            } else if (fig instanceof SubConceptFigure) {
                this.subconceptselected = true;
                this.msubconcept = ((SubConceptFigure)fig).getMiningMartSubConcept();
            } else if (fig instanceof RelationFigure) {
                this.relationselected = true;
                this.mrelation = ((RelationFigure)fig).getMiningMartRelation();
            } else if (fig instanceof ProjectionFigure) {
                this.projectionselected = true;
                this.mprojection = ((ProjectionFigure)fig).getMiningMartProjection();
            }
        }
    }

    public boolean isMiningMartSubConceptSelected() {
        return this.subconceptselected;
    }

    public boolean isMiningMartRelationSelected() {
        return this.relationselected;
    }

    public boolean isMiningMartProjectionSelected() {
        return this.projectionselected;
    }

    public boolean isMiningMartConceptSelected() {
        return this.conceptselected;
    }

    public boolean isMiningMartBaseAttributeSelected() {
        return this.baseattributeselected;
    }

    public boolean isMiningMartMultiColumnFeatureSelected() {
        return this.mcfeatselected;
    }

    public boolean isMiningMartStepSelected() {
        return this.stepselected;
    }

    public boolean isMiningMartChainSelected() {
        return this.chainselected;
    }

    public boolean isStepTransitionSelected() {
        return this.transselected;
    }

    public boolean isAnythingSelected() {
        if (this.app.getEditorMode() == 0) {
            return this.stepselected || this.chainselected || this.transselected;
        }
        return this.conceptselected || this.baseattributeselected || this.mcfeatselected || this.subconceptselected || this.relationselected || this.projectionselected;
    }

    public MiningMartMultiColumnFeature getSelectedMiningMartMultiColumnFeature() {
        if (!this.mcfeatselected) {
            return null;
        }
        return this.mmcfeat;
    }

    public MiningMartBaseAttribute getSelectedMiningMartBaseAttribute() {
        if (!this.baseattributeselected) {
            return null;
        }
        return this.mbaseatt;
    }

    public MiningMartConcept getSelectedMiningMartConcept() {
        if (!this.conceptselected) {
            return null;
        }
        return this.mconcept;
    }

    public MiningMartStep getSelectedMiningMartStep() {
        if (!this.stepselected) {
            return null;
        }
        return this.mstep;
    }

    public MiningMartChain getSelectedMiningMartChain() {
        if (!this.chainselected) {
            return null;
        }
        return this.mchain;
    }

    public StepTransition getSelectedStepTransition() {
        if (!this.transselected) {
            return null;
        }
        return this.steptrans;
    }

    public MiningMartSubConcept getSelectedMiningMartSubConcept() {
        if (!this.subconceptselected) {
            return null;
        }
        return this.msubconcept;
    }

    public MiningMartRelation getSelectedMiningMartRelation() {
        if (!this.relationselected) {
            return null;
        }
        return this.mrelation;
    }

    public MiningMartProjection getSelectedMiningMartProjection() {
        if (!this.projectionselected) {
            return null;
        }
        return this.mprojection;
    }
}

