/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.gui.application;

import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.gui.application.MiningMartApplication;
import edu.udo.cs.miningmart.gui.application.MiningMartMenuBar;
import edu.udo.cs.miningmart.gui.application.MiningMartSelectionListener;
import edu.udo.cs.miningmart.gui.concepteditor.ColumnsetPanel;
import edu.udo.cs.miningmart.gui.concepteditor.ConnectionPanel;
import edu.udo.cs.miningmart.gui.concepteditor.CreateRelationDialog;
import edu.udo.cs.miningmart.gui.concepteditor.EstimatedStatisticsDialog;
import edu.udo.cs.miningmart.gui.concepteditor.FeaturePanel;
import edu.udo.cs.miningmart.gui.concepteditor.MappingPanel;
import edu.udo.cs.miningmart.gui.model.MiningMartRelation;
import edu.udo.cs.miningmart.m4.Chain;
import edu.udo.cs.miningmart.m4.Concept;
import edu.udo.cs.miningmart.m4.M4Interface;
import edu.udo.cs.miningmart.m4.Step;
import edu.udo.cs.miningmart.m4.utils.Print;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import org.jhotdraw.framework.DrawingView;
import org.jhotdraw.framework.FigureSelectionListener;
import org.jhotdraw.util.Iconkit;
import org.musoft.limo.application.IconCommandMenu;
import org.musoft.limo.application.Resource;
import org.musoft.limo.drawing.ModelDrawingView;

public class MiningMartDrawingView
extends ModelDrawingView
implements MouseListener {
    private LinkedList selectionlistener;
    private MiningMartApplication application;

    public MiningMartDrawingView(MiningMartApplication application) {
        super(application);
        this.application = application;
        this.selectionlistener = new LinkedList();
        this.addMouseListener(this);
    }

    public void addMiningMartSelectionListener(MiningMartSelectionListener listener) {
        this.selectionlistener.add(listener);
        super.addFigureSelectionListener((FigureSelectionListener)listener);
    }

    public void removeMiningMartSelectionListener(MiningMartSelectionListener listener) {
        this.selectionlistener.remove(listener);
        super.removeFigureSelectionListener((FigureSelectionListener)listener);
    }

    public void removeAllMiningMartSelectionListener() {
        for (int s = this.getMiningMartSelectionListenerCount() - 1; s >= 0; --s) {
            MiningMartSelectionListener listener = this.getMiningMartSelectionListener(s);
            this.selectionlistener.remove(listener);
            super.removeFigureSelectionListener((FigureSelectionListener)listener);
        }
    }

    public int getMiningMartSelectionListenerCount() {
        return this.selectionlistener.size();
    }

    public MiningMartSelectionListener getMiningMartSelectionListener(int index) {
        return (MiningMartSelectionListener)this.selectionlistener.get(index);
    }

    public Color getBackground() {
        return Resource.getColor("DRAWING_VIEW_BACKGROUNDCOLOR");
    }

    protected void fireSelectionChanged() {
        for (int s = this.getMiningMartSelectionListenerCount() - 1; s >= 0; --s) {
            MiningMartSelectionListener listener = this.getMiningMartSelectionListener(s);
            listener.figureSelectionChanged((DrawingView)this);
        }
        super.fireSelectionChanged();
    }

    public void mouseClicked(MouseEvent e) {
        MiningMartSelectionListener listener;
        if (e.getModifiers() == 16 && e.getClickCount() == 2 && (listener = (MiningMartSelectionListener)this.selectionlistener.getFirst()).isAnythingSelected()) {
            if (listener.isMiningMartStepSelected()) {
                this.application.showStepSettings(listener.getSelectedMiningMartStep());
            }
            if (listener.isStepTransitionSelected()) {
                this.application.promptShowAllTransitions();
            }
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        if (e.getModifiers() == 4) {
            if (this.application.getEditorMode() == 0) {
                this.createCaseJPopupMenu(e.getX(), e.getY());
            } else {
                this.createConceptJPopupMenu(e.getX(), e.getY());
            }
        }
    }

    public void createCaseJPopupMenu(int x, int y) {
        ExecutableMenuItem menuitem;
        Iconkit kit = Iconkit.instance();
        JPopupMenu menu = new JPopupMenu();
        MiningMartSelectionListener listener = (MiningMartSelectionListener)this.selectionlistener.getFirst();
        if (this.application.getViewMode() == 0) {
            this.application.setPointForOperator(new Point(x, y));
            IconCommandMenu operators = ((MiningMartMenuBar)this.application.getJMenuBar()).getOperatorsMenu();
            menu.add((JMenuItem)((Object)operators));
        }
        if (listener.isAnythingSelected()) {
            if (listener.isStepTransitionSelected()) {
                // empty if block
            }
            if (listener.isMiningMartStepSelected()) {
                menuitem = new ExecutableMenuItem(Resource.getString("MENU_INSERT_SHOW_STEPSETTINGS"), (Icon)new ImageIcon(kit.loadImageResource(Resource.getString("MENU_ICON_INSERT_SHOW_STEPSETTINGS"))), listener){

                    public void execute() {
                        MiningMartDrawingView.this.application.showStepSettings(this.getListener().getSelectedMiningMartStep());
                    }
                };
                menu.add(menuitem);
                menuitem = new ExecutableMenuItem(Resource.getString("MENU_INSERT_SHOW_DATAMODEL"), (Icon)new ImageIcon(kit.loadImageResource(Resource.getString("MENU_ICON_INSERT_SHOW_DATAMODEL"))), listener){

                    public void execute() {
                        boolean editing;
                        MiningMartApplication app = MiningMartDrawingView.this.application;
                        MiningMartSelectionListener listener = this.getListener();
                        String casename = app.getModel().getName();
                        if (app.getEditorMode() == 1) {
                            casename = M4Interface.getCurrentCase().getName();
                        }
                        Step step = listener.getSelectedMiningMartStep().getStep();
                        Iterator it = null;
                        try {
                            it = step.getResultingDataModel().iterator();
                        }
                        catch (M4Exception e) {
                            M4Interface.print.doPrint(Print.ERROR, e.getMessage(), e);
                        }
                        Vector<String> conceptNames = new Vector<String>();
                        while (it.hasNext()) {
                            Concept myCon = (Concept)it.next();
                            conceptNames.add(myCon.getName());
                        }
                        boolean bl = editing = app.getViewMode() == 0;
                        if (!app.promptClose()) {
                            return;
                        }
                        app.setDataModel(conceptNames);
                        app.setEditorMode(1);
                        app.promptOpen(casename, editing, false);
                    }
                };
                menu.add(menuitem);
            }
            if (listener.isMiningMartChainSelected()) {
                menuitem = new ExecutableMenuItem(Resource.getString("MENU_INSERT_UNMERGE_CHAIN"), new ImageIcon(kit.loadImageResource(Resource.getString("MENU_ICON_INSERT_UNMERGE_CHAIN")))){

                    public void execute() {
                        MiningMartDrawingView.this.application.promptUnmergeChain();
                    }
                };
                menu.add(menuitem);
                menuitem = new ExecutableMenuItem(Resource.getString("MENU_INSERT_SHOW_CHAINCONCEPTS"), (Icon)new ImageIcon(kit.loadImageResource(Resource.getString("MENU_ICON_INSERT_SHOW_DATAMODEL"))), listener){

                    public void execute() {
                        boolean editing;
                        MiningMartApplication app = MiningMartDrawingView.this.application;
                        MiningMartSelectionListener listener = this.getListener();
                        String casename = app.getModel().getName();
                        if (app.getEditorMode() == 1) {
                            casename = M4Interface.getCurrentCase().getName();
                        }
                        Chain chain = listener.getSelectedMiningMartChain().getChain();
                        Iterator it = null;
                        try {
                            it = chain.getInvolvedConcepts().iterator();
                        }
                        catch (M4Exception e) {
                            M4Interface.print.doPrint(Print.ERROR, e.getMessage(), e);
                        }
                        Vector<String> conceptNames = new Vector<String>();
                        while (it.hasNext()) {
                            Concept myCon = (Concept)it.next();
                            conceptNames.add(myCon.getName());
                        }
                        boolean bl = editing = app.getViewMode() == 0;
                        if (!app.promptClose()) {
                            return;
                        }
                        app.setDataModel(conceptNames);
                        app.setEditorMode(1);
                        app.promptOpen(casename, editing, false);
                    }
                };
                menu.add(menuitem);
            }
            menuitem = new ExecutableMenuItem(Resource.getString("MENU_EDIT_DELETE"), (Icon)new ImageIcon(kit.loadImageResource(Resource.getString("MENU_ICON_EDIT_DELETE"))), listener){

                public void execute() {
                    boolean doDelete = MiningMartDrawingView.this.showDoubleCheckMessage();
                    if (doDelete) {
                        if (this.getListener().isMiningMartChainSelected()) {
                            this.getListener().getSelectedMiningMartChain().destroy();
                        } else if (this.getListener().isMiningMartStepSelected()) {
                            this.getListener().getSelectedMiningMartStep().destroy();
                        } else if (this.getListener().isStepTransitionSelected()) {
                            this.getListener().getSelectedStepTransition().destroy();
                        }
                        ((MiningMartDrawingView)MiningMartDrawingView.this.application.getMainPane().getDrawingView()).repaint();
                    }
                }
            };
            if (this.application.getViewMode() == 0) {
                menu.add(menuitem);
            }
        }
        if (menu.getComponents().length > 0) {
            menu.addSeparator();
        }
        menuitem = new ExecutableMenuItem(Resource.getString("MENU_WINDOW_CLOSE_TAB"), new ImageIcon(kit.loadImageResource(Resource.getString("MENU_ICON_WINDOW_CLOSE_TAB")))){

            public void execute() {
                MiningMartDrawingView.this.application.getMainPane().remove(MiningMartDrawingView.this.application.getMainPane().getCurrentPanel());
            }
        };
        menu.add(menuitem);
        menu.pack();
        menu.show((Component)((Object)this), x, y);
    }

    public void createConceptJPopupMenu(int x, int y) {
        ExecutableMenuItem menuitem;
        Iconkit kit = Iconkit.instance();
        JPopupMenu menu = new JPopupMenu();
        MiningMartSelectionListener listener = (MiningMartSelectionListener)this.selectionlistener.getFirst();
        if (this.application.getViewMode() == 0) {
            // empty if block
        }
        if (listener.isMiningMartConceptSelected()) {
            menuitem = new ExecutableMenuItem("Show BaseAttributes", (Icon)new ImageIcon(kit.loadImageResource(Resource.getString("MENU_ICON_SHOW_FEATURE"))), listener){

                public void execute() {
                    FeaturePanel panel = new FeaturePanel(MiningMartDrawingView.this.application, this.getListener().getSelectedMiningMartConcept(), true);
                    MiningMartDrawingView.this.application.showConceptPanel(panel);
                }
            };
            menu.add(menuitem);
            menuitem = new ExecutableMenuItem("Show MultiColumnFeatures", (Icon)new ImageIcon(kit.loadImageResource(Resource.getString("MENU_ICON_SHOW_FEATURE"))), listener){

                public void execute() {
                    FeaturePanel panel = new FeaturePanel(MiningMartDrawingView.this.application, this.getListener().getSelectedMiningMartConcept(), false);
                    MiningMartDrawingView.this.application.showConceptPanel(panel);
                }
            };
            if (listener.getSelectedMiningMartConcept().getConcept().getType().equals("DB")) {
                menuitem = new ExecutableMenuItem("Create Connection", (Icon)new ImageIcon(kit.loadImageResource(Resource.getString("MENU_ICON_CONCEPT_CONNECTION"))), listener){

                    public void execute() {
                        ConnectionPanel panel = new ConnectionPanel(MiningMartDrawingView.this.application, this.getListener().getSelectedMiningMartConcept().getConcept());
                        MiningMartDrawingView.this.application.showConceptPanel(panel);
                    }
                };
                menu.add(menuitem);
                Concept concept = listener.getSelectedMiningMartConcept().getConcept();
                int nrcolumnsets = 0;
                try {
                    Collection coll = concept.getColumnSets();
                    if (coll != null) {
                        nrcolumnsets = coll.size();
                    }
                }
                catch (Exception e) {
                    nrcolumnsets = 0;
                }
                if (nrcolumnsets != 0) {
                    menuitem = new ExecutableMenuItem("Show Mapping", (Icon)new ImageIcon(kit.loadImageResource(Resource.getString("MENU_ICON_CONCEPT_MAPPING"))), listener){

                        public void execute() {
                            MappingPanel panel = new MappingPanel(MiningMartDrawingView.this.application, this.getListener().getSelectedMiningMartConcept().getConcept());
                            MiningMartDrawingView.this.application.showConceptPanel(panel);
                        }
                    };
                    menu.add(menuitem);
                }
            }
            menuitem = new ExecutableMenuItem("Show Columnsets", (Icon)new ImageIcon(kit.loadImageResource(Resource.getString("MENU_ICON_SHOW_FEATURE"))), listener){

                public void execute() {
                    ColumnsetPanel panel = new ColumnsetPanel(MiningMartDrawingView.this.application, this.getListener().getSelectedMiningMartConcept().getConcept());
                    MiningMartDrawingView.this.application.showConceptPanel(panel);
                }
            };
            menu.add(menuitem);
            menuitem = new ExecutableMenuItem("Show estimated statistics", (Icon)new ImageIcon(kit.loadImageResource(Resource.getString("MENU_ICON_SHOW_FEATURE"))), listener){

                public void execute() {
                    Concept con = this.getListener().getSelectedMiningMartConcept().getConcept();
                    Step estimationsForThisStep = null;
                    new EstimatedStatisticsDialog(MiningMartDrawingView.this.application, con, estimationsForThisStep);
                }
            };
            menu.add(menuitem);
        }
        if (listener.isMiningMartRelationSelected()) {
            menuitem = new ExecutableMenuItem("Edit Relation...", (Icon)new ImageIcon(kit.loadImageResource(Resource.getString("MENU_ICON_SHOW_FEATURE"))), listener){

                public void execute() {
                    MiningMartRelation mmartrelation = this.getListener().getSelectedMiningMartRelation();
                    new CreateRelationDialog(MiningMartDrawingView.this.application, mmartrelation);
                }
            };
            menu.add(menuitem);
        }
        if (listener.isAnythingSelected()) {
            menuitem = new ExecutableMenuItem(Resource.getString("MENU_EDIT_DELETE"), (Icon)new ImageIcon(kit.loadImageResource(Resource.getString("MENU_ICON_EDIT_DELETE"))), listener){

                public void execute() {
                    boolean doDelete = MiningMartDrawingView.this.showDoubleCheckMessage();
                    if (doDelete) {
                        if (this.getListener().isMiningMartChainSelected()) {
                            this.getListener().getSelectedMiningMartChain().destroy();
                        } else if (this.getListener().isMiningMartStepSelected()) {
                            this.getListener().getSelectedMiningMartStep().destroy();
                        } else if (this.getListener().isStepTransitionSelected()) {
                            this.getListener().getSelectedStepTransition().destroy();
                        } else if (this.getListener().isMiningMartConceptSelected()) {
                            this.getListener().getSelectedMiningMartConcept().destroy();
                        } else if (this.getListener().isMiningMartProjectionSelected()) {
                            this.getListener().getSelectedMiningMartProjection().destroy();
                        } else if (this.getListener().isMiningMartRelationSelected()) {
                            this.getListener().getSelectedMiningMartRelation().destroy();
                        } else if (this.getListener().isMiningMartSubConceptSelected()) {
                            this.getListener().getSelectedMiningMartSubConcept().destroy();
                        }
                        ((MiningMartDrawingView)MiningMartDrawingView.this.application.getMainPane().getDrawingView()).repaint();
                    }
                }
            };
            if (this.application.getViewMode() == 0) {
                menu.add(menuitem);
            }
        }
        if (menu.getComponents().length > 0) {
            menu.addSeparator();
        }
        menuitem = new ExecutableMenuItem(Resource.getString("MENU_WINDOW_CLOSE_TAB"), new ImageIcon(kit.loadImageResource(Resource.getString("MENU_ICON_WINDOW_CLOSE_TAB")))){

            public void execute() {
                MiningMartDrawingView.this.application.getMainPane().remove(MiningMartDrawingView.this.application.getMainPane().getCurrentPanel());
            }
        };
        menu.add(menuitem);
        menu.pack();
        menu.show((Component)((Object)this), x, y);
    }

    private boolean showDoubleCheckMessage() {
        int choice = JOptionPane.showConfirmDialog(this.application, "Are you sure you want to delete the selected element(s)?", "Really delete?", 0);
        return choice == 0;
    }

    private class ExecutableMenuItem
    extends JMenuItem
    implements ActionListener {
        private MiningMartSelectionListener listener;

        public ExecutableMenuItem(String text, Icon icon) {
            super(text, icon);
            this.addActionListener(this);
        }

        public ExecutableMenuItem(String text, Icon icon, MiningMartSelectionListener listener) {
            super(text, icon);
            this.listener = listener;
            this.addActionListener(this);
        }

        public ExecutableMenuItem(String text, Icon icon, char mnemonic) {
            super(text, icon);
            this.setMnemonic(mnemonic);
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent e) {
            this.execute();
        }

        public void execute() {
        }

        public MiningMartSelectionListener getListener() {
            return this.listener;
        }
    }
}

