/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.gui.application;

import edu.udo.cs.miningmart.compiler.CompilerAccess;
import edu.udo.cs.miningmart.compiler.CompilerAccessLogic;
import edu.udo.cs.miningmart.compiler.M4CompilerInterfaceError;
import edu.udo.cs.miningmart.db.ConfigReader;
import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.gui.application.AboutDialog;
import edu.udo.cs.miningmart.gui.application.CompilerThread;
import edu.udo.cs.miningmart.gui.application.ConceptFromTableDialog;
import edu.udo.cs.miningmart.gui.application.ConceptToolPanel;
import edu.udo.cs.miningmart.gui.application.ExistingTransitionsDialog;
import edu.udo.cs.miningmart.gui.application.MatchingConceptsDialog;
import edu.udo.cs.miningmart.gui.application.MiningMartDrawing;
import edu.udo.cs.miningmart.gui.application.MiningMartDrawingView;
import edu.udo.cs.miningmart.gui.application.MiningMartMenuBar;
import edu.udo.cs.miningmart.gui.application.MiningMartSelectionListener;
import edu.udo.cs.miningmart.gui.application.MiningMartToolBar;
import edu.udo.cs.miningmart.gui.application.NewCaseDialog;
import edu.udo.cs.miningmart.gui.application.OpenCaseDialog;
import edu.udo.cs.miningmart.gui.application.OpenCaseThread;
import edu.udo.cs.miningmart.gui.application.OpeningCaseDialog;
import edu.udo.cs.miningmart.gui.application.OperatorToolPanel;
import edu.udo.cs.miningmart.gui.application.PrintViewer;
import edu.udo.cs.miningmart.gui.application.SetModeDialog;
import edu.udo.cs.miningmart.gui.application.StartWindow;
import edu.udo.cs.miningmart.gui.application.StepSelectionDialog;
import edu.udo.cs.miningmart.gui.concepteditor.ConceptPanel;
import edu.udo.cs.miningmart.gui.model.MiningMartCase;
import edu.udo.cs.miningmart.gui.model.MiningMartChain;
import edu.udo.cs.miningmart.gui.model.MiningMartConcept;
import edu.udo.cs.miningmart.gui.model.MiningMartConcepts;
import edu.udo.cs.miningmart.gui.model.MiningMartModel;
import edu.udo.cs.miningmart.gui.model.MiningMartModelFigureElement;
import edu.udo.cs.miningmart.gui.model.MiningMartStep;
import edu.udo.cs.miningmart.gui.model.StepTransition;
import edu.udo.cs.miningmart.gui.stepsettings.StepSettingsPanel;
import edu.udo.cs.miningmart.gui.util.CaseExporter;
import edu.udo.cs.miningmart.gui.util.CaseImporter;
import edu.udo.cs.miningmart.gui.util.CaseTrasher;
import edu.udo.cs.miningmart.gui.util.DbConfigEditor;
import edu.udo.cs.miningmart.gui.util.GarbageCollector;
import edu.udo.cs.miningmart.installer.MmInstallerTools;
import edu.udo.cs.miningmart.m4.Case;
import edu.udo.cs.miningmart.m4.Chain;
import edu.udo.cs.miningmart.m4.Columnset;
import edu.udo.cs.miningmart.m4.Concept;
import edu.udo.cs.miningmart.m4.EstimatedStatistics;
import edu.udo.cs.miningmart.m4.GraphicalM4Object;
import edu.udo.cs.miningmart.m4.M4Interface;
import edu.udo.cs.miningmart.m4.Operator;
import edu.udo.cs.miningmart.m4.Step;
import edu.udo.cs.miningmart.m4.utils.Print;
import edu.udo.cs.miningmart.schemamatching.DataModelConnection;
import edu.udo.cs.miningmart.schemamatching.DataModelMatcher;
import edu.udo.cs.miningmart.schemamatching.MatchingResult;
import edu.udo.cs.miningmart.schemamatching.MmSchemaMatcher;
import edu.udo.cs.miningmart.schemamatching.NgramMatcher;
import edu.udo.cs.miningmart.schemamatching.SchemaMatchException;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.jhotdraw.figures.LineConnection;
import org.jhotdraw.framework.Drawing;
import org.jhotdraw.framework.DrawingView;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.framework.FigureEnumeration;
import org.jhotdraw.util.Iconkit;
import org.musoft.limo.application.Application;
import org.musoft.limo.application.MenuBar;
import org.musoft.limo.application.Resource;
import org.musoft.limo.application.ToolBar;
import org.musoft.limo.drawing.DrawingPanel;
import org.musoft.limo.drawing.ModelConnection;
import org.musoft.limo.drawing.ModelDrawing;
import org.musoft.limo.drawing.ModelFigure;
import org.musoft.limo.model.Model;
import org.musoft.limo.model.ModelConnectionElement;
import org.musoft.limo.model.ModelFigureElement;
import org.musoft.limo.util.Preferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MiningMartApplication
extends Application {
    private Drawing drawing;
    public static final String SYSTEM_PROP_MM_HOME = "MM_HOME";
    public static boolean compileLazy = true;
    public static CompilerThread compilerThread;
    public static CompilerAccess compilerAccess;
    public static boolean keepCase;
    public static M4Interface m4Interface;
    private static CaseExporter caseExporter;
    private static CaseImporter caseImporter;
    private static int experimentCounter;
    private static String pathOfWorkingDir;
    public Case currentcase;
    private String opsintoolpanel;
    private Vector opsintp_vector;
    private OperatorToolPanel operatortoolpanel;
    private ConceptToolPanel concepttoolpanel;
    private ConceptPanel conceptpanel;
    private StepSettingsPanel stepsettings;
    private boolean showstepsettings = false;
    public PrintViewer logservice;
    private String actualcasename = null;
    private String workingdir;
    private int nrFeatures;
    private boolean drawSubconceptLinks = true;
    private boolean drawRelationships = true;
    private boolean drawProjections = true;
    private Point operatorPoint;
    private Point conceptPoint;
    private Collection datamodel;
    private int editormode = DEFAULT_MODE;
    public static int DEFAULT_MODE;
    public static final int CASE_MODE = 0;
    public static final int CONCEPT_MODE = 1;
    boolean openedCaseEditor;
    boolean openedForUpdate;

    public MiningMartApplication() {
        Iconkit kit = new Iconkit((Component)this);
        this.setIconImage(kit.loadImageResource(Resource.getString("MMART_ICON")));
        m4Interface = M4Interface.getInstance();
        this.logservice = new PrintViewer(this);
        this.showComponentInTab(this.logservice, 2, false);
        this.setDefaultCloseOperation(0);
        ((MiningMartMenuBar)this.getJMenuBar()).setRecentCasesGUI();
    }

    public int getEditorMode() {
        return this.editormode;
    }

    public void setEditorMode(int mode) {
        if (this.editormode == mode) {
            return;
        }
        this.editormode = mode;
        ((MiningMartMenuBar)this.getJMenuBar()).promptSwitchEditor();
    }

    @Override
    protected void createComponents() {
        super.createComponents();
    }

    @Override
    protected Model createModel() {
        if (this.currentcase == null) {
            this.currentcase = M4Interface.getCurrentCase();
        }
        if (this.currentcase == null) {
            return null;
        }
        if (this.editormode == 0) {
            MiningMartCase mmcase = new MiningMartCase(this, this.currentcase);
            mmcase.initTheCase();
            return mmcase;
        }
        if (this.editormode == 1) {
            MiningMartConcepts mmartconcepts = new MiningMartConcepts(this);
            mmartconcepts.initConcepts();
            return mmartconcepts;
        }
        return null;
    }

    public MiningMartCase getMiningMartCase() {
        if (this.getEditorMode() == 0) {
            return (MiningMartCase)this.getModel();
        }
        return null;
    }

    public MiningMartConcepts getMiningMartConcepts() {
        if (this.getEditorMode() == 1) {
            return (MiningMartConcepts)this.getModel();
        }
        return null;
    }

    @Override
    protected ToolBar createToolBar() {
        return new MiningMartToolBar(this);
    }

    @Override
    protected MenuBar createMenuBar() {
        return new MiningMartMenuBar(this);
    }

    @Override
    protected Drawing createDrawing(Model rootElement) {
        if (rootElement instanceof MiningMartCase) {
            this.drawing = new MiningMartDrawing(this, (MiningMartCase)rootElement);
        }
        if (rootElement instanceof MiningMartChain) {
            this.drawing = new MiningMartDrawing(this, (MiningMartChain)rootElement);
        }
        if (rootElement instanceof MiningMartConcepts) {
            this.drawing = new MiningMartDrawing(this, (MiningMartConcepts)rootElement);
        }
        return this.drawing;
    }

    @Override
    protected DrawingView createDrawingView(Model rootElement) {
        boolean wasDirty = this.currentModel.getDirty();
        MiningMartDrawingView mmartdrawview = new MiningMartDrawingView(this);
        mmartdrawview.setDrawing(this.createDrawing(rootElement));
        mmartdrawview.addMiningMartSelectionListener(new MiningMartSelectionListener(this));
        this.fireViewCreatedEvent((DrawingView)mmartdrawview);
        this.currentModel.setDirty(wasDirty);
        return mmartdrawview;
    }

    public Drawing getDrawing() {
        return this.drawing;
    }

    @Override
    protected String[] getModelClassPrefix() {
        return new String[]{"miningmart.hci.gui.model."};
    }

    @Override
    public void figureSelectionChanged(DrawingView dw) {
        super.figureSelectionChanged(dw);
        try {
            FigureEnumeration fenum = dw.selection();
            while (fenum.hasNextFigure()) {
                ModelConnection mocon;
                Figure fig = fenum.nextFigure();
                if (fig instanceof ModelFigure) {
                    ModelFigure mofig = (ModelFigure)fig;
                    if (!dw.isFigureSelected((Figure)mofig)) continue;
                    mofig.bringToFront();
                    continue;
                }
                if (!(fig instanceof ModelConnection) || !dw.isFigureSelected((Figure)(mocon = (ModelConnection)fig))) continue;
                mocon.bringToFront();
            }
        }
        catch (Exception e) {
            M4Interface.print.doPrint(Print.ERROR, e.getMessage(), e);
        }
    }

    @Override
    public String getApplicationName() {
        return Resource.getString("APP_TITLE");
    }

    @Override
    protected void setDefaultLayout() {
        Dimension d = new Dimension(800, 600);
        if (this.getWidth() < d.width) {
            this.setSize(d.width, d.height);
        }
    }

    public static void setSystemProperties() {
        MiningMartApplication.setDefaultProperties();
    }

    public static void setDefaultProperties() {
        String home = System.getProperty(SYSTEM_PROP_MM_HOME);
        System.setProperty("PRINT_VERBOSITY", "Operator");
        System.setProperty("TEMP_DIR", home + File.separator + "temp" + File.separator);
        System.setProperty("LOG_FILES", home + File.separator + "log" + File.separator);
        System.setProperty("ML_HOME", home + File.separator + "ext" + File.separator);
    }

    protected static ImageIcon createImageIcon(String path, String description) {
        URL imgURL = MiningMartApplication.class.getResource(path);
        if (imgURL != null) {
            return new ImageIcon(imgURL, description);
        }
        M4Interface.print.doPrint(Print.ERROR, "Couldn't find file: " + path);
        return null;
    }

    public Point getPointforOperator() {
        if (this.operatorPoint != null) {
            return this.operatorPoint;
        }
        return new Point(10, 10);
    }

    public void setPointForOperator(Point point) {
        this.operatorPoint = point;
    }

    public Point getPointforConcept() {
        if (this.conceptPoint != null) {
            return this.conceptPoint;
        }
        return new Point(10, 10);
    }

    public void setPointForConcept(Point point) {
        this.conceptPoint = point;
    }

    public ModelFigureElement getPotentialParent(int x, int y) {
        JPanel panel = this.getMainPane().getCurrentPanel();
        if (panel instanceof DrawingPanel) {
            return ((ModelDrawing)((DrawingPanel)panel).getDrawing()).getModel();
        }
        return null;
    }

    @Override
    public void showHelp() {
        ((MiningMartMenuBar)this.getJMenuBar()).show_help.setSelected(true);
        super.showHelp();
    }

    public void removeHelp() {
        ((MiningMartMenuBar)this.getJMenuBar()).show_help.setSelected(false);
        this.removeComponentFromTab(this.help);
    }

    @Override
    public void showAboutDialog() {
        AboutDialog aboutDialog = new AboutDialog(this);
    }

    public CompilerAccess getCompilerAccess() {
        if (compilerAccess == null) {
            return new CompilerAccessLogic(M4Interface.getInstance().getM4db(), M4Interface.print);
        }
        return compilerAccess;
    }

    @Override
    public void saveParams() {
        super.saveParams();
        Preferences pref = this.getPreferences();
        this.opsintoolpanel = new String("");
        for (int i = 0; i < this.opsintp_vector.size(); ++i) {
            this.opsintoolpanel = this.opsintoolpanel + (String)this.opsintp_vector.get(i);
            if (i + 1 >= this.opsintp_vector.size()) continue;
            this.opsintoolpanel = this.opsintoolpanel + ";";
        }
        pref.putString("OperatorToolPanel", this.opsintoolpanel);
        String rec_cases = ((MiningMartMenuBar)this.getJMenuBar()).getRecentCases().toString();
        pref.putString("RecentCases", rec_cases);
        pref.putString("WorkingDir", this.workingdir);
        pref.putInt("NumberFeatures", this.nrFeatures);
        pref.putString("Verbosity", M4Interface.print.getMinimumVerbosityLevel().getName());
        String lazy = "false";
        if (compileLazy) {
            lazy = "true";
        }
        pref.putString("CompileLazy", lazy);
        pref.putString("openedCaseEditor", this.openedCaseEditor ? "true" : "false");
        pref.putString("openedForUpdate", this.openedForUpdate ? "true" : "false");
        pref.save(System.getProperty(SYSTEM_PROP_MM_HOME) + File.separatorChar + "config" + File.separatorChar + this.getApplicationName() + ".cfg");
    }

    @Override
    public void loadParams() {
        super.loadParams();
        Preferences pref = new Preferences(System.getProperty(SYSTEM_PROP_MM_HOME) + File.separatorChar + "config" + File.separatorChar + this.getApplicationName() + ".cfg");
        String ops = pref.getString("OperatorToolPanel");
        this.opsintp_vector = new Vector();
        if (ops != null) {
            StringTokenizer st = new StringTokenizer(ops, ";");
            while (st.hasMoreTokens()) {
                this.opsintp_vector.add(st.nextToken());
            }
        }
        this.workingdir = pref.getString("WorkingDir", System.getProperty("user.home"));
        this.nrFeatures = pref.getInt("NumberFeatures", 10);
        String givenVerbosity = System.getProperty("PRINT_VERBOSITY");
        if (givenVerbosity == null) {
            givenVerbosity = Print.DEFAULT_VERBOSITY.getName();
        }
        Level verbosity = Print.getVerbosityLevelForName(pref.getString("Verbosity", givenVerbosity));
        M4Interface.print.setMinimumVerbosityLevel(verbosity);
        String lazy = pref.getString("CompileLazy", "true");
        compileLazy = lazy.equals("true");
        this.openedCaseEditor = pref.getString("openedCaseEditor", "true").equals("true");
        this.openedForUpdate = pref.getString("openedForUpdate", "true").equals("true");
    }

    public String getWorkingDir() {
        return this.workingdir;
    }

    public void setWorkingDir(String dir) {
        this.workingdir = dir;
    }

    public Vector getOperatorsInToolPanel() {
        return this.opsintp_vector;
    }

    public void setOperatorInToolPanel(Vector vector) {
        this.opsintp_vector = (Vector)vector.clone();
    }

    public void refreshOperatorToolPanel() {
        if (this.getEditorMode() == 1) {
            return;
        }
        if (this.currentcase != null) {
            this.removeComponentFromTab(this.operatortoolpanel.getOperatorToolPanel());
        }
        this.operatortoolpanel = new OperatorToolPanel(this);
        if (this.currentcase != null) {
            this.showComponentInTab(this.operatortoolpanel.getOperatorToolPanel(), 1, false);
        }
    }

    @Override
    public void promptOpen() {
        this.promptOpen(null, true, false);
    }

    public void promptOpen(String casename, boolean openCaseForUpdating, boolean forImport) {
        OpenCaseDialog opencased;
        if (this.currentcase != null && !this.promptClose()) {
            return;
        }
        int exitaction = 1;
        if (casename == null && (exitaction = (opencased = new OpenCaseDialog(this)).getExitAction()) == 1) {
            casename = opencased.getSelectedCase();
            openCaseForUpdating = opencased.openCaseForUpdating();
            if (opencased.openCaseEditor()) {
                this.setEditorMode(0);
            } else {
                this.setEditorMode(1);
            }
        }
        if (exitaction == 1) {
            OpenCaseThread openthread = new OpenCaseThread(this, casename, openCaseForUpdating, !keepCase, forImport);
            OpeningCaseDialog dialog = new OpeningCaseDialog(this, casename, openthread);
            openthread.start();
            dialog.setVisible(true);
        }
        this.updateToolsAndMenus();
    }

    public void modelLoaded() {
        if (this.getModel() == null) {
            return;
        }
        for (int i = 0; i < this.getListenerCount(); ++i) {
            this.getListener(i).onModelLoaded(this, this.getModel());
        }
    }

    @Override
    public void promptNew() {
        if (this.currentcase != null && !this.promptClose()) {
            return;
        }
        NewCaseDialog newcased = new NewCaseDialog(this);
        String casename = null;
        if (newcased.getExitAction() != newcased.OK) {
            return;
        }
        casename = newcased.getNewCaseName();
        if (casename == null) {
            return;
        }
        Case newcase = null;
        try {
            boolean setAsCurrentCase = true;
            newcase = m4Interface.createCase(casename, setAsCurrentCase);
        }
        catch (M4Exception error) {
            M4Interface.print.doPrint(Print.ERROR, Resource.getString("ERROR_CREATE_CASE") + " \"" + casename + "\"\n" + error.getMessage(), error);
            JOptionPane.showMessageDialog(this, Resource.getString("ERROR_CREATE_CASE") + " \"" + casename + "\"\n" + error.getMessage(), Resource.getString("DIALOG_ERROR_TITLE"), 0);
            return;
        }
        if (newcase == null) {
            M4Interface.print.doPrint(Print.ERROR, Resource.getString("ERROR_CREATE_CASE") + " \"" + casename + "\"");
            JOptionPane.showMessageDialog(this, Resource.getString("ERROR_CREATE_CASE") + " \"" + casename + "\"", Resource.getString("DIALOG_ERROR_TITLE"), 0);
            return;
        }
        try {
            newcase.store();
        }
        catch (M4Exception error) {
            M4Interface.print.doPrint(Print.ERROR, Resource.getString("ERROR_STORE_CASE") + " \"" + casename + "\"", error);
            JOptionPane.showMessageDialog(this, Resource.getString("ERROR_STORE_CASE") + " \"" + casename + "\"", Resource.getString("DIALOG_ERROR_TITLE"), 0);
            return;
        }
        m4Interface.releaseCase(casename);
        M4Interface.print.doPrint(Print.COMPILER_CASE_CONTROL, Resource.getString("CREATED_NEW_CASE") + " " + casename);
        this.promptOpen(casename, true, false);
    }

    public void promptNewCaseFromData() {
        if (this.currentcase != null && !this.promptClose()) {
            return;
        }
        NewCaseDialog newcased = new NewCaseDialog(this);
        String casename = null;
        if (newcased.getExitAction() != newcased.OK) {
            return;
        }
        casename = newcased.getNewCaseName();
        if (casename == null) {
            return;
        }
        Case newcase = this.getTargetDataModel(casename);
        if (newcase == null) {
            M4Interface.print.doPrint(Print.ERROR, Resource.getString("ERROR_CREATE_CASE") + " \"" + casename + "\"");
            JOptionPane.showMessageDialog(this, Resource.getString("ERROR_CREATE_CASE") + " \"" + casename + "\"", Resource.getString("DIALOG_ERROR_TITLE"), 0);
            return;
        }
        try {
            newcase.putConceptsOnGrid();
            M4Interface.setCurrentCase(newcase);
            newcase.store();
        }
        catch (M4Exception error) {
            M4Interface.print.doPrint(Print.ERROR, Resource.getString("ERROR_STORE_CASE") + " \"" + casename + "\"", error);
            JOptionPane.showMessageDialog(this, Resource.getString("ERROR_STORE_CASE") + " \"" + casename + "\"", Resource.getString("DIALOG_ERROR_TITLE"), 0);
            return;
        }
        m4Interface.releaseCase(casename);
        M4Interface.print.doPrint(Print.COMPILER_CASE_CONTROL, Resource.getString("CREATED_NEW_CASE") + " " + casename);
        this.setEditorMode(1);
        this.promptOpen(casename, true, false);
    }

    @Override
    public void saveModel() {
        if (!this.getModel().getDirty()) {
            return;
        }
        Case ca = M4Interface.getCurrentCase();
        try {
            ca.store();
            this.currentModel.setDirty(false);
        }
        catch (M4Exception error) {
            M4Interface.print.doPrint(Print.ERROR, Resource.getString("ERROR_STORECASE") + "\n" + error.getMessage(), error);
            JOptionPane.showMessageDialog(this, Resource.getString("ERROR_STORECASE") + "\n\n" + error.getMessage(), Resource.getString("TXT_STORECASE"), 0);
            return;
        }
        M4Interface.print.doPrint(Print.COMPILER_CASE_CONTROL, Resource.getString("CASE_SAVED"));
        ((MiningMartMenuBar)this.getJMenuBar()).setItemState(Resource.getString("MENU_CASE") + "." + Resource.getString("MENU_CASE_SAVE"), false);
        ((MiningMartToolBar)this.getToolbar()).enableTool(Resource.getString("TOOL_SAVECASE"), false);
    }

    public void promptDeleteCase() {
        CaseTrasher trasher = new CaseTrasher(this);
        trasher.init();
        trasher.deleteCase();
        ((MiningMartMenuBar)this.getJMenuBar()).setRecentCasesGUI();
    }

    public boolean isShowingStepSettings() {
        return this.showstepsettings;
    }

    public boolean isShowingSettings(MiningMartStep step) {
        if (this.stepsettings == null) {
            return false;
        }
        return this.stepsettings.getMiningMartStep().getName().equals(step.getName());
    }

    public boolean isShowingConceptPanel(MiningMartConcept concept) {
        Concept theconcept = concept.getConcept();
        if (this.conceptpanel == null) {
            return false;
        }
        return this.conceptpanel.getConcept().equals(theconcept);
    }

    public StepSettingsPanel getStepSettings() {
        return this.stepsettings;
    }

    public void setDataModel(Collection datamodel) {
        this.datamodel = datamodel;
    }

    public Collection getDataModel() {
        return this.datamodel;
    }

    public void clearDataModel() {
        this.datamodel = null;
    }

    public boolean hasDataModel() {
        if (this.datamodel == null) {
            return false;
        }
        return this.datamodel.size() != 0;
    }

    @Override
    public boolean promptClose() {
        boolean back = true;
        MiningMartModel.mayChangeDocumentation = false;
        MiningMartModelFigureElement.mayChangeDocumentation = false;
        if (!super.promptClose()) {
            return false;
        }
        MiningMartModel.mayChangeDocumentation = true;
        MiningMartModelFigureElement.mayChangeDocumentation = true;
        ((MiningMartMenuBar)this.getJMenuBar()).promptCloseItemStates();
        ((MiningMartToolBar)this.getToolbar()).promptCloseToolStates();
        this.clearDataModel();
        try {
            if (this.concepttoolpanel != null && this.getViewMode() == 0) {
                this.removeConceptTools();
            }
            if (this.operatortoolpanel != null && this.getViewMode() == 0) {
                this.removeOperatorTools();
            }
            if (this.showstepsettings) {
                this.removeStepSettingsPanel();
            }
            this.removeAnnotations();
            this.removeComponentFromTab(this.notepad);
            this.removeComponentFromTab(this.inspector);
            this.removeComponentFromTab(this.birdsEye);
            this.removeComponentFromTab(this.navigator);
            this.removeConceptPanel();
            this.mainpane.removeAllBut(this.logservice);
        }
        catch (Exception e) {
            M4Interface.print.doPrint(Print.ERROR, e.getMessage(), e);
        }
        if (!keepCase) {
            this.currentcase = null;
        }
        String casename = M4Interface.getCurrentCase().getName();
        if (!keepCase && M4Interface.getCurrentCase() != null) {
            try {
                m4Interface.releaseCaseWithoutStoring(M4Interface.getCurrentCase().getName());
            }
            catch (M4Exception m4Exception) {
                // empty catch block
            }
            M4Interface.removeCurrentCase();
        }
        if (back) {
            this.showComponentInTab(this.logservice, 2, false);
            if (!keepCase) {
                M4Interface.print.doPrint(Print.COMPILER_CASE_CONTROL, Resource.getString("CASE_CLOSED") + " \"" + casename + "\"");
            }
        }
        this.updateToolsAndMenus();
        System.gc();
        return back;
    }

    @Override
    public void exit() {
        if (this.currentModel != null && this.currentModel.getDirty() && this.getViewMode() == 0) {
            int input = JOptionPane.showConfirmDialog(this, Resource.getString("QUEST_SAVECLOSE"), Resource.getString("TXT_CLOSE"), 1);
            if (input == 2) {
                return;
            }
            if (input != 1 && input == 0) {
                this.saveModel();
            }
        }
        if (this.getModel() != null) {
            String casename = M4Interface.getCurrentCase().getName();
            if (M4Interface.getCurrentCase() != null) {
                try {
                    m4Interface.releaseCaseWithoutStoring(M4Interface.getCurrentCase().getName());
                }
                catch (M4Exception m4Exception) {
                    // empty catch block
                }
            }
        }
        this.saveParams();
        this.dispose();
        M4Interface.print.doPrint(Print.MAX, "\n----- " + this.getApplicationTitle() + " Version " + this.getApplicationVersion() + " exited. -----\n\n\n\n\n");
        Print.removeLogFileLock();
        System.exit(0);
    }

    public void promptSetMode() {
        SetModeDialog dia = new SetModeDialog(this, this.currentcase);
    }

    public void exportCase() {
        if (this.currentcase == null) {
            return;
        }
        caseExporter = new CaseExporter(this, this.currentcase);
        caseExporter.exportCase();
    }

    public void importCase() {
        if (this.currentcase != null && !this.promptClose()) {
            return;
        }
        caseImporter = new CaseImporter(this);
        boolean imported = false;
        try {
            imported = caseImporter.importCase();
        }
        catch (IOException e) {
            M4Interface.print.doPrint(Print.ERROR, Resource.getString("IOEXCEPTION_IMPORT") + "\n" + e.getMessage(), e);
            JOptionPane.showMessageDialog(this, Resource.getString("IOEXCEPTION_IMPORT") + "\n" + e.getMessage(), Resource.getString("DIALOG_ERROR_TITLE"), 0);
            return;
        }
        if (imported) {
            M4Interface.print.doPrint(Print.COMPILER_CASE_CONTROL, Resource.getString("CASE_IMPORTED") + " \"" + M4Interface.getCurrentCase().getName() + "\"");
            boolean openCaseForUpdating = true;
            this.promptOpen(M4Interface.getCurrentCase().getName(), openCaseForUpdating, imported);
        }
    }

    public String getActualCaseName() {
        return this.actualcasename;
    }

    public void setActualCaseName(String name) {
        this.actualcasename = name;
    }

    private void fireTraverseModel(ModelFigureElement parentElement) {
        for (int i = 0; i < parentElement.getChildCount(); ++i) {
            ModelFigureElement childElement = parentElement.getChild(i);
            this.navigator.onCreateChild(parentElement, childElement);
            this.fireTraverseModel(childElement);
        }
    }

    private void fireTraverseModel2(ModelFigureElement element) {
        if (element instanceof Model) {
            Model model = (Model)element;
            for (int i = 0; i < model.getConnectionCount(); ++i) {
                ModelConnectionElement childElement = model.getConnection(i);
                this.navigator.onCreateConnection(model, childElement);
            }
        }
        for (int i = 0; i < element.getChildCount(); ++i) {
            ModelFigureElement childElement = element.getChild(i);
            this.fireTraverseModel2(childElement);
        }
    }

    public void promptMergeChain() {
        try {
            FigureEnumeration enum1 = this.getMainPane().getDrawingView().selection();
            int size = 0;
            while (enum1.hasNextFigure()) {
                ++size;
                enum1.nextFigure();
            }
            ModelFigureElement[] elements = new ModelFigureElement[size];
            ModelConnectionElement[] conns = new ModelConnectionElement[size];
            enum1 = this.getMainPane().getDrawingView().selection();
            int index = 0;
            while (enum1.hasNextFigure()) {
                Figure figure = enum1.nextFigure();
                if (figure instanceof ModelFigure) {
                    elements[index] = ((ModelFigure)figure).getElement();
                }
                if (figure instanceof ModelConnection) {
                    conns[index] = ((ModelConnection)figure).getElement();
                }
                ++index;
            }
            if (index == 0) {
                M4Interface.print.doPrint(Print.WARNING, "At least one step or chain must be selected for merging!");
                return;
            }
            Model parentmodel = null;
            for (int i = 0; i < elements.length; ++i) {
                if (elements[i] == null) continue;
                parentmodel = elements[i].getModel();
                break;
            }
            if (parentmodel == null) {
                return;
            }
            LinkedList<GraphicalM4Object> stepsandchains = new LinkedList<GraphicalM4Object>();
            ((MiningMartCase)this.getModel()).setDeleteInDatabase(false, true);
            for (int i = 0; i < size; ++i) {
                if (elements[i] == null) continue;
                if (elements[i] instanceof MiningMartChain) {
                    stepsandchains.add(((MiningMartChain)elements[i]).getChain());
                    ((MiningMartChain)elements[i]).destroy();
                }
                if (!(elements[i] instanceof MiningMartStep)) continue;
                stepsandchains.add(((MiningMartStep)elements[i]).getStep());
                ((MiningMartStep)elements[i]).destroy();
            }
            ((MiningMartCase)this.getModel()).setDeleteInDatabase(true, true);
            String newchainname = new String(Resource.getString("CHAIN"));
            MiningMartChain subchain = null;
            if (parentmodel instanceof MiningMartCase) {
                MiningMartCase parentcase = (MiningMartCase)parentmodel;
                newchainname = parentcase.getTheCase().getValidName(newchainname, Chain.class);
                Chain newchain = parentcase.getTheCase().createChain(newchainname, stepsandchains);
                subchain = parentcase.createMiningMartChain((ModelFigureElement)parentmodel, newchain, this.getPointforOperator(), new Rectangle(35, 35));
                parentcase.getTheCase().addChain(newchain);
                parentcase.organizeTransitions(true);
            } else if (parentmodel instanceof MiningMartChain) {
                MiningMartChain parentchain = (MiningMartChain)parentmodel;
                newchainname = parentchain.getTheCase().getValidName(newchainname, Chain.class);
                Chain newchain = parentchain.getChain().createSubChain(newchainname, stepsandchains);
                subchain = parentchain.createMiningMartChain((ModelFigureElement)parentmodel, newchain, this.getPointforOperator(), new Rectangle(35, 35));
                parentchain.organizeTransitions(true);
            }
            this.getMainPane().getDrawingView().drawAll(this.getMainPane().getDrawingView().getGraphics());
            this.fireTraverseModel(parentmodel);
            this.fireTraverseModel2(parentmodel);
        }
        catch (M4Exception error) {
            M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
        }
        M4Interface.print.doPrint(Print.COMPILER_CASE_CONTROL, Resource.getString("MERGED_CHAIN"));
    }

    public void promptUnmergeChain() {
        try {
            FigureEnumeration enum1 = this.getMainPane().getDrawingView().selection();
            int size = 0;
            while (enum1.hasNextFigure()) {
                ++size;
                enum1.nextFigure();
            }
            if (size != 1) {
                return;
            }
            enum1 = this.getMainPane().getDrawingView().selection();
            ModelFigureElement element = ((ModelFigure)enum1.nextFigure()).getElement();
            if (!(element instanceof MiningMartChain)) {
                return;
            }
            MiningMartChain selchain = (MiningMartChain)element;
            Model parentmodel = (Model)selchain.getParent();
            if (parentmodel instanceof MiningMartCase) {
                ((MiningMartCase)parentmodel).dissolveMiningMartChain(selchain);
            } else if (parentmodel instanceof MiningMartChain) {
                ((MiningMartChain)parentmodel).dissolveMiningMartChain(selchain);
            }
            this.getMainPane().getDrawingView().drawAll(this.getMainPane().getDrawingView().getGraphics());
            this.fireTraverseModel(parentmodel);
            this.fireTraverseModel2(parentmodel);
        }
        catch (M4Exception error) {
            M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
        }
        M4Interface.print.doPrint(Print.COMPILER_CASE_CONTROL, Resource.getString("UNMERGED_CHAIN"));
    }

    public void promptEditDbSettings() {
        String dbConfigFileName = System.getProperty("DB_CONFIG_PATH");
        String homePropFileName = MiningMartApplication.getHomePropertiesFileName();
        HashMap theConnectionValues = null;
        try {
            ConfigReader theReader = new ConfigReader(dbConfigFileName);
            theConnectionValues = MmInstallerTools.storeValuesFromFileInMap(theReader);
        }
        catch (M4Exception m4e) {
            // empty catch block
        }
        theConnectionValues = MmInstallerTools.makeDbConfigFile(dbConfigFileName, homePropFileName, theConnectionValues);
        MmInstallerTools.makeNewDbConnection(false, theConnectionValues, dbConfigFileName, homePropFileName);
    }

    public void addReversingStep() {
        if (!(this.getMainPane().getCurrentPanel() instanceof DrawingPanel)) {
            return;
        }
        MiningMartCase mmCase = this.getMiningMartCase();
        if (mmCase == null) {
            return;
        }
        DrawingPanel panel = (DrawingPanel)this.getMainPane().getCurrentPanel();
        MiningMartDrawingView view = (MiningMartDrawingView)panel.getDrawingView();
        MiningMartSelectionListener listener = view.getMiningMartSelectionListener(0);
        if (!listener.isMiningMartStepSelected()) {
            JOptionPane.showMessageDialog(this, "Please select a Step to be reversed!", "No reversed Step found", 2);
            return;
        }
        MiningMartStep selectedMmStep = listener.getSelectedMiningMartStep();
        Step reversedStep = selectedMmStep.getStep();
        if (!this.isStepReversible(reversedStep)) {
            JOptionPane.showMessageDialog(this, "The selected Step cannot be reversed!", "No reversable Step found", 2);
            return;
        }
        Point point = this.getPointforOperator();
        ModelFigureElement p = this.getPotentialParent(point.x, point.y);
        if (!(p instanceof Model)) {
            M4Interface.print.doPrint(Print.ERROR, "The potential parent must be a model!");
            return;
        }
        point.x += 50;
        point.y += 20;
        MiningMartStep newStep = null;
        try {
            String revStepTableName = "revstep_t";
            if (!M4Interface.getInstance().getM4db().tableExistsInM4(revStepTableName)) {
                int answer = JOptionPane.showConfirmDialog(this, "The table for linking reversing steps does not exist in your M4 schema!\nDo you want to create it now? Otherwise the reversing step cannot be created!", "Missing table", 0);
                if (answer == 1) {
                    return;
                }
                M4Interface.getInstance().getM4db().createReverseStepTable();
            }
        }
        catch (M4Exception m4e) {
            JOptionPane.showMessageDialog(this, "Error trying to access reversing steps table:\n" + m4e.getMessage(), "M4 error", 0);
            return;
        }
        if (p instanceof MiningMartChain) {
            newStep = ((MiningMartChain)p).createMiningMartStep(p, "ReverseFeatureConstruction", "Reverse_" + reversedStep.getName(), point, new Rectangle(point.x, point.y, 35, 35));
        }
        if (newStep != null) {
            try {
                reversedStep.addReversingStep(newStep.getStep());
                JOptionPane.showMessageDialog(this, "The reversing step has been created. Please set its parameters\nsuch that its target attribute corresponds to the output attribute of the step you want to reverse!", "New step created", 1);
            }
            catch (M4Exception m4e) {
                JOptionPane.showMessageDialog(this, "Error trying to add reversing step:\n" + m4e.getMessage(), "M4 error", 0);
                return;
            }
        }
    }

    private boolean isStepReversible(Step aStep) {
        Operator op = aStep.getTheOperator();
        if (op.getName().equals("LinearScaling")) {
            return true;
        }
        if (op.getName().equals("LogScaling")) {
            return true;
        }
        return op.getName().indexOf("Grouping") > -1;
    }

    public void doMaterialisationRecommendations() {
        if (!(this.getMainPane().getCurrentPanel() instanceof DrawingPanel)) {
            return;
        }
        MiningMartCase mmCase = this.getMiningMartCase();
        if (mmCase == null) {
            return;
        }
        if (this.getViewMode() != 0) {
            return;
        }
        Step materialiseAfterThisStep = null;
        try {
            String message;
            int answer;
            materialiseAfterThisStep = this.currentcase.findCandidateStepForMaterialisation();
            if (materialiseAfterThisStep == null) {
                JOptionPane.showMessageDialog(this, "No (further) place for materialisation identified.", "Case ok", 1);
                return;
            }
            String reason = "'.";
            if (materialiseAfterThisStep.isLastStepProducingConceptualOutput()) {
                reason = "', because it is a final Step of this Case.";
            }
            if ((answer = JOptionPane.showConfirmDialog(this, message = "The insertion of a Materialisation operator is recommended after Step\n'" + materialiseAfterThisStep.getName() + reason + "\nDo you want MiningMart to do it?\nIn any case you can get other recommendations by using this feature again.", "Insert Materialisation?", 0)) == 1) {
                return;
            }
        }
        catch (M4Exception m4e) {
            JOptionPane.showMessageDialog(this, "M4 error trying to find Step for materialisation: " + m4e.getMessage(), "Internal error", 0);
            return;
        }
        this.realiseMaterialisationRecommendation(materialiseAfterThisStep);
    }

    public void doGridArrangement() {
        if (!(this.getMainPane().getCurrentPanel() instanceof DrawingPanel)) {
            return;
        }
        boolean arrangeSteps = true;
        MiningMartCase mmCase = this.getMiningMartCase();
        if (mmCase == null) {
            arrangeSteps = false;
        }
        if (this.getViewMode() != 0) {
            return;
        }
        String answer = JOptionPane.showInputDialog(this, "Please enter a grid length:", "50");
        int gridLength = 50;
        try {
            gridLength = Integer.parseInt(answer);
        }
        catch (NumberFormatException n) {
            return;
        }
        try {
            if (arrangeSteps) {
                this.currentcase.arrangeStepsOnGrid(gridLength);
            } else {
                this.currentcase.arrangeConceptsOnGrid(gridLength);
            }
            this.currentcase.store();
            this.currentModel.setDirty(false);
        }
        catch (M4Exception m4e) {
            JOptionPane.showMessageDialog(this, "M4 error rearranging steps: " + m4e.getMessage(), "Error", 0);
        }
        JOptionPane.showMessageDialog(this, "Please close and re-open the case in order to see the effects.", "Rearrangement successful", 1);
    }

    private void suggestAndDoConnection(Collection<Concept> conceptualModel, Collection<Concept> targetModel, DataModelConnection myConnection, MmSchemaMatcher theMatcher, Collection<Concept> conceptsRepresentingJoins) {
        MatchingConceptsDialog mcd;
        Collection<MatchingResult<Concept>> finalMapping;
        if (myConnection.getTheConceptMappings().size() > 0 && (finalMapping = (mcd = new MatchingConceptsDialog(this, conceptualModel, targetModel, myConnection, conceptsRepresentingJoins)).getUserSelectedMapping()) != null && !finalMapping.isEmpty()) {
            try {
                for (MatchingResult<Concept> oneMapping : finalMapping) {
                    Columnset joinCs;
                    Concept one = oneMapping.getObjectOfFirstSchema();
                    Concept two = oneMapping.getObjectOfSecondSchema();
                    if (one == null || two == null) continue;
                    if (conceptsRepresentingJoins.contains(two) && (joinCs = two.getCurrentColumnSet()) != null) {
                        m4Interface.getM4db().createSQLView(joinCs);
                    }
                    m4Interface.connectConceptToCs(one, two, theMatcher);
                }
            }
            catch (M4Exception m4e) {
                JOptionPane.showMessageDialog(this, "M4 error when trying to connect the concepts: " + m4e.getMessage(), "Not all connections done.", 0);
                return;
            }
            catch (SchemaMatchException sme) {
                JOptionPane.showMessageDialog(this, "Schema matching error when trying to connect the concepts: " + sme.getMessage(), "Not all connections done.", 0);
                return;
            }
            JOptionPane.showMessageDialog(this, "All concepts connected!", "Success", 1);
        }
    }

    public Step selectStepForMatching() {
        if (!this.checkConceptEditorIsOpened()) {
            return null;
        }
        StepSelectionDialog selectDialog = new StepSelectionDialog(this, true);
        if (selectDialog.getExitAction() != selectDialog.OK) {
            return null;
        }
        String stepName = selectDialog.getStepName();
        if (stepName == null) {
            return null;
        }
        try {
            return this.currentcase.getStepByName(stepName);
        }
        catch (M4Exception m4e) {
            JOptionPane.showMessageDialog(this, "M4 error trying to access step '" + stepName + "': " + m4e.getMessage(), "M4 problem", 0);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doMatch(Step modelCreatingStep, boolean onlyInitialDataModel) {
        if (!this.checkConceptEditorIsOpened()) {
            return;
        }
        Case targetModelCase = null;
        Collection<Concept> joinConcepts = null;
        MmSchemaMatcher myMatcher = null;
        targetModelCase = this.getTargetDataModel(null);
        myMatcher = this.chooseMatcher();
        try {
            joinConcepts = DataModelMatcher.addJoinsToCase(targetModelCase);
        }
        catch (M4Exception m4e) {
            JOptionPane.showMessageDialog(this, "M4 error when trying to add views representing join results to temporary case:\n" + m4e.getMessage(), "Nothing connected", 0);
            try {
                if (targetModelCase != null) {
                    targetModelCase.deleteSoon();
                }
            }
            catch (M4Exception m) {
                // empty catch block
            }
            return;
        }
        DataModelConnection theMatching = null;
        Collection conceptualModel = null;
        Collection targetModel = null;
        try {
            targetModel = targetModelCase.getConcepts();
            if (onlyInitialDataModel) {
                theMatching = m4Interface.getCurrentCase().findMatchingForInputDataModel(targetModel, myMatcher);
                conceptualModel = m4Interface.getCurrentCase().getInputDataModel();
            } else if (modelCreatingStep == null) {
                theMatching = m4Interface.getCurrentCase().findEntryPoint(targetModel, myMatcher);
                if (theMatching != null) {
                    conceptualModel = theMatching.isInitialDataModel() ? m4Interface.getCurrentCase().getInputDataModel() : theMatching.getDataModelProducingStep().getResultingDataModel();
                }
            } else {
                theMatching = m4Interface.getCurrentCase().findMatchingForResultingDataModel(modelCreatingStep, targetModel, myMatcher);
                conceptualModel = modelCreatingStep.getResultingDataModel();
            }
        }
        catch (M4Exception m4e) {
            JOptionPane.showMessageDialog(this, "M4 error when trying to match:\n" + m4e.getMessage(), "Nothing connected", 0);
            try {
                if (targetModelCase != null) {
                    targetModelCase.deleteSoon();
                }
            }
            catch (M4Exception m) {
                // empty catch block
            }
            return;
        }
        catch (SchemaMatchException sme) {
            JOptionPane.showMessageDialog(this, "Schema match error when trying to match:\n" + sme.getMessage(), "Nothing connected", 0);
            try {
                if (targetModelCase != null) {
                    targetModelCase.deleteSoon();
                }
            }
            catch (M4Exception m) {
                // empty catch block
            }
            return;
        }
        try {
            if (theMatching == null) {
                JOptionPane.showMessageDialog(this, "Sorry, no matching of suitable quality could be found.", "Nothing connected", 1);
                return;
            }
            this.suggestAndDoConnection(conceptualModel, targetModel, theMatching, myMatcher, joinConcepts);
        }
        finally {
            try {
                if (targetModelCase != null) {
                    targetModelCase.deleteSoon();
                }
            }
            catch (M4Exception m) {}
        }
    }

    private MmSchemaMatcher chooseMatcher() {
        NgramMatcher myMatcher = new NgramMatcher(3);
        return myMatcher;
    }

    private Case getTargetDataModel(String nameOfCase) {
        ConceptFromTableDialog tableSelectDialog = new ConceptFromTableDialog(this, false);
        if (tableSelectDialog.getExitAction() != tableSelectDialog.OK) {
            return null;
        }
        String[] selectedDbObjects = tableSelectDialog.getSelectionOfTables();
        if (selectedDbObjects != null) {
            Vector<String> theSelection = new Vector<String>();
            for (int i = 0; i < selectedDbObjects.length; ++i) {
                theSelection.add(selectedDbObjects[i]);
            }
            Case returnCase = null;
            try {
                returnCase = DataModelMatcher.readSchemaToMatch(theSelection, m4Interface, nameOfCase);
            }
            catch (M4Exception m4e) {
                JOptionPane.showMessageDialog(this, "M4 error when loading tables or views from DB: " + m4e.getMessage(), "Error", 0);
            }
            return returnCase;
        }
        return null;
    }

    private boolean checkConceptEditorIsOpened() {
        if (!(this.getMainPane().getCurrentPanel() instanceof DrawingPanel)) {
            return false;
        }
        MiningMartCase mmCase = this.getMiningMartCase();
        if (mmCase != null) {
            return false;
        }
        return this.getViewMode() == 0;
    }

    private void realiseMaterialisationRecommendation(Step stepToMaterialise) {
        if (stepToMaterialise == null) {
            return;
        }
        if (!(this.getMainPane().getCurrentPanel() instanceof DrawingPanel)) {
            return;
        }
        MiningMartCase mmCase = this.getMiningMartCase();
        if (mmCase == null) {
            return;
        }
        try {
            Point p = stepToMaterialise.getPoint();
            MiningMartChain mmChain = this.getMmChainForStep(mmCase, stepToMaterialise);
            if (mmChain == null) {
                return;
            }
            p.x += 50;
            p.y += 20;
            MiningMartStep newMMStep = mmChain.createMiningMartStep(mmChain, "Materialize", "Materializing_" + stepToMaterialise.getName(), p, new Rectangle(p.x, p.y, 35, 35));
            MiningMartStep oldMMStep = this.getMmStepForStep(mmChain, stepToMaterialise);
            if (oldMMStep == null) {
                return;
            }
            Vector<StepTransition> transitionsToChange = new Vector<StepTransition>();
            for (int i = 0; i < mmChain.getConnectionCount(); ++i) {
                StepTransition st = (StepTransition)mmChain.getConnection(i);
                if (!st.getStart().equals(oldMMStep)) continue;
                transitionsToChange.add(st);
            }
            for (StepTransition st : transitionsToChange) {
                StepTransition newStepTrans = mmChain.createTransition(null, newMMStep, st.getEnd(), false);
                newStepTrans.setMMartApplication(mmChain.getMMartApplication());
                mmChain.addStepTransition(newStepTrans);
                mmChain.fireCreateConnection(mmChain, newStepTrans);
                st.destroy();
                mmChain.removeConnection(st);
            }
            StepTransition newSt = mmChain.createTransition(null, oldMMStep, newMMStep, false);
            newSt.setMMartApplication(mmChain.getMMartApplication());
            mmChain.addStepTransition(newSt);
            mmChain.fireCreateConnection(mmChain, newSt);
            this.currentcase.insertMaterialisationAfterStep(stepToMaterialise, newMMStep.getStep());
        }
        catch (M4Exception m4e) {
            JOptionPane.showMessageDialog(this, "M4 error creating materialising step: " + m4e.getMessage(), "Error", 0);
        }
    }

    private MiningMartStep getMmStepForStep(MiningMartChain parentChain, Step anM4Step) {
        if (parentChain == null) {
            return null;
        }
        for (int c = 0; c < parentChain.getChildCount(); ++c) {
            MiningMartStep mmStep = (MiningMartStep)parentChain.getChild(c);
            if (!mmStep.getStep().equals(anM4Step)) continue;
            return mmStep;
        }
        return null;
    }

    private MiningMartChain getMmChainForStep(MiningMartCase mmCase, Step anM4Step) {
        if (mmCase == null) {
            return null;
        }
        for (int c = 0; c < mmCase.getChildCount(); ++c) {
            MiningMartChain mmChain = (MiningMartChain)mmCase.getChild(c);
            if (this.getMmStepForStep(mmChain, anM4Step) == null) continue;
            return mmChain;
        }
        return null;
    }

    public void promptShowAllTransitions() {
        FigureEnumeration enum1 = this.getMainPane().getDrawingView().selection();
        ModelFigureElement start = null;
        ModelFigureElement end = null;
        while (enum1.hasNextFigure()) {
            Figure figure = enum1.nextFigure();
            if (!(figure instanceof LineConnection)) continue;
            start = ((ModelFigure)((LineConnection)figure).startFigure()).getElement();
            end = ((ModelFigure)((LineConnection)figure).endFigure()).getElement();
        }
        if (start == null && end == null) {
            return;
        }
        ExistingTransitionsDialog dialog = new ExistingTransitionsDialog(this, start, end);
    }

    public void showStepSettings() {
        if (!(this.getMainPane().getCurrentPanel() instanceof DrawingPanel)) {
            return;
        }
        DrawingPanel panel = (DrawingPanel)this.getMainPane().getCurrentPanel();
        MiningMartDrawingView view = (MiningMartDrawingView)panel.getDrawingView();
        MiningMartSelectionListener listener = view.getMiningMartSelectionListener(0);
        if (listener.isMiningMartStepSelected()) {
            this.showStepSettings(listener.getSelectedMiningMartStep());
        }
    }

    public void showStepSettings(MiningMartStep step) {
        if (this.showstepsettings) {
            this.removeComponentFromTab(this.stepsettings);
        }
        this.stepsettings = new StepSettingsPanel(this, step);
        this.showComponentInTab(this.stepsettings, 1, true);
        this.showstepsettings = true;
    }

    public void removeStepSettingsPanel() {
        this.removeComponentFromTab(this.stepsettings);
        this.showstepsettings = false;
    }

    public void showConceptPanel(ConceptPanel panel) {
        if (this.conceptpanel != null) {
            this.removeConceptPanel();
        }
        this.conceptpanel = panel;
        this.showComponentInTab(this.conceptpanel, 1, true);
    }

    public void removeConceptPanel() {
        if (this.conceptpanel != null) {
            this.removeComponentFromTab(this.conceptpanel);
        }
    }

    public void setOperatorToolPanel(OperatorToolPanel panel) {
        this.operatortoolpanel = panel;
    }

    public OperatorToolPanel getOperatorToolPanel() {
        return this.operatortoolpanel;
    }

    public void setConceptToolPanel(ConceptToolPanel panel) {
        this.concepttoolpanel = panel;
    }

    public ConceptToolPanel getConceptToolPanel() {
        return this.concepttoolpanel;
    }

    public boolean isReadOnly() {
        return this.getViewMode() == 1;
    }

    public void refreshCompilerAccess() {
        try {
            compilerAccess = new CompilerAccessLogic(M4Interface.getInstance().getM4db(), M4Interface.print);
            M4Interface.setCurrentCompilerAccess(compilerAccess);
        }
        catch (Exception e) {
            M4Interface.print.doPrint(Print.ERROR, e.getMessage(), e);
        }
    }

    private void storeExperimentIdInLogFile() {
        String caseName = this.getActualCaseName();
        String idMessage = "\n\n--- COMPILER RUN / EXPERIMENT ID : " + ++experimentCounter + " (Case: " + caseName + ") ---\n";
        M4Interface.print.doPrint(Print.COMPILER_CASE_CONTROL, idMessage);
    }

    private void checkMaterialisationBeforeCompiling() {
        try {
            Collection inputs = this.currentcase.getInputDataModel();
            long maxSize = -1L;
            for (Concept inputConcept : inputs) {
                long thisSize;
                EstimatedStatistics es = inputConcept.getEstimatedStatistics(null);
                if (es == null || (thisSize = es.getNumberOfRows()) <= maxSize) continue;
                maxSize = thisSize;
            }
            if (maxSize == -1L) {
                return;
            }
            int threshold = 1000000;
            if (maxSize > (long)threshold) {
                Step materialiseAfterThisStep = this.currentcase.findCandidateStepForMaterialisation();
                while (materialiseAfterThisStep != null) {
                    if (materialiseAfterThisStep.isLastStepProducingConceptualOutput()) {
                        materialiseAfterThisStep = this.currentcase.findCandidateStepForMaterialisation();
                        continue;
                    }
                    String message = "Your input data sets are large, at least one of them has more than " + threshold + " tuples.\nThe compilation will probably be faster if an intermediate materialisation step is inserted after\n" + materialiseAfterThisStep.getName() + "\nDo you want MiningMart to do it?\n" + "('NO' will make MiningMart look for other recommendations, and start compiling if there are none;\n" + " 'CANCEL' will start compilation immediately)";
                    int answer = JOptionPane.showConfirmDialog(this, message, "Insert Materialisation?", 1);
                    if (answer == 2) {
                        return;
                    }
                    if (answer == 0) {
                        this.realiseMaterialisationRecommendation(materialiseAfterThisStep);
                    }
                    materialiseAfterThisStep = this.currentcase.findCandidateStepForMaterialisation();
                }
                this.currentcase.store();
            }
        }
        catch (M4Exception m4Exception) {
            // empty catch block
        }
    }

    public void compileStep() {
        if (!(this.getMainPane().getCurrentPanel() instanceof DrawingPanel)) {
            return;
        }
        DrawingPanel panel = (DrawingPanel)this.getMainPane().getCurrentPanel();
        MiningMartDrawingView view = (MiningMartDrawingView)panel.getDrawingView();
        MiningMartSelectionListener listener = view.getMiningMartSelectionListener(0);
        if (!listener.isMiningMartStepSelected()) {
            return;
        }
        MiningMartStep mmStep = listener.getSelectedMiningMartStep();
        long stepID = mmStep.getStep().getId();
        boolean isReady = false;
        boolean compile = true;
        boolean check = true;
        String errorMsg = "";
        Step invalidStep = null;
        try {
            invalidStep = mmStep.getStep();
            check = mmStep.getStep().checkInputParameterEntries();
            if (!mmStep.getStep().checkOutputParameterEntries()) {
                check = false;
            }
        }
        catch (M4Exception error) {
            check = false;
            errorMsg = error.getMessage();
        }
        if (!check) {
            boolean bl = compile = JOptionPane.showConfirmDialog(this, Resource.getString("COMPILE_VALIDITY_STEP") + "\n" + Resource.getString("COMPILE_VALIDITY_CAUSE") + " (Step '" + invalidStep.getName() + "')\n" + errorMsg + "\nContinue compiling?", Resource.getString("COMPILE_VALIDITY_TITLE"), 2, 0) == 0;
            if (!compile) {
                return;
            }
        }
        try {
            isReady = this.getCompilerAccess().isReadyForCompilation(stepID);
        }
        catch (M4CompilerInterfaceError e) {
            M4Interface.print.doPrint(Print.ERROR, e.getMessage(), e);
            this.refreshCompilerAccess();
        }
        catch (RemoteException re) {
            M4Interface.print.doPrint(Print.ERROR, re.getMessage(), re);
            JOptionPane.showMessageDialog(this, Resource.getString("COMPILER_ACCESS_ERROR_LINE1") + "\n" + Resource.getString("COMPILER_ACCESS_ERROR_LINE2") + "\n" + Resource.getString("COMPILER_ACCESS_ERROR_LINE3"), Resource.getString("COMPILER_ACCESS_ERROR_TITLE"), 0);
            this.refreshCompilerAccess();
            return;
        }
        if (!isReady) {
            JOptionPane.showMessageDialog(this, Resource.getString("COMPILE_NOT_STEP_LINE1") + "\n" + Resource.getString("COMPILE_NOT_STEP_LINE2"), Resource.getString("COMPILE_NOT_STEP_TITLE"), 0);
            return;
        }
        this.storeExperimentIdInLogFile();
        M4Interface.print.doPrint(Print.COMPILER_CASE_CONTROL, Resource.getString("START_COMPILING"));
        compilerThread = new CompilerThread(this, 0, stepID);
        compilerThread.start();
    }

    public void compileAll() {
        boolean check = true;
        boolean compile = true;
        Step step = null;
        Step invalidStep = null;
        String errorMsg = "";
        try {
            Collection coll = M4Interface.getCurrentCase().getAllStepNames();
            Iterator iter = coll.iterator();
            while (iter.hasNext()) {
                invalidStep = step = M4Interface.getCurrentCase().getStepByName((String)iter.next());
                if (!step.checkInputParameterEntries()) {
                    check = false;
                }
                if (step.checkOutputParameterEntries()) continue;
                check = false;
            }
        }
        catch (M4Exception error) {
            check = false;
            errorMsg = error.getMessage();
        }
        if (!check) {
            boolean bl = compile = JOptionPane.showConfirmDialog(this, Resource.getString("COMPILE_VALIDITY_ALL_STEPS") + "\n" + Resource.getString("COMPILE_VALIDITY_CAUSE") + " (Step '" + invalidStep.getName() + "')\n" + errorMsg + "\nContinue compiling?", Resource.getString("COMPILE_VALIDITY_TITLE"), 2, 0) == 0;
            if (!compile) {
                return;
            }
        }
        this.storeExperimentIdInLogFile();
        M4Interface.print.doPrint(Print.COMPILER_CASE_CONTROL, Resource.getString("START_COMPILING"));
        compilerThread = new CompilerThread(this, 3, 0L);
        compilerThread.start();
        this.getModel().setDirty(true);
    }

    public void compileUntil() {
        if (!(this.getMainPane().getCurrentPanel() instanceof DrawingPanel)) {
            return;
        }
        DrawingPanel panel = (DrawingPanel)this.getMainPane().getCurrentPanel();
        MiningMartDrawingView view = (MiningMartDrawingView)panel.getDrawingView();
        MiningMartSelectionListener listener = view.getMiningMartSelectionListener(0);
        if (!listener.isMiningMartStepSelected()) {
            return;
        }
        MiningMartStep mmStep = listener.getSelectedMiningMartStep();
        long stepID = mmStep.getStep().getId();
        boolean check = true;
        boolean compile = true;
        Step invalidStep = null;
        String errorMsg = "";
        try {
            Collection coll = M4Interface.getCurrentCase().getStepsToCompileBefore(mmStep.getStep(), true);
            Iterator iter = coll.iterator();
            while (iter.hasNext()) {
                Step step;
                invalidStep = step = (Step)iter.next();
                if (!step.checkInputParameterEntries()) {
                    check = false;
                }
                if (step.checkOutputParameterEntries()) continue;
                check = false;
            }
            invalidStep = mmStep.getStep();
            if (!mmStep.getStep().checkInputParameterEntries()) {
                check = false;
            }
            if (!mmStep.getStep().checkOutputParameterEntries()) {
                check = false;
            }
        }
        catch (M4Exception error) {
            check = false;
            errorMsg = error.getMessage();
        }
        if (!check) {
            boolean bl = compile = JOptionPane.showConfirmDialog(this, Resource.getString("COMPILE_VALIDITY_ALL_STEPS") + "\n" + Resource.getString("COMPILE_VALIDITY_CAUSE") + " (Step '" + invalidStep.getName() + "')\n" + errorMsg + "\nContinue compiling?", Resource.getString("COMPILE_VALIDITY_TITLE"), 2, 0) == 0;
            if (!compile) {
                return;
            }
        }
        this.storeExperimentIdInLogFile();
        M4Interface.print.doPrint(Print.COMPILER_CASE_CONTROL, Resource.getString("START_COMPILING"));
        compilerThread = new CompilerThread(this, 2, stepID);
        compilerThread.start();
        this.getModel().setDirty(true);
    }

    public void compileFrom() {
        if (!(this.getMainPane().getCurrentPanel() instanceof DrawingPanel)) {
            return;
        }
        DrawingPanel panel = (DrawingPanel)this.getMainPane().getCurrentPanel();
        MiningMartDrawingView view = (MiningMartDrawingView)panel.getDrawingView();
        MiningMartSelectionListener listener = view.getMiningMartSelectionListener(0);
        if (!listener.isMiningMartStepSelected()) {
            return;
        }
        MiningMartStep mmStep = listener.getSelectedMiningMartStep();
        long stepID = mmStep.getStep().getId();
        boolean check = true;
        boolean compile = true;
        Step invalidStep = null;
        String errorMsg = "";
        try {
            Collection coll = M4Interface.getCurrentCase().getDependentStepsFor(mmStep.getStep());
            Iterator iter = coll.iterator();
            while (iter.hasNext()) {
                Step step;
                invalidStep = step = (Step)iter.next();
                if (!step.checkInputParameterEntries()) {
                    check = false;
                }
                if (step.checkOutputParameterEntries()) continue;
                check = false;
            }
            invalidStep = mmStep.getStep();
            if (!mmStep.getStep().checkInputParameterEntries()) {
                check = false;
            }
            if (!mmStep.getStep().checkOutputParameterEntries()) {
                check = false;
            }
        }
        catch (M4Exception error) {
            check = false;
            errorMsg = error.getMessage();
        }
        if (!check) {
            boolean bl = compile = JOptionPane.showConfirmDialog(this, Resource.getString("COMPILE_VALIDITY_ALL_STEPS") + "\n" + Resource.getString("COMPILE_VALIDITY_CAUSE") + " (Step '" + invalidStep.getName() + "')\n" + errorMsg + "\nContinue compiling?", Resource.getString("COMPILE_VALIDITY_TITLE"), 2, 0) == 0;
            if (!compile) {
                return;
            }
        }
        boolean isReady = false;
        try {
            isReady = this.getCompilerAccess().isReadyForCompilation(stepID);
        }
        catch (M4CompilerInterfaceError error) {
            M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
        }
        catch (RemoteException re) {
            M4Interface.print.doPrint(Print.ERROR, re.getMessage(), re);
            JOptionPane.showMessageDialog(this, Resource.getString("COMPILER_ACCESS_ERROR_LINE1") + "\n" + Resource.getString("COMPILER_ACCESS_ERROR_LINE2") + "\n" + Resource.getString("COMPILER_ACCESS_ERROR_LINE3"), Resource.getString("COMPILER_ACCESS_ERROR_TITLE"), 0);
            this.refreshCompilerAccess();
            return;
        }
        if (isReady) {
            this.storeExperimentIdInLogFile();
            M4Interface.print.doPrint(Print.COMPILER_CASE_CONTROL, Resource.getString("START_COMPILING"));
            compilerThread = new CompilerThread(this, 1, stepID);
            compilerThread.start();
            this.getModel().setDirty(true);
        } else {
            JOptionPane.showMessageDialog(this, Resource.getString("COMPILE_NOT_STEP_LINE1") + "\n" + Resource.getString("COMPILE_NOT_STEP_LINE2"), Resource.getString("COMPILE_NOT_STEP_TITLE"), 0);
        }
    }

    public void killCompilation() {
        try {
            this.getCompilerAccess().killCompilerThread(M4Interface.getCurrentCase().getId());
        }
        catch (RemoteException re) {
            M4Interface.print.doPrint(Print.ERROR, re.getMessage(), re);
        }
        M4Interface.print.doPrint(Print.COMPILER_CASE_CONTROL, "Killed Compilation.");
        ((MiningMartMenuBar)this.getJMenuBar()).promptDoneCompilationItemStates();
        ((MiningMartToolBar)this.getToolbar()).promptDoneCompilationItemStates();
    }

    public void collectGarbage() {
        GarbageCollector collector = new GarbageCollector(this, M4Interface.getCurrentCase());
    }

    public void showAnnotations() {
        ((MiningMartMenuBar)this.getJMenuBar()).show_annotations.setSelected(true);
        this.showComponentInTab(this.hypertextViewer, 1, true);
    }

    public void removeAnnotations() {
        ((MiningMartMenuBar)this.getJMenuBar()).show_annotations.setSelected(false);
        this.removeComponentFromTab(this.hypertextViewer);
    }

    public void showOperatorTools() {
        ((MiningMartMenuBar)this.getJMenuBar()).show_tools.setSelected(true);
        this.showComponentInTab(this.operatortoolpanel.getOperatorToolPanel(), 1, true);
    }

    public void removeOperatorTools() {
        ((MiningMartMenuBar)this.getJMenuBar()).show_tools.setSelected(false);
        this.removeComponentFromTab(this.operatortoolpanel.getOperatorToolPanel());
    }

    public void showConceptTools() {
        ((MiningMartMenuBar)this.getJMenuBar()).show_tools.setSelected(true);
        this.showComponentInTab(this.concepttoolpanel.getConceptToolPanel(), 1, true);
    }

    public void removeConceptTools() {
        ((MiningMartMenuBar)this.getJMenuBar()).show_tools.setSelected(false);
        this.removeComponentFromTab(this.concepttoolpanel.getConceptToolPanel());
    }

    @Override
    public Logger createLogger() {
        return M4Interface.print.getLogger();
    }

    @Override
    public String getApplicationTitle() {
        return Resource.getString("APP_TITLE");
    }

    @Override
    public String getApplicationVersion() {
        return Resource.getString("APP_VERSION");
    }

    @Override
    protected File getConfigPath() {
        File home = new File(System.getProperty(SYSTEM_PROP_MM_HOME) + File.separatorChar + "config");
        File file = new File(home, this.getApplicationName() + ".cfg");
        return file;
    }

    @Override
    protected void checkToolsAndMenus() {
        super.checkToolsAndMenus();
        String title = new String(Resource.getString("APP_TITLE"));
        if (this.currentModel != null) {
            title = title + " - [" + this.currentModel.getName() + "]";
        }
        if (this.currentModel != null && this.getViewMode() == 0 && this.currentModel.getDirty()) {
            title = title + "*";
        }
        if (this.currentModel != null && this.getViewMode() != 0) {
            title = title + " - " + Resource.getString("TXT_READONLY");
        }
        this.setTitle(title);
        this.fireStateChanged();
    }

    public int getNumberOfFeatures() {
        return this.nrFeatures;
    }

    public void setWhichLinksToDraw(boolean subconc, boolean rels, boolean projs) {
        this.drawProjections = projs;
        this.drawRelationships = rels;
        this.drawSubconceptLinks = subconc;
    }

    public boolean shouldDrawSubconceptLinks() {
        return this.drawSubconceptLinks;
    }

    public boolean shouldDrawRelationships() {
        return this.drawRelationships;
    }

    public boolean shouldDrawProjections() {
        return this.drawProjections;
    }

    public void setNumberOfFeatures(int nr) {
        this.nrFeatures = nr;
    }

    public void updateToolsAndMenus() {
        this.checkToolsAndMenus();
    }

    public static void main(String[] args) {
        String homePropertiesFileName = MiningMartApplication.getHomePropertiesFileName();
        MiningMartApplication.readResources(homePropertiesFileName);
        boolean installationOk = false;
        installationOk = MmInstallerTools.installationIsValid();
        if (!installationOk) {
            installationOk = MmInstallerTools.doInstallation(pathOfWorkingDir);
        }
        MmInstallerTools.endDebugMessaging();
        if (!installationOk) {
            JOptionPane.showMessageDialog(null, "Starting MiningMart failed. Please start again and try new installation or DB connection settings.", "Error during startup", 0);
            System.exit(-1);
        }
        MiningMartApplication.setTabbedPaneUiGlobally();
        StartWindow startupWindow = new StartWindow();
        startupWindow.setMessage(Resource.getString("STARTWINDOW_CREATEFRAME"));
        boolean canceled = false;
        while (!MiningMartApplication.validateDbConfigFile() && !canceled) {
            startupWindow.setVisible(false);
            DbConfigEditor editor = new DbConfigEditor(null);
            editor.setRestartWarning(false);
            editor.init();
            canceled = editor.isCanceled();
        }
        if (!MiningMartApplication.validateDbConfigFile()) {
            System.err.println("\n** The database connection could not be established. **");
            System.err.println("** Could not launch the system. **\n");
            System.exit(-1);
        }
        MiningMartApplication m = new MiningMartApplication();
        startupWindow.setMessage(Resource.getString("STARTWINDOW_SHOWFRAME"));
        startupWindow.setVisible(false);
        startupWindow.dispose();
    }

    public static void setTabbedPaneUiGlobally() {
        String className = "edu.udo.cs.miningmart.gui.util.MmTabbedPaneUI";
        try {
            Class<?> cl = Class.forName(className);
            UIManager.getDefaults().put("TabbedPaneUI", cl);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        UIManager.getDefaults().put("TabbedPaneUI", className);
    }

    private static String getHomePropertiesFileName() {
        String path = System.getProperty(SYSTEM_PROP_MM_HOME);
        if (path == null || path.equals("")) {
            path = System.getProperty("user.dir");
            if (path.toLowerCase().endsWith("bin")) {
                path = path.substring(0, path.length() - 3);
            }
            if (path.toLowerCase().endsWith("bin" + File.separator)) {
                path = path.substring(0, path.length() - 4);
            }
        }
        if (!path.endsWith(File.separator)) {
            path = path + File.separator;
        }
        MmInstallerTools.prepareExtraDebugMessageLogFile(path);
        MmInstallerTools.printDebugMessage("'path' is '" + path + "'");
        String filename = path + "config" + File.separator + "MiningMartHome.properties";
        MmInstallerTools.printDebugMessage("'filename' is '" + filename + "'");
        File f = new File(filename);
        String homePropertiesFilename = null;
        if (!f.exists()) {
            String homepath = JOptionPane.showInputDialog(null, "No file 'MiningMartHome.properties' found. The system will create one\nautomatically. Please provide the MiningMart home directory, which is the\npath up to and including 'MiningMart-1.1'.", path);
            if (homepath == null || homepath.equals("")) {
                System.exit(-1);
            }
            if (!homepath.endsWith(File.separator)) {
                homepath = homepath + File.separator;
            }
            if ((homePropertiesFilename = MmInstallerTools.createHomePropertiesFile(homepath)) == null) {
                JOptionPane.showMessageDialog(null, "Error accessing 'MiningMartHome.properties'! Please start again.", "Error starting the system", 0);
                System.exit(-1);
            }
        } else {
            homePropertiesFilename = filename;
        }
        MmInstallerTools.printDebugMessage("'homePropertiesFilename' is '" + homePropertiesFilename + "'");
        pathOfWorkingDir = path;
        return homePropertiesFilename;
    }

    private static void readResources(String homePropertiesFilename) {
        System.out.print("Loading Resources...");
        try {
            MmInstallerTools.readSystemPropsFromHomeProperties(homePropertiesFilename);
            Resource.addSpecResources("operators");
            Resource.addSpecResources("mmart_constants");
            Resource.addSpecResources("mmart_menu");
            Resource.addSpecResources("mmart_toolbar");
            MiningMartApplication.setDefaultProperties();
            MmInstallerTools.printDebugMessage("Resources loaded successfully.");
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Error reading resources! Please check the location of the '*.properties' files and start again. Error message:\n" + e.getMessage(), "Error starting the system", 0);
            System.exit(-1);
        }
        System.out.println("done.");
    }

    private static boolean validateDbConfigFile() {
        String dbConfigPath = System.getProperty("DB_CONFIG_PATH");
        if (dbConfigPath == null || dbConfigPath.length() == 0) {
            System.err.println("Fatal error: Could not read System property DB_CONFIG_PATH to set up database connections!!");
            return false;
        }
        try {
            ConfigReader cr = new ConfigReader(dbConfigPath);
        }
        catch (M4Exception e) {
            System.err.println("Fatal error: File specified by System property DB_CONFIG_PATH does not contain valid information to connect to database.");
            return false;
        }
        M4Interface m4i = M4Interface.getInstance();
        return m4i.getM4db() != null;
    }

    private long calculateMemoryUsage() {
        long mem = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        return mem;
    }

    private void showMemoryUsage() {
        long mem = this.calculateMemoryUsage();
        System.out.println("Memory used " + mem / 1024L + " kbytes");
    }

    static {
        compilerAccess = null;
        keepCase = false;
        experimentCounter = 0;
        DEFAULT_MODE = 0;
    }
}

