/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.gui.application;

import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.gui.application.MiningMartApplication;
import edu.udo.cs.miningmart.m4.Concept;
import edu.udo.cs.miningmart.m4.Step;
import edu.udo.cs.miningmart.schemamatching.DataModelConnection;
import edu.udo.cs.miningmart.schemamatching.MatchingResult;
import edu.udo.cs.miningmart.schemamatching.SchemaMatchException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import org.musoft.limo.application.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatchingConceptsDialog
extends JDialog
implements ActionListener {
    private MiningMartApplication app;
    private JButton closebutton;
    private JButton matchButton;
    private Collection<MatchingResult<Concept>> myMappings;
    private DataModelConnection myDmc;
    private Collection<Concept> conceptualModel;
    private Collection<Concept> targetModel;
    private Collection<Concept> myJoinResults;
    private String[] allTargetNames;
    private String[][] tableData;
    private int noOfRowsInTable;

    public MatchingConceptsDialog(MiningMartApplication app, Collection<Concept> conceptualModel, Collection<Concept> targetModel, DataModelConnection dmc, Collection<Concept> joinResults) {
        super(app, Resource.getString("SHOW_MATCHINGS_TITLE"), true);
        this.app = app;
        this.conceptualModel = conceptualModel;
        this.targetModel = targetModel;
        this.myDmc = dmc;
        this.myMappings = this.myDmc.getTheConceptMappings();
        this.myJoinResults = joinResults;
        if (this.myMappings == null || this.targetModel == null || this.conceptualModel == null) {
            return;
        }
        this.allTargetNames = new String[this.targetModel.size() + 1];
        this.allTargetNames[0] = Resource.getString("MAPPING_NONE");
        int i = 1;
        for (Concept target : this.targetModel) {
            this.allTargetNames[i] = target.getName();
            ++i;
        }
        int heightOfTable = this.initComponents();
        if (heightOfTable == -1) {
            return;
        }
        this.setDefaultCloseOperation(2);
        this.pack();
        this.setSize(600, 150 + heightOfTable * 25);
        Dimension size = this.getSize();
        this.setLocation((Toolkit.getDefaultToolkit().getScreenSize().width - size.width) / 2, (Toolkit.getDefaultToolkit().getScreenSize().height - size.height) / 2);
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!(e.getSource() instanceof JButton)) {
            return;
        }
        JButton source = (JButton)e.getSource();
        if (source.getText().equals(this.matchButton.getText())) {
            this.myMappings = new Vector<MatchingResult<Concept>>();
            for (int i = 0; i < this.tableData.length; ++i) {
                MatchingResult<Concept> mapping;
                String conceptualConcept = this.tableData[i][0];
                String targetConcept = this.tableData[i][1];
                if (targetConcept == null || targetConcept.equalsIgnoreCase(Resource.getString("MAPPING_NONE"))) continue;
                if (targetConcept.indexOf("(") > -1) {
                    targetConcept = targetConcept.substring(0, targetConcept.indexOf("(")).trim();
                }
                if ((mapping = this.collectConcepts(conceptualConcept, targetConcept)) == null) continue;
                this.myMappings.add(mapping);
            }
        }
        if (source.getText().equals(this.closebutton.getText())) {
            this.myMappings = null;
        }
        this.dispose();
    }

    public Collection<MatchingResult<Concept>> getUserSelectedMapping() {
        return this.myMappings;
    }

    private MatchingResult<Concept> collectConcepts(String concName, String targetName) {
        MatchingResult<Concept> mr = new MatchingResult<Concept>();
        try {
            for (Concept cc : this.conceptualModel) {
                if (!cc.getName().equalsIgnoreCase(concName)) continue;
                mr.setObjectOfFirstSchema(cc);
            }
            for (Concept tc : this.targetModel) {
                if (!tc.getName().equalsIgnoreCase(targetName)) continue;
                mr.setObjectOfSecondSchema(tc);
            }
        }
        catch (SchemaMatchException sm) {
            // empty catch block
        }
        if (mr.getObjectOfFirstSchema() != null && mr.getObjectOfSecondSchema() != null) {
            return mr;
        }
        return null;
    }

    private int initComponents() {
        Step s;
        JPanel mainpanel = new JPanel(new BorderLayout(5, 5));
        this.getContentPane().add(mainpanel);
        JPanel northpanel = new JPanel(new BorderLayout(5, 5));
        northpanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        mainpanel.add((Component)northpanel, "North");
        JLabel namelabel = new JLabel(Resource.getString("SHOW_MATCHINGS_LABEL"));
        JLabel simLabel = new JLabel("\nOverall similarity: " + this.myDmc.getSimilarity());
        String text = "";
        if (this.myDmc.isInitialDataModel()) {
            text = text + "\nThe initial data model was matched.";
        }
        if ((s = this.myDmc.getDataModelProducingStep()) != null) {
            text = text + "\nThe Step that produces this data model is '" + s.getName() + "' from Chain '" + s.getTheChain().getName() + "'.";
        }
        JLabel infoLabel = new JLabel(text);
        namelabel.getFont().deriveFont(1, 15.0f);
        infoLabel.getFont().deriveFont(1, 15.0f);
        simLabel.getFont().deriveFont(1, 15.0f);
        namelabel.setHorizontalAlignment(0);
        infoLabel.setHorizontalAlignment(0);
        simLabel.setHorizontalAlignment(0);
        northpanel.add((Component)namelabel, "North");
        northpanel.add((Component)simLabel, "Center");
        northpanel.add((Component)infoLabel, "South");
        JPanel buttonpanel = new JPanel(new GridLayout(1, 2));
        mainpanel.add((Component)buttonpanel, "South");
        this.closebutton = new JButton(Resource.getString("CANCEL"));
        this.closebutton.addActionListener(this);
        this.matchButton = new JButton(Resource.getString("CONNECT"));
        this.matchButton.addActionListener(this);
        buttonpanel.add(this.matchButton);
        buttonpanel.add(this.closebutton);
        JScrollPane theInfoTable = this.createInfoTable();
        if (theInfoTable == null) {
            JOptionPane.showMessageDialog(this.app, "No mapping information found!", "Error displaying matching information", 0);
            this.dispose();
            return -1;
        }
        mainpanel.add((Component)theInfoTable, "Center");
        return this.noOfRowsInTable;
    }

    private JScrollPane createInfoTable() {
        this.noOfRowsInTable = Math.max(this.myMappings.size(), Math.max(this.conceptualModel.size(), this.targetModel.size()));
        this.tableData = new String[this.noOfRowsInTable][3];
        String[] columnNames = new String[]{"Concepts of current Case", "DB objects", "Similarity"};
        try {
            int rowIndex = 0;
            for (MatchingResult<Concept> oneMapping : this.myMappings) {
                Concept left = oneMapping.getObjectOfFirstSchema();
                Concept right = oneMapping.getObjectOfSecondSchema();
                String ext = " (" + (right.getCurrentColumnSet().getType().equals("T") ? "Table" : "View");
                if (this.myJoinResults.contains(right)) {
                    ext = ext + ", Join result";
                }
                ext = ext + ")";
                this.tableData[rowIndex][0] = left.getName();
                this.tableData[rowIndex][1] = right.getName() + ext;
                this.tableData[rowIndex][2] = "" + oneMapping.getSimilarity();
                ++rowIndex;
            }
            for (Concept leftover : this.conceptualModel) {
                if (!this.notMatched(leftover)) continue;
                this.tableData[rowIndex][0] = leftover.getName();
                ++rowIndex;
            }
        }
        catch (M4Exception m4e) {
            return null;
        }
        MappingTable table = new MappingTable(columnNames);
        table.createEditor();
        JScrollPane scrollpane = new JScrollPane(table);
        return scrollpane;
    }

    private boolean notMatched(Concept c) {
        for (MatchingResult<Concept> oneMapping : this.myMappings) {
            Concept left = oneMapping.getObjectOfFirstSchema();
            if (!left.equals(c)) continue;
            return false;
        }
        return true;
    }

    private class MappingTableModel
    extends AbstractTableModel {
        private String[] colNames;

        public MappingTableModel(String[] columnNames) {
            this.colNames = columnNames;
        }

        public int getColumnCount() {
            return 3;
        }

        public int getRowCount() {
            return MatchingConceptsDialog.this.conceptualModel.size();
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex >= 0 && columnIndex <= 2) {
                return MatchingConceptsDialog.this.tableData[rowIndex][columnIndex];
            }
            return null;
        }

        public Class getColumnClass(int columnIndex) {
            return String.class;
        }

        public String getColumnName(int column) {
            return this.colNames[column];
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            if (MatchingConceptsDialog.this.app.getViewMode() != 0) {
                return false;
            }
            return columnIndex == 1;
        }

        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (columnIndex == 1) {
                String value = (String)aValue;
                if (value.equals(Resource.getString("MAPPING_NONE"))) {
                    ((MatchingConceptsDialog)MatchingConceptsDialog.this).tableData[rowIndex][1] = Resource.getString("MAPPING_NONE");
                    ((MatchingConceptsDialog)MatchingConceptsDialog.this).tableData[rowIndex][2] = null;
                } else {
                    ((MatchingConceptsDialog)MatchingConceptsDialog.this).tableData[rowIndex][1] = value;
                    ((MatchingConceptsDialog)MatchingConceptsDialog.this).tableData[rowIndex][2] = null;
                }
                this.fireTableDataChanged();
            }
        }
    }

    private class MappingTable
    extends JTable {
        public MappingTable(String[] columnNames) {
            this.setSelectionMode(0);
            this.getTableHeader().setReorderingAllowed(false);
            this.setRowHeight(this.getRowHeight() + 4);
            this.setModel(new MappingTableModel(columnNames));
            this.getColumnModel().getColumn(2).setMaxWidth(60);
        }

        public void createEditor() {
            TableColumn tablecolumn = this.getColumnModel().getColumn(1);
            JComboBox<String> comboBox = new JComboBox<String>(MatchingConceptsDialog.this.allTargetNames);
            tablecolumn.setCellEditor(new DefaultCellEditor(comboBox));
        }
    }
}

