/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.gui.application;

import edu.udo.cs.miningmart.m4.M4Interface;
import edu.udo.cs.miningmart.m4.utils.Print;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import org.jhotdraw.util.Iconkit;
import org.musoft.limo.application.Resource;

public class LogFileViewer
extends JDialog
implements ActionListener,
TreeSelectionListener {
    private JTextArea textarea;
    private JButton close_button;
    private String logtext;
    private Vector sessions;
    private JTree sessiontree;

    public LogFileViewer(Frame owner) {
        super(owner, Resource.getString("LOGFILEVIEWER_TITLE"), true);
        this.loadLogFile();
        this.initComponents();
    }

    private void initComponents() {
        JSplitPane splitpane = new JSplitPane();
        splitpane.setOrientation(1);
        splitpane.setDividerLocation(225);
        DefaultMutableTreeNode top = new DefaultMutableTreeNode(Resource.getString("SESSIONS"), true);
        this.createTreeNodes(top);
        this.sessiontree = new JTree(top);
        MyTreeCellRenderer treerenderer = new MyTreeCellRenderer();
        this.sessiontree.setCellRenderer(treerenderer);
        this.sessiontree.addTreeSelectionListener(this);
        JScrollPane scrollpane1 = new JScrollPane(this.sessiontree);
        splitpane.setLeftComponent(scrollpane1);
        this.textarea = new JTextArea();
        this.textarea.setText("");
        this.textarea.setEditable(false);
        this.textarea.setForeground(Color.black);
        this.textarea.setBackground(Color.white);
        JScrollPane scrollpane = new JScrollPane(this.textarea);
        splitpane.setBottomComponent(scrollpane);
        JPanel toppanel = new JPanel();
        toppanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        toppanel.setLayout(new BorderLayout());
        toppanel.add((Component)splitpane, "Center");
        this.getContentPane().add(toppanel);
        JPanel buttonpanel = new JPanel();
        buttonpanel.setLayout(new BorderLayout());
        toppanel.add((Component)buttonpanel, "South");
        this.close_button = new JButton(Resource.getString("CLOSE"));
        this.close_button.addActionListener(this);
        buttonpanel.add((Component)this.close_button, "East");
        this.setDefaultCloseOperation(2);
        this.pack();
        this.setSize(800, 600);
        Dimension size = this.getSize();
        this.setLocation((Toolkit.getDefaultToolkit().getScreenSize().width - size.width) / 2, (Toolkit.getDefaultToolkit().getScreenSize().height - size.height) / 2);
        this.setVisible(true);
    }

    private void createTreeNodes(DefaultMutableTreeNode top) {
        for (int i = 0; i < this.sessions.size(); ++i) {
            Session session = (Session)this.sessions.get(i);
            DefaultMutableTreeNode treenode = new DefaultMutableTreeNode(session, false);
            top.add(treenode);
        }
    }

    private void loadLogFile() {
        File logfile = Print.getLogFile();
        this.sessions = new Vector();
        this.logtext = new String();
        try {
            Session session;
            String description;
            LineNumberReader reader = new LineNumberReader(new FileReader(logfile));
            String logfiletext = "";
            String line = reader.readLine();
            while (line != null) {
                if (line.equals("")) {
                    line = reader.readLine();
                    continue;
                }
                if (line.indexOf("MiningMart Version") > 0 && line.indexOf("exit") > 0) {
                    description = logfiletext.substring(0, logfiletext.indexOf("M:") + 1);
                    description.replace('\n', ' ');
                    session = new Session(description, logfiletext);
                    this.sessions.add(session);
                    this.logtext = this.logtext + logfiletext + "\n";
                    line = reader.readLine();
                    logfiletext = "";
                    continue;
                }
                logfiletext = logfiletext + line + "\n";
                line = reader.readLine();
            }
            description = logfiletext.substring(0, logfiletext.indexOf("M:") + 1);
            description.replace('\n', ' ');
            session = new Session(description, logfiletext);
            this.sessions.add(session);
            this.logtext = this.logtext + logfiletext + "\n";
        }
        catch (FileNotFoundException error) {
            M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
            this.logtext = "";
        }
        catch (IOException error) {
            M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
        }
    }

    public void actionPerformed(ActionEvent e) {
        this.dispose();
    }

    public MutableTreeNode getSelectedTreeNode() {
        TreePath path = this.sessiontree.getSelectionPath();
        if (path == null) {
            return (MutableTreeNode)this.sessiontree.getModel().getRoot();
        }
        return (MutableTreeNode)path.getLastPathComponent();
    }

    public void valueChanged(TreeSelectionEvent e) {
        MutableTreeNode node = this.getSelectedTreeNode();
        if (((DefaultMutableTreeNode)node).isRoot()) {
            this.textarea.setText(this.logtext);
            return;
        }
        Object object = ((DefaultMutableTreeNode)node).getUserObject();
        if (object instanceof Session) {
            this.textarea.setText(((Session)object).getText());
        }
    }

    private class MyTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private Icon sessions;
        private Icon session;

        public MyTreeCellRenderer() {
            Iconkit kit = Iconkit.instance();
            this.sessions = new ImageIcon(kit.loadImageResource(Resource.getString("SESSIONS_ICON")));
            this.session = new ImageIcon(kit.loadImageResource(Resource.getString("SESSION_ICON")));
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            DefaultMutableTreeNode treenode = (DefaultMutableTreeNode)value;
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (treenode.isRoot()) {
                this.setIcon(this.sessions);
                return this;
            }
            this.setIcon(this.session);
            return this;
        }
    }

    private class Session {
        private String description;
        private String text;

        public Session(String description, String text) {
            this.description = description;
            this.text = text;
        }

        public String getDescription() {
            return this.description;
        }

        public String getText() {
            return this.text;
        }

        public String toString() {
            return this.description;
        }
    }
}

