/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.gui.application;

import edu.udo.cs.miningmart.gui.application.IteratorListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jhotdraw.util.Iconkit;
import org.musoft.limo.application.Resource;

public class IteratorList
extends JPanel {
    private JTextField textlabel;
    private String[] data;
    private boolean dataset = false;
    private int selection = 0;
    private Vector iterlistener = new Vector();

    public IteratorList() {
        this.initComponents();
    }

    public IteratorList(String[] data) {
        this();
        this.setData(data);
    }

    public void addIteratorListener(IteratorListener listener) {
        this.iterlistener.add(listener);
    }

    public void removeIteratorListener(IteratorListener listener) {
        this.iterlistener.remove(listener);
    }

    public void reamoveAllIteratorListener() {
        this.iterlistener.clear();
    }

    public int getIteratorListenerCount() {
        return this.iterlistener.size();
    }

    public IteratorListener getIteratorListener(int index) {
        return (IteratorListener)this.iterlistener.get(index);
    }

    public void setData(String[] data) {
        this.data = data;
        this.setFirst();
        this.dataset = true;
    }

    public void setFirst() {
        this.textlabel.setText(this.data[0]);
        this.selection = 0;
    }

    public void setLast() {
        this.textlabel.setText(this.data[this.data.length - 1]);
        this.selection = this.data.length - 1;
    }

    public String[] getData() {
        return this.data;
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.setBackground(Color.WHITE);
        this.setBorder(BorderFactory.createLineBorder(Color.black));
        Iconkit kit = Iconkit.instance();
        ImageIcon upicon = new ImageIcon(kit.loadImageResource(Resource.getString("LOOP_UP_ICON")));
        ImageIcon downicon = new ImageIcon(kit.loadImageResource(Resource.getString("LOOP_DOWN_ICON")));
        JLabel uplabel = new JLabel();
        uplabel.setBackground(Color.WHITE);
        uplabel.setMaximumSize(new Dimension(10, 5));
        uplabel.setMinimumSize(new Dimension(10, 5));
        uplabel.setPreferredSize(new Dimension(10, 5));
        uplabel.setHorizontalAlignment(4);
        uplabel.setHorizontalTextPosition(10);
        uplabel.setIcon(upicon);
        uplabel.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                IteratorList.this.next();
            }
        });
        JLabel downlabel = new JLabel();
        downlabel.setBackground(Color.WHITE);
        downlabel.setMaximumSize(new Dimension(10, 5));
        downlabel.setMinimumSize(new Dimension(10, 5));
        downlabel.setPreferredSize(new Dimension(10, 5));
        downlabel.setHorizontalAlignment(4);
        downlabel.setHorizontalTextPosition(10);
        downlabel.setIcon(downicon);
        downlabel.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                IteratorList.this.previous();
            }
        });
        Box box = new Box(1);
        box.add(uplabel);
        box.add(Box.createVerticalStrut(6));
        box.add(downlabel);
        this.textlabel = new JTextField("");
        this.textlabel.setHorizontalAlignment(2);
        this.textlabel.setBorder(BorderFactory.createEmptyBorder());
        this.textlabel.setMaximumSize(new Dimension(20, 20));
        this.textlabel.setMinimumSize(new Dimension(20, 10));
        this.textlabel.setPreferredSize(new Dimension(20, 16));
        this.textlabel.setColumns(2);
        this.textlabel.setEditable(false);
        this.textlabel.setOpaque(false);
        this.add((Component)box, "East");
        this.add((Component)this.textlabel, "Center");
    }

    public String getSelected() {
        return this.textlabel.getText();
    }

    public int getSelectedIndex() {
        return this.selection;
    }

    public void next() {
        if (this.dataset) {
            int oldNr = this.selection++;
            if (this.selection < this.data.length) {
                this.textlabel.setText(this.data[this.selection]);
            } else {
                this.textlabel.setText(this.data[0]);
                this.selection = 0;
            }
            oldNr = this.selection;
            for (int i = 0; i < this.iterlistener.size(); ++i) {
                IteratorListener listener = this.getIteratorListener(i);
                listener.iterationChanged(this.data[this.selection], this.selection);
            }
        }
    }

    public void previous() {
        if (this.dataset) {
            int oldNr = this.selection--;
            if (this.selection >= 0) {
                this.textlabel.setText(this.data[this.selection]);
            } else {
                this.selection = this.data.length - 1;
                this.textlabel.setText(this.data[this.selection]);
            }
            oldNr = this.selection;
            for (int i = 0; i < this.iterlistener.size(); ++i) {
                IteratorListener listener = this.getIteratorListener(i);
                listener.iterationChanged(this.data[this.selection], this.selection);
            }
        }
    }
}

