/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.gui.application;

import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.gui.application.MiningMartApplication;
import edu.udo.cs.miningmart.m4.M4Interface;
import edu.udo.cs.miningmart.m4.utils.Print;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.musoft.limo.application.Resource;

public class DeleteCaseDialog
extends JDialog
implements ActionListener,
ListSelectionListener {
    public static final int CANCEL = 0;
    public static final int DELETE = 1;
    private JList list;
    private JButton cancel;
    private JButton select;
    private int exitAction = 0;

    public DeleteCaseDialog(MiningMartApplication parent) {
        super(parent, Resource.getString("DELETE_CASE"), true);
        this.initComponents();
        this.setDefaultCloseOperation(2);
        this.pack();
        this.setSize(300, 300);
        Dimension size = this.getSize();
        this.setLocation((Toolkit.getDefaultToolkit().getScreenSize().width - size.width) / 2, (Toolkit.getDefaultToolkit().getScreenSize().height - size.height) / 2);
        this.setVisible(true);
    }

    private String[] selectionSort(String[] data) {
        for (int i = 0; i < data.length - 1; ++i) {
            int min = i;
            for (int j = i + 1; j < data.length; ++j) {
                if (data[j].compareTo(data[min]) >= 0) continue;
                min = j;
            }
            this.swap((Comparable[])data, min, i);
        }
        return data;
    }

    private void swap(Comparable[] a, int i, int j) {
        Comparable tmp = a[i];
        a[i] = a[j];
        a[j] = tmp;
    }

    public void initComponents() {
        JPanel top_panel = new JPanel();
        top_panel.setLayout(new BorderLayout(5, 5));
        this.list = new JList();
        this.list.setSelectionMode(0);
        this.list.setLayoutOrientation(0);
        this.list.setVisibleRowCount(-1);
        Collection coll = null;
        try {
            coll = MiningMartApplication.m4Interface.getAllCaseNames();
        }
        catch (M4Exception error) {
            M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
        }
        if (coll == null) {
            return;
        }
        Iterator iter = coll.iterator();
        String[] data = new String[coll.size()];
        int index = 0;
        while (iter.hasNext()) {
            data[index] = (String)iter.next();
            ++index;
        }
        data = this.selectionSort(data);
        this.list.setListData(data);
        this.list.addListSelectionListener(this);
        JScrollPane scrollpane = new JScrollPane(this.list);
        JPanel mid_panel = new JPanel();
        mid_panel.setLayout(new BorderLayout());
        mid_panel.add((Component)scrollpane, "Center");
        top_panel.add((Component)mid_panel, "Center");
        this.cancel = new JButton(Resource.getString("CANCEL"));
        this.select = new JButton(Resource.getString("DELETE"));
        this.select.setEnabled(false);
        this.cancel.addActionListener(this);
        this.select.addActionListener(this);
        JPanel bottom = new JPanel();
        bottom.setLayout(new BoxLayout(bottom, 0));
        bottom.add(Box.createHorizontalGlue());
        bottom.add(this.select);
        bottom.add(Box.createRigidArea(new Dimension(10, 0)));
        bottom.add(this.cancel);
        top_panel.add((Component)bottom, "South");
        JLabel label = new JLabel(Resource.getString("CASES") + ":");
        top_panel.add((Component)label, "North");
        top_panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.getContentPane().add(top_panel);
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals(Resource.getString("CANCEL"))) {
            this.exitAction = 0;
            this.dispose();
        }
        if (cmd.equals(Resource.getString("DELETE"))) {
            this.exitAction = 1;
            this.dispose();
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        if (!this.list.isSelectionEmpty()) {
            this.select.setEnabled(true);
        }
    }

    public int getExitAction() {
        return this.exitAction;
    }

    public String getSelectedCase() {
        if (this.exitAction == 1) {
            return (String)this.list.getSelectedValue();
        }
        return null;
    }
}

